(ns boot-azure.tasks
  {:boot/export-tasks true}
  (:require
    [boot-azure.azure :refer :all]
    [boot.task.built-in :refer [aot uber]]
    [boot.core          :as c]
    [boot.util          :as util]
    [clojure.java.shell :as shell]
    [boot.filesystem :as fs]))

(c/deftask azure-store
  [c container CNT str]
  (if-not container
    (do (util/fail "The -c/--container option is required!") (*usage*))
  (c/with-pass-thru [fs]
    (doseq [{:keys [dir path] :as fi} (vals (:tree (c/output-fileset fs)))
            :let [f (.toFile (.resolve (.toPath dir) path))]]
      (util/info "uploading %s...\n" path dir)
      (upload-file container f path)))))
