(ns boot-docker.tasks
  {:boot/export-tasks true}
  (:require
    [boot-docker.docker :refer :all]
    [boot.task.built-in :refer [aot uber]]
    [boot.core          :as c]
    [boot.util          :as util]
    [clojure.java.shell :as shell]
    [boot.filesystem :as fs]))


(c/deftask docker-file 
  [m main NS sym "Main namespace"]
  (c/with-pre-wrap fileset
    (let [tgt (c/tmp-dir!)
          dockerfile (clojure.java.io/file tgt "Dockerfile")
          main-class   (. (name main)  (replace \- \_)) ]
      (spit dockerfile (str "FROM java
                            RUN mkdir -p /app
                            WORKDIR /app
                            COPY . /app
                            ENTRYPOINT [\"java\", \"-classpath\", \"./*:.\", \"" main-class "\"]" ))
      (-> fileset (c/add-resource tgt) c/commit!))))


(c/deftask docker-build 
  [o organization ORG   str   "the organization for the docker repo"
   r repo         REP   str   "the name of the repository"
   t tags         TAG #{str}  "applied tags"]
  (assert repo "Expected --repo option.")
  (let [tgt (c/tmp-dir!)]
    (c/with-pass-thru [fs]
      (fs/patch! (fs/->path tgt) nil (c/output-fileset fs) :link :tmp) 
      (util/info "building docker image...")
      (build-image tgt organization repo tags))))

(c/deftask docker-image
  [m main         NS    sym   "Main namespace"
   o organization ORG   str   "the organization for the docker repo"
   r repo         REP   str   "the name of the repository"
   t tags         TAG #{str}  "applied tags"]
  (comp (aot)
        (uber :as-jars true)
        (docker-file :main main)
        (docker-build :organization organization :repo repo :tags tags)))
