(ns scenarios.core 
  (:require [cljs.test :refer [deftest testing]]
            [com.stuartsierra.component :as component]
            [clojure.string :as str]))



(defmulti extract-phase (fn [[f _]] (keyword (name f))))

(defmethod extract-phase :given [[f d c]] [:given {:description d :component c}])


(defmethod extract-phase :when [[f d b & r]] [:when {:description d :binds b :body r}])

(defmethod extract-phase :then [[f d b & r]] [:then {:description d :binds b :body r}])

(defmethod extract-phase :default  [[f d & r]] [(keyword (name f)) {:description d :body r}])

(defn extract-gherkin [s]
  (apply assoc {} (mapcat extract-phase s)))



(defn create-test-symbol [d]
  (-> d
      str/lower-case
      (str/replace #"\s+" "-")
      symbol))

(defn scenario* [n bd]
  (let [{:keys [given when then]} (extract-gherkin bd)
        component-under-test (:component given)
        sc `(component/start ~component-under-test)]
    `(deftest ~(create-test-symbol n)
      (testing ~(str "Given " (:description given))
       (let [c# ~sc]
         (testing ~(str "When " (:description when))
           (let [{:keys ~(:binds when)} c#]
           ~@(:body when)))
         (testing ~(str "Then " (:description then))
           (let [{:keys ~(:binds then)} c#]
           ~@(:body then)))
         (component/stop c#))))))

(defmacro scenario [d & bd]
  (scenario* d bd))

