/*
 * Decompiled with CFR 0.152.
 */
package SimpleOpenNI;

import SimpleOpenNI.ContextWrapper;
import SimpleOpenNI.IntVector;
import SimpleOpenNI.SimpleOpenNIConstants;
import SimpleOpenNI.StrVector;
import SimpleOpenNI.XnMatrix3X3;
import SimpleOpenNI.XnPoint3D;
import SimpleOpenNI.XnSkeletonJointOrientation;
import SimpleOpenNI.XnSkeletonJointPosition;
import SimpleOpenNI.XnVector3D;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix3D;
import processing.core.PVector;

public class SimpleOpenNI
extends ContextWrapper
implements SimpleOpenNIConstants {
    protected Object _userCbObject;
    protected Object _calibrationCbObject;
    protected Object _poseCbObject;
    protected Object _handsCbObject;
    protected Object _gestureCbObject;
    protected Object _sessionCbObject;
    protected Method _newUserMethod;
    protected Method _lostUserMethod;
    protected Method _exitUserMethod;
    protected Method _reEnterUserMethod;
    protected Method _startCalibrationMethod;
    protected Method _endCalibrationMethod;
    protected Method _startPoseMethod;
    protected Method _endPoseMethod;
    protected Method _createHandsMethod;
    protected Method _updateHandsMethod;
    protected Method _destroyHandsMethod;
    protected Method _recognizeGestureMethod;
    protected Method _progressGestureMethod;
    protected Method _startSessionMethod;
    protected Method _endSessionMethod;
    protected Method _focusSessionMethod;
    protected String _filename;
    protected PApplet _parent;
    protected PImage _depthImage;
    protected int[] _depthRaw;
    protected PVector[] _depthMapRealWorld;
    protected XnPoint3D[] _depthMapRealWorldXn;
    protected PImage _rgbImage;
    protected PImage _irImage;
    protected PImage _sceneImage;
    protected int[] _sceneRaw;
    protected int[] _userRaw;
    protected long _depthMapTimeStamp;
    protected long _depthImageTimeStamp;
    protected long _depthRealWorldTimeStamp;
    protected long _rgbTimeStamp;
    protected long _irImageTimeStamp;
    protected long _sceneMapTimeStamp;
    protected long _sceneImageTimeStamp;
    protected static boolean _initFlag;

    public static void start() {
        if (_initFlag) {
            return;
        }
        _initFlag = true;
        SimpleOpenNI.initContext();
    }

    public static int deviceCount() {
        SimpleOpenNI.start();
        return ContextWrapper.deviceCount();
    }

    public static int deviceNames(StrVector strVector) {
        SimpleOpenNI.start();
        return ContextWrapper.deviceNames(strVector);
    }

    public SimpleOpenNI(PApplet pApplet, String string) {
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        this.init(pApplet.dataPath(string));
    }

    public SimpleOpenNI(PApplet pApplet, String string, int n) {
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        this.init(pApplet.dataPath(string), n);
    }

    public SimpleOpenNI(PApplet pApplet) {
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        this.init();
    }

    public SimpleOpenNI(int n, PApplet pApplet) {
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        this.init(n, RUN_MODE_SINGLE_THREADED);
    }

    public SimpleOpenNI(PApplet pApplet, int n) {
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        this.init(n);
    }

    protected void initVars() {
        this._depthMapTimeStamp = -1L;
        this._depthImageTimeStamp = -1L;
        this._depthRealWorldTimeStamp = -1L;
        this._rgbTimeStamp = -1L;
        this._irImageTimeStamp = -1L;
        this._sceneMapTimeStamp = -1L;
        this._sceneImageTimeStamp = -1L;
    }

    protected void setupCallbackFunc() {
        this._userCbObject = this._parent;
        this._calibrationCbObject = this._parent;
        this._poseCbObject = this._parent;
        this._handsCbObject = this._parent;
        this._gestureCbObject = this._parent;
        this._sessionCbObject = this._parent;
        this._newUserMethod = null;
        this._lostUserMethod = null;
        this._exitUserMethod = null;
        this._reEnterUserMethod = null;
        this._startCalibrationMethod = null;
        this._endCalibrationMethod = null;
        this._startPoseMethod = null;
        this._endPoseMethod = null;
        this._createHandsMethod = null;
        this._updateHandsMethod = null;
        this._destroyHandsMethod = null;
        this._newUserMethod = this.getMethodRef("onNewUser", new Class[]{Integer.TYPE});
        this._lostUserMethod = this.getMethodRef("onLostUser", new Class[]{Integer.TYPE});
        this._exitUserMethod = this.getMethodRef("onExitUser", new Class[]{Integer.TYPE});
        this._reEnterUserMethod = this.getMethodRef("onReEnterUser", new Class[]{Integer.TYPE});
        this._startCalibrationMethod = this.getMethodRef("onStartCalibration", new Class[]{Integer.TYPE});
        this._endCalibrationMethod = this.getMethodRef("onEndCalibration", new Class[]{Integer.TYPE, Boolean.TYPE});
        this._startPoseMethod = this.getMethodRef("onStartPose", new Class[]{String.class, Integer.TYPE});
        this._endPoseMethod = this.getMethodRef("onEndPose", new Class[]{String.class, Integer.TYPE});
        this._createHandsMethod = this.getMethodRef("onCreateHands", new Class[]{Integer.TYPE, PVector.class, Float.TYPE});
        this._updateHandsMethod = this.getMethodRef("onUpdateHands", new Class[]{Integer.TYPE, PVector.class, Float.TYPE});
        this._destroyHandsMethod = this.getMethodRef("onDestroyHands", new Class[]{Integer.TYPE, Float.TYPE});
        this._recognizeGestureMethod = this.getMethodRef("onRecognizeGesture", new Class[]{String.class, PVector.class, PVector.class});
        this._progressGestureMethod = this.getMethodRef("onProgressGesture", new Class[]{String.class, PVector.class, Float.TYPE});
        this._startSessionMethod = this.getMethodRef("onStartSession", new Class[]{PVector.class});
        this._endSessionMethod = this.getMethodRef("onEndSession", new Class[0]);
        this._focusSessionMethod = this.getMethodRef("onFocusSession", new Class[]{String.class, PVector.class, Float.TYPE});
    }

    protected Method getMethodRef(String string, Class[] classArray) {
        Method method = null;
        try {
            method = this._parent.getClass().getMethod(string, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method getMethodRef(Object object, String string, Class[] classArray) {
        Method method = null;
        try {
            method = object.getClass().getMethod(string, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public void dispose() {
        this.close();
    }

    @Override
    public void finalize() {
        this.close();
    }

    private void setupDepth() {
        this._depthImage = new PImage(this.depthWidth(), this.depthHeight(), 1);
        this._depthRaw = new int[this.depthMapSize()];
        this._depthMapRealWorld = new PVector[this.depthMapSize()];
        this._depthMapRealWorldXn = new XnPoint3D[this.depthMapSize()];
        for (int i = 0; i < this.depthMapSize(); ++i) {
            this._depthMapRealWorld[i] = new PVector();
            this._depthMapRealWorldXn[i] = new XnPoint3D();
        }
    }

    @Override
    public boolean enableDepth() {
        if (super.enableDepth()) {
            this.setupDepth();
            return true;
        }
        return false;
    }

    @Override
    public boolean enableDepth(int n, int n2, int n3) {
        if (super.enableDepth(n, n2, n3)) {
            this.setupDepth();
            return true;
        }
        return false;
    }

    public PImage depthImage() {
        this.updateDepthImage();
        return this._depthImage;
    }

    public int[] depthMap() {
        this.updateDepthRaw();
        return this._depthRaw;
    }

    public PVector[] depthMapRealWorld() {
        this.updateDepthRealWorld();
        return this._depthMapRealWorld;
    }

    private void setupRGB() {
        this._rgbImage = new PImage(this.rgbWidth(), this.rgbHeight(), 1);
    }

    @Override
    public boolean enableRGB() {
        if (super.enableRGB()) {
            this.setupRGB();
            return true;
        }
        return false;
    }

    @Override
    public boolean enableRGB(int n, int n2, int n3) {
        if (super.enableRGB(n, n2, n3)) {
            this.setupRGB();
            return true;
        }
        return false;
    }

    public PImage rgbImage() {
        this.updateImage();
        return this._rgbImage;
    }

    private void setupIR() {
        this._irImage = new PImage(this.irWidth(), this.irHeight(), 1);
    }

    @Override
    public boolean enableIR() {
        if (super.enableIR()) {
            this.setupIR();
            return true;
        }
        return false;
    }

    @Override
    public boolean enableIR(int n, int n2, int n3) {
        if (super.enableIR(n, n2, n3)) {
            this.setupIR();
            return true;
        }
        return false;
    }

    public PImage irImage() {
        this.updateIrImage();
        return this._irImage;
    }

    private void setupScene() {
        this._sceneImage = new PImage(this.sceneWidth(), this.sceneHeight(), 1);
        this._sceneRaw = new int[this.sceneWidth() * this.sceneHeight()];
    }

    @Override
    public boolean enableScene() {
        if (super.enableScene()) {
            this.setupScene();
            return true;
        }
        return false;
    }

    @Override
    public boolean enableScene(int n, int n2, int n3) {
        if (super.enableScene(n, n2, n3)) {
            this.setupScene();
            return true;
        }
        return false;
    }

    public PImage sceneImage() {
        this.updateSceneImage();
        return this._sceneImage;
    }

    public int[] sceneMap() {
        this.updateSceneRaw();
        return this._sceneRaw;
    }

    public void getSceneFloor(PVector pVector, PVector pVector2) {
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        super.getSceneFloor(xnVector3D, xnVector3D2);
        pVector.set(xnVector3D.getX(), xnVector3D.getY(), xnVector3D.getZ());
        pVector2.set(xnVector3D2.getX(), xnVector3D2.getY(), xnVector3D2.getZ());
    }

    private void setupUser() {
        this._userRaw = new int[this.userWidth() * this.userHeight()];
        this._newUserMethod = SimpleOpenNI.getMethodRef(this._userCbObject, "onNewUser", new Class[]{Integer.TYPE});
        this._lostUserMethod = SimpleOpenNI.getMethodRef(this._userCbObject, "onLostUser", new Class[]{Integer.TYPE});
        this._exitUserMethod = SimpleOpenNI.getMethodRef(this._userCbObject, "onExitUser", new Class[]{Integer.TYPE});
        this._reEnterUserMethod = SimpleOpenNI.getMethodRef(this._userCbObject, "onReEnterUser", new Class[]{Integer.TYPE});
        this._startCalibrationMethod = SimpleOpenNI.getMethodRef(this._calibrationCbObject, "onStartCalibration", new Class[]{Integer.TYPE});
        this._endCalibrationMethod = SimpleOpenNI.getMethodRef(this._calibrationCbObject, "onEndCalibration", new Class[]{Integer.TYPE, Boolean.TYPE});
        this._startPoseMethod = SimpleOpenNI.getMethodRef(this._poseCbObject, "onStartPose", new Class[]{String.class, Integer.TYPE});
        this._endPoseMethod = SimpleOpenNI.getMethodRef(this._poseCbObject, "onEndPose", new Class[]{String.class, Integer.TYPE});
    }

    @Override
    public boolean enableUser(int n) {
        return this.enableUser(n, this._parent);
    }

    public boolean enableUser(int n, Object object) {
        this._userCbObject = object;
        this._calibrationCbObject = object;
        this._poseCbObject = object;
        if (super.enableUser(n)) {
            this.setupUser();
            return true;
        }
        return false;
    }

    @Override
    public boolean saveCalibrationDataSkeleton(int n, String string) {
        String string2 = this._parent.dataPath(string);
        PApplet.createPath((String)string2);
        PApplet.println((String)string2);
        return super.saveCalibrationDataSkeleton(n, string2);
    }

    @Override
    public boolean loadCalibrationDataSkeleton(int n, String string) {
        String string2 = this._parent.dataPath(string);
        return super.loadCalibrationDataSkeleton(n, string2);
    }

    public int[] getUsersPixels(int n) {
        int n2 = this.userWidth() * this.userHeight();
        if (n2 == 0) {
            return this._userRaw;
        }
        if (this._userRaw.length != this.userWidth() * this.userHeight()) {
            this._userRaw = new int[this.userWidth() * this.userHeight()];
        }
        super.getUserPixels(n, this._userRaw);
        return this._userRaw;
    }

    public boolean getCoM(int n, PVector pVector) {
        XnPoint3D xnPoint3D = new XnPoint3D();
        boolean bl = super.getCoM(n, xnPoint3D);
        pVector.set(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
        return bl;
    }

    public int[] getUsers() {
        IntVector intVector = new IntVector();
        this.getUsers(intVector);
        int[] nArray = new int[(int)intVector.size()];
        int n = 0;
        while ((long)n < intVector.size()) {
            nArray[n] = intVector.get(n);
            ++n;
        }
        return nArray;
    }

    private void setupHands() {
        this._createHandsMethod = SimpleOpenNI.getMethodRef(this._handsCbObject, "onCreateHands", new Class[]{Integer.TYPE, PVector.class, Float.TYPE});
        this._updateHandsMethod = SimpleOpenNI.getMethodRef(this._handsCbObject, "onUpdateHands", new Class[]{Integer.TYPE, PVector.class, Float.TYPE});
        this._destroyHandsMethod = SimpleOpenNI.getMethodRef(this._handsCbObject, "onDestroyHands", new Class[]{Integer.TYPE, Float.TYPE});
    }

    @Override
    public boolean enableHands() {
        return this.enableHands(this._parent);
    }

    public boolean enableHands(Object object) {
        this._handsCbObject = object;
        if (super.enableHands()) {
            this.setupHands();
            return true;
        }
        return false;
    }

    public void startTrackingHands(PVector pVector) {
        XnVector3D xnVector3D = new XnVector3D();
        xnVector3D.setX(pVector.x);
        xnVector3D.setY(pVector.y);
        xnVector3D.setZ(pVector.z);
        super.startTrackingHands(xnVector3D);
    }

    private void setupGesture() {
        this._recognizeGestureMethod = SimpleOpenNI.getMethodRef(this._gestureCbObject, "onRecognizeGesture", new Class[]{String.class, PVector.class, PVector.class});
        this._progressGestureMethod = SimpleOpenNI.getMethodRef(this._gestureCbObject, "onProgressGesture", new Class[]{String.class, PVector.class, Float.TYPE});
    }

    @Override
    public boolean enableGesture() {
        return this.enableGesture(this._parent);
    }

    public boolean enableGesture(Object object) {
        this._gestureCbObject = object;
        if (super.enableGesture()) {
            this.setupGesture();
            return true;
        }
        return false;
    }

    @Override
    public boolean enableRecorder(int n, String string) {
        String string2 = this._parent.dataPath(string);
        PApplet.createPath((String)string2);
        return super.enableRecorder(n, string2);
    }

    @Override
    public boolean openFileRecording(String string) {
        String string2 = this._parent.dataPath(string);
        if (super.openFileRecording(string2)) {
            if ((this.nodes() & NODE_DEPTH) > 0) {
                this.setupDepth();
            }
            if ((this.nodes() & NODE_IMAGE) > 0) {
                this.setupRGB();
            }
            if ((this.nodes() & NODE_IR) > 0) {
                this.setupIR();
            }
            if ((this.nodes() & NODE_SCENE) > 0) {
                this.setupScene();
            }
            if ((this.nodes() & NODE_USER) > 0) {
                this.setupUser();
            }
            if ((this.nodes() & NODE_GESTURE) > 0) {
                this.setupGesture();
            }
            if ((this.nodes() & NODE_HANDS) > 0) {
                this.setupHands();
            }
            return true;
        }
        return false;
    }

    protected void updateDepthRaw() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthMapTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.depthMap(this._depthRaw);
        this._depthMapTimeStamp = this.updateTimeStamp();
    }

    protected void updateDepthImage() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._depthImage.loadPixels();
        this.depthImage(this._depthImage.pixels);
        this._depthImage.updatePixels();
        this._depthImageTimeStamp = this.updateTimeStamp();
    }

    protected void updateDepthRealWorld() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthRealWorldTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.depthMapRealWorld(this._depthMapRealWorldXn);
        for (int i = 0; i < this._depthMapRealWorldXn.length; ++i) {
            XnPoint3D xnPoint3D = this._depthMapRealWorldXn[i];
            this._depthMapRealWorld[i].set(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
        }
        this._depthRealWorldTimeStamp = this.updateTimeStamp();
    }

    protected void updateImage() {
        if ((this.nodes() & NODE_IMAGE) == 0) {
            return;
        }
        if (this._rgbTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._rgbImage.loadPixels();
        this.rgbImage(this._rgbImage.pixels);
        this._rgbImage.updatePixels();
        this._rgbTimeStamp = this.updateTimeStamp();
    }

    protected void updateIrImage() {
        if ((this.nodes() & NODE_IR) == 0) {
            return;
        }
        if (this._irImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._irImage.loadPixels();
        this.irImage(this._irImage.pixels);
        this._irImage.updatePixels();
        this._irImageTimeStamp = this.updateTimeStamp();
    }

    protected void updateSceneRaw() {
        if ((this.nodes() & NODE_SCENE) == 0) {
            return;
        }
        if (this._sceneMapTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.sceneMap(this._sceneRaw);
        this._sceneMapTimeStamp = this.updateTimeStamp();
    }

    protected void updateSceneImage() {
        if ((this.nodes() & NODE_SCENE) == 0) {
            return;
        }
        if (this._sceneImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._sceneImage.loadPixels();
        this.sceneImage(this._sceneImage.pixels);
        this._sceneImage.updatePixels();
        this._sceneImageTimeStamp = this.updateTimeStamp();
    }

    @Override
    public void update() {
        super.update();
    }

    public void drawLimb(int n, int n2, int n3) {
        if (!this.isCalibratedSkeleton(n)) {
            return;
        }
        if (!this.isTrackingSkeleton(n)) {
            return;
        }
        XnSkeletonJointPosition xnSkeletonJointPosition = new XnSkeletonJointPosition();
        XnSkeletonJointPosition xnSkeletonJointPosition2 = new XnSkeletonJointPosition();
        this.getJointPositionSkeleton(n, n2, xnSkeletonJointPosition);
        this.getJointPositionSkeleton(n, n3, xnSkeletonJointPosition2);
        if ((double)xnSkeletonJointPosition.getFConfidence() < 0.5 || (double)xnSkeletonJointPosition2.getFConfidence() < 0.5) {
            return;
        }
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        this.convertRealWorldToProjective(xnSkeletonJointPosition.getPosition(), xnVector3D);
        this.convertRealWorldToProjective(xnSkeletonJointPosition2.getPosition(), xnVector3D2);
        this._parent.line(xnVector3D.getX(), xnVector3D.getY(), xnVector3D2.getX(), xnVector3D2.getY());
    }

    public float getJointPositionSkeleton(int n, int n2, PVector pVector) {
        if (!this.isCalibratedSkeleton(n)) {
            return 0.0f;
        }
        if (!this.isTrackingSkeleton(n)) {
            return 0.0f;
        }
        XnSkeletonJointPosition xnSkeletonJointPosition = new XnSkeletonJointPosition();
        this.getJointPositionSkeleton(n, n2, xnSkeletonJointPosition);
        pVector.set(xnSkeletonJointPosition.getPosition().getX(), xnSkeletonJointPosition.getPosition().getY(), xnSkeletonJointPosition.getPosition().getZ());
        return xnSkeletonJointPosition.getFConfidence();
    }

    public float getJointOrientationSkeleton(int n, int n2, PMatrix3D pMatrix3D) {
        if (!this.isCalibratedSkeleton(n)) {
            return 0.0f;
        }
        if (!this.isTrackingSkeleton(n)) {
            return 0.0f;
        }
        XnSkeletonJointOrientation xnSkeletonJointOrientation = new XnSkeletonJointOrientation();
        this.getJointOrientationSkeleton(n, n2, xnSkeletonJointOrientation);
        float[] fArray = xnSkeletonJointOrientation.getOrientation().getElements();
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], 0.0f, fArray[3], fArray[4], fArray[5], 0.0f, fArray[6], fArray[7], fArray[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        return xnSkeletonJointOrientation.getFConfidence();
    }

    public void convertRealWorldToProjective(PVector pVector, PVector pVector2) {
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        xnVector3D.setX(pVector.x);
        xnVector3D.setY(pVector.y);
        xnVector3D.setZ(pVector.z);
        this.convertRealWorldToProjective(xnVector3D, xnVector3D2);
        pVector2.set(xnVector3D2.getX(), xnVector3D2.getY(), xnVector3D2.getZ());
    }

    public void convertProjectiveToRealWorld(PVector pVector, PVector pVector2) {
        XnVector3D xnVector3D = new XnVector3D();
        XnVector3D xnVector3D2 = new XnVector3D();
        xnVector3D.setX(pVector.x);
        xnVector3D.setY(pVector.y);
        xnVector3D.setZ(pVector.z);
        this.convertProjectiveToRealWorld(xnVector3D, xnVector3D2);
        pVector2.set(xnVector3D2.getX(), xnVector3D2.getY(), xnVector3D2.getZ());
    }

    public void getUserCoordsysTransMat(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[16];
        this.getUserCoordsysTransMat(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11], fArray[12], fArray[13], fArray[14], fArray[15]);
    }

    public void calcUserCoordsys(PVector pVector) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        XnPoint3D xnPoint3D = new XnPoint3D();
        this.calcUserCoordsys(xnPoint3D);
        pVector.set(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
    }

    public void calcUserCoordsys(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        XnMatrix3X3 xnMatrix3X3 = new XnMatrix3X3();
        float[] fArray = xnMatrix3X3.getElements();
        fArray[0] = pMatrix3D.m00;
        fArray[1] = pMatrix3D.m01;
        fArray[2] = pMatrix3D.m02;
        fArray[3] = pMatrix3D.m10;
        fArray[4] = pMatrix3D.m11;
        fArray[5] = pMatrix3D.m12;
        fArray[6] = pMatrix3D.m20;
        fArray[7] = pMatrix3D.m21;
        fArray[8] = pMatrix3D.m22;
        this.calcUserCoordsys(xnMatrix3X3);
        fArray = xnMatrix3X3.getElements();
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], 0.0f, fArray[3], fArray[4], fArray[5], 0.0f, fArray[6], fArray[7], fArray[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void calcUserCoordsysBack(PVector pVector) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        XnPoint3D xnPoint3D = new XnPoint3D();
        this.calcUserCoordsysBack(xnPoint3D);
        pVector.set(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ());
    }

    public void calcUserCoordsysBack(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        XnMatrix3X3 xnMatrix3X3 = new XnMatrix3X3();
        float[] fArray = xnMatrix3X3.getElements();
        fArray[0] = pMatrix3D.m00;
        fArray[1] = pMatrix3D.m01;
        fArray[2] = pMatrix3D.m02;
        fArray[3] = pMatrix3D.m10;
        fArray[4] = pMatrix3D.m11;
        fArray[5] = pMatrix3D.m12;
        fArray[6] = pMatrix3D.m20;
        fArray[7] = pMatrix3D.m21;
        fArray[8] = pMatrix3D.m22;
        this.calcUserCoordsysBack(xnMatrix3X3);
        fArray = xnMatrix3X3.getElements();
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], 0.0f, fArray[3], fArray[4], fArray[5], 0.0f, fArray[6], fArray[7], fArray[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void getUserCoordsys(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[16];
        this.getUserCoordsys(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11], fArray[12], fArray[13], fArray[14], fArray[15]);
    }

    public void getUserCoordsysBack(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[16];
        this.getUserCoordsysBack(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11], fArray[12], fArray[13], fArray[14], fArray[15]);
    }

    public void drawCamFrustum() {
        this._parent.g.pushStyle();
        this._parent.g.pushMatrix();
        if (this.hasUserCoordsys()) {
            PMatrix3D pMatrix3D = new PMatrix3D();
            this.getUserCoordsys(pMatrix3D);
            this._parent.g.applyMatrix(pMatrix3D);
        }
        this._parent.stroke(200.0f, 200.0f, 0.0f);
        this._parent.noFill();
        this._parent.g.beginShape();
        this._parent.g.vertex(135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(-135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(-135.0f, -20.0f, 0.0f);
        this._parent.g.vertex(135.0f, -20.0f, 0.0f);
        this._parent.g.endShape(2);
        this._parent.g.beginShape();
        this._parent.g.vertex(110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-110.0f, -20.0f, -50.0f);
        this._parent.g.vertex(110.0f, -20.0f, -50.0f);
        this._parent.g.endShape(2);
        this._parent.g.beginShape(4);
        this._parent.g.vertex(135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(-110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-135.0f, -20.0f, 0.0f);
        this._parent.g.vertex(-110.0f, -20.0f, -50.0f);
        this._parent.g.vertex(135.0f, -20.0f, 0.0f);
        this._parent.g.vertex(110.0f, -20.0f, -50.0f);
        this._parent.g.endShape();
        this._parent.stroke(200.0f, 200.0f, 0.0f, 50.0f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1000.0f);
        float f = 10000.0f;
        float f2 = f * PApplet.tan((float)(this.hFieldOfView() * 0.5f));
        float f3 = f * PApplet.tan((float)(this.vFieldOfView() * 0.5f));
        this._parent.stroke(200.0f, 200.0f, 0.0f, 100.0f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, f2, f3, f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, -f2, f3, f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, f2, -f3, f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, -f2, -f3, f);
        this._parent.g.beginShape();
        this._parent.g.vertex(f2, f3, f);
        this._parent.g.vertex(-f2, f3, f);
        this._parent.g.vertex(-f2, -f3, f);
        this._parent.g.vertex(f2, -f3, f);
        this._parent.g.endShape(2);
        this._parent.g.popMatrix();
        this._parent.g.popStyle();
    }

    public static boolean rayTriangleIntersection(PVector pVector, PVector pVector2, PVector pVector3, PVector pVector4, PVector pVector5, PVector pVector6) {
        float[] fArray = new float[3];
        if (SimpleOpenNI.rayTriangleIntersection(pVector.array(), pVector2.array(), pVector3.array(), pVector4.array(), pVector5.array(), fArray)) {
            pVector6.set(fArray);
            return true;
        }
        return false;
    }

    public static int raySphereIntersection(PVector pVector, PVector pVector2, PVector pVector3, float f, PVector pVector4, PVector pVector5) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n = SimpleOpenNI.raySphereIntersection(pVector.array(), pVector2.array(), pVector3.array(), f, fArray, fArray2);
        if (n > 0) {
            pVector4.set(fArray);
            if (n > 1) {
                pVector5.set(fArray2);
            }
        }
        return n;
    }

    @Override
    protected void onNewUserCb(long l) {
        try {
            this._newUserMethod.invoke(this._userCbObject, (int)l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onLostUserCb(long l) {
        try {
            this._lostUserMethod.invoke(this._userCbObject, (int)l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onExitUserCb(long l) {
        try {
            this._exitUserMethod.invoke(this._userCbObject, (int)l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onReEnterUserCb(long l) {
        try {
            this._reEnterUserMethod.invoke(this._userCbObject, (int)l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onStartCalibrationCb(long l) {
        try {
            this._startCalibrationMethod.invoke(this._calibrationCbObject, (int)l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onEndCalibrationCb(long l, boolean bl) {
        try {
            this._endCalibrationMethod.invoke(this._calibrationCbObject, (int)l, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onStartPoseCb(String string, long l) {
        try {
            this._startPoseMethod.invoke(this._poseCbObject, string, (int)l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onEndPoseCb(String string, long l) {
        try {
            this._endPoseMethod.invoke(this._poseCbObject, string, (int)l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onCreateHandsCb(long l, XnPoint3D xnPoint3D, float f) {
        try {
            this._createHandsMethod.invoke(this._handsCbObject, (int)l, new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ()), Float.valueOf(f));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onUpdateHandsCb(long l, XnPoint3D xnPoint3D, float f) {
        try {
            this._updateHandsMethod.invoke(this._handsCbObject, (int)l, new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ()), Float.valueOf(f));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onDestroyHandsCb(long l, float f) {
        try {
            this._destroyHandsMethod.invoke(this._handsCbObject, (int)l, Float.valueOf(f));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onRecognizeGestureCb(String string, XnPoint3D xnPoint3D, XnPoint3D xnPoint3D2) {
        try {
            this._recognizeGestureMethod.invoke(this._gestureCbObject, string, new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ()), new PVector(xnPoint3D2.getX(), xnPoint3D2.getY(), xnPoint3D2.getZ()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onProgressGestureCb(String string, XnPoint3D xnPoint3D, float f) {
        try {
            this._progressGestureMethod.invoke(this._gestureCbObject, string, new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ()), Float.valueOf(f));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onStartSessionCb(XnPoint3D xnPoint3D) {
        try {
            this._startSessionMethod.invoke(this._sessionCbObject, new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onEndSessionCb() {
        try {
            this._endSessionMethod.invoke(this._sessionCbObject, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onFocusSessionCb(String string, XnPoint3D xnPoint3D, float f) {
        try {
            this._focusSessionMethod.invoke(this._sessionCbObject, string, new PVector(xnPoint3D.getX(), xnPoint3D.getY(), xnPoint3D.getZ()), Float.valueOf(f));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = "SimpleOpenNI";
        String string3 = System.getProperty("os.arch").toLowerCase();
        if (string.indexOf("win") >= 0) {
            if (string3.indexOf("86") >= 0) {
                string2 = string2 + "32";
            } else if (string3.indexOf("64") >= 0) {
                string2 = string2 + "64";
            }
        } else if (string.indexOf("nix") >= 0 || string.indexOf("linux") >= 0) {
            if (string3.indexOf("86") >= 0) {
                string2 = string2 + "32";
            } else if (string3.indexOf("64") >= 0) {
                System.out.println("----");
                string2 = string2 + "64";
            }
        } else if (string.indexOf("mac") >= 0) {
            // empty if block
        }
        try {
            System.loadLibrary(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("Can't load SimpleOpenNI library (" + string2 + ") : " + unsatisfiedLinkError);
            System.out.println("Verify if you installed SimpleOpenNI correctly.\nhttp://code.google.com/p/simple-openni/wiki/Installation");
        }
        _initFlag = false;
    }
}

