(ns clj-common.ring
  (:require [cheshire.core :as cheshire])
  (:import (java.net URL)))

(defn ring-request
  ([method url]
   (ring-request method url nil))
  ([method url body]
   (let [url (if-not (.startsWith url "http")
               (str "https://test.localhost" url)
               url)
         uri (URL. url)
         host (.getHost uri)
         port (.getPort uri)
         server-port (if (= port -1) (.getDefaultPort uri) port)
         host-header (str host (when-not (= port -1) (str ":" port)))]
     {:remote-addr    "127.0.0.1",
      :headers        (merge
                        {"accept" "*/*", "host" host-header, "user-agent" "mocked-ring"}
                        (when body
                          {"content-type" "application/json"})),
      :server-port    server-port,
      :uri            (.getPath uri),
      :server-name    host,
      :query-string   (.getQuery uri),
      :body           (cond
                        (map? body) (cheshire/generate-string body)
                        :else body),
      :scheme         (keyword (.getProtocol uri)),
      :protocol       "HTTP/1.1"
      :request-method (keyword method)})))