(ns clj-common.ring
  (:require [cheshire.core :as cheshire]
            [taoensso.nippy :as nippy])
  (:import (java.net URL)))

(defn ring-request
  ([method url]
   (ring-request method url nil))
  ([method url body]
   (ring-request method url body {}))
  ([method url body options]
   (let [url (if-not (.startsWith url "http")
               (str "https://test.localhost" url)
               url)
         uri (URL. url)
         host (.getHost uri)
         port (.getPort uri)
         server-port (if (= port -1) (.getDefaultPort uri) port)
         host-header (str host (when-not (= port -1) (str ":" port)))
         content-type (or
                        (:content-type options)
                        (when body
                          (cond
                            (map? body) "application/json"
                            :else "text/plain")))]
     {:remote-addr    "127.0.0.1",
      :headers        (merge
                        {"accept" "*/*", "host" host-header, "user-agent" "mocked-ring"}
                        (when content-type
                          {"content-type" content-type})),
      :server-port    server-port,
      :uri            (.getPath uri),
      :server-name    host,
      :query-string   (.getQuery uri),
      :body           (when body
                        (if (map? body)
                          (cond
                            (= content-type "application/json") (cheshire/generate-string body)
                            (= content-type "application/nippy") (nippy/freeze body))
                          body)),
      :scheme         (keyword (.getProtocol uri)),
      :protocol       "HTTP/1.1"
      :request-method (keyword method)})))