(ns slf4timbre.adapter
  (:gen-class
    :name com.simplycreditinc.slf4timbre.TimbreLoggerAdapter
    :implements [org.slf4j.Logger]
    :state state
    :init init
    :constructors {[String] []})
  (:require [taoensso.timbre :as timbre])
  (:import
    [org.slf4j.helpers MessageFormatter]
    org.slf4j.Marker))

(defn -init
  [logger-name]
  [[] logger-name])

(defn -getName
  [this]
  (.state this))

(defmacro ^:private log-slf4j-timbre
  [level]
  (let [name-fn -getName]
    `(fn [this# & args#]
       (letfn [(inner#
                 ([msg#]
                  (timbre/log! ~level :p [msg#] {:?ns-str (~name-fn this#)}))
                 ([msg# o1# o2#]
                  (let [ft# (MessageFormatter/format msg# o1# o2#)]
                    (timbre/log! ~level :p [(.getThrowable ft#) (.getMessage ft#)] {:?ns-str (~name-fn this#)})))
                 ([msg# o#]
                  (cond
                    (string? o#)
                    (let [ft# (MessageFormatter/format msg# o#)]
                      (timbre/log! ~level :p [(.getThrowable ft#) (.getMessage ft#)] {:?ns-str (~name-fn this#)}))
                    (.isArray (class o#))
                    (let [ft# (MessageFormatter/arrayFormat msg# o#)]
                      (timbre/log! ~level :p [(.getThrowable ft#) (.getMessage ft#)] {:?ns-str (~name-fn this#)}))
                    (isa? (class o#) Throwable)
                    (timbre/log! ~level :p [o# msg#] {:?ns-str (~name-fn this#)}))))]
         (if (isa? (class (first args#)) Marker)
           (apply inner# (rest args#))
           (apply inner# args#))))))

(def -error (log-slf4j-timbre :error))
(def -warn  (log-slf4j-timbre :warn))
(def -info  (log-slf4j-timbre :info))
(def -debug (log-slf4j-timbre :debug))
(def -trace (log-slf4j-timbre :trace))

(defn -isErrorEnabled
  ([_]   (timbre/log? :error))
  ([_ _] (timbre/log? :error)))
(defn -isWarnEnabled
  ([_]   (timbre/log? :warn))
  ([_ _] (timbre/log? :warn)))
(defn -isInfoEnabled
  ([_]   (timbre/log? :info))
  ([_ _] (timbre/log? :info)))
(defn -isDebugEnabled
  ([_]   (timbre/log? :debug))
  ([_ _] (timbre/log? :debug)))
(defn -isTraceEnabled
  ([_]   (timbre/log? :trace))
  ([_ _] (timbre/log? :trace)))
