(ns slf4timbre.logger-binder
  (:gen-class
    :name org.slf4j.impl.StaticLoggerBinder
    :implements [org.slf4j.spi.LoggerFactoryBinder]
    :factory getSingleton
    :init init)
  (:import com.simplycreditinc.slf4timbre.TimbreLoggerFactory))

(def ^:private singleton-instance
  (atom nil))

(defn -init
  []
  (compare-and-set! singleton-instance nil (TimbreLoggerFactory.))
  [[]])

(defn -getLoggerFactory
  [this]
  @singleton-instance)

(defn -getLoggerFactoryClassStr
  [this]
  (.getName TimbreLoggerFactory))