(ns {{sanitized}}.custom-functions
  (:refer-clojure :exclude [max min get inc dec + - * / quot mod == rem contains? get-in < <= > >=
                            boolean re-find and or count str nth rand nil? hash-set empty? not])
  (:require
    [{{sanitized}}.fns :refer :all]
    [clojure.tools.logging :as log]))

(defn ownWallet?
  [ctx]
  (contains? ctx (get-all ctx (?s ctx "[{wallet/user [{_user/auth [_id]}] }]") ["wallet/user" "_user/auth" "_id"]) (?auth_id ctx)))

(defn nonNegative?
  [ctx]
  (< ctx -1 (?o ctx)))

(defn subtractOwnAddOthers?
  [ctx]
  (if-else ctx (ownWallet? ctx) (> ctx (?pO ctx) (?o ctx)) (< ctx (?pO ctx) (?o ctx))))

(defn required
  [ctx predicate]
  (boolean ctx (get ctx (?s ctx) predicate)))

(defn new?
  [ctx]
  (nil? ctx (?pO ctx)))

(defn authOrganizationType
  [ctx]
  (query ctx "[{organization/_auth [{organization/type [_tag/id] }]}]" (?auth_id ctx) nil nil nil))

(defn organizationType
  [ctx]
  (query ctx "[{organization/type [_tag/id]}]" (?o ctx) nil nil nil))

(defn organizationAuth
  [ctx]
  (query ctx "[{organization/auth  [_id]}]" (?o ctx) nil nil nil))

(defn shipmentPOApproved
  [ctx]
  (get-all ctx (?s ctx "[{purchaseOrder/_shipments [{purchaseOrder/approved [_id]}] }]") ["purchaseOrder/_shipments" "purchaseOrder/approved" "_id"]))

(defn approvedOrgTypes
  [ctx]
  (get-all ctx  (?s ctx "[{purchaseOrder/approved [{organization/type [_tag/id] }] }]") ["purchaseOrder/approved" "organization/type" "_tag/id"]))

(defn shipmentSentBy
  [ctx]
  (get ctx (get ctx (?s ctx "[{shipment/sentBy [_id]}]") "shipment/sentBy") "_id"))

(defn shipmentConnectedToPO?
  [ctx]
  (if-else ctx (nil? ctx (get-all ctx (?s ctx "[{purchaseOrder/_shipments [*]}]") ["purchaseOrder/_shipments" "_id"])) false true))

(defn sentSignature?
  [ctx]
  (if-else ctx (nil? ctx (get-all ctx (?s ctx) ["shipment/sentSignature" "_id"])) false true))

(defn GPSLocation?
  [ctx]
  (if-else ctx (nil? ctx (get ctx (?s ctx) "shipment/GPSLocation")) false true))

(defn shipper?
  [ctx]
  (if-else ctx (nil? ctx (get ctx (?s ctx) "shipment/shipper")) false true))

(defn purchaseOrderReceivedSignaturesAuth
  [ctx]
  (get-all ctx (?s ctx "[{purchaseOrder/shipments [{shipment/receivedSignature [{ organization/auth [_id ]}]}]}]") ["purchaseOrder/shipments" "shipment/receivedSignature" "organization/auth" "_id"]))

(defn authOrgType
  [ctx]
  (get-all ctx (authOrganizationType ctx) ["organization/_auth" "organization/type" "_tag/id"]))

(defn orgType
  [ctx]
  (get-all ctx (organizationType ctx) ["organization/type" "_tag/id"]))

(defn orgAuth
  [ctx]
  (get-all ctx (organizationAuth ctx) ["organization/auth" "_id"]))

(defn senderApprovedPO
  [ctx]
  (contains? ctx (shipmentPOApproved ctx) (shipmentSentBy ctx)))

(defn cafeApprovedPO?
  [ctx]
  (contains? ctx (approvedOrgTypes ctx) "organization/type:cafe"))

(defn growerApprovedPO?
  [ctx]
  (contains? ctx (approvedOrgTypes ctx) "organization/type:grower"))

(defn roasterApprovedPO?
  [ctx]
  (contains? ctx (approvedOrgTypes ctx) "organization/type:roaster"))

(defn didAuthRecieveShipment?
  [ctx]
  (contains? ctx (purchaseOrderReceivedSignaturesAuth ctx) (?auth_id ctx)))

(defn authIsGrower?
  [ctx]
  (contains? ctx (authOrgType ctx) "organization/type:grower"))

(defn authIsRoaster?
  [ctx]
  (contains? ctx (authOrgType ctx) "organization/type:roaster"))

(defn authIsCafe?
  [ctx]
  (contains? ctx (authOrgType ctx) "organization/type:cafe"))

(defn authIsShipper?
  [ctx]
  (contains? ctx (authOrgType ctx) "organization/type:shipper"))

(defn isGrower?
  [ctx]
  (contains? ctx (orgType ctx) "organization/type:grower"))

(defn isRoaster?
  [ctx]
  (contains? ctx (orgType ctx) "organization/type:roaster"))

(defn isCafe
  [ctx]
  (contains? ctx (orgType ctx) "organization/type:cafe"))

(defn isShipper
  [ctx]
  (contains? ctx (orgType ctx) "organization/type:shipper"))

(defn orgAuthIsSelf?
  [ctx]
  (contains? ctx (orgAuth ctx) (?auth_id ctx)))

(defn purchaseOrderPredsReq
  [ctx]
  (and ctx (required ctx "purchaseOrder/id") (required ctx "purchaseOrder/product") (required ctx "purchaseOrder/issuer") (required ctx "purchaseOrder/issueDate") (required ctx "purchaseOrder/name")))

(defn shipmentPredsReq
  [ctx]
  (and ctx (required ctx "shipment/id") (required ctx "shipment/name") (required ctx "shipment/sentBy")  (required ctx "shipment/sentDate") (required ctx "shipment/sentLocation") (required ctx "shipment/itemDescription") (required ctx "shipment/sentSignature") (required ctx "shipment/intendedRecipient") (required ctx "shipment/intendedReceiptLocation")))

(defn onlyCafeCreate
  [ctx]
  (if-else ctx (new? ctx) (authIsCafe? ctx) false))

(defn sentSignatureEqualsSentBy
  [ctx]
  (== ctx (get ctx (?s ctx) "shipment/sentBy") (get ctx (?s ctx) "shipment/sentSignature")))

(defn shipperGPSRequiredTogether
  [ctx]
  (if-else ctx (or ctx (GPSLocation? ctx) (shipper? ctx)) (and ctx (sentSignature? ctx) (GPSLocation? ctx) (shipper? ctx)) true))

(defn recipientIsIntended
  [ctx]
  (== ctx (get ctx (?s ctx) "shipment/intendedRecipient") (get ctx (?s ctx) "shipment/receivedSignature")))

(defn chainOfApproval
  [ctx]
  (if-else ctx (authIsCafe? ctx) (not ctx (growerApprovedPO? ctx)) (if-else ctx (authIsGrower? ctx) (and ctx (cafeApprovedPO? ctx) (not ctx (roasterApprovedPO? ctx))) (if-else ctx (authIsRoaster? ctx) (growerApprovedPO? ctx) false))))
