(ns leiningen.new.smart-function
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files multi-segment sanitize]]
            [leiningen.core.main :as main]) )

(def render (renderer "smart-function"))

(defn smart-function
  "Generate leiningen smart function project"
  [name]
  (let [data {:name name
              :sanitized (sanitize name)
              :string (str (sanitize name))}]
    (main/info "Generating fresh 'lein leiningen' smart-function project.")
    (->files data
             ["README.md" (render "README.md" data)]
             [".VERSION" (render ".VERSION" data)]
             [".gitignore" (render ".gitignore" data)]
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/temp_custom_functions.clj" (render "temp_custom_functions.clj" data)]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["src/{{sanitized}}/fns.clj" (render "fns.clj" data)]
             ["src/{{sanitized}}/internal.clj" (render "internal.clj" data)])))
