(ns org.clojars.smee.binary.gorilla
  (:require [org.clojars.smee.binary.core :as bin]))

(defn write-n-bits [^bytes arr bit-pos n-bits value]
  (assert (>= (alength arr) (int (/ (+ bit-pos n-bits) 8))))
  (loop [bit-pos bit-pos
         bit-idx-in-byte (- 7 (bit-and bit-pos 7))           
         n-bits-left n-bits]
    (if (= n-bits-left 0)
      bit-pos
      (let [byte-idx (bit-shift-right bit-pos 3)
            n-bits-in-byte (min (inc bit-idx-in-byte) n-bits-left)
            v-offset (- n-bits-left n-bits-in-byte)
            mask (bit-shift-left (dec (bit-shift-left 1 n-bits-in-byte)) v-offset)
            v (bit-shift-right (bit-and value mask) v-offset)
            crnt-byte (aget arr byte-idx)
            b (bit-or crnt-byte (bit-shift-left v (- (inc bit-idx-in-byte) n-bits-in-byte)))
            _ (aset arr byte-idx (bin/ubyte->byte b))
            bit-pos (+ bit-pos n-bits-in-byte)
            bit-idx-in-byte (- 7 (bit-and bit-pos 7))]        
        (recur bit-pos
               bit-idx-in-byte
               v-offset)))))

(defn bytes->long [^bytes bytes]
  (.getLong (doto (java.nio.ByteBuffer/allocate Long/BYTES)
              (.put bytes)
              .flip)))

(comment
  (def arr (byte-array 8))
  (doto arr
    (write-n-bits 5 6 63)
    (write-n-bits 50 6 63))
  (Long/toBinaryString (bytes->long arr))
  )
