// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__44099 = cljs.core._EQ_;
var expr__44100 = (function (){var or__20360__auto__ = localStorage.getItem("figwheel_autoload");
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__44099.call(null,"true",expr__44100))){
return true;
} else {
if(cljs.core.truth_(pred__44099.call(null,"false",expr__44100))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__44100)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__44102__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__44102 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__44103__i = 0, G__44103__a = new Array(arguments.length -  0);
while (G__44103__i < G__44103__a.length) {G__44103__a[G__44103__i] = arguments[G__44103__i + 0]; ++G__44103__i;}
  args = new cljs.core.IndexedSeq(G__44103__a,0);
} 
return G__44102__delegate.call(this,args);};
G__44102.cljs$lang$maxFixedArity = 0;
G__44102.cljs$lang$applyTo = (function (arglist__44104){
var args = cljs.core.seq(arglist__44104);
return G__44102__delegate(args);
});
G__44102.cljs$core$IFn$_invoke$arity$variadic = G__44102__delegate;
return G__44102;
})()
;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__44105){
var map__44108 = p__44105;
var map__44108__$1 = ((((!((map__44108 == null)))?((((map__44108.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44108.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44108):map__44108);
var message = cljs.core.get.call(null,map__44108__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__44108__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__20360__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__20348__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__20348__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__20348__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__24690__auto___44270 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___44270,ch){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___44270,ch){
return (function (state_44239){
var state_val_44240 = (state_44239[(1)]);
if((state_val_44240 === (7))){
var inst_44235 = (state_44239[(2)]);
var state_44239__$1 = state_44239;
var statearr_44241_44271 = state_44239__$1;
(statearr_44241_44271[(2)] = inst_44235);

(statearr_44241_44271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (1))){
var state_44239__$1 = state_44239;
var statearr_44242_44272 = state_44239__$1;
(statearr_44242_44272[(2)] = null);

(statearr_44242_44272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (4))){
var inst_44192 = (state_44239[(7)]);
var inst_44192__$1 = (state_44239[(2)]);
var state_44239__$1 = (function (){var statearr_44243 = state_44239;
(statearr_44243[(7)] = inst_44192__$1);

return statearr_44243;
})();
if(cljs.core.truth_(inst_44192__$1)){
var statearr_44244_44273 = state_44239__$1;
(statearr_44244_44273[(1)] = (5));

} else {
var statearr_44245_44274 = state_44239__$1;
(statearr_44245_44274[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (15))){
var inst_44199 = (state_44239[(8)]);
var inst_44214 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_44199);
var inst_44215 = cljs.core.first.call(null,inst_44214);
var inst_44216 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_44215);
var inst_44217 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_44216)].join('');
var inst_44218 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_44217);
var state_44239__$1 = state_44239;
var statearr_44246_44275 = state_44239__$1;
(statearr_44246_44275[(2)] = inst_44218);

(statearr_44246_44275[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (13))){
var inst_44223 = (state_44239[(2)]);
var state_44239__$1 = state_44239;
var statearr_44247_44276 = state_44239__$1;
(statearr_44247_44276[(2)] = inst_44223);

(statearr_44247_44276[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (6))){
var state_44239__$1 = state_44239;
var statearr_44248_44277 = state_44239__$1;
(statearr_44248_44277[(2)] = null);

(statearr_44248_44277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (17))){
var inst_44221 = (state_44239[(2)]);
var state_44239__$1 = state_44239;
var statearr_44249_44278 = state_44239__$1;
(statearr_44249_44278[(2)] = inst_44221);

(statearr_44249_44278[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (3))){
var inst_44237 = (state_44239[(2)]);
var state_44239__$1 = state_44239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44239__$1,inst_44237);
} else {
if((state_val_44240 === (12))){
var inst_44198 = (state_44239[(9)]);
var inst_44212 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_44198,opts);
var state_44239__$1 = state_44239;
if(cljs.core.truth_(inst_44212)){
var statearr_44250_44279 = state_44239__$1;
(statearr_44250_44279[(1)] = (15));

} else {
var statearr_44251_44280 = state_44239__$1;
(statearr_44251_44280[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (2))){
var state_44239__$1 = state_44239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44239__$1,(4),ch);
} else {
if((state_val_44240 === (11))){
var inst_44199 = (state_44239[(8)]);
var inst_44204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44205 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_44199);
var inst_44206 = cljs.core.async.timeout.call(null,(1000));
var inst_44207 = [inst_44205,inst_44206];
var inst_44208 = (new cljs.core.PersistentVector(null,2,(5),inst_44204,inst_44207,null));
var state_44239__$1 = state_44239;
return cljs.core.async.ioc_alts_BANG_.call(null,state_44239__$1,(14),inst_44208);
} else {
if((state_val_44240 === (9))){
var inst_44199 = (state_44239[(8)]);
var inst_44225 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_44226 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_44199);
var inst_44227 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_44226);
var inst_44228 = [cljs.core.str("Not loading: "),cljs.core.str(inst_44227)].join('');
var inst_44229 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_44228);
var state_44239__$1 = (function (){var statearr_44252 = state_44239;
(statearr_44252[(10)] = inst_44225);

return statearr_44252;
})();
var statearr_44253_44281 = state_44239__$1;
(statearr_44253_44281[(2)] = inst_44229);

(statearr_44253_44281[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (5))){
var inst_44192 = (state_44239[(7)]);
var inst_44194 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_44195 = (new cljs.core.PersistentArrayMap(null,2,inst_44194,null));
var inst_44196 = (new cljs.core.PersistentHashSet(null,inst_44195,null));
var inst_44197 = figwheel.client.focus_msgs.call(null,inst_44196,inst_44192);
var inst_44198 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_44197);
var inst_44199 = cljs.core.first.call(null,inst_44197);
var inst_44200 = figwheel.client.autoload_QMARK_.call(null);
var state_44239__$1 = (function (){var statearr_44254 = state_44239;
(statearr_44254[(8)] = inst_44199);

(statearr_44254[(9)] = inst_44198);

return statearr_44254;
})();
if(cljs.core.truth_(inst_44200)){
var statearr_44255_44282 = state_44239__$1;
(statearr_44255_44282[(1)] = (8));

} else {
var statearr_44256_44283 = state_44239__$1;
(statearr_44256_44283[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (14))){
var inst_44210 = (state_44239[(2)]);
var state_44239__$1 = state_44239;
var statearr_44257_44284 = state_44239__$1;
(statearr_44257_44284[(2)] = inst_44210);

(statearr_44257_44284[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (16))){
var state_44239__$1 = state_44239;
var statearr_44258_44285 = state_44239__$1;
(statearr_44258_44285[(2)] = null);

(statearr_44258_44285[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (10))){
var inst_44231 = (state_44239[(2)]);
var state_44239__$1 = (function (){var statearr_44259 = state_44239;
(statearr_44259[(11)] = inst_44231);

return statearr_44259;
})();
var statearr_44260_44286 = state_44239__$1;
(statearr_44260_44286[(2)] = null);

(statearr_44260_44286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44240 === (8))){
var inst_44198 = (state_44239[(9)]);
var inst_44202 = figwheel.client.reload_file_state_QMARK_.call(null,inst_44198,opts);
var state_44239__$1 = state_44239;
if(cljs.core.truth_(inst_44202)){
var statearr_44261_44287 = state_44239__$1;
(statearr_44261_44287[(1)] = (11));

} else {
var statearr_44262_44288 = state_44239__$1;
(statearr_44262_44288[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto___44270,ch))
;
return ((function (switch__24576__auto__,c__24690__auto___44270,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__24577__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__24577__auto____0 = (function (){
var statearr_44266 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44266[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__24577__auto__);

(statearr_44266[(1)] = (1));

return statearr_44266;
});
var figwheel$client$file_reloader_plugin_$_state_machine__24577__auto____1 = (function (state_44239){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_44239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e44267){if((e44267 instanceof Object)){
var ex__24580__auto__ = e44267;
var statearr_44268_44289 = state_44239;
(statearr_44268_44289[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44239);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44267;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44290 = state_44239;
state_44239 = G__44290;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__24577__auto__ = function(state_44239){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__24577__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__24577__auto____1.call(this,state_44239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__24577__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__24577__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___44270,ch))
})();
var state__24692__auto__ = (function (){var statearr_44269 = f__24691__auto__.call(null);
(statearr_44269[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___44270);

return statearr_44269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___44270,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__44291_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__44291_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_44298 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_44298){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_44296 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_44297 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_fn_STAR_44296,_STAR_print_newline_STAR_44297,base_path_44298){
return (function() { 
var G__44299__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__44299 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__44300__i = 0, G__44300__a = new Array(arguments.length -  0);
while (G__44300__i < G__44300__a.length) {G__44300__a[G__44300__i] = arguments[G__44300__i + 0]; ++G__44300__i;}
  args = new cljs.core.IndexedSeq(G__44300__a,0);
} 
return G__44299__delegate.call(this,args);};
G__44299.cljs$lang$maxFixedArity = 0;
G__44299.cljs$lang$applyTo = (function (arglist__44301){
var args = cljs.core.seq(arglist__44301);
return G__44299__delegate(args);
});
G__44299.cljs$core$IFn$_invoke$arity$variadic = G__44299__delegate;
return G__44299;
})()
;})(_STAR_print_fn_STAR_44296,_STAR_print_newline_STAR_44297,base_path_44298))
;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.str(figwheel.client.utils.eval_helper.call(null,code,opts))].join('')], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_44297;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_44296;
}}catch (e44295){if((e44295 instanceof Error)){
var e = e44295;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_44298], null));
} else {
var e = e44295;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_44298))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__44302){
var map__44311 = p__44302;
var map__44311__$1 = ((((!((map__44311 == null)))?((((map__44311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44311.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44311):map__44311);
var opts = map__44311__$1;
var build_id = cljs.core.get.call(null,map__44311__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__44311,map__44311__$1,opts,build_id){
return (function (p__44313){
var vec__44314 = p__44313;
var seq__44315 = cljs.core.seq.call(null,vec__44314);
var first__44316 = cljs.core.first.call(null,seq__44315);
var seq__44315__$1 = cljs.core.next.call(null,seq__44315);
var map__44317 = first__44316;
var map__44317__$1 = ((((!((map__44317 == null)))?((((map__44317.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44317.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44317):map__44317);
var msg = map__44317__$1;
var msg_name = cljs.core.get.call(null,map__44317__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__44315__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__44314,seq__44315,first__44316,seq__44315__$1,map__44317,map__44317__$1,msg,msg_name,_,map__44311,map__44311__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__44314,seq__44315,first__44316,seq__44315__$1,map__44317,map__44317__$1,msg,msg_name,_,map__44311,map__44311__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__44311,map__44311__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__44325){
var vec__44326 = p__44325;
var seq__44327 = cljs.core.seq.call(null,vec__44326);
var first__44328 = cljs.core.first.call(null,seq__44327);
var seq__44327__$1 = cljs.core.next.call(null,seq__44327);
var map__44329 = first__44328;
var map__44329__$1 = ((((!((map__44329 == null)))?((((map__44329.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44329.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44329):map__44329);
var msg = map__44329__$1;
var msg_name = cljs.core.get.call(null,map__44329__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__44327__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__44331){
var map__44343 = p__44331;
var map__44343__$1 = ((((!((map__44343 == null)))?((((map__44343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44343.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44343):map__44343);
var on_compile_warning = cljs.core.get.call(null,map__44343__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__44343__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__44343,map__44343__$1,on_compile_warning,on_compile_fail){
return (function (p__44345){
var vec__44346 = p__44345;
var seq__44347 = cljs.core.seq.call(null,vec__44346);
var first__44348 = cljs.core.first.call(null,seq__44347);
var seq__44347__$1 = cljs.core.next.call(null,seq__44347);
var map__44349 = first__44348;
var map__44349__$1 = ((((!((map__44349 == null)))?((((map__44349.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44349.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44349):map__44349);
var msg = map__44349__$1;
var msg_name = cljs.core.get.call(null,map__44349__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__44347__$1;
var pred__44351 = cljs.core._EQ_;
var expr__44352 = msg_name;
if(cljs.core.truth_(pred__44351.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__44352))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__44351.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__44352))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__44343,map__44343__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__,msg_hist,msg_names,msg){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__,msg_hist,msg_names,msg){
return (function (state_44568){
var state_val_44569 = (state_44568[(1)]);
if((state_val_44569 === (7))){
var inst_44492 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44492)){
var statearr_44570_44616 = state_44568__$1;
(statearr_44570_44616[(1)] = (8));

} else {
var statearr_44571_44617 = state_44568__$1;
(statearr_44571_44617[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (20))){
var inst_44562 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44572_44618 = state_44568__$1;
(statearr_44572_44618[(2)] = inst_44562);

(statearr_44572_44618[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (27))){
var inst_44558 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44573_44619 = state_44568__$1;
(statearr_44573_44619[(2)] = inst_44558);

(statearr_44573_44619[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (1))){
var inst_44485 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44485)){
var statearr_44574_44620 = state_44568__$1;
(statearr_44574_44620[(1)] = (2));

} else {
var statearr_44575_44621 = state_44568__$1;
(statearr_44575_44621[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (24))){
var inst_44560 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44576_44622 = state_44568__$1;
(statearr_44576_44622[(2)] = inst_44560);

(statearr_44576_44622[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (4))){
var inst_44566 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44568__$1,inst_44566);
} else {
if((state_val_44569 === (15))){
var inst_44564 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44577_44623 = state_44568__$1;
(statearr_44577_44623[(2)] = inst_44564);

(statearr_44577_44623[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (21))){
var inst_44523 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44578_44624 = state_44568__$1;
(statearr_44578_44624[(2)] = inst_44523);

(statearr_44578_44624[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (31))){
var inst_44547 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44547)){
var statearr_44579_44625 = state_44568__$1;
(statearr_44579_44625[(1)] = (34));

} else {
var statearr_44580_44626 = state_44568__$1;
(statearr_44580_44626[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (32))){
var inst_44556 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44581_44627 = state_44568__$1;
(statearr_44581_44627[(2)] = inst_44556);

(statearr_44581_44627[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (33))){
var inst_44545 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44582_44628 = state_44568__$1;
(statearr_44582_44628[(2)] = inst_44545);

(statearr_44582_44628[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (13))){
var inst_44506 = figwheel.client.heads_up.clear.call(null);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(16),inst_44506);
} else {
if((state_val_44569 === (22))){
var inst_44527 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44528 = figwheel.client.heads_up.append_message.call(null,inst_44527);
var state_44568__$1 = state_44568;
var statearr_44583_44629 = state_44568__$1;
(statearr_44583_44629[(2)] = inst_44528);

(statearr_44583_44629[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (36))){
var inst_44554 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44584_44630 = state_44568__$1;
(statearr_44584_44630[(2)] = inst_44554);

(statearr_44584_44630[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (29))){
var inst_44538 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44585_44631 = state_44568__$1;
(statearr_44585_44631[(2)] = inst_44538);

(statearr_44585_44631[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (6))){
var inst_44487 = (state_44568[(7)]);
var state_44568__$1 = state_44568;
var statearr_44586_44632 = state_44568__$1;
(statearr_44586_44632[(2)] = inst_44487);

(statearr_44586_44632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (28))){
var inst_44534 = (state_44568[(2)]);
var inst_44535 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44536 = figwheel.client.heads_up.display_warning.call(null,inst_44535);
var state_44568__$1 = (function (){var statearr_44587 = state_44568;
(statearr_44587[(8)] = inst_44534);

return statearr_44587;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(29),inst_44536);
} else {
if((state_val_44569 === (25))){
var inst_44532 = figwheel.client.heads_up.clear.call(null);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(28),inst_44532);
} else {
if((state_val_44569 === (34))){
var inst_44549 = figwheel.client.heads_up.flash_loaded.call(null);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(37),inst_44549);
} else {
if((state_val_44569 === (17))){
var inst_44514 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44588_44633 = state_44568__$1;
(statearr_44588_44633[(2)] = inst_44514);

(statearr_44588_44633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (3))){
var inst_44504 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44504)){
var statearr_44589_44634 = state_44568__$1;
(statearr_44589_44634[(1)] = (13));

} else {
var statearr_44590_44635 = state_44568__$1;
(statearr_44590_44635[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (12))){
var inst_44500 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44591_44636 = state_44568__$1;
(statearr_44591_44636[(2)] = inst_44500);

(statearr_44591_44636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (2))){
var inst_44487 = (state_44568[(7)]);
var inst_44487__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_44568__$1 = (function (){var statearr_44592 = state_44568;
(statearr_44592[(7)] = inst_44487__$1);

return statearr_44592;
})();
if(cljs.core.truth_(inst_44487__$1)){
var statearr_44593_44637 = state_44568__$1;
(statearr_44593_44637[(1)] = (5));

} else {
var statearr_44594_44638 = state_44568__$1;
(statearr_44594_44638[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (23))){
var inst_44530 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44530)){
var statearr_44595_44639 = state_44568__$1;
(statearr_44595_44639[(1)] = (25));

} else {
var statearr_44596_44640 = state_44568__$1;
(statearr_44596_44640[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (35))){
var state_44568__$1 = state_44568;
var statearr_44597_44641 = state_44568__$1;
(statearr_44597_44641[(2)] = null);

(statearr_44597_44641[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (19))){
var inst_44525 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44525)){
var statearr_44598_44642 = state_44568__$1;
(statearr_44598_44642[(1)] = (22));

} else {
var statearr_44599_44643 = state_44568__$1;
(statearr_44599_44643[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (11))){
var inst_44496 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44600_44644 = state_44568__$1;
(statearr_44600_44644[(2)] = inst_44496);

(statearr_44600_44644[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (9))){
var inst_44498 = figwheel.client.heads_up.clear.call(null);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(12),inst_44498);
} else {
if((state_val_44569 === (5))){
var inst_44489 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_44568__$1 = state_44568;
var statearr_44601_44645 = state_44568__$1;
(statearr_44601_44645[(2)] = inst_44489);

(statearr_44601_44645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (14))){
var inst_44516 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44516)){
var statearr_44602_44646 = state_44568__$1;
(statearr_44602_44646[(1)] = (18));

} else {
var statearr_44603_44647 = state_44568__$1;
(statearr_44603_44647[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (26))){
var inst_44540 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_44568__$1 = state_44568;
if(cljs.core.truth_(inst_44540)){
var statearr_44604_44648 = state_44568__$1;
(statearr_44604_44648[(1)] = (30));

} else {
var statearr_44605_44649 = state_44568__$1;
(statearr_44605_44649[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (16))){
var inst_44508 = (state_44568[(2)]);
var inst_44509 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44510 = figwheel.client.format_messages.call(null,inst_44509);
var inst_44511 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44512 = figwheel.client.heads_up.display_error.call(null,inst_44510,inst_44511);
var state_44568__$1 = (function (){var statearr_44606 = state_44568;
(statearr_44606[(9)] = inst_44508);

return statearr_44606;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(17),inst_44512);
} else {
if((state_val_44569 === (30))){
var inst_44542 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44543 = figwheel.client.heads_up.display_warning.call(null,inst_44542);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(33),inst_44543);
} else {
if((state_val_44569 === (10))){
var inst_44502 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44607_44650 = state_44568__$1;
(statearr_44607_44650[(2)] = inst_44502);

(statearr_44607_44650[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (18))){
var inst_44518 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44519 = figwheel.client.format_messages.call(null,inst_44518);
var inst_44520 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_44521 = figwheel.client.heads_up.display_error.call(null,inst_44519,inst_44520);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(21),inst_44521);
} else {
if((state_val_44569 === (37))){
var inst_44551 = (state_44568[(2)]);
var state_44568__$1 = state_44568;
var statearr_44608_44651 = state_44568__$1;
(statearr_44608_44651[(2)] = inst_44551);

(statearr_44608_44651[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44569 === (8))){
var inst_44494 = figwheel.client.heads_up.flash_loaded.call(null);
var state_44568__$1 = state_44568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44568__$1,(11),inst_44494);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__24576__auto__,c__24690__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto____0 = (function (){
var statearr_44612 = [null,null,null,null,null,null,null,null,null,null];
(statearr_44612[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto__);

(statearr_44612[(1)] = (1));

return statearr_44612;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto____1 = (function (state_44568){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_44568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e44613){if((e44613 instanceof Object)){
var ex__24580__auto__ = e44613;
var statearr_44614_44652 = state_44568;
(statearr_44614_44652[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44613;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44653 = state_44568;
state_44568 = G__44653;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto__ = function(state_44568){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto____1.call(this,state_44568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__,msg_hist,msg_names,msg))
})();
var state__24692__auto__ = (function (){var statearr_44615 = f__24691__auto__.call(null);
(statearr_44615[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_44615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__,msg_hist,msg_names,msg))
);

return c__24690__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__24690__auto___44716 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___44716,ch){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___44716,ch){
return (function (state_44699){
var state_val_44700 = (state_44699[(1)]);
if((state_val_44700 === (1))){
var state_44699__$1 = state_44699;
var statearr_44701_44717 = state_44699__$1;
(statearr_44701_44717[(2)] = null);

(statearr_44701_44717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44700 === (2))){
var state_44699__$1 = state_44699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44699__$1,(4),ch);
} else {
if((state_val_44700 === (3))){
var inst_44697 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44699__$1,inst_44697);
} else {
if((state_val_44700 === (4))){
var inst_44687 = (state_44699[(7)]);
var inst_44687__$1 = (state_44699[(2)]);
var state_44699__$1 = (function (){var statearr_44702 = state_44699;
(statearr_44702[(7)] = inst_44687__$1);

return statearr_44702;
})();
if(cljs.core.truth_(inst_44687__$1)){
var statearr_44703_44718 = state_44699__$1;
(statearr_44703_44718[(1)] = (5));

} else {
var statearr_44704_44719 = state_44699__$1;
(statearr_44704_44719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44700 === (5))){
var inst_44687 = (state_44699[(7)]);
var inst_44689 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_44687);
var state_44699__$1 = state_44699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44699__$1,(8),inst_44689);
} else {
if((state_val_44700 === (6))){
var state_44699__$1 = state_44699;
var statearr_44705_44720 = state_44699__$1;
(statearr_44705_44720[(2)] = null);

(statearr_44705_44720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44700 === (7))){
var inst_44695 = (state_44699[(2)]);
var state_44699__$1 = state_44699;
var statearr_44706_44721 = state_44699__$1;
(statearr_44706_44721[(2)] = inst_44695);

(statearr_44706_44721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44700 === (8))){
var inst_44691 = (state_44699[(2)]);
var state_44699__$1 = (function (){var statearr_44707 = state_44699;
(statearr_44707[(8)] = inst_44691);

return statearr_44707;
})();
var statearr_44708_44722 = state_44699__$1;
(statearr_44708_44722[(2)] = null);

(statearr_44708_44722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__24690__auto___44716,ch))
;
return ((function (switch__24576__auto__,c__24690__auto___44716,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__24577__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__24577__auto____0 = (function (){
var statearr_44712 = [null,null,null,null,null,null,null,null,null];
(statearr_44712[(0)] = figwheel$client$heads_up_plugin_$_state_machine__24577__auto__);

(statearr_44712[(1)] = (1));

return statearr_44712;
});
var figwheel$client$heads_up_plugin_$_state_machine__24577__auto____1 = (function (state_44699){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_44699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e44713){if((e44713 instanceof Object)){
var ex__24580__auto__ = e44713;
var statearr_44714_44723 = state_44699;
(statearr_44714_44723[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44724 = state_44699;
state_44699 = G__44724;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__24577__auto__ = function(state_44699){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__24577__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__24577__auto____1.call(this,state_44699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__24577__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__24577__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___44716,ch))
})();
var state__24692__auto__ = (function (){var statearr_44715 = f__24691__auto__.call(null);
(statearr_44715[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___44716);

return statearr_44715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___44716,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__){
return (function (state_44745){
var state_val_44746 = (state_44745[(1)]);
if((state_val_44746 === (1))){
var inst_44740 = cljs.core.async.timeout.call(null,(3000));
var state_44745__$1 = state_44745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_44745__$1,(2),inst_44740);
} else {
if((state_val_44746 === (2))){
var inst_44742 = (state_44745[(2)]);
var inst_44743 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_44745__$1 = (function (){var statearr_44747 = state_44745;
(statearr_44747[(7)] = inst_44742);

return statearr_44747;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_44745__$1,inst_44743);
} else {
return null;
}
}
});})(c__24690__auto__))
;
return ((function (switch__24576__auto__,c__24690__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__24577__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__24577__auto____0 = (function (){
var statearr_44751 = [null,null,null,null,null,null,null,null];
(statearr_44751[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__24577__auto__);

(statearr_44751[(1)] = (1));

return statearr_44751;
});
var figwheel$client$enforce_project_plugin_$_state_machine__24577__auto____1 = (function (state_44745){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_44745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e44752){if((e44752 instanceof Object)){
var ex__24580__auto__ = e44752;
var statearr_44753_44755 = state_44745;
(statearr_44753_44755[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_44745);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e44752;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44756 = state_44745;
state_44745 = G__44756;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__24577__auto__ = function(state_44745){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__24577__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__24577__auto____1.call(this,state_44745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__24577__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__24577__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__))
})();
var state__24692__auto__ = (function (){var statearr_44754 = f__24691__auto__.call(null);
(statearr_44754[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_44754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__))
);

return c__24690__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__44757){
var map__44764 = p__44757;
var map__44764__$1 = ((((!((map__44764 == null)))?((((map__44764.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44764.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44764):map__44764);
var ed = map__44764__$1;
var formatted_exception = cljs.core.get.call(null,map__44764__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__44764__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__44764__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__44766_44770 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__44767_44771 = null;
var count__44768_44772 = (0);
var i__44769_44773 = (0);
while(true){
if((i__44769_44773 < count__44768_44772)){
var msg_44774 = cljs.core._nth.call(null,chunk__44767_44771,i__44769_44773);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_44774);

var G__44775 = seq__44766_44770;
var G__44776 = chunk__44767_44771;
var G__44777 = count__44768_44772;
var G__44778 = (i__44769_44773 + (1));
seq__44766_44770 = G__44775;
chunk__44767_44771 = G__44776;
count__44768_44772 = G__44777;
i__44769_44773 = G__44778;
continue;
} else {
var temp__6753__auto___44779 = cljs.core.seq.call(null,seq__44766_44770);
if(temp__6753__auto___44779){
var seq__44766_44780__$1 = temp__6753__auto___44779;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44766_44780__$1)){
var c__21266__auto___44781 = cljs.core.chunk_first.call(null,seq__44766_44780__$1);
var G__44782 = cljs.core.chunk_rest.call(null,seq__44766_44780__$1);
var G__44783 = c__21266__auto___44781;
var G__44784 = cljs.core.count.call(null,c__21266__auto___44781);
var G__44785 = (0);
seq__44766_44770 = G__44782;
chunk__44767_44771 = G__44783;
count__44768_44772 = G__44784;
i__44769_44773 = G__44785;
continue;
} else {
var msg_44786 = cljs.core.first.call(null,seq__44766_44780__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_44786);

var G__44787 = cljs.core.next.call(null,seq__44766_44780__$1);
var G__44788 = null;
var G__44789 = (0);
var G__44790 = (0);
seq__44766_44770 = G__44787;
chunk__44767_44771 = G__44788;
count__44768_44772 = G__44789;
i__44769_44773 = G__44790;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__44791){
var map__44794 = p__44791;
var map__44794__$1 = ((((!((map__44794 == null)))?((((map__44794.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44794.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44794):map__44794);
var w = map__44794__$1;
var message = cljs.core.get.call(null,map__44794__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__20348__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__20348__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__20348__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__44806 = cljs.core.seq.call(null,plugins);
var chunk__44807 = null;
var count__44808 = (0);
var i__44809 = (0);
while(true){
if((i__44809 < count__44808)){
var vec__44810 = cljs.core._nth.call(null,chunk__44807,i__44809);
var k = cljs.core.nth.call(null,vec__44810,(0),null);
var plugin = cljs.core.nth.call(null,vec__44810,(1),null);
if(cljs.core.truth_(plugin)){
var pl_44816 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__44806,chunk__44807,count__44808,i__44809,pl_44816,vec__44810,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_44816.call(null,msg_hist);
});})(seq__44806,chunk__44807,count__44808,i__44809,pl_44816,vec__44810,k,plugin))
);
} else {
}

var G__44817 = seq__44806;
var G__44818 = chunk__44807;
var G__44819 = count__44808;
var G__44820 = (i__44809 + (1));
seq__44806 = G__44817;
chunk__44807 = G__44818;
count__44808 = G__44819;
i__44809 = G__44820;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__44806);
if(temp__6753__auto__){
var seq__44806__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44806__$1)){
var c__21266__auto__ = cljs.core.chunk_first.call(null,seq__44806__$1);
var G__44821 = cljs.core.chunk_rest.call(null,seq__44806__$1);
var G__44822 = c__21266__auto__;
var G__44823 = cljs.core.count.call(null,c__21266__auto__);
var G__44824 = (0);
seq__44806 = G__44821;
chunk__44807 = G__44822;
count__44808 = G__44823;
i__44809 = G__44824;
continue;
} else {
var vec__44813 = cljs.core.first.call(null,seq__44806__$1);
var k = cljs.core.nth.call(null,vec__44813,(0),null);
var plugin = cljs.core.nth.call(null,vec__44813,(1),null);
if(cljs.core.truth_(plugin)){
var pl_44825 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__44806,chunk__44807,count__44808,i__44809,pl_44825,vec__44813,k,plugin,seq__44806__$1,temp__6753__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_44825.call(null,msg_hist);
});})(seq__44806,chunk__44807,count__44808,i__44809,pl_44825,vec__44813,k,plugin,seq__44806__$1,temp__6753__auto__))
);
} else {
}

var G__44826 = cljs.core.next.call(null,seq__44806__$1);
var G__44827 = null;
var G__44828 = (0);
var G__44829 = (0);
seq__44806 = G__44826;
chunk__44807 = G__44827;
count__44808 = G__44828;
i__44809 = G__44829;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args44830 = [];
var len__21576__auto___44833 = arguments.length;
var i__21577__auto___44834 = (0);
while(true){
if((i__21577__auto___44834 < len__21576__auto___44833)){
args44830.push((arguments[i__21577__auto___44834]));

var G__44835 = (i__21577__auto___44834 + (1));
i__21577__auto___44834 = G__44835;
continue;
} else {
}
break;
}

var G__44832 = args44830.length;
switch (G__44832) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args44830.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__21583__auto__ = [];
var len__21576__auto___44841 = arguments.length;
var i__21577__auto___44842 = (0);
while(true){
if((i__21577__auto___44842 < len__21576__auto___44841)){
args__21583__auto__.push((arguments[i__21577__auto___44842]));

var G__44843 = (i__21577__auto___44842 + (1));
i__21577__auto___44842 = G__44843;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((0) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__21584__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__44838){
var map__44839 = p__44838;
var map__44839__$1 = ((((!((map__44839 == null)))?((((map__44839.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44839.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44839):map__44839);
var opts = map__44839__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq44837){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq44837));
});


//# sourceMappingURL=client.js.map