// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__20360__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__20360__auto__){
return or__20360__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__20360__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__41194_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__41194_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__41199 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__41200 = null;
var count__41201 = (0);
var i__41202 = (0);
while(true){
if((i__41202 < count__41201)){
var n = cljs.core._nth.call(null,chunk__41200,i__41202);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__41203 = seq__41199;
var G__41204 = chunk__41200;
var G__41205 = count__41201;
var G__41206 = (i__41202 + (1));
seq__41199 = G__41203;
chunk__41200 = G__41204;
count__41201 = G__41205;
i__41202 = G__41206;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__41199);
if(temp__6753__auto__){
var seq__41199__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41199__$1)){
var c__21266__auto__ = cljs.core.chunk_first.call(null,seq__41199__$1);
var G__41207 = cljs.core.chunk_rest.call(null,seq__41199__$1);
var G__41208 = c__21266__auto__;
var G__41209 = cljs.core.count.call(null,c__21266__auto__);
var G__41210 = (0);
seq__41199 = G__41207;
chunk__41200 = G__41208;
count__41201 = G__41209;
i__41202 = G__41210;
continue;
} else {
var n = cljs.core.first.call(null,seq__41199__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__41211 = cljs.core.next.call(null,seq__41199__$1);
var G__41212 = null;
var G__41213 = (0);
var G__41214 = (0);
seq__41199 = G__41211;
chunk__41200 = G__41212;
count__41201 = G__41213;
i__41202 = G__41214;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__41265_41276 = cljs.core.seq.call(null,deps);
var chunk__41266_41277 = null;
var count__41267_41278 = (0);
var i__41268_41279 = (0);
while(true){
if((i__41268_41279 < count__41267_41278)){
var dep_41280 = cljs.core._nth.call(null,chunk__41266_41277,i__41268_41279);
topo_sort_helper_STAR_.call(null,dep_41280,(depth + (1)),state);

var G__41281 = seq__41265_41276;
var G__41282 = chunk__41266_41277;
var G__41283 = count__41267_41278;
var G__41284 = (i__41268_41279 + (1));
seq__41265_41276 = G__41281;
chunk__41266_41277 = G__41282;
count__41267_41278 = G__41283;
i__41268_41279 = G__41284;
continue;
} else {
var temp__6753__auto___41285 = cljs.core.seq.call(null,seq__41265_41276);
if(temp__6753__auto___41285){
var seq__41265_41286__$1 = temp__6753__auto___41285;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41265_41286__$1)){
var c__21266__auto___41287 = cljs.core.chunk_first.call(null,seq__41265_41286__$1);
var G__41288 = cljs.core.chunk_rest.call(null,seq__41265_41286__$1);
var G__41289 = c__21266__auto___41287;
var G__41290 = cljs.core.count.call(null,c__21266__auto___41287);
var G__41291 = (0);
seq__41265_41276 = G__41288;
chunk__41266_41277 = G__41289;
count__41267_41278 = G__41290;
i__41268_41279 = G__41291;
continue;
} else {
var dep_41292 = cljs.core.first.call(null,seq__41265_41286__$1);
topo_sort_helper_STAR_.call(null,dep_41292,(depth + (1)),state);

var G__41293 = cljs.core.next.call(null,seq__41265_41286__$1);
var G__41294 = null;
var G__41295 = (0);
var G__41296 = (0);
seq__41265_41276 = G__41293;
chunk__41266_41277 = G__41294;
count__41267_41278 = G__41295;
i__41268_41279 = G__41296;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__41269){
var vec__41273 = p__41269;
var seq__41274 = cljs.core.seq.call(null,vec__41273);
var first__41275 = cljs.core.first.call(null,seq__41274);
var seq__41274__$1 = cljs.core.next.call(null,seq__41274);
var x = first__41275;
var xs = seq__41274__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__41273,seq__41274,first__41275,seq__41274__$1,x,xs,get_deps__$1){
return (function (p1__41215_SHARP_){
return clojure.set.difference.call(null,p1__41215_SHARP_,x);
});})(vec__41273,seq__41274,first__41275,seq__41274__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__41309 = cljs.core.seq.call(null,provides);
var chunk__41310 = null;
var count__41311 = (0);
var i__41312 = (0);
while(true){
if((i__41312 < count__41311)){
var prov = cljs.core._nth.call(null,chunk__41310,i__41312);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__41313_41321 = cljs.core.seq.call(null,requires);
var chunk__41314_41322 = null;
var count__41315_41323 = (0);
var i__41316_41324 = (0);
while(true){
if((i__41316_41324 < count__41315_41323)){
var req_41325 = cljs.core._nth.call(null,chunk__41314_41322,i__41316_41324);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_41325,prov);

var G__41326 = seq__41313_41321;
var G__41327 = chunk__41314_41322;
var G__41328 = count__41315_41323;
var G__41329 = (i__41316_41324 + (1));
seq__41313_41321 = G__41326;
chunk__41314_41322 = G__41327;
count__41315_41323 = G__41328;
i__41316_41324 = G__41329;
continue;
} else {
var temp__6753__auto___41330 = cljs.core.seq.call(null,seq__41313_41321);
if(temp__6753__auto___41330){
var seq__41313_41331__$1 = temp__6753__auto___41330;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41313_41331__$1)){
var c__21266__auto___41332 = cljs.core.chunk_first.call(null,seq__41313_41331__$1);
var G__41333 = cljs.core.chunk_rest.call(null,seq__41313_41331__$1);
var G__41334 = c__21266__auto___41332;
var G__41335 = cljs.core.count.call(null,c__21266__auto___41332);
var G__41336 = (0);
seq__41313_41321 = G__41333;
chunk__41314_41322 = G__41334;
count__41315_41323 = G__41335;
i__41316_41324 = G__41336;
continue;
} else {
var req_41337 = cljs.core.first.call(null,seq__41313_41331__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_41337,prov);

var G__41338 = cljs.core.next.call(null,seq__41313_41331__$1);
var G__41339 = null;
var G__41340 = (0);
var G__41341 = (0);
seq__41313_41321 = G__41338;
chunk__41314_41322 = G__41339;
count__41315_41323 = G__41340;
i__41316_41324 = G__41341;
continue;
}
} else {
}
}
break;
}

var G__41342 = seq__41309;
var G__41343 = chunk__41310;
var G__41344 = count__41311;
var G__41345 = (i__41312 + (1));
seq__41309 = G__41342;
chunk__41310 = G__41343;
count__41311 = G__41344;
i__41312 = G__41345;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__41309);
if(temp__6753__auto__){
var seq__41309__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41309__$1)){
var c__21266__auto__ = cljs.core.chunk_first.call(null,seq__41309__$1);
var G__41346 = cljs.core.chunk_rest.call(null,seq__41309__$1);
var G__41347 = c__21266__auto__;
var G__41348 = cljs.core.count.call(null,c__21266__auto__);
var G__41349 = (0);
seq__41309 = G__41346;
chunk__41310 = G__41347;
count__41311 = G__41348;
i__41312 = G__41349;
continue;
} else {
var prov = cljs.core.first.call(null,seq__41309__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__41317_41350 = cljs.core.seq.call(null,requires);
var chunk__41318_41351 = null;
var count__41319_41352 = (0);
var i__41320_41353 = (0);
while(true){
if((i__41320_41353 < count__41319_41352)){
var req_41354 = cljs.core._nth.call(null,chunk__41318_41351,i__41320_41353);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_41354,prov);

var G__41355 = seq__41317_41350;
var G__41356 = chunk__41318_41351;
var G__41357 = count__41319_41352;
var G__41358 = (i__41320_41353 + (1));
seq__41317_41350 = G__41355;
chunk__41318_41351 = G__41356;
count__41319_41352 = G__41357;
i__41320_41353 = G__41358;
continue;
} else {
var temp__6753__auto___41359__$1 = cljs.core.seq.call(null,seq__41317_41350);
if(temp__6753__auto___41359__$1){
var seq__41317_41360__$1 = temp__6753__auto___41359__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41317_41360__$1)){
var c__21266__auto___41361 = cljs.core.chunk_first.call(null,seq__41317_41360__$1);
var G__41362 = cljs.core.chunk_rest.call(null,seq__41317_41360__$1);
var G__41363 = c__21266__auto___41361;
var G__41364 = cljs.core.count.call(null,c__21266__auto___41361);
var G__41365 = (0);
seq__41317_41350 = G__41362;
chunk__41318_41351 = G__41363;
count__41319_41352 = G__41364;
i__41320_41353 = G__41365;
continue;
} else {
var req_41366 = cljs.core.first.call(null,seq__41317_41360__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_41366,prov);

var G__41367 = cljs.core.next.call(null,seq__41317_41360__$1);
var G__41368 = null;
var G__41369 = (0);
var G__41370 = (0);
seq__41317_41350 = G__41367;
chunk__41318_41351 = G__41368;
count__41319_41352 = G__41369;
i__41320_41353 = G__41370;
continue;
}
} else {
}
}
break;
}

var G__41371 = cljs.core.next.call(null,seq__41309__$1);
var G__41372 = null;
var G__41373 = (0);
var G__41374 = (0);
seq__41309 = G__41371;
chunk__41310 = G__41372;
count__41311 = G__41373;
i__41312 = G__41374;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__41379_41383 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__41380_41384 = null;
var count__41381_41385 = (0);
var i__41382_41386 = (0);
while(true){
if((i__41382_41386 < count__41381_41385)){
var ns_41387 = cljs.core._nth.call(null,chunk__41380_41384,i__41382_41386);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_41387);

var G__41388 = seq__41379_41383;
var G__41389 = chunk__41380_41384;
var G__41390 = count__41381_41385;
var G__41391 = (i__41382_41386 + (1));
seq__41379_41383 = G__41388;
chunk__41380_41384 = G__41389;
count__41381_41385 = G__41390;
i__41382_41386 = G__41391;
continue;
} else {
var temp__6753__auto___41392 = cljs.core.seq.call(null,seq__41379_41383);
if(temp__6753__auto___41392){
var seq__41379_41393__$1 = temp__6753__auto___41392;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41379_41393__$1)){
var c__21266__auto___41394 = cljs.core.chunk_first.call(null,seq__41379_41393__$1);
var G__41395 = cljs.core.chunk_rest.call(null,seq__41379_41393__$1);
var G__41396 = c__21266__auto___41394;
var G__41397 = cljs.core.count.call(null,c__21266__auto___41394);
var G__41398 = (0);
seq__41379_41383 = G__41395;
chunk__41380_41384 = G__41396;
count__41381_41385 = G__41397;
i__41382_41386 = G__41398;
continue;
} else {
var ns_41399 = cljs.core.first.call(null,seq__41379_41393__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_41399);

var G__41400 = cljs.core.next.call(null,seq__41379_41393__$1);
var G__41401 = null;
var G__41402 = (0);
var G__41403 = (0);
seq__41379_41383 = G__41400;
chunk__41380_41384 = G__41401;
count__41381_41385 = G__41402;
i__41382_41386 = G__41403;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__20360__auto__ = goog.require__;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__41404__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__41404 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__41405__i = 0, G__41405__a = new Array(arguments.length -  0);
while (G__41405__i < G__41405__a.length) {G__41405__a[G__41405__i] = arguments[G__41405__i + 0]; ++G__41405__i;}
  args = new cljs.core.IndexedSeq(G__41405__a,0);
} 
return G__41404__delegate.call(this,args);};
G__41404.cljs$lang$maxFixedArity = 0;
G__41404.cljs$lang$applyTo = (function (arglist__41406){
var args = cljs.core.seq(arglist__41406);
return G__41404__delegate(args);
});
G__41404.cljs$core$IFn$_invoke$arity$variadic = G__41404__delegate;
return G__41404;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__41408 = cljs.core._EQ_;
var expr__41409 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__41408.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__41409))){
var path_parts = ((function (pred__41408,expr__41409){
return (function (p1__41407_SHARP_){
return clojure.string.split.call(null,p1__41407_SHARP_,/[\/\\]/);
});})(pred__41408,expr__41409))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__41408,expr__41409){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e41411){if((e41411 instanceof Error)){
var e = e41411;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e41411;

}
}})());
});
;})(path_parts,sep,root,pred__41408,expr__41409))
} else {
if(cljs.core.truth_(pred__41408.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__41409))){
return ((function (pred__41408,expr__41409){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__41408,expr__41409){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__41408,expr__41409))
);

return deferred.addErrback(((function (deferred,pred__41408,expr__41409){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__41408,expr__41409))
);
});
;})(pred__41408,expr__41409))
} else {
return ((function (pred__41408,expr__41409){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__41408,expr__41409))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__41412,callback){
var map__41415 = p__41412;
var map__41415__$1 = ((((!((map__41415 == null)))?((((map__41415.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41415.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41415):map__41415);
var file_msg = map__41415__$1;
var request_url = cljs.core.get.call(null,map__41415__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__41415,map__41415__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__41415,map__41415__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__){
return (function (state_41439){
var state_val_41440 = (state_41439[(1)]);
if((state_val_41440 === (7))){
var inst_41435 = (state_41439[(2)]);
var state_41439__$1 = state_41439;
var statearr_41441_41461 = state_41439__$1;
(statearr_41441_41461[(2)] = inst_41435);

(statearr_41441_41461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41440 === (1))){
var state_41439__$1 = state_41439;
var statearr_41442_41462 = state_41439__$1;
(statearr_41442_41462[(2)] = null);

(statearr_41442_41462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41440 === (4))){
var inst_41419 = (state_41439[(7)]);
var inst_41419__$1 = (state_41439[(2)]);
var state_41439__$1 = (function (){var statearr_41443 = state_41439;
(statearr_41443[(7)] = inst_41419__$1);

return statearr_41443;
})();
if(cljs.core.truth_(inst_41419__$1)){
var statearr_41444_41463 = state_41439__$1;
(statearr_41444_41463[(1)] = (5));

} else {
var statearr_41445_41464 = state_41439__$1;
(statearr_41445_41464[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41440 === (6))){
var state_41439__$1 = state_41439;
var statearr_41446_41465 = state_41439__$1;
(statearr_41446_41465[(2)] = null);

(statearr_41446_41465[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41440 === (3))){
var inst_41437 = (state_41439[(2)]);
var state_41439__$1 = state_41439;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41439__$1,inst_41437);
} else {
if((state_val_41440 === (2))){
var state_41439__$1 = state_41439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41439__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_41440 === (11))){
var inst_41431 = (state_41439[(2)]);
var state_41439__$1 = (function (){var statearr_41447 = state_41439;
(statearr_41447[(8)] = inst_41431);

return statearr_41447;
})();
var statearr_41448_41466 = state_41439__$1;
(statearr_41448_41466[(2)] = null);

(statearr_41448_41466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41440 === (9))){
var inst_41423 = (state_41439[(9)]);
var inst_41425 = (state_41439[(10)]);
var inst_41427 = inst_41425.call(null,inst_41423);
var state_41439__$1 = state_41439;
var statearr_41449_41467 = state_41439__$1;
(statearr_41449_41467[(2)] = inst_41427);

(statearr_41449_41467[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41440 === (5))){
var inst_41419 = (state_41439[(7)]);
var inst_41421 = figwheel.client.file_reloading.blocking_load.call(null,inst_41419);
var state_41439__$1 = state_41439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41439__$1,(8),inst_41421);
} else {
if((state_val_41440 === (10))){
var inst_41423 = (state_41439[(9)]);
var inst_41429 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_41423);
var state_41439__$1 = state_41439;
var statearr_41450_41468 = state_41439__$1;
(statearr_41450_41468[(2)] = inst_41429);

(statearr_41450_41468[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41440 === (8))){
var inst_41419 = (state_41439[(7)]);
var inst_41425 = (state_41439[(10)]);
var inst_41423 = (state_41439[(2)]);
var inst_41424 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_41425__$1 = cljs.core.get.call(null,inst_41424,inst_41419);
var state_41439__$1 = (function (){var statearr_41451 = state_41439;
(statearr_41451[(9)] = inst_41423);

(statearr_41451[(10)] = inst_41425__$1);

return statearr_41451;
})();
if(cljs.core.truth_(inst_41425__$1)){
var statearr_41452_41469 = state_41439__$1;
(statearr_41452_41469[(1)] = (9));

} else {
var statearr_41453_41470 = state_41439__$1;
(statearr_41453_41470[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto__))
;
return ((function (switch__24576__auto__,c__24690__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__24577__auto__ = null;
var figwheel$client$file_reloading$state_machine__24577__auto____0 = (function (){
var statearr_41457 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_41457[(0)] = figwheel$client$file_reloading$state_machine__24577__auto__);

(statearr_41457[(1)] = (1));

return statearr_41457;
});
var figwheel$client$file_reloading$state_machine__24577__auto____1 = (function (state_41439){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_41439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e41458){if((e41458 instanceof Object)){
var ex__24580__auto__ = e41458;
var statearr_41459_41471 = state_41439;
(statearr_41459_41471[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41439);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41458;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41472 = state_41439;
state_41439 = G__41472;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__24577__auto__ = function(state_41439){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__24577__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__24577__auto____1.call(this,state_41439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__24577__auto____0;
figwheel$client$file_reloading$state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__24577__auto____1;
return figwheel$client$file_reloading$state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__))
})();
var state__24692__auto__ = (function (){var statearr_41460 = f__24691__auto__.call(null);
(statearr_41460[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_41460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__))
);

return c__24690__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__41473,callback){
var map__41476 = p__41473;
var map__41476__$1 = ((((!((map__41476 == null)))?((((map__41476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41476.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41476):map__41476);
var file_msg = map__41476__$1;
var namespace = cljs.core.get.call(null,map__41476__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__41476,map__41476__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__41476,map__41476__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__41478){
var map__41481 = p__41478;
var map__41481__$1 = ((((!((map__41481 == null)))?((((map__41481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41481.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41481):map__41481);
var file_msg = map__41481__$1;
var namespace = cljs.core.get.call(null,map__41481__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__20348__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__20348__auto__){
var or__20360__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
var or__20360__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20360__auto____$1)){
return or__20360__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__20348__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__41483,callback){
var map__41486 = p__41483;
var map__41486__$1 = ((((!((map__41486 == null)))?((((map__41486.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41486.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41486):map__41486);
var file_msg = map__41486__$1;
var request_url = cljs.core.get.call(null,map__41486__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__41486__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__24690__auto___41590 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto___41590,out){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto___41590,out){
return (function (state_41572){
var state_val_41573 = (state_41572[(1)]);
if((state_val_41573 === (1))){
var inst_41546 = cljs.core.seq.call(null,files);
var inst_41547 = cljs.core.first.call(null,inst_41546);
var inst_41548 = cljs.core.next.call(null,inst_41546);
var inst_41549 = files;
var state_41572__$1 = (function (){var statearr_41574 = state_41572;
(statearr_41574[(7)] = inst_41547);

(statearr_41574[(8)] = inst_41549);

(statearr_41574[(9)] = inst_41548);

return statearr_41574;
})();
var statearr_41575_41591 = state_41572__$1;
(statearr_41575_41591[(2)] = null);

(statearr_41575_41591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41573 === (2))){
var inst_41555 = (state_41572[(10)]);
var inst_41549 = (state_41572[(8)]);
var inst_41554 = cljs.core.seq.call(null,inst_41549);
var inst_41555__$1 = cljs.core.first.call(null,inst_41554);
var inst_41556 = cljs.core.next.call(null,inst_41554);
var inst_41557 = (inst_41555__$1 == null);
var inst_41558 = cljs.core.not.call(null,inst_41557);
var state_41572__$1 = (function (){var statearr_41576 = state_41572;
(statearr_41576[(11)] = inst_41556);

(statearr_41576[(10)] = inst_41555__$1);

return statearr_41576;
})();
if(inst_41558){
var statearr_41577_41592 = state_41572__$1;
(statearr_41577_41592[(1)] = (4));

} else {
var statearr_41578_41593 = state_41572__$1;
(statearr_41578_41593[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41573 === (3))){
var inst_41570 = (state_41572[(2)]);
var state_41572__$1 = state_41572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41572__$1,inst_41570);
} else {
if((state_val_41573 === (4))){
var inst_41555 = (state_41572[(10)]);
var inst_41560 = figwheel.client.file_reloading.reload_js_file.call(null,inst_41555);
var state_41572__$1 = state_41572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41572__$1,(7),inst_41560);
} else {
if((state_val_41573 === (5))){
var inst_41566 = cljs.core.async.close_BANG_.call(null,out);
var state_41572__$1 = state_41572;
var statearr_41579_41594 = state_41572__$1;
(statearr_41579_41594[(2)] = inst_41566);

(statearr_41579_41594[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41573 === (6))){
var inst_41568 = (state_41572[(2)]);
var state_41572__$1 = state_41572;
var statearr_41580_41595 = state_41572__$1;
(statearr_41580_41595[(2)] = inst_41568);

(statearr_41580_41595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41573 === (7))){
var inst_41556 = (state_41572[(11)]);
var inst_41562 = (state_41572[(2)]);
var inst_41563 = cljs.core.async.put_BANG_.call(null,out,inst_41562);
var inst_41549 = inst_41556;
var state_41572__$1 = (function (){var statearr_41581 = state_41572;
(statearr_41581[(12)] = inst_41563);

(statearr_41581[(8)] = inst_41549);

return statearr_41581;
})();
var statearr_41582_41596 = state_41572__$1;
(statearr_41582_41596[(2)] = null);

(statearr_41582_41596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__24690__auto___41590,out))
;
return ((function (switch__24576__auto__,c__24690__auto___41590,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto____0 = (function (){
var statearr_41586 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41586[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto__);

(statearr_41586[(1)] = (1));

return statearr_41586;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto____1 = (function (state_41572){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_41572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e41587){if((e41587 instanceof Object)){
var ex__24580__auto__ = e41587;
var statearr_41588_41597 = state_41572;
(statearr_41588_41597[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41587;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41598 = state_41572;
state_41572 = G__41598;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto__ = function(state_41572){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto____1.call(this,state_41572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto___41590,out))
})();
var state__24692__auto__ = (function (){var statearr_41589 = f__24691__auto__.call(null);
(statearr_41589[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto___41590);

return statearr_41589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto___41590,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__41599,opts){
var map__41603 = p__41599;
var map__41603__$1 = ((((!((map__41603 == null)))?((((map__41603.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41603.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41603):map__41603);
var eval_body = cljs.core.get.call(null,map__41603__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__41603__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__20348__auto__ = eval_body;
if(cljs.core.truth_(and__20348__auto__)){
return typeof eval_body === 'string';
} else {
return and__20348__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e41605){var e = e41605;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__41606_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__41606_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__41615){
var vec__41616 = p__41615;
var k = cljs.core.nth.call(null,vec__41616,(0),null);
var v = cljs.core.nth.call(null,vec__41616,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__41619){
var vec__41620 = p__41619;
var k = cljs.core.nth.call(null,vec__41620,(0),null);
var v = cljs.core.nth.call(null,vec__41620,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__41626,p__41627){
var map__41875 = p__41626;
var map__41875__$1 = ((((!((map__41875 == null)))?((((map__41875.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41875.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41875):map__41875);
var opts = map__41875__$1;
var before_jsload = cljs.core.get.call(null,map__41875__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__41875__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__41875__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__41876 = p__41627;
var map__41876__$1 = ((((!((map__41876 == null)))?((((map__41876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41876.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41876):map__41876);
var msg = map__41876__$1;
var files = cljs.core.get.call(null,map__41876__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__41876__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__41876__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__24690__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__24691__auto__ = (function (){var switch__24576__auto__ = ((function (c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_42030){
var state_val_42031 = (state_42030[(1)]);
if((state_val_42031 === (7))){
var inst_41891 = (state_42030[(7)]);
var inst_41890 = (state_42030[(8)]);
var inst_41892 = (state_42030[(9)]);
var inst_41893 = (state_42030[(10)]);
var inst_41898 = cljs.core._nth.call(null,inst_41891,inst_41893);
var inst_41899 = figwheel.client.file_reloading.eval_body.call(null,inst_41898,opts);
var inst_41900 = (inst_41893 + (1));
var tmp42032 = inst_41891;
var tmp42033 = inst_41890;
var tmp42034 = inst_41892;
var inst_41890__$1 = tmp42033;
var inst_41891__$1 = tmp42032;
var inst_41892__$1 = tmp42034;
var inst_41893__$1 = inst_41900;
var state_42030__$1 = (function (){var statearr_42035 = state_42030;
(statearr_42035[(7)] = inst_41891__$1);

(statearr_42035[(8)] = inst_41890__$1);

(statearr_42035[(9)] = inst_41892__$1);

(statearr_42035[(10)] = inst_41893__$1);

(statearr_42035[(11)] = inst_41899);

return statearr_42035;
})();
var statearr_42036_42122 = state_42030__$1;
(statearr_42036_42122[(2)] = null);

(statearr_42036_42122[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (20))){
var inst_41933 = (state_42030[(12)]);
var inst_41941 = figwheel.client.file_reloading.sort_files.call(null,inst_41933);
var state_42030__$1 = state_42030;
var statearr_42037_42123 = state_42030__$1;
(statearr_42037_42123[(2)] = inst_41941);

(statearr_42037_42123[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (27))){
var state_42030__$1 = state_42030;
var statearr_42038_42124 = state_42030__$1;
(statearr_42038_42124[(2)] = null);

(statearr_42038_42124[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (1))){
var inst_41882 = (state_42030[(13)]);
var inst_41879 = before_jsload.call(null,files);
var inst_41880 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_41881 = (function (){return ((function (inst_41882,inst_41879,inst_41880,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__41623_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__41623_SHARP_);
});
;})(inst_41882,inst_41879,inst_41880,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41882__$1 = cljs.core.filter.call(null,inst_41881,files);
var inst_41883 = cljs.core.not_empty.call(null,inst_41882__$1);
var state_42030__$1 = (function (){var statearr_42039 = state_42030;
(statearr_42039[(14)] = inst_41879);

(statearr_42039[(15)] = inst_41880);

(statearr_42039[(13)] = inst_41882__$1);

return statearr_42039;
})();
if(cljs.core.truth_(inst_41883)){
var statearr_42040_42125 = state_42030__$1;
(statearr_42040_42125[(1)] = (2));

} else {
var statearr_42041_42126 = state_42030__$1;
(statearr_42041_42126[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (24))){
var state_42030__$1 = state_42030;
var statearr_42042_42127 = state_42030__$1;
(statearr_42042_42127[(2)] = null);

(statearr_42042_42127[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (39))){
var inst_41983 = (state_42030[(16)]);
var state_42030__$1 = state_42030;
var statearr_42043_42128 = state_42030__$1;
(statearr_42043_42128[(2)] = inst_41983);

(statearr_42043_42128[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (46))){
var inst_42025 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
var statearr_42044_42129 = state_42030__$1;
(statearr_42044_42129[(2)] = inst_42025);

(statearr_42044_42129[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (4))){
var inst_41927 = (state_42030[(2)]);
var inst_41928 = cljs.core.List.EMPTY;
var inst_41929 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_41928);
var inst_41930 = (function (){return ((function (inst_41927,inst_41928,inst_41929,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__41624_SHARP_){
var and__20348__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__41624_SHARP_);
if(cljs.core.truth_(and__20348__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__41624_SHARP_));
} else {
return and__20348__auto__;
}
});
;})(inst_41927,inst_41928,inst_41929,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41931 = cljs.core.filter.call(null,inst_41930,files);
var inst_41932 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_41933 = cljs.core.concat.call(null,inst_41931,inst_41932);
var state_42030__$1 = (function (){var statearr_42045 = state_42030;
(statearr_42045[(17)] = inst_41929);

(statearr_42045[(18)] = inst_41927);

(statearr_42045[(12)] = inst_41933);

return statearr_42045;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_42046_42130 = state_42030__$1;
(statearr_42046_42130[(1)] = (16));

} else {
var statearr_42047_42131 = state_42030__$1;
(statearr_42047_42131[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (15))){
var inst_41917 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
var statearr_42048_42132 = state_42030__$1;
(statearr_42048_42132[(2)] = inst_41917);

(statearr_42048_42132[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (21))){
var inst_41943 = (state_42030[(19)]);
var inst_41943__$1 = (state_42030[(2)]);
var inst_41944 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_41943__$1);
var state_42030__$1 = (function (){var statearr_42049 = state_42030;
(statearr_42049[(19)] = inst_41943__$1);

return statearr_42049;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42030__$1,(22),inst_41944);
} else {
if((state_val_42031 === (31))){
var inst_42028 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42030__$1,inst_42028);
} else {
if((state_val_42031 === (32))){
var inst_41983 = (state_42030[(16)]);
var inst_41988 = inst_41983.cljs$lang$protocol_mask$partition0$;
var inst_41989 = (inst_41988 & (64));
var inst_41990 = inst_41983.cljs$core$ISeq$;
var inst_41991 = (cljs.core.PROTOCOL_SENTINEL === inst_41990);
var inst_41992 = (inst_41989) || (inst_41991);
var state_42030__$1 = state_42030;
if(cljs.core.truth_(inst_41992)){
var statearr_42050_42133 = state_42030__$1;
(statearr_42050_42133[(1)] = (35));

} else {
var statearr_42051_42134 = state_42030__$1;
(statearr_42051_42134[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (40))){
var inst_42005 = (state_42030[(20)]);
var inst_42004 = (state_42030[(2)]);
var inst_42005__$1 = cljs.core.get.call(null,inst_42004,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_42006 = cljs.core.get.call(null,inst_42004,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_42007 = cljs.core.not_empty.call(null,inst_42005__$1);
var state_42030__$1 = (function (){var statearr_42052 = state_42030;
(statearr_42052[(21)] = inst_42006);

(statearr_42052[(20)] = inst_42005__$1);

return statearr_42052;
})();
if(cljs.core.truth_(inst_42007)){
var statearr_42053_42135 = state_42030__$1;
(statearr_42053_42135[(1)] = (41));

} else {
var statearr_42054_42136 = state_42030__$1;
(statearr_42054_42136[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (33))){
var state_42030__$1 = state_42030;
var statearr_42055_42137 = state_42030__$1;
(statearr_42055_42137[(2)] = false);

(statearr_42055_42137[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (13))){
var inst_41903 = (state_42030[(22)]);
var inst_41907 = cljs.core.chunk_first.call(null,inst_41903);
var inst_41908 = cljs.core.chunk_rest.call(null,inst_41903);
var inst_41909 = cljs.core.count.call(null,inst_41907);
var inst_41890 = inst_41908;
var inst_41891 = inst_41907;
var inst_41892 = inst_41909;
var inst_41893 = (0);
var state_42030__$1 = (function (){var statearr_42056 = state_42030;
(statearr_42056[(7)] = inst_41891);

(statearr_42056[(8)] = inst_41890);

(statearr_42056[(9)] = inst_41892);

(statearr_42056[(10)] = inst_41893);

return statearr_42056;
})();
var statearr_42057_42138 = state_42030__$1;
(statearr_42057_42138[(2)] = null);

(statearr_42057_42138[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (22))){
var inst_41943 = (state_42030[(19)]);
var inst_41951 = (state_42030[(23)]);
var inst_41947 = (state_42030[(24)]);
var inst_41946 = (state_42030[(25)]);
var inst_41946__$1 = (state_42030[(2)]);
var inst_41947__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_41946__$1);
var inst_41948 = (function (){var all_files = inst_41943;
var res_SINGLEQUOTE_ = inst_41946__$1;
var res = inst_41947__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_41943,inst_41951,inst_41947,inst_41946,inst_41946__$1,inst_41947__$1,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__41625_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__41625_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_41943,inst_41951,inst_41947,inst_41946,inst_41946__$1,inst_41947__$1,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41949 = cljs.core.filter.call(null,inst_41948,inst_41946__$1);
var inst_41950 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_41951__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_41950);
var inst_41952 = cljs.core.not_empty.call(null,inst_41951__$1);
var state_42030__$1 = (function (){var statearr_42058 = state_42030;
(statearr_42058[(26)] = inst_41949);

(statearr_42058[(23)] = inst_41951__$1);

(statearr_42058[(24)] = inst_41947__$1);

(statearr_42058[(25)] = inst_41946__$1);

return statearr_42058;
})();
if(cljs.core.truth_(inst_41952)){
var statearr_42059_42139 = state_42030__$1;
(statearr_42059_42139[(1)] = (23));

} else {
var statearr_42060_42140 = state_42030__$1;
(statearr_42060_42140[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (36))){
var state_42030__$1 = state_42030;
var statearr_42061_42141 = state_42030__$1;
(statearr_42061_42141[(2)] = false);

(statearr_42061_42141[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (41))){
var inst_42005 = (state_42030[(20)]);
var inst_42009 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_42010 = cljs.core.map.call(null,inst_42009,inst_42005);
var inst_42011 = cljs.core.pr_str.call(null,inst_42010);
var inst_42012 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_42011)].join('');
var inst_42013 = figwheel.client.utils.log.call(null,inst_42012);
var state_42030__$1 = state_42030;
var statearr_42062_42142 = state_42030__$1;
(statearr_42062_42142[(2)] = inst_42013);

(statearr_42062_42142[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (43))){
var inst_42006 = (state_42030[(21)]);
var inst_42016 = (state_42030[(2)]);
var inst_42017 = cljs.core.not_empty.call(null,inst_42006);
var state_42030__$1 = (function (){var statearr_42063 = state_42030;
(statearr_42063[(27)] = inst_42016);

return statearr_42063;
})();
if(cljs.core.truth_(inst_42017)){
var statearr_42064_42143 = state_42030__$1;
(statearr_42064_42143[(1)] = (44));

} else {
var statearr_42065_42144 = state_42030__$1;
(statearr_42065_42144[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (29))){
var inst_41943 = (state_42030[(19)]);
var inst_41983 = (state_42030[(16)]);
var inst_41949 = (state_42030[(26)]);
var inst_41951 = (state_42030[(23)]);
var inst_41947 = (state_42030[(24)]);
var inst_41946 = (state_42030[(25)]);
var inst_41979 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_41982 = (function (){var all_files = inst_41943;
var res_SINGLEQUOTE_ = inst_41946;
var res = inst_41947;
var files_not_loaded = inst_41949;
var dependencies_that_loaded = inst_41951;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41983,inst_41949,inst_41951,inst_41947,inst_41946,inst_41979,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__41981){
var map__42066 = p__41981;
var map__42066__$1 = ((((!((map__42066 == null)))?((((map__42066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42066.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42066):map__42066);
var namespace = cljs.core.get.call(null,map__42066__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41983,inst_41949,inst_41951,inst_41947,inst_41946,inst_41979,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41983__$1 = cljs.core.group_by.call(null,inst_41982,inst_41949);
var inst_41985 = (inst_41983__$1 == null);
var inst_41986 = cljs.core.not.call(null,inst_41985);
var state_42030__$1 = (function (){var statearr_42068 = state_42030;
(statearr_42068[(16)] = inst_41983__$1);

(statearr_42068[(28)] = inst_41979);

return statearr_42068;
})();
if(inst_41986){
var statearr_42069_42145 = state_42030__$1;
(statearr_42069_42145[(1)] = (32));

} else {
var statearr_42070_42146 = state_42030__$1;
(statearr_42070_42146[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (44))){
var inst_42006 = (state_42030[(21)]);
var inst_42019 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_42006);
var inst_42020 = cljs.core.pr_str.call(null,inst_42019);
var inst_42021 = [cljs.core.str("not required: "),cljs.core.str(inst_42020)].join('');
var inst_42022 = figwheel.client.utils.log.call(null,inst_42021);
var state_42030__$1 = state_42030;
var statearr_42071_42147 = state_42030__$1;
(statearr_42071_42147[(2)] = inst_42022);

(statearr_42071_42147[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (6))){
var inst_41924 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
var statearr_42072_42148 = state_42030__$1;
(statearr_42072_42148[(2)] = inst_41924);

(statearr_42072_42148[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (28))){
var inst_41949 = (state_42030[(26)]);
var inst_41976 = (state_42030[(2)]);
var inst_41977 = cljs.core.not_empty.call(null,inst_41949);
var state_42030__$1 = (function (){var statearr_42073 = state_42030;
(statearr_42073[(29)] = inst_41976);

return statearr_42073;
})();
if(cljs.core.truth_(inst_41977)){
var statearr_42074_42149 = state_42030__$1;
(statearr_42074_42149[(1)] = (29));

} else {
var statearr_42075_42150 = state_42030__$1;
(statearr_42075_42150[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (25))){
var inst_41947 = (state_42030[(24)]);
var inst_41963 = (state_42030[(2)]);
var inst_41964 = cljs.core.not_empty.call(null,inst_41947);
var state_42030__$1 = (function (){var statearr_42076 = state_42030;
(statearr_42076[(30)] = inst_41963);

return statearr_42076;
})();
if(cljs.core.truth_(inst_41964)){
var statearr_42077_42151 = state_42030__$1;
(statearr_42077_42151[(1)] = (26));

} else {
var statearr_42078_42152 = state_42030__$1;
(statearr_42078_42152[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (34))){
var inst_41999 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
if(cljs.core.truth_(inst_41999)){
var statearr_42079_42153 = state_42030__$1;
(statearr_42079_42153[(1)] = (38));

} else {
var statearr_42080_42154 = state_42030__$1;
(statearr_42080_42154[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (17))){
var state_42030__$1 = state_42030;
var statearr_42081_42155 = state_42030__$1;
(statearr_42081_42155[(2)] = recompile_dependents);

(statearr_42081_42155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (3))){
var state_42030__$1 = state_42030;
var statearr_42082_42156 = state_42030__$1;
(statearr_42082_42156[(2)] = null);

(statearr_42082_42156[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (12))){
var inst_41920 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
var statearr_42083_42157 = state_42030__$1;
(statearr_42083_42157[(2)] = inst_41920);

(statearr_42083_42157[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (2))){
var inst_41882 = (state_42030[(13)]);
var inst_41889 = cljs.core.seq.call(null,inst_41882);
var inst_41890 = inst_41889;
var inst_41891 = null;
var inst_41892 = (0);
var inst_41893 = (0);
var state_42030__$1 = (function (){var statearr_42084 = state_42030;
(statearr_42084[(7)] = inst_41891);

(statearr_42084[(8)] = inst_41890);

(statearr_42084[(9)] = inst_41892);

(statearr_42084[(10)] = inst_41893);

return statearr_42084;
})();
var statearr_42085_42158 = state_42030__$1;
(statearr_42085_42158[(2)] = null);

(statearr_42085_42158[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (23))){
var inst_41943 = (state_42030[(19)]);
var inst_41949 = (state_42030[(26)]);
var inst_41951 = (state_42030[(23)]);
var inst_41947 = (state_42030[(24)]);
var inst_41946 = (state_42030[(25)]);
var inst_41954 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_41956 = (function (){var all_files = inst_41943;
var res_SINGLEQUOTE_ = inst_41946;
var res = inst_41947;
var files_not_loaded = inst_41949;
var dependencies_that_loaded = inst_41951;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41949,inst_41951,inst_41947,inst_41946,inst_41954,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__41955){
var map__42086 = p__41955;
var map__42086__$1 = ((((!((map__42086 == null)))?((((map__42086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42086.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42086):map__42086);
var request_url = cljs.core.get.call(null,map__42086__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41949,inst_41951,inst_41947,inst_41946,inst_41954,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41957 = cljs.core.reverse.call(null,inst_41951);
var inst_41958 = cljs.core.map.call(null,inst_41956,inst_41957);
var inst_41959 = cljs.core.pr_str.call(null,inst_41958);
var inst_41960 = figwheel.client.utils.log.call(null,inst_41959);
var state_42030__$1 = (function (){var statearr_42088 = state_42030;
(statearr_42088[(31)] = inst_41954);

return statearr_42088;
})();
var statearr_42089_42159 = state_42030__$1;
(statearr_42089_42159[(2)] = inst_41960);

(statearr_42089_42159[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (35))){
var state_42030__$1 = state_42030;
var statearr_42090_42160 = state_42030__$1;
(statearr_42090_42160[(2)] = true);

(statearr_42090_42160[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (19))){
var inst_41933 = (state_42030[(12)]);
var inst_41939 = figwheel.client.file_reloading.expand_files.call(null,inst_41933);
var state_42030__$1 = state_42030;
var statearr_42091_42161 = state_42030__$1;
(statearr_42091_42161[(2)] = inst_41939);

(statearr_42091_42161[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (11))){
var state_42030__$1 = state_42030;
var statearr_42092_42162 = state_42030__$1;
(statearr_42092_42162[(2)] = null);

(statearr_42092_42162[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (9))){
var inst_41922 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
var statearr_42093_42163 = state_42030__$1;
(statearr_42093_42163[(2)] = inst_41922);

(statearr_42093_42163[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (5))){
var inst_41892 = (state_42030[(9)]);
var inst_41893 = (state_42030[(10)]);
var inst_41895 = (inst_41893 < inst_41892);
var inst_41896 = inst_41895;
var state_42030__$1 = state_42030;
if(cljs.core.truth_(inst_41896)){
var statearr_42094_42164 = state_42030__$1;
(statearr_42094_42164[(1)] = (7));

} else {
var statearr_42095_42165 = state_42030__$1;
(statearr_42095_42165[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (14))){
var inst_41903 = (state_42030[(22)]);
var inst_41912 = cljs.core.first.call(null,inst_41903);
var inst_41913 = figwheel.client.file_reloading.eval_body.call(null,inst_41912,opts);
var inst_41914 = cljs.core.next.call(null,inst_41903);
var inst_41890 = inst_41914;
var inst_41891 = null;
var inst_41892 = (0);
var inst_41893 = (0);
var state_42030__$1 = (function (){var statearr_42096 = state_42030;
(statearr_42096[(7)] = inst_41891);

(statearr_42096[(8)] = inst_41890);

(statearr_42096[(9)] = inst_41892);

(statearr_42096[(10)] = inst_41893);

(statearr_42096[(32)] = inst_41913);

return statearr_42096;
})();
var statearr_42097_42166 = state_42030__$1;
(statearr_42097_42166[(2)] = null);

(statearr_42097_42166[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (45))){
var state_42030__$1 = state_42030;
var statearr_42098_42167 = state_42030__$1;
(statearr_42098_42167[(2)] = null);

(statearr_42098_42167[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (26))){
var inst_41943 = (state_42030[(19)]);
var inst_41949 = (state_42030[(26)]);
var inst_41951 = (state_42030[(23)]);
var inst_41947 = (state_42030[(24)]);
var inst_41946 = (state_42030[(25)]);
var inst_41966 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_41968 = (function (){var all_files = inst_41943;
var res_SINGLEQUOTE_ = inst_41946;
var res = inst_41947;
var files_not_loaded = inst_41949;
var dependencies_that_loaded = inst_41951;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41949,inst_41951,inst_41947,inst_41946,inst_41966,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__41967){
var map__42099 = p__41967;
var map__42099__$1 = ((((!((map__42099 == null)))?((((map__42099.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42099.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42099):map__42099);
var namespace = cljs.core.get.call(null,map__42099__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__42099__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41949,inst_41951,inst_41947,inst_41946,inst_41966,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41969 = cljs.core.map.call(null,inst_41968,inst_41947);
var inst_41970 = cljs.core.pr_str.call(null,inst_41969);
var inst_41971 = figwheel.client.utils.log.call(null,inst_41970);
var inst_41972 = (function (){var all_files = inst_41943;
var res_SINGLEQUOTE_ = inst_41946;
var res = inst_41947;
var files_not_loaded = inst_41949;
var dependencies_that_loaded = inst_41951;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41949,inst_41951,inst_41947,inst_41946,inst_41966,inst_41968,inst_41969,inst_41970,inst_41971,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_41943,inst_41949,inst_41951,inst_41947,inst_41946,inst_41966,inst_41968,inst_41969,inst_41970,inst_41971,state_val_42031,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_41973 = setTimeout(inst_41972,(10));
var state_42030__$1 = (function (){var statearr_42101 = state_42030;
(statearr_42101[(33)] = inst_41966);

(statearr_42101[(34)] = inst_41971);

return statearr_42101;
})();
var statearr_42102_42168 = state_42030__$1;
(statearr_42102_42168[(2)] = inst_41973);

(statearr_42102_42168[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (16))){
var state_42030__$1 = state_42030;
var statearr_42103_42169 = state_42030__$1;
(statearr_42103_42169[(2)] = reload_dependents);

(statearr_42103_42169[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (38))){
var inst_41983 = (state_42030[(16)]);
var inst_42001 = cljs.core.apply.call(null,cljs.core.hash_map,inst_41983);
var state_42030__$1 = state_42030;
var statearr_42104_42170 = state_42030__$1;
(statearr_42104_42170[(2)] = inst_42001);

(statearr_42104_42170[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (30))){
var state_42030__$1 = state_42030;
var statearr_42105_42171 = state_42030__$1;
(statearr_42105_42171[(2)] = null);

(statearr_42105_42171[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (10))){
var inst_41903 = (state_42030[(22)]);
var inst_41905 = cljs.core.chunked_seq_QMARK_.call(null,inst_41903);
var state_42030__$1 = state_42030;
if(inst_41905){
var statearr_42106_42172 = state_42030__$1;
(statearr_42106_42172[(1)] = (13));

} else {
var statearr_42107_42173 = state_42030__$1;
(statearr_42107_42173[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (18))){
var inst_41937 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
if(cljs.core.truth_(inst_41937)){
var statearr_42108_42174 = state_42030__$1;
(statearr_42108_42174[(1)] = (19));

} else {
var statearr_42109_42175 = state_42030__$1;
(statearr_42109_42175[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (42))){
var state_42030__$1 = state_42030;
var statearr_42110_42176 = state_42030__$1;
(statearr_42110_42176[(2)] = null);

(statearr_42110_42176[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (37))){
var inst_41996 = (state_42030[(2)]);
var state_42030__$1 = state_42030;
var statearr_42111_42177 = state_42030__$1;
(statearr_42111_42177[(2)] = inst_41996);

(statearr_42111_42177[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42031 === (8))){
var inst_41890 = (state_42030[(8)]);
var inst_41903 = (state_42030[(22)]);
var inst_41903__$1 = cljs.core.seq.call(null,inst_41890);
var state_42030__$1 = (function (){var statearr_42112 = state_42030;
(statearr_42112[(22)] = inst_41903__$1);

return statearr_42112;
})();
if(inst_41903__$1){
var statearr_42113_42178 = state_42030__$1;
(statearr_42113_42178[(1)] = (10));

} else {
var statearr_42114_42179 = state_42030__$1;
(statearr_42114_42179[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__24576__auto__,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto____0 = (function (){
var statearr_42118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42118[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto__);

(statearr_42118[(1)] = (1));

return statearr_42118;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto____1 = (function (state_42030){
while(true){
var ret_value__24578__auto__ = (function (){try{while(true){
var result__24579__auto__ = switch__24576__auto__.call(null,state_42030);
if(cljs.core.keyword_identical_QMARK_.call(null,result__24579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__24579__auto__;
}
break;
}
}catch (e42119){if((e42119 instanceof Object)){
var ex__24580__auto__ = e42119;
var statearr_42120_42180 = state_42030;
(statearr_42120_42180[(5)] = ex__24580__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42030);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42119;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__24578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42181 = state_42030;
state_42030 = G__42181;
continue;
} else {
return ret_value__24578__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto__ = function(state_42030){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto____1.call(this,state_42030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__24577__auto__;
})()
;})(switch__24576__auto__,c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__24692__auto__ = (function (){var statearr_42121 = f__24691__auto__.call(null);
(statearr_42121[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__24690__auto__);

return statearr_42121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__24692__auto__);
});})(c__24690__auto__,map__41875,map__41875__$1,opts,before_jsload,on_jsload,reload_dependents,map__41876,map__41876__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__24690__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__42184,link){
var map__42187 = p__42184;
var map__42187__$1 = ((((!((map__42187 == null)))?((((map__42187.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42187.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42187):map__42187);
var file = cljs.core.get.call(null,map__42187__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__42187,map__42187__$1,file){
return (function (p1__42182_SHARP_,p2__42183_SHARP_){
if(cljs.core._EQ_.call(null,p1__42182_SHARP_,p2__42183_SHARP_)){
return p1__42182_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__42187,map__42187__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__42193){
var map__42194 = p__42193;
var map__42194__$1 = ((((!((map__42194 == null)))?((((map__42194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42194.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42194):map__42194);
var match_length = cljs.core.get.call(null,map__42194__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__42194__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__42189_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__42189_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args42196 = [];
var len__21576__auto___42199 = arguments.length;
var i__21577__auto___42200 = (0);
while(true){
if((i__21577__auto___42200 < len__21576__auto___42199)){
args42196.push((arguments[i__21577__auto___42200]));

var G__42201 = (i__21577__auto___42200 + (1));
i__21577__auto___42200 = G__42201;
continue;
} else {
}
break;
}

var G__42198 = args42196.length;
switch (G__42198) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42196.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__42203_SHARP_,p2__42204_SHARP_){
return cljs.core.assoc.call(null,p1__42203_SHARP_,cljs.core.get.call(null,p2__42204_SHARP_,key),p2__42204_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__42205){
var map__42208 = p__42205;
var map__42208__$1 = ((((!((map__42208 == null)))?((((map__42208.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42208.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42208):map__42208);
var f_data = map__42208__$1;
var file = cljs.core.get.call(null,map__42208__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__42210,files_msg){
var map__42217 = p__42210;
var map__42217__$1 = ((((!((map__42217 == null)))?((((map__42217.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42217.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42217):map__42217);
var opts = map__42217__$1;
var on_cssload = cljs.core.get.call(null,map__42217__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__42219_42223 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__42220_42224 = null;
var count__42221_42225 = (0);
var i__42222_42226 = (0);
while(true){
if((i__42222_42226 < count__42221_42225)){
var f_42227 = cljs.core._nth.call(null,chunk__42220_42224,i__42222_42226);
figwheel.client.file_reloading.reload_css_file.call(null,f_42227);

var G__42228 = seq__42219_42223;
var G__42229 = chunk__42220_42224;
var G__42230 = count__42221_42225;
var G__42231 = (i__42222_42226 + (1));
seq__42219_42223 = G__42228;
chunk__42220_42224 = G__42229;
count__42221_42225 = G__42230;
i__42222_42226 = G__42231;
continue;
} else {
var temp__6753__auto___42232 = cljs.core.seq.call(null,seq__42219_42223);
if(temp__6753__auto___42232){
var seq__42219_42233__$1 = temp__6753__auto___42232;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42219_42233__$1)){
var c__21266__auto___42234 = cljs.core.chunk_first.call(null,seq__42219_42233__$1);
var G__42235 = cljs.core.chunk_rest.call(null,seq__42219_42233__$1);
var G__42236 = c__21266__auto___42234;
var G__42237 = cljs.core.count.call(null,c__21266__auto___42234);
var G__42238 = (0);
seq__42219_42223 = G__42235;
chunk__42220_42224 = G__42236;
count__42221_42225 = G__42237;
i__42222_42226 = G__42238;
continue;
} else {
var f_42239 = cljs.core.first.call(null,seq__42219_42233__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_42239);

var G__42240 = cljs.core.next.call(null,seq__42219_42233__$1);
var G__42241 = null;
var G__42242 = (0);
var G__42243 = (0);
seq__42219_42223 = G__42240;
chunk__42220_42224 = G__42241;
count__42221_42225 = G__42242;
i__42222_42226 = G__42243;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__42217,map__42217__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__42217,map__42217__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map