// Compiled by ClojureScript 1.9.293 {}
goog.provide('om_tools.dom');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('om.dom');
/**
 * Converts kebab-case to camelCase
 */
om_tools.dom.camel_case = (function om_tools$dom$camel_case(s){
return clojure.string.replace.call(null,s,/-(\w)/,cljs.core.comp.call(null,clojure.string.upper_case,cljs.core.second));
});
/**
 * Converts attributes that are kebab-case and should be camelCase
 */
om_tools.dom.opt_key_case = (function om_tools$dom$opt_key_case(attr){
if(cljs.core.truth_((function (){var or__20360__auto__ = (cljs.core.count.call(null,attr) < (5));
if(or__20360__auto__){
return or__20360__auto__;
} else {
var G__33789 = cljs.core.subs.call(null,attr,(0),(5));
switch (G__33789) {
case "data-":
case "aria-":
return true;

break;
default:
return false;

}
}
})())){
return attr;
} else {
return om_tools.dom.camel_case.call(null,attr);
}
});
/**
 * Converts aliased attributes
 */
om_tools.dom.opt_key_alias = (function om_tools$dom$opt_key_alias(opt){
var G__33792 = (((opt instanceof cljs.core.Keyword))?opt.fqn:null);
switch (G__33792) {
case "class":
return new cljs.core.Keyword(null,"className","className",-1983287057);

break;
case "for":
return new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720);

break;
default:
return opt;

}
});
/**
 * Returns potentially formatted name for DOM element attribute.
 * Converts kebab-case to camelCase.
 */
om_tools.dom.format_opt_key = (function om_tools$dom$format_opt_key(opt_key){
return cljs.core.keyword.call(null,om_tools.dom.opt_key_case.call(null,cljs.core.name.call(null,om_tools.dom.opt_key_alias.call(null,opt_key))));
});
/**
 * Returns potentially modified value for DOM element attribute.
 * Recursively formats map values (ie :style attribute)
 */
om_tools.dom.format_opt_val = (function om_tools$dom$format_opt_val(opt_val){
if(cljs.core.map_QMARK_.call(null,opt_val)){
return om_tools.dom.format_opts.call(null,opt_val);
} else {
return opt_val;

}
});
/**
 * Returns JavaScript object for React DOM attributes from opts map
 */
om_tools.dom.format_opts = (function om_tools$dom$format_opts(opts){
if(cljs.core.map_QMARK_.call(null,opts)){
return cljs.core.clj__GT_js.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__33798){
var vec__33799 = p__33798;
var k = cljs.core.nth.call(null,vec__33799,(0),null);
var v = cljs.core.nth.call(null,vec__33799,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_tools.dom.format_opt_key.call(null,k),om_tools.dom.format_opt_val.call(null,v)], null);
}),opts)));
} else {
return opts;
}
});
om_tools.dom.possible_coll_QMARK_ = (function om_tools$dom$possible_coll_QMARK_(form){
return (cljs.core.coll_QMARK_.call(null,form)) || ((form instanceof cljs.core.Symbol)) || (cljs.core.list_QMARK_.call(null,form));
});
om_tools.dom.valid_element_QMARK_ = (function om_tools$dom$valid_element_QMARK_(x){
return (function (){var or__20360__auto__ = React.isValidElement;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return React.isValidComponent;
}
})().call(null,x);
});
om_tools.dom.js_opts_QMARK_ = (function om_tools$dom$js_opts_QMARK_(x){
return (cljs.core.object_QMARK_.call(null,x)) && (!(om_tools.dom.valid_element_QMARK_.call(null,x)));
});
/**
 * Returns a vector of [opts children] for from first and second
 *   argument given to DOM function
 */
om_tools.dom.element_args = (function om_tools$dom$element_args(opts,children){
if((opts == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,children], null);
} else {
if(cljs.core.map_QMARK_.call(null,opts)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_tools.dom.format_opts.call(null,opts),children], null);
} else {
if(cljs.core.truth_(om_tools.dom.js_opts_QMARK_.call(null,opts))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [opts,children], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.cons.call(null,opts,children)], null);

}
}
}
});
om_tools.dom.element = (function om_tools$dom$element(ctor,opts,children){
var vec__33805 = om_tools.dom.element_args.call(null,opts,children);
var opts__$1 = cljs.core.nth.call(null,vec__33805,(0),null);
var children__$1 = cljs.core.nth.call(null,vec__33805,(1),null);
return cljs.core.apply.call(null,ctor,cljs.core.flatten.call(null,cljs.core.cons.call(null,opts__$1,children__$1)));
});
om_tools.dom.a = (function om_tools$dom$a(var_args){
var args33808 = [];
var len__21576__auto___34458 = arguments.length;
var i__21577__auto___34459 = (0);
while(true){
if((i__21577__auto___34459 < len__21576__auto___34458)){
args33808.push((arguments[i__21577__auto___34459]));

var G__34460 = (i__21577__auto___34459 + (1));
i__21577__auto___34459 = G__34460;
continue;
} else {
}
break;
}

var G__33812 = args33808.length;
switch (G__33812) {
case 0:
return om_tools.dom.a.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33808.slice((1)),(0),null));
return om_tools.dom.a.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.a.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.a,null,null);
});

om_tools.dom.a.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.a,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.a.cljs$lang$applyTo = (function (seq33809){
var G__33810 = cljs.core.first.call(null,seq33809);
var seq33809__$1 = cljs.core.next.call(null,seq33809);
return om_tools.dom.a.cljs$core$IFn$_invoke$arity$variadic(G__33810,seq33809__$1);
});

om_tools.dom.a.cljs$lang$maxFixedArity = (1);


om_tools.dom.abbr = (function om_tools$dom$abbr(var_args){
var args33813 = [];
var len__21576__auto___34462 = arguments.length;
var i__21577__auto___34463 = (0);
while(true){
if((i__21577__auto___34463 < len__21576__auto___34462)){
args33813.push((arguments[i__21577__auto___34463]));

var G__34464 = (i__21577__auto___34463 + (1));
i__21577__auto___34463 = G__34464;
continue;
} else {
}
break;
}

var G__33817 = args33813.length;
switch (G__33817) {
case 0:
return om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33813.slice((1)),(0),null));
return om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.abbr,null,null);
});

om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.abbr,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.abbr.cljs$lang$applyTo = (function (seq33814){
var G__33815 = cljs.core.first.call(null,seq33814);
var seq33814__$1 = cljs.core.next.call(null,seq33814);
return om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$variadic(G__33815,seq33814__$1);
});

om_tools.dom.abbr.cljs$lang$maxFixedArity = (1);


om_tools.dom.address = (function om_tools$dom$address(var_args){
var args33818 = [];
var len__21576__auto___34466 = arguments.length;
var i__21577__auto___34467 = (0);
while(true){
if((i__21577__auto___34467 < len__21576__auto___34466)){
args33818.push((arguments[i__21577__auto___34467]));

var G__34468 = (i__21577__auto___34467 + (1));
i__21577__auto___34467 = G__34468;
continue;
} else {
}
break;
}

var G__33822 = args33818.length;
switch (G__33822) {
case 0:
return om_tools.dom.address.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33818.slice((1)),(0),null));
return om_tools.dom.address.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.address.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.address,null,null);
});

om_tools.dom.address.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.address,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.address.cljs$lang$applyTo = (function (seq33819){
var G__33820 = cljs.core.first.call(null,seq33819);
var seq33819__$1 = cljs.core.next.call(null,seq33819);
return om_tools.dom.address.cljs$core$IFn$_invoke$arity$variadic(G__33820,seq33819__$1);
});

om_tools.dom.address.cljs$lang$maxFixedArity = (1);


om_tools.dom.area = (function om_tools$dom$area(var_args){
var args33823 = [];
var len__21576__auto___34470 = arguments.length;
var i__21577__auto___34471 = (0);
while(true){
if((i__21577__auto___34471 < len__21576__auto___34470)){
args33823.push((arguments[i__21577__auto___34471]));

var G__34472 = (i__21577__auto___34471 + (1));
i__21577__auto___34471 = G__34472;
continue;
} else {
}
break;
}

var G__33827 = args33823.length;
switch (G__33827) {
case 0:
return om_tools.dom.area.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33823.slice((1)),(0),null));
return om_tools.dom.area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.area.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.area,null,null);
});

om_tools.dom.area.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.area,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.area.cljs$lang$applyTo = (function (seq33824){
var G__33825 = cljs.core.first.call(null,seq33824);
var seq33824__$1 = cljs.core.next.call(null,seq33824);
return om_tools.dom.area.cljs$core$IFn$_invoke$arity$variadic(G__33825,seq33824__$1);
});

om_tools.dom.area.cljs$lang$maxFixedArity = (1);


om_tools.dom.article = (function om_tools$dom$article(var_args){
var args33828 = [];
var len__21576__auto___34474 = arguments.length;
var i__21577__auto___34475 = (0);
while(true){
if((i__21577__auto___34475 < len__21576__auto___34474)){
args33828.push((arguments[i__21577__auto___34475]));

var G__34476 = (i__21577__auto___34475 + (1));
i__21577__auto___34475 = G__34476;
continue;
} else {
}
break;
}

var G__33832 = args33828.length;
switch (G__33832) {
case 0:
return om_tools.dom.article.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33828.slice((1)),(0),null));
return om_tools.dom.article.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.article.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.article,null,null);
});

om_tools.dom.article.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.article,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.article.cljs$lang$applyTo = (function (seq33829){
var G__33830 = cljs.core.first.call(null,seq33829);
var seq33829__$1 = cljs.core.next.call(null,seq33829);
return om_tools.dom.article.cljs$core$IFn$_invoke$arity$variadic(G__33830,seq33829__$1);
});

om_tools.dom.article.cljs$lang$maxFixedArity = (1);


om_tools.dom.aside = (function om_tools$dom$aside(var_args){
var args33833 = [];
var len__21576__auto___34478 = arguments.length;
var i__21577__auto___34479 = (0);
while(true){
if((i__21577__auto___34479 < len__21576__auto___34478)){
args33833.push((arguments[i__21577__auto___34479]));

var G__34480 = (i__21577__auto___34479 + (1));
i__21577__auto___34479 = G__34480;
continue;
} else {
}
break;
}

var G__33837 = args33833.length;
switch (G__33837) {
case 0:
return om_tools.dom.aside.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33833.slice((1)),(0),null));
return om_tools.dom.aside.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.aside.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.aside,null,null);
});

om_tools.dom.aside.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.aside,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.aside.cljs$lang$applyTo = (function (seq33834){
var G__33835 = cljs.core.first.call(null,seq33834);
var seq33834__$1 = cljs.core.next.call(null,seq33834);
return om_tools.dom.aside.cljs$core$IFn$_invoke$arity$variadic(G__33835,seq33834__$1);
});

om_tools.dom.aside.cljs$lang$maxFixedArity = (1);


om_tools.dom.audio = (function om_tools$dom$audio(var_args){
var args33838 = [];
var len__21576__auto___34482 = arguments.length;
var i__21577__auto___34483 = (0);
while(true){
if((i__21577__auto___34483 < len__21576__auto___34482)){
args33838.push((arguments[i__21577__auto___34483]));

var G__34484 = (i__21577__auto___34483 + (1));
i__21577__auto___34483 = G__34484;
continue;
} else {
}
break;
}

var G__33842 = args33838.length;
switch (G__33842) {
case 0:
return om_tools.dom.audio.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33838.slice((1)),(0),null));
return om_tools.dom.audio.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.audio.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.audio,null,null);
});

om_tools.dom.audio.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.audio,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.audio.cljs$lang$applyTo = (function (seq33839){
var G__33840 = cljs.core.first.call(null,seq33839);
var seq33839__$1 = cljs.core.next.call(null,seq33839);
return om_tools.dom.audio.cljs$core$IFn$_invoke$arity$variadic(G__33840,seq33839__$1);
});

om_tools.dom.audio.cljs$lang$maxFixedArity = (1);


om_tools.dom.b = (function om_tools$dom$b(var_args){
var args33843 = [];
var len__21576__auto___34486 = arguments.length;
var i__21577__auto___34487 = (0);
while(true){
if((i__21577__auto___34487 < len__21576__auto___34486)){
args33843.push((arguments[i__21577__auto___34487]));

var G__34488 = (i__21577__auto___34487 + (1));
i__21577__auto___34487 = G__34488;
continue;
} else {
}
break;
}

var G__33847 = args33843.length;
switch (G__33847) {
case 0:
return om_tools.dom.b.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33843.slice((1)),(0),null));
return om_tools.dom.b.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.b.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.b,null,null);
});

om_tools.dom.b.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.b,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.b.cljs$lang$applyTo = (function (seq33844){
var G__33845 = cljs.core.first.call(null,seq33844);
var seq33844__$1 = cljs.core.next.call(null,seq33844);
return om_tools.dom.b.cljs$core$IFn$_invoke$arity$variadic(G__33845,seq33844__$1);
});

om_tools.dom.b.cljs$lang$maxFixedArity = (1);


om_tools.dom.base = (function om_tools$dom$base(var_args){
var args33848 = [];
var len__21576__auto___34490 = arguments.length;
var i__21577__auto___34491 = (0);
while(true){
if((i__21577__auto___34491 < len__21576__auto___34490)){
args33848.push((arguments[i__21577__auto___34491]));

var G__34492 = (i__21577__auto___34491 + (1));
i__21577__auto___34491 = G__34492;
continue;
} else {
}
break;
}

var G__33852 = args33848.length;
switch (G__33852) {
case 0:
return om_tools.dom.base.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33848.slice((1)),(0),null));
return om_tools.dom.base.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.base.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.base,null,null);
});

om_tools.dom.base.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.base,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.base.cljs$lang$applyTo = (function (seq33849){
var G__33850 = cljs.core.first.call(null,seq33849);
var seq33849__$1 = cljs.core.next.call(null,seq33849);
return om_tools.dom.base.cljs$core$IFn$_invoke$arity$variadic(G__33850,seq33849__$1);
});

om_tools.dom.base.cljs$lang$maxFixedArity = (1);


om_tools.dom.bdi = (function om_tools$dom$bdi(var_args){
var args33853 = [];
var len__21576__auto___34494 = arguments.length;
var i__21577__auto___34495 = (0);
while(true){
if((i__21577__auto___34495 < len__21576__auto___34494)){
args33853.push((arguments[i__21577__auto___34495]));

var G__34496 = (i__21577__auto___34495 + (1));
i__21577__auto___34495 = G__34496;
continue;
} else {
}
break;
}

var G__33857 = args33853.length;
switch (G__33857) {
case 0:
return om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33853.slice((1)),(0),null));
return om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.bdi,null,null);
});

om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.bdi,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.bdi.cljs$lang$applyTo = (function (seq33854){
var G__33855 = cljs.core.first.call(null,seq33854);
var seq33854__$1 = cljs.core.next.call(null,seq33854);
return om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$variadic(G__33855,seq33854__$1);
});

om_tools.dom.bdi.cljs$lang$maxFixedArity = (1);


om_tools.dom.bdo = (function om_tools$dom$bdo(var_args){
var args33858 = [];
var len__21576__auto___34498 = arguments.length;
var i__21577__auto___34499 = (0);
while(true){
if((i__21577__auto___34499 < len__21576__auto___34498)){
args33858.push((arguments[i__21577__auto___34499]));

var G__34500 = (i__21577__auto___34499 + (1));
i__21577__auto___34499 = G__34500;
continue;
} else {
}
break;
}

var G__33862 = args33858.length;
switch (G__33862) {
case 0:
return om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33858.slice((1)),(0),null));
return om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.bdo,null,null);
});

om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.bdo,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.bdo.cljs$lang$applyTo = (function (seq33859){
var G__33860 = cljs.core.first.call(null,seq33859);
var seq33859__$1 = cljs.core.next.call(null,seq33859);
return om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$variadic(G__33860,seq33859__$1);
});

om_tools.dom.bdo.cljs$lang$maxFixedArity = (1);


om_tools.dom.big = (function om_tools$dom$big(var_args){
var args33863 = [];
var len__21576__auto___34502 = arguments.length;
var i__21577__auto___34503 = (0);
while(true){
if((i__21577__auto___34503 < len__21576__auto___34502)){
args33863.push((arguments[i__21577__auto___34503]));

var G__34504 = (i__21577__auto___34503 + (1));
i__21577__auto___34503 = G__34504;
continue;
} else {
}
break;
}

var G__33867 = args33863.length;
switch (G__33867) {
case 0:
return om_tools.dom.big.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33863.slice((1)),(0),null));
return om_tools.dom.big.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.big.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.big,null,null);
});

om_tools.dom.big.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.big,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.big.cljs$lang$applyTo = (function (seq33864){
var G__33865 = cljs.core.first.call(null,seq33864);
var seq33864__$1 = cljs.core.next.call(null,seq33864);
return om_tools.dom.big.cljs$core$IFn$_invoke$arity$variadic(G__33865,seq33864__$1);
});

om_tools.dom.big.cljs$lang$maxFixedArity = (1);


om_tools.dom.blockquote = (function om_tools$dom$blockquote(var_args){
var args33868 = [];
var len__21576__auto___34506 = arguments.length;
var i__21577__auto___34507 = (0);
while(true){
if((i__21577__auto___34507 < len__21576__auto___34506)){
args33868.push((arguments[i__21577__auto___34507]));

var G__34508 = (i__21577__auto___34507 + (1));
i__21577__auto___34507 = G__34508;
continue;
} else {
}
break;
}

var G__33872 = args33868.length;
switch (G__33872) {
case 0:
return om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33868.slice((1)),(0),null));
return om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.blockquote,null,null);
});

om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.blockquote,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.blockquote.cljs$lang$applyTo = (function (seq33869){
var G__33870 = cljs.core.first.call(null,seq33869);
var seq33869__$1 = cljs.core.next.call(null,seq33869);
return om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic(G__33870,seq33869__$1);
});

om_tools.dom.blockquote.cljs$lang$maxFixedArity = (1);


om_tools.dom.body = (function om_tools$dom$body(var_args){
var args33873 = [];
var len__21576__auto___34510 = arguments.length;
var i__21577__auto___34511 = (0);
while(true){
if((i__21577__auto___34511 < len__21576__auto___34510)){
args33873.push((arguments[i__21577__auto___34511]));

var G__34512 = (i__21577__auto___34511 + (1));
i__21577__auto___34511 = G__34512;
continue;
} else {
}
break;
}

var G__33877 = args33873.length;
switch (G__33877) {
case 0:
return om_tools.dom.body.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33873.slice((1)),(0),null));
return om_tools.dom.body.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.body.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.body,null,null);
});

om_tools.dom.body.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.body,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.body.cljs$lang$applyTo = (function (seq33874){
var G__33875 = cljs.core.first.call(null,seq33874);
var seq33874__$1 = cljs.core.next.call(null,seq33874);
return om_tools.dom.body.cljs$core$IFn$_invoke$arity$variadic(G__33875,seq33874__$1);
});

om_tools.dom.body.cljs$lang$maxFixedArity = (1);


om_tools.dom.br = (function om_tools$dom$br(var_args){
var args33878 = [];
var len__21576__auto___34514 = arguments.length;
var i__21577__auto___34515 = (0);
while(true){
if((i__21577__auto___34515 < len__21576__auto___34514)){
args33878.push((arguments[i__21577__auto___34515]));

var G__34516 = (i__21577__auto___34515 + (1));
i__21577__auto___34515 = G__34516;
continue;
} else {
}
break;
}

var G__33882 = args33878.length;
switch (G__33882) {
case 0:
return om_tools.dom.br.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33878.slice((1)),(0),null));
return om_tools.dom.br.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.br.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.br,null,null);
});

om_tools.dom.br.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.br,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.br.cljs$lang$applyTo = (function (seq33879){
var G__33880 = cljs.core.first.call(null,seq33879);
var seq33879__$1 = cljs.core.next.call(null,seq33879);
return om_tools.dom.br.cljs$core$IFn$_invoke$arity$variadic(G__33880,seq33879__$1);
});

om_tools.dom.br.cljs$lang$maxFixedArity = (1);


om_tools.dom.button = (function om_tools$dom$button(var_args){
var args33883 = [];
var len__21576__auto___34518 = arguments.length;
var i__21577__auto___34519 = (0);
while(true){
if((i__21577__auto___34519 < len__21576__auto___34518)){
args33883.push((arguments[i__21577__auto___34519]));

var G__34520 = (i__21577__auto___34519 + (1));
i__21577__auto___34519 = G__34520;
continue;
} else {
}
break;
}

var G__33887 = args33883.length;
switch (G__33887) {
case 0:
return om_tools.dom.button.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33883.slice((1)),(0),null));
return om_tools.dom.button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.button.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.button,null,null);
});

om_tools.dom.button.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.button,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.button.cljs$lang$applyTo = (function (seq33884){
var G__33885 = cljs.core.first.call(null,seq33884);
var seq33884__$1 = cljs.core.next.call(null,seq33884);
return om_tools.dom.button.cljs$core$IFn$_invoke$arity$variadic(G__33885,seq33884__$1);
});

om_tools.dom.button.cljs$lang$maxFixedArity = (1);


om_tools.dom.canvas = (function om_tools$dom$canvas(var_args){
var args33888 = [];
var len__21576__auto___34522 = arguments.length;
var i__21577__auto___34523 = (0);
while(true){
if((i__21577__auto___34523 < len__21576__auto___34522)){
args33888.push((arguments[i__21577__auto___34523]));

var G__34524 = (i__21577__auto___34523 + (1));
i__21577__auto___34523 = G__34524;
continue;
} else {
}
break;
}

var G__33892 = args33888.length;
switch (G__33892) {
case 0:
return om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33888.slice((1)),(0),null));
return om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.canvas,null,null);
});

om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.canvas,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.canvas.cljs$lang$applyTo = (function (seq33889){
var G__33890 = cljs.core.first.call(null,seq33889);
var seq33889__$1 = cljs.core.next.call(null,seq33889);
return om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$variadic(G__33890,seq33889__$1);
});

om_tools.dom.canvas.cljs$lang$maxFixedArity = (1);


om_tools.dom.caption = (function om_tools$dom$caption(var_args){
var args33893 = [];
var len__21576__auto___34526 = arguments.length;
var i__21577__auto___34527 = (0);
while(true){
if((i__21577__auto___34527 < len__21576__auto___34526)){
args33893.push((arguments[i__21577__auto___34527]));

var G__34528 = (i__21577__auto___34527 + (1));
i__21577__auto___34527 = G__34528;
continue;
} else {
}
break;
}

var G__33897 = args33893.length;
switch (G__33897) {
case 0:
return om_tools.dom.caption.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33893.slice((1)),(0),null));
return om_tools.dom.caption.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.caption.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.caption,null,null);
});

om_tools.dom.caption.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.caption,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.caption.cljs$lang$applyTo = (function (seq33894){
var G__33895 = cljs.core.first.call(null,seq33894);
var seq33894__$1 = cljs.core.next.call(null,seq33894);
return om_tools.dom.caption.cljs$core$IFn$_invoke$arity$variadic(G__33895,seq33894__$1);
});

om_tools.dom.caption.cljs$lang$maxFixedArity = (1);


om_tools.dom.cite = (function om_tools$dom$cite(var_args){
var args33898 = [];
var len__21576__auto___34530 = arguments.length;
var i__21577__auto___34531 = (0);
while(true){
if((i__21577__auto___34531 < len__21576__auto___34530)){
args33898.push((arguments[i__21577__auto___34531]));

var G__34532 = (i__21577__auto___34531 + (1));
i__21577__auto___34531 = G__34532;
continue;
} else {
}
break;
}

var G__33902 = args33898.length;
switch (G__33902) {
case 0:
return om_tools.dom.cite.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33898.slice((1)),(0),null));
return om_tools.dom.cite.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.cite.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.cite,null,null);
});

om_tools.dom.cite.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.cite,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.cite.cljs$lang$applyTo = (function (seq33899){
var G__33900 = cljs.core.first.call(null,seq33899);
var seq33899__$1 = cljs.core.next.call(null,seq33899);
return om_tools.dom.cite.cljs$core$IFn$_invoke$arity$variadic(G__33900,seq33899__$1);
});

om_tools.dom.cite.cljs$lang$maxFixedArity = (1);


om_tools.dom.code = (function om_tools$dom$code(var_args){
var args33903 = [];
var len__21576__auto___34534 = arguments.length;
var i__21577__auto___34535 = (0);
while(true){
if((i__21577__auto___34535 < len__21576__auto___34534)){
args33903.push((arguments[i__21577__auto___34535]));

var G__34536 = (i__21577__auto___34535 + (1));
i__21577__auto___34535 = G__34536;
continue;
} else {
}
break;
}

var G__33907 = args33903.length;
switch (G__33907) {
case 0:
return om_tools.dom.code.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33903.slice((1)),(0),null));
return om_tools.dom.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.code.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.code,null,null);
});

om_tools.dom.code.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.code,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.code.cljs$lang$applyTo = (function (seq33904){
var G__33905 = cljs.core.first.call(null,seq33904);
var seq33904__$1 = cljs.core.next.call(null,seq33904);
return om_tools.dom.code.cljs$core$IFn$_invoke$arity$variadic(G__33905,seq33904__$1);
});

om_tools.dom.code.cljs$lang$maxFixedArity = (1);


om_tools.dom.col = (function om_tools$dom$col(var_args){
var args33908 = [];
var len__21576__auto___34538 = arguments.length;
var i__21577__auto___34539 = (0);
while(true){
if((i__21577__auto___34539 < len__21576__auto___34538)){
args33908.push((arguments[i__21577__auto___34539]));

var G__34540 = (i__21577__auto___34539 + (1));
i__21577__auto___34539 = G__34540;
continue;
} else {
}
break;
}

var G__33912 = args33908.length;
switch (G__33912) {
case 0:
return om_tools.dom.col.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33908.slice((1)),(0),null));
return om_tools.dom.col.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.col.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.col,null,null);
});

om_tools.dom.col.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.col,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.col.cljs$lang$applyTo = (function (seq33909){
var G__33910 = cljs.core.first.call(null,seq33909);
var seq33909__$1 = cljs.core.next.call(null,seq33909);
return om_tools.dom.col.cljs$core$IFn$_invoke$arity$variadic(G__33910,seq33909__$1);
});

om_tools.dom.col.cljs$lang$maxFixedArity = (1);


om_tools.dom.colgroup = (function om_tools$dom$colgroup(var_args){
var args33913 = [];
var len__21576__auto___34542 = arguments.length;
var i__21577__auto___34543 = (0);
while(true){
if((i__21577__auto___34543 < len__21576__auto___34542)){
args33913.push((arguments[i__21577__auto___34543]));

var G__34544 = (i__21577__auto___34543 + (1));
i__21577__auto___34543 = G__34544;
continue;
} else {
}
break;
}

var G__33917 = args33913.length;
switch (G__33917) {
case 0:
return om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33913.slice((1)),(0),null));
return om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.colgroup,null,null);
});

om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.colgroup,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.colgroup.cljs$lang$applyTo = (function (seq33914){
var G__33915 = cljs.core.first.call(null,seq33914);
var seq33914__$1 = cljs.core.next.call(null,seq33914);
return om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic(G__33915,seq33914__$1);
});

om_tools.dom.colgroup.cljs$lang$maxFixedArity = (1);


om_tools.dom.data = (function om_tools$dom$data(var_args){
var args33918 = [];
var len__21576__auto___34546 = arguments.length;
var i__21577__auto___34547 = (0);
while(true){
if((i__21577__auto___34547 < len__21576__auto___34546)){
args33918.push((arguments[i__21577__auto___34547]));

var G__34548 = (i__21577__auto___34547 + (1));
i__21577__auto___34547 = G__34548;
continue;
} else {
}
break;
}

var G__33922 = args33918.length;
switch (G__33922) {
case 0:
return om_tools.dom.data.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33918.slice((1)),(0),null));
return om_tools.dom.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.data.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.data,null,null);
});

om_tools.dom.data.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.data,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.data.cljs$lang$applyTo = (function (seq33919){
var G__33920 = cljs.core.first.call(null,seq33919);
var seq33919__$1 = cljs.core.next.call(null,seq33919);
return om_tools.dom.data.cljs$core$IFn$_invoke$arity$variadic(G__33920,seq33919__$1);
});

om_tools.dom.data.cljs$lang$maxFixedArity = (1);


om_tools.dom.datalist = (function om_tools$dom$datalist(var_args){
var args33923 = [];
var len__21576__auto___34550 = arguments.length;
var i__21577__auto___34551 = (0);
while(true){
if((i__21577__auto___34551 < len__21576__auto___34550)){
args33923.push((arguments[i__21577__auto___34551]));

var G__34552 = (i__21577__auto___34551 + (1));
i__21577__auto___34551 = G__34552;
continue;
} else {
}
break;
}

var G__33927 = args33923.length;
switch (G__33927) {
case 0:
return om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33923.slice((1)),(0),null));
return om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.datalist,null,null);
});

om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.datalist,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.datalist.cljs$lang$applyTo = (function (seq33924){
var G__33925 = cljs.core.first.call(null,seq33924);
var seq33924__$1 = cljs.core.next.call(null,seq33924);
return om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$variadic(G__33925,seq33924__$1);
});

om_tools.dom.datalist.cljs$lang$maxFixedArity = (1);


om_tools.dom.dd = (function om_tools$dom$dd(var_args){
var args33928 = [];
var len__21576__auto___34554 = arguments.length;
var i__21577__auto___34555 = (0);
while(true){
if((i__21577__auto___34555 < len__21576__auto___34554)){
args33928.push((arguments[i__21577__auto___34555]));

var G__34556 = (i__21577__auto___34555 + (1));
i__21577__auto___34555 = G__34556;
continue;
} else {
}
break;
}

var G__33932 = args33928.length;
switch (G__33932) {
case 0:
return om_tools.dom.dd.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33928.slice((1)),(0),null));
return om_tools.dom.dd.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.dd.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dd,null,null);
});

om_tools.dom.dd.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.dd,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.dd.cljs$lang$applyTo = (function (seq33929){
var G__33930 = cljs.core.first.call(null,seq33929);
var seq33929__$1 = cljs.core.next.call(null,seq33929);
return om_tools.dom.dd.cljs$core$IFn$_invoke$arity$variadic(G__33930,seq33929__$1);
});

om_tools.dom.dd.cljs$lang$maxFixedArity = (1);


om_tools.dom.del = (function om_tools$dom$del(var_args){
var args33933 = [];
var len__21576__auto___34558 = arguments.length;
var i__21577__auto___34559 = (0);
while(true){
if((i__21577__auto___34559 < len__21576__auto___34558)){
args33933.push((arguments[i__21577__auto___34559]));

var G__34560 = (i__21577__auto___34559 + (1));
i__21577__auto___34559 = G__34560;
continue;
} else {
}
break;
}

var G__33937 = args33933.length;
switch (G__33937) {
case 0:
return om_tools.dom.del.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33933.slice((1)),(0),null));
return om_tools.dom.del.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.del.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.del,null,null);
});

om_tools.dom.del.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.del,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.del.cljs$lang$applyTo = (function (seq33934){
var G__33935 = cljs.core.first.call(null,seq33934);
var seq33934__$1 = cljs.core.next.call(null,seq33934);
return om_tools.dom.del.cljs$core$IFn$_invoke$arity$variadic(G__33935,seq33934__$1);
});

om_tools.dom.del.cljs$lang$maxFixedArity = (1);


om_tools.dom.details = (function om_tools$dom$details(var_args){
var args33938 = [];
var len__21576__auto___34562 = arguments.length;
var i__21577__auto___34563 = (0);
while(true){
if((i__21577__auto___34563 < len__21576__auto___34562)){
args33938.push((arguments[i__21577__auto___34563]));

var G__34564 = (i__21577__auto___34563 + (1));
i__21577__auto___34563 = G__34564;
continue;
} else {
}
break;
}

var G__33942 = args33938.length;
switch (G__33942) {
case 0:
return om_tools.dom.details.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33938.slice((1)),(0),null));
return om_tools.dom.details.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.details.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.details,null,null);
});

om_tools.dom.details.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.details,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.details.cljs$lang$applyTo = (function (seq33939){
var G__33940 = cljs.core.first.call(null,seq33939);
var seq33939__$1 = cljs.core.next.call(null,seq33939);
return om_tools.dom.details.cljs$core$IFn$_invoke$arity$variadic(G__33940,seq33939__$1);
});

om_tools.dom.details.cljs$lang$maxFixedArity = (1);


om_tools.dom.dfn = (function om_tools$dom$dfn(var_args){
var args33943 = [];
var len__21576__auto___34566 = arguments.length;
var i__21577__auto___34567 = (0);
while(true){
if((i__21577__auto___34567 < len__21576__auto___34566)){
args33943.push((arguments[i__21577__auto___34567]));

var G__34568 = (i__21577__auto___34567 + (1));
i__21577__auto___34567 = G__34568;
continue;
} else {
}
break;
}

var G__33947 = args33943.length;
switch (G__33947) {
case 0:
return om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33943.slice((1)),(0),null));
return om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dfn,null,null);
});

om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.dfn,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.dfn.cljs$lang$applyTo = (function (seq33944){
var G__33945 = cljs.core.first.call(null,seq33944);
var seq33944__$1 = cljs.core.next.call(null,seq33944);
return om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$variadic(G__33945,seq33944__$1);
});

om_tools.dom.dfn.cljs$lang$maxFixedArity = (1);


om_tools.dom.dialog = (function om_tools$dom$dialog(var_args){
var args33948 = [];
var len__21576__auto___34570 = arguments.length;
var i__21577__auto___34571 = (0);
while(true){
if((i__21577__auto___34571 < len__21576__auto___34570)){
args33948.push((arguments[i__21577__auto___34571]));

var G__34572 = (i__21577__auto___34571 + (1));
i__21577__auto___34571 = G__34572;
continue;
} else {
}
break;
}

var G__33952 = args33948.length;
switch (G__33952) {
case 0:
return om_tools.dom.dialog.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33948.slice((1)),(0),null));
return om_tools.dom.dialog.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.dialog.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dialog,null,null);
});

om_tools.dom.dialog.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.dialog,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.dialog.cljs$lang$applyTo = (function (seq33949){
var G__33950 = cljs.core.first.call(null,seq33949);
var seq33949__$1 = cljs.core.next.call(null,seq33949);
return om_tools.dom.dialog.cljs$core$IFn$_invoke$arity$variadic(G__33950,seq33949__$1);
});

om_tools.dom.dialog.cljs$lang$maxFixedArity = (1);


om_tools.dom.div = (function om_tools$dom$div(var_args){
var args33953 = [];
var len__21576__auto___34574 = arguments.length;
var i__21577__auto___34575 = (0);
while(true){
if((i__21577__auto___34575 < len__21576__auto___34574)){
args33953.push((arguments[i__21577__auto___34575]));

var G__34576 = (i__21577__auto___34575 + (1));
i__21577__auto___34575 = G__34576;
continue;
} else {
}
break;
}

var G__33957 = args33953.length;
switch (G__33957) {
case 0:
return om_tools.dom.div.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33953.slice((1)),(0),null));
return om_tools.dom.div.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.div.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.div,null,null);
});

om_tools.dom.div.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.div,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.div.cljs$lang$applyTo = (function (seq33954){
var G__33955 = cljs.core.first.call(null,seq33954);
var seq33954__$1 = cljs.core.next.call(null,seq33954);
return om_tools.dom.div.cljs$core$IFn$_invoke$arity$variadic(G__33955,seq33954__$1);
});

om_tools.dom.div.cljs$lang$maxFixedArity = (1);


om_tools.dom.dl = (function om_tools$dom$dl(var_args){
var args33958 = [];
var len__21576__auto___34578 = arguments.length;
var i__21577__auto___34579 = (0);
while(true){
if((i__21577__auto___34579 < len__21576__auto___34578)){
args33958.push((arguments[i__21577__auto___34579]));

var G__34580 = (i__21577__auto___34579 + (1));
i__21577__auto___34579 = G__34580;
continue;
} else {
}
break;
}

var G__33962 = args33958.length;
switch (G__33962) {
case 0:
return om_tools.dom.dl.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33958.slice((1)),(0),null));
return om_tools.dom.dl.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.dl.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dl,null,null);
});

om_tools.dom.dl.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.dl,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.dl.cljs$lang$applyTo = (function (seq33959){
var G__33960 = cljs.core.first.call(null,seq33959);
var seq33959__$1 = cljs.core.next.call(null,seq33959);
return om_tools.dom.dl.cljs$core$IFn$_invoke$arity$variadic(G__33960,seq33959__$1);
});

om_tools.dom.dl.cljs$lang$maxFixedArity = (1);


om_tools.dom.dt = (function om_tools$dom$dt(var_args){
var args33963 = [];
var len__21576__auto___34582 = arguments.length;
var i__21577__auto___34583 = (0);
while(true){
if((i__21577__auto___34583 < len__21576__auto___34582)){
args33963.push((arguments[i__21577__auto___34583]));

var G__34584 = (i__21577__auto___34583 + (1));
i__21577__auto___34583 = G__34584;
continue;
} else {
}
break;
}

var G__33967 = args33963.length;
switch (G__33967) {
case 0:
return om_tools.dom.dt.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33963.slice((1)),(0),null));
return om_tools.dom.dt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.dt.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dt,null,null);
});

om_tools.dom.dt.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.dt,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.dt.cljs$lang$applyTo = (function (seq33964){
var G__33965 = cljs.core.first.call(null,seq33964);
var seq33964__$1 = cljs.core.next.call(null,seq33964);
return om_tools.dom.dt.cljs$core$IFn$_invoke$arity$variadic(G__33965,seq33964__$1);
});

om_tools.dom.dt.cljs$lang$maxFixedArity = (1);


om_tools.dom.em = (function om_tools$dom$em(var_args){
var args33973 = [];
var len__21576__auto___34586 = arguments.length;
var i__21577__auto___34587 = (0);
while(true){
if((i__21577__auto___34587 < len__21576__auto___34586)){
args33973.push((arguments[i__21577__auto___34587]));

var G__34588 = (i__21577__auto___34587 + (1));
i__21577__auto___34587 = G__34588;
continue;
} else {
}
break;
}

var G__33977 = args33973.length;
switch (G__33977) {
case 0:
return om_tools.dom.em.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33973.slice((1)),(0),null));
return om_tools.dom.em.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.em.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.em,null,null);
});

om_tools.dom.em.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.em,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.em.cljs$lang$applyTo = (function (seq33974){
var G__33975 = cljs.core.first.call(null,seq33974);
var seq33974__$1 = cljs.core.next.call(null,seq33974);
return om_tools.dom.em.cljs$core$IFn$_invoke$arity$variadic(G__33975,seq33974__$1);
});

om_tools.dom.em.cljs$lang$maxFixedArity = (1);


om_tools.dom.embed = (function om_tools$dom$embed(var_args){
var args33978 = [];
var len__21576__auto___34590 = arguments.length;
var i__21577__auto___34591 = (0);
while(true){
if((i__21577__auto___34591 < len__21576__auto___34590)){
args33978.push((arguments[i__21577__auto___34591]));

var G__34592 = (i__21577__auto___34591 + (1));
i__21577__auto___34591 = G__34592;
continue;
} else {
}
break;
}

var G__33982 = args33978.length;
switch (G__33982) {
case 0:
return om_tools.dom.embed.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33978.slice((1)),(0),null));
return om_tools.dom.embed.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.embed.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.embed,null,null);
});

om_tools.dom.embed.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.embed,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.embed.cljs$lang$applyTo = (function (seq33979){
var G__33980 = cljs.core.first.call(null,seq33979);
var seq33979__$1 = cljs.core.next.call(null,seq33979);
return om_tools.dom.embed.cljs$core$IFn$_invoke$arity$variadic(G__33980,seq33979__$1);
});

om_tools.dom.embed.cljs$lang$maxFixedArity = (1);


om_tools.dom.fieldset = (function om_tools$dom$fieldset(var_args){
var args33983 = [];
var len__21576__auto___34594 = arguments.length;
var i__21577__auto___34595 = (0);
while(true){
if((i__21577__auto___34595 < len__21576__auto___34594)){
args33983.push((arguments[i__21577__auto___34595]));

var G__34596 = (i__21577__auto___34595 + (1));
i__21577__auto___34595 = G__34596;
continue;
} else {
}
break;
}

var G__33987 = args33983.length;
switch (G__33987) {
case 0:
return om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33983.slice((1)),(0),null));
return om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.fieldset,null,null);
});

om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.fieldset,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.fieldset.cljs$lang$applyTo = (function (seq33984){
var G__33985 = cljs.core.first.call(null,seq33984);
var seq33984__$1 = cljs.core.next.call(null,seq33984);
return om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic(G__33985,seq33984__$1);
});

om_tools.dom.fieldset.cljs$lang$maxFixedArity = (1);


om_tools.dom.figcaption = (function om_tools$dom$figcaption(var_args){
var args33988 = [];
var len__21576__auto___34598 = arguments.length;
var i__21577__auto___34599 = (0);
while(true){
if((i__21577__auto___34599 < len__21576__auto___34598)){
args33988.push((arguments[i__21577__auto___34599]));

var G__34600 = (i__21577__auto___34599 + (1));
i__21577__auto___34599 = G__34600;
continue;
} else {
}
break;
}

var G__33992 = args33988.length;
switch (G__33992) {
case 0:
return om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33988.slice((1)),(0),null));
return om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.figcaption,null,null);
});

om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.figcaption,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.figcaption.cljs$lang$applyTo = (function (seq33989){
var G__33990 = cljs.core.first.call(null,seq33989);
var seq33989__$1 = cljs.core.next.call(null,seq33989);
return om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic(G__33990,seq33989__$1);
});

om_tools.dom.figcaption.cljs$lang$maxFixedArity = (1);


om_tools.dom.figure = (function om_tools$dom$figure(var_args){
var args33993 = [];
var len__21576__auto___34602 = arguments.length;
var i__21577__auto___34603 = (0);
while(true){
if((i__21577__auto___34603 < len__21576__auto___34602)){
args33993.push((arguments[i__21577__auto___34603]));

var G__34604 = (i__21577__auto___34603 + (1));
i__21577__auto___34603 = G__34604;
continue;
} else {
}
break;
}

var G__33997 = args33993.length;
switch (G__33997) {
case 0:
return om_tools.dom.figure.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33993.slice((1)),(0),null));
return om_tools.dom.figure.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.figure.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.figure,null,null);
});

om_tools.dom.figure.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.figure,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.figure.cljs$lang$applyTo = (function (seq33994){
var G__33995 = cljs.core.first.call(null,seq33994);
var seq33994__$1 = cljs.core.next.call(null,seq33994);
return om_tools.dom.figure.cljs$core$IFn$_invoke$arity$variadic(G__33995,seq33994__$1);
});

om_tools.dom.figure.cljs$lang$maxFixedArity = (1);


om_tools.dom.footer = (function om_tools$dom$footer(var_args){
var args33998 = [];
var len__21576__auto___34606 = arguments.length;
var i__21577__auto___34607 = (0);
while(true){
if((i__21577__auto___34607 < len__21576__auto___34606)){
args33998.push((arguments[i__21577__auto___34607]));

var G__34608 = (i__21577__auto___34607 + (1));
i__21577__auto___34607 = G__34608;
continue;
} else {
}
break;
}

var G__34002 = args33998.length;
switch (G__34002) {
case 0:
return om_tools.dom.footer.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33998.slice((1)),(0),null));
return om_tools.dom.footer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.footer.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.footer,null,null);
});

om_tools.dom.footer.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.footer,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.footer.cljs$lang$applyTo = (function (seq33999){
var G__34000 = cljs.core.first.call(null,seq33999);
var seq33999__$1 = cljs.core.next.call(null,seq33999);
return om_tools.dom.footer.cljs$core$IFn$_invoke$arity$variadic(G__34000,seq33999__$1);
});

om_tools.dom.footer.cljs$lang$maxFixedArity = (1);


om_tools.dom.form = (function om_tools$dom$form(var_args){
var args34003 = [];
var len__21576__auto___34610 = arguments.length;
var i__21577__auto___34611 = (0);
while(true){
if((i__21577__auto___34611 < len__21576__auto___34610)){
args34003.push((arguments[i__21577__auto___34611]));

var G__34612 = (i__21577__auto___34611 + (1));
i__21577__auto___34611 = G__34612;
continue;
} else {
}
break;
}

var G__34007 = args34003.length;
switch (G__34007) {
case 0:
return om_tools.dom.form.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34003.slice((1)),(0),null));
return om_tools.dom.form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.form.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.form,null,null);
});

om_tools.dom.form.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.form,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.form.cljs$lang$applyTo = (function (seq34004){
var G__34005 = cljs.core.first.call(null,seq34004);
var seq34004__$1 = cljs.core.next.call(null,seq34004);
return om_tools.dom.form.cljs$core$IFn$_invoke$arity$variadic(G__34005,seq34004__$1);
});

om_tools.dom.form.cljs$lang$maxFixedArity = (1);


om_tools.dom.h1 = (function om_tools$dom$h1(var_args){
var args34008 = [];
var len__21576__auto___34614 = arguments.length;
var i__21577__auto___34615 = (0);
while(true){
if((i__21577__auto___34615 < len__21576__auto___34614)){
args34008.push((arguments[i__21577__auto___34615]));

var G__34616 = (i__21577__auto___34615 + (1));
i__21577__auto___34615 = G__34616;
continue;
} else {
}
break;
}

var G__34012 = args34008.length;
switch (G__34012) {
case 0:
return om_tools.dom.h1.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34008.slice((1)),(0),null));
return om_tools.dom.h1.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.h1.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h1,null,null);
});

om_tools.dom.h1.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.h1,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.h1.cljs$lang$applyTo = (function (seq34009){
var G__34010 = cljs.core.first.call(null,seq34009);
var seq34009__$1 = cljs.core.next.call(null,seq34009);
return om_tools.dom.h1.cljs$core$IFn$_invoke$arity$variadic(G__34010,seq34009__$1);
});

om_tools.dom.h1.cljs$lang$maxFixedArity = (1);


om_tools.dom.h2 = (function om_tools$dom$h2(var_args){
var args34013 = [];
var len__21576__auto___34618 = arguments.length;
var i__21577__auto___34619 = (0);
while(true){
if((i__21577__auto___34619 < len__21576__auto___34618)){
args34013.push((arguments[i__21577__auto___34619]));

var G__34620 = (i__21577__auto___34619 + (1));
i__21577__auto___34619 = G__34620;
continue;
} else {
}
break;
}

var G__34017 = args34013.length;
switch (G__34017) {
case 0:
return om_tools.dom.h2.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34013.slice((1)),(0),null));
return om_tools.dom.h2.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.h2.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h2,null,null);
});

om_tools.dom.h2.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.h2,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.h2.cljs$lang$applyTo = (function (seq34014){
var G__34015 = cljs.core.first.call(null,seq34014);
var seq34014__$1 = cljs.core.next.call(null,seq34014);
return om_tools.dom.h2.cljs$core$IFn$_invoke$arity$variadic(G__34015,seq34014__$1);
});

om_tools.dom.h2.cljs$lang$maxFixedArity = (1);


om_tools.dom.h3 = (function om_tools$dom$h3(var_args){
var args34018 = [];
var len__21576__auto___34622 = arguments.length;
var i__21577__auto___34623 = (0);
while(true){
if((i__21577__auto___34623 < len__21576__auto___34622)){
args34018.push((arguments[i__21577__auto___34623]));

var G__34624 = (i__21577__auto___34623 + (1));
i__21577__auto___34623 = G__34624;
continue;
} else {
}
break;
}

var G__34022 = args34018.length;
switch (G__34022) {
case 0:
return om_tools.dom.h3.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34018.slice((1)),(0),null));
return om_tools.dom.h3.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.h3.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h3,null,null);
});

om_tools.dom.h3.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.h3,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.h3.cljs$lang$applyTo = (function (seq34019){
var G__34020 = cljs.core.first.call(null,seq34019);
var seq34019__$1 = cljs.core.next.call(null,seq34019);
return om_tools.dom.h3.cljs$core$IFn$_invoke$arity$variadic(G__34020,seq34019__$1);
});

om_tools.dom.h3.cljs$lang$maxFixedArity = (1);


om_tools.dom.h4 = (function om_tools$dom$h4(var_args){
var args34023 = [];
var len__21576__auto___34626 = arguments.length;
var i__21577__auto___34627 = (0);
while(true){
if((i__21577__auto___34627 < len__21576__auto___34626)){
args34023.push((arguments[i__21577__auto___34627]));

var G__34628 = (i__21577__auto___34627 + (1));
i__21577__auto___34627 = G__34628;
continue;
} else {
}
break;
}

var G__34027 = args34023.length;
switch (G__34027) {
case 0:
return om_tools.dom.h4.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34023.slice((1)),(0),null));
return om_tools.dom.h4.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.h4.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h4,null,null);
});

om_tools.dom.h4.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.h4,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.h4.cljs$lang$applyTo = (function (seq34024){
var G__34025 = cljs.core.first.call(null,seq34024);
var seq34024__$1 = cljs.core.next.call(null,seq34024);
return om_tools.dom.h4.cljs$core$IFn$_invoke$arity$variadic(G__34025,seq34024__$1);
});

om_tools.dom.h4.cljs$lang$maxFixedArity = (1);


om_tools.dom.h5 = (function om_tools$dom$h5(var_args){
var args34028 = [];
var len__21576__auto___34630 = arguments.length;
var i__21577__auto___34631 = (0);
while(true){
if((i__21577__auto___34631 < len__21576__auto___34630)){
args34028.push((arguments[i__21577__auto___34631]));

var G__34632 = (i__21577__auto___34631 + (1));
i__21577__auto___34631 = G__34632;
continue;
} else {
}
break;
}

var G__34032 = args34028.length;
switch (G__34032) {
case 0:
return om_tools.dom.h5.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34028.slice((1)),(0),null));
return om_tools.dom.h5.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.h5.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h5,null,null);
});

om_tools.dom.h5.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.h5,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.h5.cljs$lang$applyTo = (function (seq34029){
var G__34030 = cljs.core.first.call(null,seq34029);
var seq34029__$1 = cljs.core.next.call(null,seq34029);
return om_tools.dom.h5.cljs$core$IFn$_invoke$arity$variadic(G__34030,seq34029__$1);
});

om_tools.dom.h5.cljs$lang$maxFixedArity = (1);


om_tools.dom.h6 = (function om_tools$dom$h6(var_args){
var args34033 = [];
var len__21576__auto___34634 = arguments.length;
var i__21577__auto___34635 = (0);
while(true){
if((i__21577__auto___34635 < len__21576__auto___34634)){
args34033.push((arguments[i__21577__auto___34635]));

var G__34636 = (i__21577__auto___34635 + (1));
i__21577__auto___34635 = G__34636;
continue;
} else {
}
break;
}

var G__34037 = args34033.length;
switch (G__34037) {
case 0:
return om_tools.dom.h6.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34033.slice((1)),(0),null));
return om_tools.dom.h6.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.h6.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h6,null,null);
});

om_tools.dom.h6.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.h6,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.h6.cljs$lang$applyTo = (function (seq34034){
var G__34035 = cljs.core.first.call(null,seq34034);
var seq34034__$1 = cljs.core.next.call(null,seq34034);
return om_tools.dom.h6.cljs$core$IFn$_invoke$arity$variadic(G__34035,seq34034__$1);
});

om_tools.dom.h6.cljs$lang$maxFixedArity = (1);


om_tools.dom.head = (function om_tools$dom$head(var_args){
var args34038 = [];
var len__21576__auto___34638 = arguments.length;
var i__21577__auto___34639 = (0);
while(true){
if((i__21577__auto___34639 < len__21576__auto___34638)){
args34038.push((arguments[i__21577__auto___34639]));

var G__34640 = (i__21577__auto___34639 + (1));
i__21577__auto___34639 = G__34640;
continue;
} else {
}
break;
}

var G__34042 = args34038.length;
switch (G__34042) {
case 0:
return om_tools.dom.head.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34038.slice((1)),(0),null));
return om_tools.dom.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.head.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.head,null,null);
});

om_tools.dom.head.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.head,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.head.cljs$lang$applyTo = (function (seq34039){
var G__34040 = cljs.core.first.call(null,seq34039);
var seq34039__$1 = cljs.core.next.call(null,seq34039);
return om_tools.dom.head.cljs$core$IFn$_invoke$arity$variadic(G__34040,seq34039__$1);
});

om_tools.dom.head.cljs$lang$maxFixedArity = (1);


om_tools.dom.header = (function om_tools$dom$header(var_args){
var args34043 = [];
var len__21576__auto___34642 = arguments.length;
var i__21577__auto___34643 = (0);
while(true){
if((i__21577__auto___34643 < len__21576__auto___34642)){
args34043.push((arguments[i__21577__auto___34643]));

var G__34644 = (i__21577__auto___34643 + (1));
i__21577__auto___34643 = G__34644;
continue;
} else {
}
break;
}

var G__34047 = args34043.length;
switch (G__34047) {
case 0:
return om_tools.dom.header.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34043.slice((1)),(0),null));
return om_tools.dom.header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.header.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.header,null,null);
});

om_tools.dom.header.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.header,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.header.cljs$lang$applyTo = (function (seq34044){
var G__34045 = cljs.core.first.call(null,seq34044);
var seq34044__$1 = cljs.core.next.call(null,seq34044);
return om_tools.dom.header.cljs$core$IFn$_invoke$arity$variadic(G__34045,seq34044__$1);
});

om_tools.dom.header.cljs$lang$maxFixedArity = (1);


om_tools.dom.hr = (function om_tools$dom$hr(var_args){
var args34048 = [];
var len__21576__auto___34646 = arguments.length;
var i__21577__auto___34647 = (0);
while(true){
if((i__21577__auto___34647 < len__21576__auto___34646)){
args34048.push((arguments[i__21577__auto___34647]));

var G__34648 = (i__21577__auto___34647 + (1));
i__21577__auto___34647 = G__34648;
continue;
} else {
}
break;
}

var G__34052 = args34048.length;
switch (G__34052) {
case 0:
return om_tools.dom.hr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34048.slice((1)),(0),null));
return om_tools.dom.hr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.hr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.hr,null,null);
});

om_tools.dom.hr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.hr,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.hr.cljs$lang$applyTo = (function (seq34049){
var G__34050 = cljs.core.first.call(null,seq34049);
var seq34049__$1 = cljs.core.next.call(null,seq34049);
return om_tools.dom.hr.cljs$core$IFn$_invoke$arity$variadic(G__34050,seq34049__$1);
});

om_tools.dom.hr.cljs$lang$maxFixedArity = (1);


om_tools.dom.html = (function om_tools$dom$html(var_args){
var args34053 = [];
var len__21576__auto___34650 = arguments.length;
var i__21577__auto___34651 = (0);
while(true){
if((i__21577__auto___34651 < len__21576__auto___34650)){
args34053.push((arguments[i__21577__auto___34651]));

var G__34652 = (i__21577__auto___34651 + (1));
i__21577__auto___34651 = G__34652;
continue;
} else {
}
break;
}

var G__34057 = args34053.length;
switch (G__34057) {
case 0:
return om_tools.dom.html.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34053.slice((1)),(0),null));
return om_tools.dom.html.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.html.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.html,null,null);
});

om_tools.dom.html.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.html,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.html.cljs$lang$applyTo = (function (seq34054){
var G__34055 = cljs.core.first.call(null,seq34054);
var seq34054__$1 = cljs.core.next.call(null,seq34054);
return om_tools.dom.html.cljs$core$IFn$_invoke$arity$variadic(G__34055,seq34054__$1);
});

om_tools.dom.html.cljs$lang$maxFixedArity = (1);


om_tools.dom.i = (function om_tools$dom$i(var_args){
var args34058 = [];
var len__21576__auto___34654 = arguments.length;
var i__21577__auto___34655 = (0);
while(true){
if((i__21577__auto___34655 < len__21576__auto___34654)){
args34058.push((arguments[i__21577__auto___34655]));

var G__34656 = (i__21577__auto___34655 + (1));
i__21577__auto___34655 = G__34656;
continue;
} else {
}
break;
}

var G__34062 = args34058.length;
switch (G__34062) {
case 0:
return om_tools.dom.i.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34058.slice((1)),(0),null));
return om_tools.dom.i.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.i.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.i,null,null);
});

om_tools.dom.i.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.i,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.i.cljs$lang$applyTo = (function (seq34059){
var G__34060 = cljs.core.first.call(null,seq34059);
var seq34059__$1 = cljs.core.next.call(null,seq34059);
return om_tools.dom.i.cljs$core$IFn$_invoke$arity$variadic(G__34060,seq34059__$1);
});

om_tools.dom.i.cljs$lang$maxFixedArity = (1);


om_tools.dom.iframe = (function om_tools$dom$iframe(var_args){
var args34063 = [];
var len__21576__auto___34658 = arguments.length;
var i__21577__auto___34659 = (0);
while(true){
if((i__21577__auto___34659 < len__21576__auto___34658)){
args34063.push((arguments[i__21577__auto___34659]));

var G__34660 = (i__21577__auto___34659 + (1));
i__21577__auto___34659 = G__34660;
continue;
} else {
}
break;
}

var G__34067 = args34063.length;
switch (G__34067) {
case 0:
return om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34063.slice((1)),(0),null));
return om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.iframe,null,null);
});

om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.iframe,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.iframe.cljs$lang$applyTo = (function (seq34064){
var G__34065 = cljs.core.first.call(null,seq34064);
var seq34064__$1 = cljs.core.next.call(null,seq34064);
return om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$variadic(G__34065,seq34064__$1);
});

om_tools.dom.iframe.cljs$lang$maxFixedArity = (1);


om_tools.dom.img = (function om_tools$dom$img(var_args){
var args34068 = [];
var len__21576__auto___34662 = arguments.length;
var i__21577__auto___34663 = (0);
while(true){
if((i__21577__auto___34663 < len__21576__auto___34662)){
args34068.push((arguments[i__21577__auto___34663]));

var G__34664 = (i__21577__auto___34663 + (1));
i__21577__auto___34663 = G__34664;
continue;
} else {
}
break;
}

var G__34072 = args34068.length;
switch (G__34072) {
case 0:
return om_tools.dom.img.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34068.slice((1)),(0),null));
return om_tools.dom.img.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.img.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.img,null,null);
});

om_tools.dom.img.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.img,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.img.cljs$lang$applyTo = (function (seq34069){
var G__34070 = cljs.core.first.call(null,seq34069);
var seq34069__$1 = cljs.core.next.call(null,seq34069);
return om_tools.dom.img.cljs$core$IFn$_invoke$arity$variadic(G__34070,seq34069__$1);
});

om_tools.dom.img.cljs$lang$maxFixedArity = (1);


om_tools.dom.ins = (function om_tools$dom$ins(var_args){
var args34073 = [];
var len__21576__auto___34666 = arguments.length;
var i__21577__auto___34667 = (0);
while(true){
if((i__21577__auto___34667 < len__21576__auto___34666)){
args34073.push((arguments[i__21577__auto___34667]));

var G__34668 = (i__21577__auto___34667 + (1));
i__21577__auto___34667 = G__34668;
continue;
} else {
}
break;
}

var G__34077 = args34073.length;
switch (G__34077) {
case 0:
return om_tools.dom.ins.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34073.slice((1)),(0),null));
return om_tools.dom.ins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.ins.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ins,null,null);
});

om_tools.dom.ins.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.ins,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.ins.cljs$lang$applyTo = (function (seq34074){
var G__34075 = cljs.core.first.call(null,seq34074);
var seq34074__$1 = cljs.core.next.call(null,seq34074);
return om_tools.dom.ins.cljs$core$IFn$_invoke$arity$variadic(G__34075,seq34074__$1);
});

om_tools.dom.ins.cljs$lang$maxFixedArity = (1);


om_tools.dom.kbd = (function om_tools$dom$kbd(var_args){
var args34078 = [];
var len__21576__auto___34670 = arguments.length;
var i__21577__auto___34671 = (0);
while(true){
if((i__21577__auto___34671 < len__21576__auto___34670)){
args34078.push((arguments[i__21577__auto___34671]));

var G__34672 = (i__21577__auto___34671 + (1));
i__21577__auto___34671 = G__34672;
continue;
} else {
}
break;
}

var G__34082 = args34078.length;
switch (G__34082) {
case 0:
return om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34078.slice((1)),(0),null));
return om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.kbd,null,null);
});

om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.kbd,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.kbd.cljs$lang$applyTo = (function (seq34079){
var G__34080 = cljs.core.first.call(null,seq34079);
var seq34079__$1 = cljs.core.next.call(null,seq34079);
return om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$variadic(G__34080,seq34079__$1);
});

om_tools.dom.kbd.cljs$lang$maxFixedArity = (1);


om_tools.dom.keygen = (function om_tools$dom$keygen(var_args){
var args34083 = [];
var len__21576__auto___34674 = arguments.length;
var i__21577__auto___34675 = (0);
while(true){
if((i__21577__auto___34675 < len__21576__auto___34674)){
args34083.push((arguments[i__21577__auto___34675]));

var G__34676 = (i__21577__auto___34675 + (1));
i__21577__auto___34675 = G__34676;
continue;
} else {
}
break;
}

var G__34087 = args34083.length;
switch (G__34087) {
case 0:
return om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34083.slice((1)),(0),null));
return om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.keygen,null,null);
});

om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.keygen,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.keygen.cljs$lang$applyTo = (function (seq34084){
var G__34085 = cljs.core.first.call(null,seq34084);
var seq34084__$1 = cljs.core.next.call(null,seq34084);
return om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$variadic(G__34085,seq34084__$1);
});

om_tools.dom.keygen.cljs$lang$maxFixedArity = (1);


om_tools.dom.label = (function om_tools$dom$label(var_args){
var args34088 = [];
var len__21576__auto___34678 = arguments.length;
var i__21577__auto___34679 = (0);
while(true){
if((i__21577__auto___34679 < len__21576__auto___34678)){
args34088.push((arguments[i__21577__auto___34679]));

var G__34680 = (i__21577__auto___34679 + (1));
i__21577__auto___34679 = G__34680;
continue;
} else {
}
break;
}

var G__34092 = args34088.length;
switch (G__34092) {
case 0:
return om_tools.dom.label.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34088.slice((1)),(0),null));
return om_tools.dom.label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.label.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.label,null,null);
});

om_tools.dom.label.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.label,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.label.cljs$lang$applyTo = (function (seq34089){
var G__34090 = cljs.core.first.call(null,seq34089);
var seq34089__$1 = cljs.core.next.call(null,seq34089);
return om_tools.dom.label.cljs$core$IFn$_invoke$arity$variadic(G__34090,seq34089__$1);
});

om_tools.dom.label.cljs$lang$maxFixedArity = (1);


om_tools.dom.legend = (function om_tools$dom$legend(var_args){
var args34093 = [];
var len__21576__auto___34682 = arguments.length;
var i__21577__auto___34683 = (0);
while(true){
if((i__21577__auto___34683 < len__21576__auto___34682)){
args34093.push((arguments[i__21577__auto___34683]));

var G__34684 = (i__21577__auto___34683 + (1));
i__21577__auto___34683 = G__34684;
continue;
} else {
}
break;
}

var G__34097 = args34093.length;
switch (G__34097) {
case 0:
return om_tools.dom.legend.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34093.slice((1)),(0),null));
return om_tools.dom.legend.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.legend.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.legend,null,null);
});

om_tools.dom.legend.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.legend,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.legend.cljs$lang$applyTo = (function (seq34094){
var G__34095 = cljs.core.first.call(null,seq34094);
var seq34094__$1 = cljs.core.next.call(null,seq34094);
return om_tools.dom.legend.cljs$core$IFn$_invoke$arity$variadic(G__34095,seq34094__$1);
});

om_tools.dom.legend.cljs$lang$maxFixedArity = (1);


om_tools.dom.li = (function om_tools$dom$li(var_args){
var args34098 = [];
var len__21576__auto___34686 = arguments.length;
var i__21577__auto___34687 = (0);
while(true){
if((i__21577__auto___34687 < len__21576__auto___34686)){
args34098.push((arguments[i__21577__auto___34687]));

var G__34688 = (i__21577__auto___34687 + (1));
i__21577__auto___34687 = G__34688;
continue;
} else {
}
break;
}

var G__34102 = args34098.length;
switch (G__34102) {
case 0:
return om_tools.dom.li.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34098.slice((1)),(0),null));
return om_tools.dom.li.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.li.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.li,null,null);
});

om_tools.dom.li.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.li,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.li.cljs$lang$applyTo = (function (seq34099){
var G__34100 = cljs.core.first.call(null,seq34099);
var seq34099__$1 = cljs.core.next.call(null,seq34099);
return om_tools.dom.li.cljs$core$IFn$_invoke$arity$variadic(G__34100,seq34099__$1);
});

om_tools.dom.li.cljs$lang$maxFixedArity = (1);


om_tools.dom.link = (function om_tools$dom$link(var_args){
var args34103 = [];
var len__21576__auto___34690 = arguments.length;
var i__21577__auto___34691 = (0);
while(true){
if((i__21577__auto___34691 < len__21576__auto___34690)){
args34103.push((arguments[i__21577__auto___34691]));

var G__34692 = (i__21577__auto___34691 + (1));
i__21577__auto___34691 = G__34692;
continue;
} else {
}
break;
}

var G__34107 = args34103.length;
switch (G__34107) {
case 0:
return om_tools.dom.link.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34103.slice((1)),(0),null));
return om_tools.dom.link.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.link.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.link,null,null);
});

om_tools.dom.link.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.link,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.link.cljs$lang$applyTo = (function (seq34104){
var G__34105 = cljs.core.first.call(null,seq34104);
var seq34104__$1 = cljs.core.next.call(null,seq34104);
return om_tools.dom.link.cljs$core$IFn$_invoke$arity$variadic(G__34105,seq34104__$1);
});

om_tools.dom.link.cljs$lang$maxFixedArity = (1);


om_tools.dom.main = (function om_tools$dom$main(var_args){
var args34108 = [];
var len__21576__auto___34694 = arguments.length;
var i__21577__auto___34695 = (0);
while(true){
if((i__21577__auto___34695 < len__21576__auto___34694)){
args34108.push((arguments[i__21577__auto___34695]));

var G__34696 = (i__21577__auto___34695 + (1));
i__21577__auto___34695 = G__34696;
continue;
} else {
}
break;
}

var G__34112 = args34108.length;
switch (G__34112) {
case 0:
return om_tools.dom.main.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34108.slice((1)),(0),null));
return om_tools.dom.main.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.main.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.main,null,null);
});

om_tools.dom.main.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.main,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.main.cljs$lang$applyTo = (function (seq34109){
var G__34110 = cljs.core.first.call(null,seq34109);
var seq34109__$1 = cljs.core.next.call(null,seq34109);
return om_tools.dom.main.cljs$core$IFn$_invoke$arity$variadic(G__34110,seq34109__$1);
});

om_tools.dom.main.cljs$lang$maxFixedArity = (1);


om_tools.dom.map = (function om_tools$dom$map(var_args){
var args34113 = [];
var len__21576__auto___34698 = arguments.length;
var i__21577__auto___34699 = (0);
while(true){
if((i__21577__auto___34699 < len__21576__auto___34698)){
args34113.push((arguments[i__21577__auto___34699]));

var G__34700 = (i__21577__auto___34699 + (1));
i__21577__auto___34699 = G__34700;
continue;
} else {
}
break;
}

var G__34117 = args34113.length;
switch (G__34117) {
case 0:
return om_tools.dom.map.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34113.slice((1)),(0),null));
return om_tools.dom.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.map.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.map,null,null);
});

om_tools.dom.map.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.map,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.map.cljs$lang$applyTo = (function (seq34114){
var G__34115 = cljs.core.first.call(null,seq34114);
var seq34114__$1 = cljs.core.next.call(null,seq34114);
return om_tools.dom.map.cljs$core$IFn$_invoke$arity$variadic(G__34115,seq34114__$1);
});

om_tools.dom.map.cljs$lang$maxFixedArity = (1);


om_tools.dom.mark = (function om_tools$dom$mark(var_args){
var args34118 = [];
var len__21576__auto___34702 = arguments.length;
var i__21577__auto___34703 = (0);
while(true){
if((i__21577__auto___34703 < len__21576__auto___34702)){
args34118.push((arguments[i__21577__auto___34703]));

var G__34704 = (i__21577__auto___34703 + (1));
i__21577__auto___34703 = G__34704;
continue;
} else {
}
break;
}

var G__34122 = args34118.length;
switch (G__34122) {
case 0:
return om_tools.dom.mark.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34118.slice((1)),(0),null));
return om_tools.dom.mark.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.mark.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.mark,null,null);
});

om_tools.dom.mark.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.mark,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.mark.cljs$lang$applyTo = (function (seq34119){
var G__34120 = cljs.core.first.call(null,seq34119);
var seq34119__$1 = cljs.core.next.call(null,seq34119);
return om_tools.dom.mark.cljs$core$IFn$_invoke$arity$variadic(G__34120,seq34119__$1);
});

om_tools.dom.mark.cljs$lang$maxFixedArity = (1);


om_tools.dom.menu = (function om_tools$dom$menu(var_args){
var args34123 = [];
var len__21576__auto___34706 = arguments.length;
var i__21577__auto___34707 = (0);
while(true){
if((i__21577__auto___34707 < len__21576__auto___34706)){
args34123.push((arguments[i__21577__auto___34707]));

var G__34708 = (i__21577__auto___34707 + (1));
i__21577__auto___34707 = G__34708;
continue;
} else {
}
break;
}

var G__34127 = args34123.length;
switch (G__34127) {
case 0:
return om_tools.dom.menu.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34123.slice((1)),(0),null));
return om_tools.dom.menu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.menu.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.menu,null,null);
});

om_tools.dom.menu.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.menu,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.menu.cljs$lang$applyTo = (function (seq34124){
var G__34125 = cljs.core.first.call(null,seq34124);
var seq34124__$1 = cljs.core.next.call(null,seq34124);
return om_tools.dom.menu.cljs$core$IFn$_invoke$arity$variadic(G__34125,seq34124__$1);
});

om_tools.dom.menu.cljs$lang$maxFixedArity = (1);


om_tools.dom.menuitem = (function om_tools$dom$menuitem(var_args){
var args34128 = [];
var len__21576__auto___34710 = arguments.length;
var i__21577__auto___34711 = (0);
while(true){
if((i__21577__auto___34711 < len__21576__auto___34710)){
args34128.push((arguments[i__21577__auto___34711]));

var G__34712 = (i__21577__auto___34711 + (1));
i__21577__auto___34711 = G__34712;
continue;
} else {
}
break;
}

var G__34132 = args34128.length;
switch (G__34132) {
case 0:
return om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34128.slice((1)),(0),null));
return om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.menuitem,null,null);
});

om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.menuitem,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.menuitem.cljs$lang$applyTo = (function (seq34129){
var G__34130 = cljs.core.first.call(null,seq34129);
var seq34129__$1 = cljs.core.next.call(null,seq34129);
return om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic(G__34130,seq34129__$1);
});

om_tools.dom.menuitem.cljs$lang$maxFixedArity = (1);


om_tools.dom.meta = (function om_tools$dom$meta(var_args){
var args34133 = [];
var len__21576__auto___34714 = arguments.length;
var i__21577__auto___34715 = (0);
while(true){
if((i__21577__auto___34715 < len__21576__auto___34714)){
args34133.push((arguments[i__21577__auto___34715]));

var G__34716 = (i__21577__auto___34715 + (1));
i__21577__auto___34715 = G__34716;
continue;
} else {
}
break;
}

var G__34137 = args34133.length;
switch (G__34137) {
case 0:
return om_tools.dom.meta.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34133.slice((1)),(0),null));
return om_tools.dom.meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.meta.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.meta,null,null);
});

om_tools.dom.meta.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.meta,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.meta.cljs$lang$applyTo = (function (seq34134){
var G__34135 = cljs.core.first.call(null,seq34134);
var seq34134__$1 = cljs.core.next.call(null,seq34134);
return om_tools.dom.meta.cljs$core$IFn$_invoke$arity$variadic(G__34135,seq34134__$1);
});

om_tools.dom.meta.cljs$lang$maxFixedArity = (1);


om_tools.dom.meter = (function om_tools$dom$meter(var_args){
var args34138 = [];
var len__21576__auto___34718 = arguments.length;
var i__21577__auto___34719 = (0);
while(true){
if((i__21577__auto___34719 < len__21576__auto___34718)){
args34138.push((arguments[i__21577__auto___34719]));

var G__34720 = (i__21577__auto___34719 + (1));
i__21577__auto___34719 = G__34720;
continue;
} else {
}
break;
}

var G__34142 = args34138.length;
switch (G__34142) {
case 0:
return om_tools.dom.meter.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34138.slice((1)),(0),null));
return om_tools.dom.meter.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.meter.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.meter,null,null);
});

om_tools.dom.meter.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.meter,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.meter.cljs$lang$applyTo = (function (seq34139){
var G__34140 = cljs.core.first.call(null,seq34139);
var seq34139__$1 = cljs.core.next.call(null,seq34139);
return om_tools.dom.meter.cljs$core$IFn$_invoke$arity$variadic(G__34140,seq34139__$1);
});

om_tools.dom.meter.cljs$lang$maxFixedArity = (1);


om_tools.dom.nav = (function om_tools$dom$nav(var_args){
var args34143 = [];
var len__21576__auto___34722 = arguments.length;
var i__21577__auto___34723 = (0);
while(true){
if((i__21577__auto___34723 < len__21576__auto___34722)){
args34143.push((arguments[i__21577__auto___34723]));

var G__34724 = (i__21577__auto___34723 + (1));
i__21577__auto___34723 = G__34724;
continue;
} else {
}
break;
}

var G__34147 = args34143.length;
switch (G__34147) {
case 0:
return om_tools.dom.nav.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34143.slice((1)),(0),null));
return om_tools.dom.nav.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.nav.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.nav,null,null);
});

om_tools.dom.nav.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.nav,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.nav.cljs$lang$applyTo = (function (seq34144){
var G__34145 = cljs.core.first.call(null,seq34144);
var seq34144__$1 = cljs.core.next.call(null,seq34144);
return om_tools.dom.nav.cljs$core$IFn$_invoke$arity$variadic(G__34145,seq34144__$1);
});

om_tools.dom.nav.cljs$lang$maxFixedArity = (1);


om_tools.dom.noscript = (function om_tools$dom$noscript(var_args){
var args34148 = [];
var len__21576__auto___34726 = arguments.length;
var i__21577__auto___34727 = (0);
while(true){
if((i__21577__auto___34727 < len__21576__auto___34726)){
args34148.push((arguments[i__21577__auto___34727]));

var G__34728 = (i__21577__auto___34727 + (1));
i__21577__auto___34727 = G__34728;
continue;
} else {
}
break;
}

var G__34152 = args34148.length;
switch (G__34152) {
case 0:
return om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34148.slice((1)),(0),null));
return om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.noscript,null,null);
});

om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.noscript,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.noscript.cljs$lang$applyTo = (function (seq34149){
var G__34150 = cljs.core.first.call(null,seq34149);
var seq34149__$1 = cljs.core.next.call(null,seq34149);
return om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$variadic(G__34150,seq34149__$1);
});

om_tools.dom.noscript.cljs$lang$maxFixedArity = (1);


om_tools.dom.object = (function om_tools$dom$object(var_args){
var args34153 = [];
var len__21576__auto___34730 = arguments.length;
var i__21577__auto___34731 = (0);
while(true){
if((i__21577__auto___34731 < len__21576__auto___34730)){
args34153.push((arguments[i__21577__auto___34731]));

var G__34732 = (i__21577__auto___34731 + (1));
i__21577__auto___34731 = G__34732;
continue;
} else {
}
break;
}

var G__34157 = args34153.length;
switch (G__34157) {
case 0:
return om_tools.dom.object.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34153.slice((1)),(0),null));
return om_tools.dom.object.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.object.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.object,null,null);
});

om_tools.dom.object.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.object,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.object.cljs$lang$applyTo = (function (seq34154){
var G__34155 = cljs.core.first.call(null,seq34154);
var seq34154__$1 = cljs.core.next.call(null,seq34154);
return om_tools.dom.object.cljs$core$IFn$_invoke$arity$variadic(G__34155,seq34154__$1);
});

om_tools.dom.object.cljs$lang$maxFixedArity = (1);


om_tools.dom.ol = (function om_tools$dom$ol(var_args){
var args34158 = [];
var len__21576__auto___34734 = arguments.length;
var i__21577__auto___34735 = (0);
while(true){
if((i__21577__auto___34735 < len__21576__auto___34734)){
args34158.push((arguments[i__21577__auto___34735]));

var G__34736 = (i__21577__auto___34735 + (1));
i__21577__auto___34735 = G__34736;
continue;
} else {
}
break;
}

var G__34162 = args34158.length;
switch (G__34162) {
case 0:
return om_tools.dom.ol.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34158.slice((1)),(0),null));
return om_tools.dom.ol.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.ol.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ol,null,null);
});

om_tools.dom.ol.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.ol,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.ol.cljs$lang$applyTo = (function (seq34159){
var G__34160 = cljs.core.first.call(null,seq34159);
var seq34159__$1 = cljs.core.next.call(null,seq34159);
return om_tools.dom.ol.cljs$core$IFn$_invoke$arity$variadic(G__34160,seq34159__$1);
});

om_tools.dom.ol.cljs$lang$maxFixedArity = (1);


om_tools.dom.optgroup = (function om_tools$dom$optgroup(var_args){
var args34163 = [];
var len__21576__auto___34738 = arguments.length;
var i__21577__auto___34739 = (0);
while(true){
if((i__21577__auto___34739 < len__21576__auto___34738)){
args34163.push((arguments[i__21577__auto___34739]));

var G__34740 = (i__21577__auto___34739 + (1));
i__21577__auto___34739 = G__34740;
continue;
} else {
}
break;
}

var G__34167 = args34163.length;
switch (G__34167) {
case 0:
return om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34163.slice((1)),(0),null));
return om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.optgroup,null,null);
});

om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.optgroup,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.optgroup.cljs$lang$applyTo = (function (seq34164){
var G__34165 = cljs.core.first.call(null,seq34164);
var seq34164__$1 = cljs.core.next.call(null,seq34164);
return om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic(G__34165,seq34164__$1);
});

om_tools.dom.optgroup.cljs$lang$maxFixedArity = (1);


om_tools.dom.output = (function om_tools$dom$output(var_args){
var args34168 = [];
var len__21576__auto___34742 = arguments.length;
var i__21577__auto___34743 = (0);
while(true){
if((i__21577__auto___34743 < len__21576__auto___34742)){
args34168.push((arguments[i__21577__auto___34743]));

var G__34744 = (i__21577__auto___34743 + (1));
i__21577__auto___34743 = G__34744;
continue;
} else {
}
break;
}

var G__34172 = args34168.length;
switch (G__34172) {
case 0:
return om_tools.dom.output.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34168.slice((1)),(0),null));
return om_tools.dom.output.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.output.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.output,null,null);
});

om_tools.dom.output.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.output,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.output.cljs$lang$applyTo = (function (seq34169){
var G__34170 = cljs.core.first.call(null,seq34169);
var seq34169__$1 = cljs.core.next.call(null,seq34169);
return om_tools.dom.output.cljs$core$IFn$_invoke$arity$variadic(G__34170,seq34169__$1);
});

om_tools.dom.output.cljs$lang$maxFixedArity = (1);


om_tools.dom.p = (function om_tools$dom$p(var_args){
var args34173 = [];
var len__21576__auto___34746 = arguments.length;
var i__21577__auto___34747 = (0);
while(true){
if((i__21577__auto___34747 < len__21576__auto___34746)){
args34173.push((arguments[i__21577__auto___34747]));

var G__34748 = (i__21577__auto___34747 + (1));
i__21577__auto___34747 = G__34748;
continue;
} else {
}
break;
}

var G__34177 = args34173.length;
switch (G__34177) {
case 0:
return om_tools.dom.p.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34173.slice((1)),(0),null));
return om_tools.dom.p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.p.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.p,null,null);
});

om_tools.dom.p.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.p,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.p.cljs$lang$applyTo = (function (seq34174){
var G__34175 = cljs.core.first.call(null,seq34174);
var seq34174__$1 = cljs.core.next.call(null,seq34174);
return om_tools.dom.p.cljs$core$IFn$_invoke$arity$variadic(G__34175,seq34174__$1);
});

om_tools.dom.p.cljs$lang$maxFixedArity = (1);


om_tools.dom.param = (function om_tools$dom$param(var_args){
var args34178 = [];
var len__21576__auto___34750 = arguments.length;
var i__21577__auto___34751 = (0);
while(true){
if((i__21577__auto___34751 < len__21576__auto___34750)){
args34178.push((arguments[i__21577__auto___34751]));

var G__34752 = (i__21577__auto___34751 + (1));
i__21577__auto___34751 = G__34752;
continue;
} else {
}
break;
}

var G__34182 = args34178.length;
switch (G__34182) {
case 0:
return om_tools.dom.param.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34178.slice((1)),(0),null));
return om_tools.dom.param.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.param.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.param,null,null);
});

om_tools.dom.param.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.param,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.param.cljs$lang$applyTo = (function (seq34179){
var G__34180 = cljs.core.first.call(null,seq34179);
var seq34179__$1 = cljs.core.next.call(null,seq34179);
return om_tools.dom.param.cljs$core$IFn$_invoke$arity$variadic(G__34180,seq34179__$1);
});

om_tools.dom.param.cljs$lang$maxFixedArity = (1);


om_tools.dom.picture = (function om_tools$dom$picture(var_args){
var args34183 = [];
var len__21576__auto___34754 = arguments.length;
var i__21577__auto___34755 = (0);
while(true){
if((i__21577__auto___34755 < len__21576__auto___34754)){
args34183.push((arguments[i__21577__auto___34755]));

var G__34756 = (i__21577__auto___34755 + (1));
i__21577__auto___34755 = G__34756;
continue;
} else {
}
break;
}

var G__34187 = args34183.length;
switch (G__34187) {
case 0:
return om_tools.dom.picture.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34183.slice((1)),(0),null));
return om_tools.dom.picture.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.picture.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.picture,null,null);
});

om_tools.dom.picture.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.picture,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.picture.cljs$lang$applyTo = (function (seq34184){
var G__34185 = cljs.core.first.call(null,seq34184);
var seq34184__$1 = cljs.core.next.call(null,seq34184);
return om_tools.dom.picture.cljs$core$IFn$_invoke$arity$variadic(G__34185,seq34184__$1);
});

om_tools.dom.picture.cljs$lang$maxFixedArity = (1);


om_tools.dom.pre = (function om_tools$dom$pre(var_args){
var args34188 = [];
var len__21576__auto___34758 = arguments.length;
var i__21577__auto___34759 = (0);
while(true){
if((i__21577__auto___34759 < len__21576__auto___34758)){
args34188.push((arguments[i__21577__auto___34759]));

var G__34760 = (i__21577__auto___34759 + (1));
i__21577__auto___34759 = G__34760;
continue;
} else {
}
break;
}

var G__34192 = args34188.length;
switch (G__34192) {
case 0:
return om_tools.dom.pre.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34188.slice((1)),(0),null));
return om_tools.dom.pre.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.pre.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.pre,null,null);
});

om_tools.dom.pre.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.pre,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.pre.cljs$lang$applyTo = (function (seq34189){
var G__34190 = cljs.core.first.call(null,seq34189);
var seq34189__$1 = cljs.core.next.call(null,seq34189);
return om_tools.dom.pre.cljs$core$IFn$_invoke$arity$variadic(G__34190,seq34189__$1);
});

om_tools.dom.pre.cljs$lang$maxFixedArity = (1);


om_tools.dom.progress = (function om_tools$dom$progress(var_args){
var args34193 = [];
var len__21576__auto___34762 = arguments.length;
var i__21577__auto___34763 = (0);
while(true){
if((i__21577__auto___34763 < len__21576__auto___34762)){
args34193.push((arguments[i__21577__auto___34763]));

var G__34764 = (i__21577__auto___34763 + (1));
i__21577__auto___34763 = G__34764;
continue;
} else {
}
break;
}

var G__34197 = args34193.length;
switch (G__34197) {
case 0:
return om_tools.dom.progress.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34193.slice((1)),(0),null));
return om_tools.dom.progress.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.progress.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.progress,null,null);
});

om_tools.dom.progress.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.progress,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.progress.cljs$lang$applyTo = (function (seq34194){
var G__34195 = cljs.core.first.call(null,seq34194);
var seq34194__$1 = cljs.core.next.call(null,seq34194);
return om_tools.dom.progress.cljs$core$IFn$_invoke$arity$variadic(G__34195,seq34194__$1);
});

om_tools.dom.progress.cljs$lang$maxFixedArity = (1);


om_tools.dom.q = (function om_tools$dom$q(var_args){
var args34198 = [];
var len__21576__auto___34766 = arguments.length;
var i__21577__auto___34767 = (0);
while(true){
if((i__21577__auto___34767 < len__21576__auto___34766)){
args34198.push((arguments[i__21577__auto___34767]));

var G__34768 = (i__21577__auto___34767 + (1));
i__21577__auto___34767 = G__34768;
continue;
} else {
}
break;
}

var G__34202 = args34198.length;
switch (G__34202) {
case 0:
return om_tools.dom.q.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34198.slice((1)),(0),null));
return om_tools.dom.q.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.q.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.q,null,null);
});

om_tools.dom.q.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.q,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.q.cljs$lang$applyTo = (function (seq34199){
var G__34200 = cljs.core.first.call(null,seq34199);
var seq34199__$1 = cljs.core.next.call(null,seq34199);
return om_tools.dom.q.cljs$core$IFn$_invoke$arity$variadic(G__34200,seq34199__$1);
});

om_tools.dom.q.cljs$lang$maxFixedArity = (1);


om_tools.dom.rp = (function om_tools$dom$rp(var_args){
var args34203 = [];
var len__21576__auto___34770 = arguments.length;
var i__21577__auto___34771 = (0);
while(true){
if((i__21577__auto___34771 < len__21576__auto___34770)){
args34203.push((arguments[i__21577__auto___34771]));

var G__34772 = (i__21577__auto___34771 + (1));
i__21577__auto___34771 = G__34772;
continue;
} else {
}
break;
}

var G__34207 = args34203.length;
switch (G__34207) {
case 0:
return om_tools.dom.rp.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34203.slice((1)),(0),null));
return om_tools.dom.rp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.rp.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.rp,null,null);
});

om_tools.dom.rp.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.rp,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.rp.cljs$lang$applyTo = (function (seq34204){
var G__34205 = cljs.core.first.call(null,seq34204);
var seq34204__$1 = cljs.core.next.call(null,seq34204);
return om_tools.dom.rp.cljs$core$IFn$_invoke$arity$variadic(G__34205,seq34204__$1);
});

om_tools.dom.rp.cljs$lang$maxFixedArity = (1);


om_tools.dom.rt = (function om_tools$dom$rt(var_args){
var args34208 = [];
var len__21576__auto___34774 = arguments.length;
var i__21577__auto___34775 = (0);
while(true){
if((i__21577__auto___34775 < len__21576__auto___34774)){
args34208.push((arguments[i__21577__auto___34775]));

var G__34776 = (i__21577__auto___34775 + (1));
i__21577__auto___34775 = G__34776;
continue;
} else {
}
break;
}

var G__34212 = args34208.length;
switch (G__34212) {
case 0:
return om_tools.dom.rt.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34208.slice((1)),(0),null));
return om_tools.dom.rt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.rt.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.rt,null,null);
});

om_tools.dom.rt.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.rt,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.rt.cljs$lang$applyTo = (function (seq34209){
var G__34210 = cljs.core.first.call(null,seq34209);
var seq34209__$1 = cljs.core.next.call(null,seq34209);
return om_tools.dom.rt.cljs$core$IFn$_invoke$arity$variadic(G__34210,seq34209__$1);
});

om_tools.dom.rt.cljs$lang$maxFixedArity = (1);


om_tools.dom.ruby = (function om_tools$dom$ruby(var_args){
var args34213 = [];
var len__21576__auto___34778 = arguments.length;
var i__21577__auto___34779 = (0);
while(true){
if((i__21577__auto___34779 < len__21576__auto___34778)){
args34213.push((arguments[i__21577__auto___34779]));

var G__34780 = (i__21577__auto___34779 + (1));
i__21577__auto___34779 = G__34780;
continue;
} else {
}
break;
}

var G__34217 = args34213.length;
switch (G__34217) {
case 0:
return om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34213.slice((1)),(0),null));
return om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ruby,null,null);
});

om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.ruby,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.ruby.cljs$lang$applyTo = (function (seq34214){
var G__34215 = cljs.core.first.call(null,seq34214);
var seq34214__$1 = cljs.core.next.call(null,seq34214);
return om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$variadic(G__34215,seq34214__$1);
});

om_tools.dom.ruby.cljs$lang$maxFixedArity = (1);


om_tools.dom.s = (function om_tools$dom$s(var_args){
var args34218 = [];
var len__21576__auto___34782 = arguments.length;
var i__21577__auto___34783 = (0);
while(true){
if((i__21577__auto___34783 < len__21576__auto___34782)){
args34218.push((arguments[i__21577__auto___34783]));

var G__34784 = (i__21577__auto___34783 + (1));
i__21577__auto___34783 = G__34784;
continue;
} else {
}
break;
}

var G__34222 = args34218.length;
switch (G__34222) {
case 0:
return om_tools.dom.s.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34218.slice((1)),(0),null));
return om_tools.dom.s.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.s.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.s,null,null);
});

om_tools.dom.s.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.s,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.s.cljs$lang$applyTo = (function (seq34219){
var G__34220 = cljs.core.first.call(null,seq34219);
var seq34219__$1 = cljs.core.next.call(null,seq34219);
return om_tools.dom.s.cljs$core$IFn$_invoke$arity$variadic(G__34220,seq34219__$1);
});

om_tools.dom.s.cljs$lang$maxFixedArity = (1);


om_tools.dom.samp = (function om_tools$dom$samp(var_args){
var args34223 = [];
var len__21576__auto___34786 = arguments.length;
var i__21577__auto___34787 = (0);
while(true){
if((i__21577__auto___34787 < len__21576__auto___34786)){
args34223.push((arguments[i__21577__auto___34787]));

var G__34788 = (i__21577__auto___34787 + (1));
i__21577__auto___34787 = G__34788;
continue;
} else {
}
break;
}

var G__34227 = args34223.length;
switch (G__34227) {
case 0:
return om_tools.dom.samp.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34223.slice((1)),(0),null));
return om_tools.dom.samp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.samp.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.samp,null,null);
});

om_tools.dom.samp.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.samp,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.samp.cljs$lang$applyTo = (function (seq34224){
var G__34225 = cljs.core.first.call(null,seq34224);
var seq34224__$1 = cljs.core.next.call(null,seq34224);
return om_tools.dom.samp.cljs$core$IFn$_invoke$arity$variadic(G__34225,seq34224__$1);
});

om_tools.dom.samp.cljs$lang$maxFixedArity = (1);


om_tools.dom.script = (function om_tools$dom$script(var_args){
var args34228 = [];
var len__21576__auto___34790 = arguments.length;
var i__21577__auto___34791 = (0);
while(true){
if((i__21577__auto___34791 < len__21576__auto___34790)){
args34228.push((arguments[i__21577__auto___34791]));

var G__34792 = (i__21577__auto___34791 + (1));
i__21577__auto___34791 = G__34792;
continue;
} else {
}
break;
}

var G__34232 = args34228.length;
switch (G__34232) {
case 0:
return om_tools.dom.script.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34228.slice((1)),(0),null));
return om_tools.dom.script.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.script.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.script,null,null);
});

om_tools.dom.script.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.script,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.script.cljs$lang$applyTo = (function (seq34229){
var G__34230 = cljs.core.first.call(null,seq34229);
var seq34229__$1 = cljs.core.next.call(null,seq34229);
return om_tools.dom.script.cljs$core$IFn$_invoke$arity$variadic(G__34230,seq34229__$1);
});

om_tools.dom.script.cljs$lang$maxFixedArity = (1);


om_tools.dom.section = (function om_tools$dom$section(var_args){
var args34233 = [];
var len__21576__auto___34794 = arguments.length;
var i__21577__auto___34795 = (0);
while(true){
if((i__21577__auto___34795 < len__21576__auto___34794)){
args34233.push((arguments[i__21577__auto___34795]));

var G__34796 = (i__21577__auto___34795 + (1));
i__21577__auto___34795 = G__34796;
continue;
} else {
}
break;
}

var G__34237 = args34233.length;
switch (G__34237) {
case 0:
return om_tools.dom.section.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34233.slice((1)),(0),null));
return om_tools.dom.section.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.section.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.section,null,null);
});

om_tools.dom.section.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.section,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.section.cljs$lang$applyTo = (function (seq34234){
var G__34235 = cljs.core.first.call(null,seq34234);
var seq34234__$1 = cljs.core.next.call(null,seq34234);
return om_tools.dom.section.cljs$core$IFn$_invoke$arity$variadic(G__34235,seq34234__$1);
});

om_tools.dom.section.cljs$lang$maxFixedArity = (1);


om_tools.dom.small = (function om_tools$dom$small(var_args){
var args34238 = [];
var len__21576__auto___34798 = arguments.length;
var i__21577__auto___34799 = (0);
while(true){
if((i__21577__auto___34799 < len__21576__auto___34798)){
args34238.push((arguments[i__21577__auto___34799]));

var G__34800 = (i__21577__auto___34799 + (1));
i__21577__auto___34799 = G__34800;
continue;
} else {
}
break;
}

var G__34242 = args34238.length;
switch (G__34242) {
case 0:
return om_tools.dom.small.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34238.slice((1)),(0),null));
return om_tools.dom.small.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.small.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.small,null,null);
});

om_tools.dom.small.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.small,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.small.cljs$lang$applyTo = (function (seq34239){
var G__34240 = cljs.core.first.call(null,seq34239);
var seq34239__$1 = cljs.core.next.call(null,seq34239);
return om_tools.dom.small.cljs$core$IFn$_invoke$arity$variadic(G__34240,seq34239__$1);
});

om_tools.dom.small.cljs$lang$maxFixedArity = (1);


om_tools.dom.source = (function om_tools$dom$source(var_args){
var args34243 = [];
var len__21576__auto___34802 = arguments.length;
var i__21577__auto___34803 = (0);
while(true){
if((i__21577__auto___34803 < len__21576__auto___34802)){
args34243.push((arguments[i__21577__auto___34803]));

var G__34804 = (i__21577__auto___34803 + (1));
i__21577__auto___34803 = G__34804;
continue;
} else {
}
break;
}

var G__34247 = args34243.length;
switch (G__34247) {
case 0:
return om_tools.dom.source.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34243.slice((1)),(0),null));
return om_tools.dom.source.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.source.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.source,null,null);
});

om_tools.dom.source.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.source,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.source.cljs$lang$applyTo = (function (seq34244){
var G__34245 = cljs.core.first.call(null,seq34244);
var seq34244__$1 = cljs.core.next.call(null,seq34244);
return om_tools.dom.source.cljs$core$IFn$_invoke$arity$variadic(G__34245,seq34244__$1);
});

om_tools.dom.source.cljs$lang$maxFixedArity = (1);


om_tools.dom.span = (function om_tools$dom$span(var_args){
var args34248 = [];
var len__21576__auto___34806 = arguments.length;
var i__21577__auto___34807 = (0);
while(true){
if((i__21577__auto___34807 < len__21576__auto___34806)){
args34248.push((arguments[i__21577__auto___34807]));

var G__34808 = (i__21577__auto___34807 + (1));
i__21577__auto___34807 = G__34808;
continue;
} else {
}
break;
}

var G__34252 = args34248.length;
switch (G__34252) {
case 0:
return om_tools.dom.span.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34248.slice((1)),(0),null));
return om_tools.dom.span.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.span.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.span,null,null);
});

om_tools.dom.span.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.span,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.span.cljs$lang$applyTo = (function (seq34249){
var G__34250 = cljs.core.first.call(null,seq34249);
var seq34249__$1 = cljs.core.next.call(null,seq34249);
return om_tools.dom.span.cljs$core$IFn$_invoke$arity$variadic(G__34250,seq34249__$1);
});

om_tools.dom.span.cljs$lang$maxFixedArity = (1);


om_tools.dom.strong = (function om_tools$dom$strong(var_args){
var args34253 = [];
var len__21576__auto___34810 = arguments.length;
var i__21577__auto___34811 = (0);
while(true){
if((i__21577__auto___34811 < len__21576__auto___34810)){
args34253.push((arguments[i__21577__auto___34811]));

var G__34812 = (i__21577__auto___34811 + (1));
i__21577__auto___34811 = G__34812;
continue;
} else {
}
break;
}

var G__34257 = args34253.length;
switch (G__34257) {
case 0:
return om_tools.dom.strong.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34253.slice((1)),(0),null));
return om_tools.dom.strong.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.strong.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.strong,null,null);
});

om_tools.dom.strong.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.strong,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.strong.cljs$lang$applyTo = (function (seq34254){
var G__34255 = cljs.core.first.call(null,seq34254);
var seq34254__$1 = cljs.core.next.call(null,seq34254);
return om_tools.dom.strong.cljs$core$IFn$_invoke$arity$variadic(G__34255,seq34254__$1);
});

om_tools.dom.strong.cljs$lang$maxFixedArity = (1);


om_tools.dom.style = (function om_tools$dom$style(var_args){
var args34258 = [];
var len__21576__auto___34814 = arguments.length;
var i__21577__auto___34815 = (0);
while(true){
if((i__21577__auto___34815 < len__21576__auto___34814)){
args34258.push((arguments[i__21577__auto___34815]));

var G__34816 = (i__21577__auto___34815 + (1));
i__21577__auto___34815 = G__34816;
continue;
} else {
}
break;
}

var G__34262 = args34258.length;
switch (G__34262) {
case 0:
return om_tools.dom.style.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34258.slice((1)),(0),null));
return om_tools.dom.style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.style.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.style,null,null);
});

om_tools.dom.style.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.style,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.style.cljs$lang$applyTo = (function (seq34259){
var G__34260 = cljs.core.first.call(null,seq34259);
var seq34259__$1 = cljs.core.next.call(null,seq34259);
return om_tools.dom.style.cljs$core$IFn$_invoke$arity$variadic(G__34260,seq34259__$1);
});

om_tools.dom.style.cljs$lang$maxFixedArity = (1);


om_tools.dom.sub = (function om_tools$dom$sub(var_args){
var args34263 = [];
var len__21576__auto___34818 = arguments.length;
var i__21577__auto___34819 = (0);
while(true){
if((i__21577__auto___34819 < len__21576__auto___34818)){
args34263.push((arguments[i__21577__auto___34819]));

var G__34820 = (i__21577__auto___34819 + (1));
i__21577__auto___34819 = G__34820;
continue;
} else {
}
break;
}

var G__34267 = args34263.length;
switch (G__34267) {
case 0:
return om_tools.dom.sub.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34263.slice((1)),(0),null));
return om_tools.dom.sub.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.sub.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.sub,null,null);
});

om_tools.dom.sub.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.sub,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.sub.cljs$lang$applyTo = (function (seq34264){
var G__34265 = cljs.core.first.call(null,seq34264);
var seq34264__$1 = cljs.core.next.call(null,seq34264);
return om_tools.dom.sub.cljs$core$IFn$_invoke$arity$variadic(G__34265,seq34264__$1);
});

om_tools.dom.sub.cljs$lang$maxFixedArity = (1);


om_tools.dom.summary = (function om_tools$dom$summary(var_args){
var args34268 = [];
var len__21576__auto___34822 = arguments.length;
var i__21577__auto___34823 = (0);
while(true){
if((i__21577__auto___34823 < len__21576__auto___34822)){
args34268.push((arguments[i__21577__auto___34823]));

var G__34824 = (i__21577__auto___34823 + (1));
i__21577__auto___34823 = G__34824;
continue;
} else {
}
break;
}

var G__34272 = args34268.length;
switch (G__34272) {
case 0:
return om_tools.dom.summary.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34268.slice((1)),(0),null));
return om_tools.dom.summary.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.summary.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.summary,null,null);
});

om_tools.dom.summary.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.summary,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.summary.cljs$lang$applyTo = (function (seq34269){
var G__34270 = cljs.core.first.call(null,seq34269);
var seq34269__$1 = cljs.core.next.call(null,seq34269);
return om_tools.dom.summary.cljs$core$IFn$_invoke$arity$variadic(G__34270,seq34269__$1);
});

om_tools.dom.summary.cljs$lang$maxFixedArity = (1);


om_tools.dom.sup = (function om_tools$dom$sup(var_args){
var args34273 = [];
var len__21576__auto___34826 = arguments.length;
var i__21577__auto___34827 = (0);
while(true){
if((i__21577__auto___34827 < len__21576__auto___34826)){
args34273.push((arguments[i__21577__auto___34827]));

var G__34828 = (i__21577__auto___34827 + (1));
i__21577__auto___34827 = G__34828;
continue;
} else {
}
break;
}

var G__34277 = args34273.length;
switch (G__34277) {
case 0:
return om_tools.dom.sup.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34273.slice((1)),(0),null));
return om_tools.dom.sup.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.sup.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.sup,null,null);
});

om_tools.dom.sup.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.sup,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.sup.cljs$lang$applyTo = (function (seq34274){
var G__34275 = cljs.core.first.call(null,seq34274);
var seq34274__$1 = cljs.core.next.call(null,seq34274);
return om_tools.dom.sup.cljs$core$IFn$_invoke$arity$variadic(G__34275,seq34274__$1);
});

om_tools.dom.sup.cljs$lang$maxFixedArity = (1);


om_tools.dom.table = (function om_tools$dom$table(var_args){
var args34278 = [];
var len__21576__auto___34830 = arguments.length;
var i__21577__auto___34831 = (0);
while(true){
if((i__21577__auto___34831 < len__21576__auto___34830)){
args34278.push((arguments[i__21577__auto___34831]));

var G__34832 = (i__21577__auto___34831 + (1));
i__21577__auto___34831 = G__34832;
continue;
} else {
}
break;
}

var G__34282 = args34278.length;
switch (G__34282) {
case 0:
return om_tools.dom.table.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34278.slice((1)),(0),null));
return om_tools.dom.table.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.table.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.table,null,null);
});

om_tools.dom.table.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.table,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.table.cljs$lang$applyTo = (function (seq34279){
var G__34280 = cljs.core.first.call(null,seq34279);
var seq34279__$1 = cljs.core.next.call(null,seq34279);
return om_tools.dom.table.cljs$core$IFn$_invoke$arity$variadic(G__34280,seq34279__$1);
});

om_tools.dom.table.cljs$lang$maxFixedArity = (1);


om_tools.dom.tbody = (function om_tools$dom$tbody(var_args){
var args34283 = [];
var len__21576__auto___34834 = arguments.length;
var i__21577__auto___34835 = (0);
while(true){
if((i__21577__auto___34835 < len__21576__auto___34834)){
args34283.push((arguments[i__21577__auto___34835]));

var G__34836 = (i__21577__auto___34835 + (1));
i__21577__auto___34835 = G__34836;
continue;
} else {
}
break;
}

var G__34287 = args34283.length;
switch (G__34287) {
case 0:
return om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34283.slice((1)),(0),null));
return om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tbody,null,null);
});

om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.tbody,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.tbody.cljs$lang$applyTo = (function (seq34284){
var G__34285 = cljs.core.first.call(null,seq34284);
var seq34284__$1 = cljs.core.next.call(null,seq34284);
return om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$variadic(G__34285,seq34284__$1);
});

om_tools.dom.tbody.cljs$lang$maxFixedArity = (1);


om_tools.dom.td = (function om_tools$dom$td(var_args){
var args34288 = [];
var len__21576__auto___34838 = arguments.length;
var i__21577__auto___34839 = (0);
while(true){
if((i__21577__auto___34839 < len__21576__auto___34838)){
args34288.push((arguments[i__21577__auto___34839]));

var G__34840 = (i__21577__auto___34839 + (1));
i__21577__auto___34839 = G__34840;
continue;
} else {
}
break;
}

var G__34292 = args34288.length;
switch (G__34292) {
case 0:
return om_tools.dom.td.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34288.slice((1)),(0),null));
return om_tools.dom.td.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.td.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.td,null,null);
});

om_tools.dom.td.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.td,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.td.cljs$lang$applyTo = (function (seq34289){
var G__34290 = cljs.core.first.call(null,seq34289);
var seq34289__$1 = cljs.core.next.call(null,seq34289);
return om_tools.dom.td.cljs$core$IFn$_invoke$arity$variadic(G__34290,seq34289__$1);
});

om_tools.dom.td.cljs$lang$maxFixedArity = (1);


om_tools.dom.tfoot = (function om_tools$dom$tfoot(var_args){
var args34293 = [];
var len__21576__auto___34842 = arguments.length;
var i__21577__auto___34843 = (0);
while(true){
if((i__21577__auto___34843 < len__21576__auto___34842)){
args34293.push((arguments[i__21577__auto___34843]));

var G__34844 = (i__21577__auto___34843 + (1));
i__21577__auto___34843 = G__34844;
continue;
} else {
}
break;
}

var G__34297 = args34293.length;
switch (G__34297) {
case 0:
return om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34293.slice((1)),(0),null));
return om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tfoot,null,null);
});

om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.tfoot,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.tfoot.cljs$lang$applyTo = (function (seq34294){
var G__34295 = cljs.core.first.call(null,seq34294);
var seq34294__$1 = cljs.core.next.call(null,seq34294);
return om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic(G__34295,seq34294__$1);
});

om_tools.dom.tfoot.cljs$lang$maxFixedArity = (1);


om_tools.dom.th = (function om_tools$dom$th(var_args){
var args34298 = [];
var len__21576__auto___34846 = arguments.length;
var i__21577__auto___34847 = (0);
while(true){
if((i__21577__auto___34847 < len__21576__auto___34846)){
args34298.push((arguments[i__21577__auto___34847]));

var G__34848 = (i__21577__auto___34847 + (1));
i__21577__auto___34847 = G__34848;
continue;
} else {
}
break;
}

var G__34302 = args34298.length;
switch (G__34302) {
case 0:
return om_tools.dom.th.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34298.slice((1)),(0),null));
return om_tools.dom.th.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.th.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.th,null,null);
});

om_tools.dom.th.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.th,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.th.cljs$lang$applyTo = (function (seq34299){
var G__34300 = cljs.core.first.call(null,seq34299);
var seq34299__$1 = cljs.core.next.call(null,seq34299);
return om_tools.dom.th.cljs$core$IFn$_invoke$arity$variadic(G__34300,seq34299__$1);
});

om_tools.dom.th.cljs$lang$maxFixedArity = (1);


om_tools.dom.thead = (function om_tools$dom$thead(var_args){
var args34303 = [];
var len__21576__auto___34850 = arguments.length;
var i__21577__auto___34851 = (0);
while(true){
if((i__21577__auto___34851 < len__21576__auto___34850)){
args34303.push((arguments[i__21577__auto___34851]));

var G__34852 = (i__21577__auto___34851 + (1));
i__21577__auto___34851 = G__34852;
continue;
} else {
}
break;
}

var G__34307 = args34303.length;
switch (G__34307) {
case 0:
return om_tools.dom.thead.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34303.slice((1)),(0),null));
return om_tools.dom.thead.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.thead.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.thead,null,null);
});

om_tools.dom.thead.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.thead,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.thead.cljs$lang$applyTo = (function (seq34304){
var G__34305 = cljs.core.first.call(null,seq34304);
var seq34304__$1 = cljs.core.next.call(null,seq34304);
return om_tools.dom.thead.cljs$core$IFn$_invoke$arity$variadic(G__34305,seq34304__$1);
});

om_tools.dom.thead.cljs$lang$maxFixedArity = (1);


om_tools.dom.time = (function om_tools$dom$time(var_args){
var args34308 = [];
var len__21576__auto___34854 = arguments.length;
var i__21577__auto___34855 = (0);
while(true){
if((i__21577__auto___34855 < len__21576__auto___34854)){
args34308.push((arguments[i__21577__auto___34855]));

var G__34856 = (i__21577__auto___34855 + (1));
i__21577__auto___34855 = G__34856;
continue;
} else {
}
break;
}

var G__34312 = args34308.length;
switch (G__34312) {
case 0:
return om_tools.dom.time.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34308.slice((1)),(0),null));
return om_tools.dom.time.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.time.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.time,null,null);
});

om_tools.dom.time.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.time,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.time.cljs$lang$applyTo = (function (seq34309){
var G__34310 = cljs.core.first.call(null,seq34309);
var seq34309__$1 = cljs.core.next.call(null,seq34309);
return om_tools.dom.time.cljs$core$IFn$_invoke$arity$variadic(G__34310,seq34309__$1);
});

om_tools.dom.time.cljs$lang$maxFixedArity = (1);


om_tools.dom.title = (function om_tools$dom$title(var_args){
var args34313 = [];
var len__21576__auto___34858 = arguments.length;
var i__21577__auto___34859 = (0);
while(true){
if((i__21577__auto___34859 < len__21576__auto___34858)){
args34313.push((arguments[i__21577__auto___34859]));

var G__34860 = (i__21577__auto___34859 + (1));
i__21577__auto___34859 = G__34860;
continue;
} else {
}
break;
}

var G__34317 = args34313.length;
switch (G__34317) {
case 0:
return om_tools.dom.title.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34313.slice((1)),(0),null));
return om_tools.dom.title.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.title.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.title,null,null);
});

om_tools.dom.title.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.title,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.title.cljs$lang$applyTo = (function (seq34314){
var G__34315 = cljs.core.first.call(null,seq34314);
var seq34314__$1 = cljs.core.next.call(null,seq34314);
return om_tools.dom.title.cljs$core$IFn$_invoke$arity$variadic(G__34315,seq34314__$1);
});

om_tools.dom.title.cljs$lang$maxFixedArity = (1);


om_tools.dom.tr = (function om_tools$dom$tr(var_args){
var args34318 = [];
var len__21576__auto___34862 = arguments.length;
var i__21577__auto___34863 = (0);
while(true){
if((i__21577__auto___34863 < len__21576__auto___34862)){
args34318.push((arguments[i__21577__auto___34863]));

var G__34864 = (i__21577__auto___34863 + (1));
i__21577__auto___34863 = G__34864;
continue;
} else {
}
break;
}

var G__34322 = args34318.length;
switch (G__34322) {
case 0:
return om_tools.dom.tr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34318.slice((1)),(0),null));
return om_tools.dom.tr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.tr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tr,null,null);
});

om_tools.dom.tr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.tr,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.tr.cljs$lang$applyTo = (function (seq34319){
var G__34320 = cljs.core.first.call(null,seq34319);
var seq34319__$1 = cljs.core.next.call(null,seq34319);
return om_tools.dom.tr.cljs$core$IFn$_invoke$arity$variadic(G__34320,seq34319__$1);
});

om_tools.dom.tr.cljs$lang$maxFixedArity = (1);


om_tools.dom.track = (function om_tools$dom$track(var_args){
var args34323 = [];
var len__21576__auto___34866 = arguments.length;
var i__21577__auto___34867 = (0);
while(true){
if((i__21577__auto___34867 < len__21576__auto___34866)){
args34323.push((arguments[i__21577__auto___34867]));

var G__34868 = (i__21577__auto___34867 + (1));
i__21577__auto___34867 = G__34868;
continue;
} else {
}
break;
}

var G__34327 = args34323.length;
switch (G__34327) {
case 0:
return om_tools.dom.track.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34323.slice((1)),(0),null));
return om_tools.dom.track.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.track.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.track,null,null);
});

om_tools.dom.track.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.track,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.track.cljs$lang$applyTo = (function (seq34324){
var G__34325 = cljs.core.first.call(null,seq34324);
var seq34324__$1 = cljs.core.next.call(null,seq34324);
return om_tools.dom.track.cljs$core$IFn$_invoke$arity$variadic(G__34325,seq34324__$1);
});

om_tools.dom.track.cljs$lang$maxFixedArity = (1);


om_tools.dom.u = (function om_tools$dom$u(var_args){
var args34328 = [];
var len__21576__auto___34870 = arguments.length;
var i__21577__auto___34871 = (0);
while(true){
if((i__21577__auto___34871 < len__21576__auto___34870)){
args34328.push((arguments[i__21577__auto___34871]));

var G__34872 = (i__21577__auto___34871 + (1));
i__21577__auto___34871 = G__34872;
continue;
} else {
}
break;
}

var G__34332 = args34328.length;
switch (G__34332) {
case 0:
return om_tools.dom.u.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34328.slice((1)),(0),null));
return om_tools.dom.u.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.u.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.u,null,null);
});

om_tools.dom.u.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.u,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.u.cljs$lang$applyTo = (function (seq34329){
var G__34330 = cljs.core.first.call(null,seq34329);
var seq34329__$1 = cljs.core.next.call(null,seq34329);
return om_tools.dom.u.cljs$core$IFn$_invoke$arity$variadic(G__34330,seq34329__$1);
});

om_tools.dom.u.cljs$lang$maxFixedArity = (1);


om_tools.dom.ul = (function om_tools$dom$ul(var_args){
var args34333 = [];
var len__21576__auto___34874 = arguments.length;
var i__21577__auto___34875 = (0);
while(true){
if((i__21577__auto___34875 < len__21576__auto___34874)){
args34333.push((arguments[i__21577__auto___34875]));

var G__34876 = (i__21577__auto___34875 + (1));
i__21577__auto___34875 = G__34876;
continue;
} else {
}
break;
}

var G__34337 = args34333.length;
switch (G__34337) {
case 0:
return om_tools.dom.ul.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34333.slice((1)),(0),null));
return om_tools.dom.ul.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.ul.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ul,null,null);
});

om_tools.dom.ul.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.ul,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.ul.cljs$lang$applyTo = (function (seq34334){
var G__34335 = cljs.core.first.call(null,seq34334);
var seq34334__$1 = cljs.core.next.call(null,seq34334);
return om_tools.dom.ul.cljs$core$IFn$_invoke$arity$variadic(G__34335,seq34334__$1);
});

om_tools.dom.ul.cljs$lang$maxFixedArity = (1);


om_tools.dom.var$ = (function om_tools$dom$var(var_args){
var args34338 = [];
var len__21576__auto___34878 = arguments.length;
var i__21577__auto___34879 = (0);
while(true){
if((i__21577__auto___34879 < len__21576__auto___34878)){
args34338.push((arguments[i__21577__auto___34879]));

var G__34880 = (i__21577__auto___34879 + (1));
i__21577__auto___34879 = G__34880;
continue;
} else {
}
break;
}

var G__34342 = args34338.length;
switch (G__34342) {
case 0:
return om_tools.dom.var$.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34338.slice((1)),(0),null));
return om_tools.dom.var$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.var$.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.var$,null,null);
});

om_tools.dom.var$.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.var$,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.var$.cljs$lang$applyTo = (function (seq34339){
var G__34340 = cljs.core.first.call(null,seq34339);
var seq34339__$1 = cljs.core.next.call(null,seq34339);
return om_tools.dom.var$.cljs$core$IFn$_invoke$arity$variadic(G__34340,seq34339__$1);
});

om_tools.dom.var$.cljs$lang$maxFixedArity = (1);


om_tools.dom.video = (function om_tools$dom$video(var_args){
var args34343 = [];
var len__21576__auto___34882 = arguments.length;
var i__21577__auto___34883 = (0);
while(true){
if((i__21577__auto___34883 < len__21576__auto___34882)){
args34343.push((arguments[i__21577__auto___34883]));

var G__34884 = (i__21577__auto___34883 + (1));
i__21577__auto___34883 = G__34884;
continue;
} else {
}
break;
}

var G__34347 = args34343.length;
switch (G__34347) {
case 0:
return om_tools.dom.video.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34343.slice((1)),(0),null));
return om_tools.dom.video.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.video.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.video,null,null);
});

om_tools.dom.video.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.video,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.video.cljs$lang$applyTo = (function (seq34344){
var G__34345 = cljs.core.first.call(null,seq34344);
var seq34344__$1 = cljs.core.next.call(null,seq34344);
return om_tools.dom.video.cljs$core$IFn$_invoke$arity$variadic(G__34345,seq34344__$1);
});

om_tools.dom.video.cljs$lang$maxFixedArity = (1);


om_tools.dom.wbr = (function om_tools$dom$wbr(var_args){
var args34348 = [];
var len__21576__auto___34886 = arguments.length;
var i__21577__auto___34887 = (0);
while(true){
if((i__21577__auto___34887 < len__21576__auto___34886)){
args34348.push((arguments[i__21577__auto___34887]));

var G__34888 = (i__21577__auto___34887 + (1));
i__21577__auto___34887 = G__34888;
continue;
} else {
}
break;
}

var G__34352 = args34348.length;
switch (G__34352) {
case 0:
return om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34348.slice((1)),(0),null));
return om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.wbr,null,null);
});

om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.wbr,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.wbr.cljs$lang$applyTo = (function (seq34349){
var G__34350 = cljs.core.first.call(null,seq34349);
var seq34349__$1 = cljs.core.next.call(null,seq34349);
return om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$variadic(G__34350,seq34349__$1);
});

om_tools.dom.wbr.cljs$lang$maxFixedArity = (1);


om_tools.dom.circle = (function om_tools$dom$circle(var_args){
var args34353 = [];
var len__21576__auto___34890 = arguments.length;
var i__21577__auto___34891 = (0);
while(true){
if((i__21577__auto___34891 < len__21576__auto___34890)){
args34353.push((arguments[i__21577__auto___34891]));

var G__34892 = (i__21577__auto___34891 + (1));
i__21577__auto___34891 = G__34892;
continue;
} else {
}
break;
}

var G__34357 = args34353.length;
switch (G__34357) {
case 0:
return om_tools.dom.circle.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34353.slice((1)),(0),null));
return om_tools.dom.circle.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.circle.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.circle,null,null);
});

om_tools.dom.circle.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.circle,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.circle.cljs$lang$applyTo = (function (seq34354){
var G__34355 = cljs.core.first.call(null,seq34354);
var seq34354__$1 = cljs.core.next.call(null,seq34354);
return om_tools.dom.circle.cljs$core$IFn$_invoke$arity$variadic(G__34355,seq34354__$1);
});

om_tools.dom.circle.cljs$lang$maxFixedArity = (1);


om_tools.dom.clipPath = (function om_tools$dom$clipPath(var_args){
var args34358 = [];
var len__21576__auto___34894 = arguments.length;
var i__21577__auto___34895 = (0);
while(true){
if((i__21577__auto___34895 < len__21576__auto___34894)){
args34358.push((arguments[i__21577__auto___34895]));

var G__34896 = (i__21577__auto___34895 + (1));
i__21577__auto___34895 = G__34896;
continue;
} else {
}
break;
}

var G__34362 = args34358.length;
switch (G__34362) {
case 0:
return om_tools.dom.clipPath.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34358.slice((1)),(0),null));
return om_tools.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.clipPath.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.clipPath,null,null);
});

om_tools.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.clipPath,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.clipPath.cljs$lang$applyTo = (function (seq34359){
var G__34360 = cljs.core.first.call(null,seq34359);
var seq34359__$1 = cljs.core.next.call(null,seq34359);
return om_tools.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic(G__34360,seq34359__$1);
});

om_tools.dom.clipPath.cljs$lang$maxFixedArity = (1);


om_tools.dom.ellipse = (function om_tools$dom$ellipse(var_args){
var args34363 = [];
var len__21576__auto___34898 = arguments.length;
var i__21577__auto___34899 = (0);
while(true){
if((i__21577__auto___34899 < len__21576__auto___34898)){
args34363.push((arguments[i__21577__auto___34899]));

var G__34900 = (i__21577__auto___34899 + (1));
i__21577__auto___34899 = G__34900;
continue;
} else {
}
break;
}

var G__34367 = args34363.length;
switch (G__34367) {
case 0:
return om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34363.slice((1)),(0),null));
return om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ellipse,null,null);
});

om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.ellipse,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.ellipse.cljs$lang$applyTo = (function (seq34364){
var G__34365 = cljs.core.first.call(null,seq34364);
var seq34364__$1 = cljs.core.next.call(null,seq34364);
return om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic(G__34365,seq34364__$1);
});

om_tools.dom.ellipse.cljs$lang$maxFixedArity = (1);


om_tools.dom.g = (function om_tools$dom$g(var_args){
var args34368 = [];
var len__21576__auto___34902 = arguments.length;
var i__21577__auto___34903 = (0);
while(true){
if((i__21577__auto___34903 < len__21576__auto___34902)){
args34368.push((arguments[i__21577__auto___34903]));

var G__34904 = (i__21577__auto___34903 + (1));
i__21577__auto___34903 = G__34904;
continue;
} else {
}
break;
}

var G__34372 = args34368.length;
switch (G__34372) {
case 0:
return om_tools.dom.g.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34368.slice((1)),(0),null));
return om_tools.dom.g.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.g.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.g,null,null);
});

om_tools.dom.g.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.g,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.g.cljs$lang$applyTo = (function (seq34369){
var G__34370 = cljs.core.first.call(null,seq34369);
var seq34369__$1 = cljs.core.next.call(null,seq34369);
return om_tools.dom.g.cljs$core$IFn$_invoke$arity$variadic(G__34370,seq34369__$1);
});

om_tools.dom.g.cljs$lang$maxFixedArity = (1);


om_tools.dom.line = (function om_tools$dom$line(var_args){
var args34373 = [];
var len__21576__auto___34906 = arguments.length;
var i__21577__auto___34907 = (0);
while(true){
if((i__21577__auto___34907 < len__21576__auto___34906)){
args34373.push((arguments[i__21577__auto___34907]));

var G__34908 = (i__21577__auto___34907 + (1));
i__21577__auto___34907 = G__34908;
continue;
} else {
}
break;
}

var G__34377 = args34373.length;
switch (G__34377) {
case 0:
return om_tools.dom.line.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34373.slice((1)),(0),null));
return om_tools.dom.line.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.line.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.line,null,null);
});

om_tools.dom.line.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.line,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.line.cljs$lang$applyTo = (function (seq34374){
var G__34375 = cljs.core.first.call(null,seq34374);
var seq34374__$1 = cljs.core.next.call(null,seq34374);
return om_tools.dom.line.cljs$core$IFn$_invoke$arity$variadic(G__34375,seq34374__$1);
});

om_tools.dom.line.cljs$lang$maxFixedArity = (1);


om_tools.dom.mask = (function om_tools$dom$mask(var_args){
var args34378 = [];
var len__21576__auto___34910 = arguments.length;
var i__21577__auto___34911 = (0);
while(true){
if((i__21577__auto___34911 < len__21576__auto___34910)){
args34378.push((arguments[i__21577__auto___34911]));

var G__34912 = (i__21577__auto___34911 + (1));
i__21577__auto___34911 = G__34912;
continue;
} else {
}
break;
}

var G__34382 = args34378.length;
switch (G__34382) {
case 0:
return om_tools.dom.mask.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34378.slice((1)),(0),null));
return om_tools.dom.mask.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.mask.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.mask,null,null);
});

om_tools.dom.mask.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.mask,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.mask.cljs$lang$applyTo = (function (seq34379){
var G__34380 = cljs.core.first.call(null,seq34379);
var seq34379__$1 = cljs.core.next.call(null,seq34379);
return om_tools.dom.mask.cljs$core$IFn$_invoke$arity$variadic(G__34380,seq34379__$1);
});

om_tools.dom.mask.cljs$lang$maxFixedArity = (1);


om_tools.dom.path = (function om_tools$dom$path(var_args){
var args34383 = [];
var len__21576__auto___34914 = arguments.length;
var i__21577__auto___34915 = (0);
while(true){
if((i__21577__auto___34915 < len__21576__auto___34914)){
args34383.push((arguments[i__21577__auto___34915]));

var G__34916 = (i__21577__auto___34915 + (1));
i__21577__auto___34915 = G__34916;
continue;
} else {
}
break;
}

var G__34387 = args34383.length;
switch (G__34387) {
case 0:
return om_tools.dom.path.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34383.slice((1)),(0),null));
return om_tools.dom.path.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.path.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.path,null,null);
});

om_tools.dom.path.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.path,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.path.cljs$lang$applyTo = (function (seq34384){
var G__34385 = cljs.core.first.call(null,seq34384);
var seq34384__$1 = cljs.core.next.call(null,seq34384);
return om_tools.dom.path.cljs$core$IFn$_invoke$arity$variadic(G__34385,seq34384__$1);
});

om_tools.dom.path.cljs$lang$maxFixedArity = (1);


om_tools.dom.pattern = (function om_tools$dom$pattern(var_args){
var args34388 = [];
var len__21576__auto___34918 = arguments.length;
var i__21577__auto___34919 = (0);
while(true){
if((i__21577__auto___34919 < len__21576__auto___34918)){
args34388.push((arguments[i__21577__auto___34919]));

var G__34920 = (i__21577__auto___34919 + (1));
i__21577__auto___34919 = G__34920;
continue;
} else {
}
break;
}

var G__34392 = args34388.length;
switch (G__34392) {
case 0:
return om_tools.dom.pattern.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34388.slice((1)),(0),null));
return om_tools.dom.pattern.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.pattern.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.pattern,null,null);
});

om_tools.dom.pattern.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.pattern,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.pattern.cljs$lang$applyTo = (function (seq34389){
var G__34390 = cljs.core.first.call(null,seq34389);
var seq34389__$1 = cljs.core.next.call(null,seq34389);
return om_tools.dom.pattern.cljs$core$IFn$_invoke$arity$variadic(G__34390,seq34389__$1);
});

om_tools.dom.pattern.cljs$lang$maxFixedArity = (1);


om_tools.dom.polyline = (function om_tools$dom$polyline(var_args){
var args34393 = [];
var len__21576__auto___34922 = arguments.length;
var i__21577__auto___34923 = (0);
while(true){
if((i__21577__auto___34923 < len__21576__auto___34922)){
args34393.push((arguments[i__21577__auto___34923]));

var G__34924 = (i__21577__auto___34923 + (1));
i__21577__auto___34923 = G__34924;
continue;
} else {
}
break;
}

var G__34397 = args34393.length;
switch (G__34397) {
case 0:
return om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34393.slice((1)),(0),null));
return om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.polyline,null,null);
});

om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.polyline,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.polyline.cljs$lang$applyTo = (function (seq34394){
var G__34395 = cljs.core.first.call(null,seq34394);
var seq34394__$1 = cljs.core.next.call(null,seq34394);
return om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$variadic(G__34395,seq34394__$1);
});

om_tools.dom.polyline.cljs$lang$maxFixedArity = (1);


om_tools.dom.rect = (function om_tools$dom$rect(var_args){
var args34398 = [];
var len__21576__auto___34926 = arguments.length;
var i__21577__auto___34927 = (0);
while(true){
if((i__21577__auto___34927 < len__21576__auto___34926)){
args34398.push((arguments[i__21577__auto___34927]));

var G__34928 = (i__21577__auto___34927 + (1));
i__21577__auto___34927 = G__34928;
continue;
} else {
}
break;
}

var G__34402 = args34398.length;
switch (G__34402) {
case 0:
return om_tools.dom.rect.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34398.slice((1)),(0),null));
return om_tools.dom.rect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.rect.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.rect,null,null);
});

om_tools.dom.rect.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.rect,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.rect.cljs$lang$applyTo = (function (seq34399){
var G__34400 = cljs.core.first.call(null,seq34399);
var seq34399__$1 = cljs.core.next.call(null,seq34399);
return om_tools.dom.rect.cljs$core$IFn$_invoke$arity$variadic(G__34400,seq34399__$1);
});

om_tools.dom.rect.cljs$lang$maxFixedArity = (1);


om_tools.dom.svg = (function om_tools$dom$svg(var_args){
var args34403 = [];
var len__21576__auto___34930 = arguments.length;
var i__21577__auto___34931 = (0);
while(true){
if((i__21577__auto___34931 < len__21576__auto___34930)){
args34403.push((arguments[i__21577__auto___34931]));

var G__34932 = (i__21577__auto___34931 + (1));
i__21577__auto___34931 = G__34932;
continue;
} else {
}
break;
}

var G__34407 = args34403.length;
switch (G__34407) {
case 0:
return om_tools.dom.svg.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34403.slice((1)),(0),null));
return om_tools.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.svg.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.svg,null,null);
});

om_tools.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.svg,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.svg.cljs$lang$applyTo = (function (seq34404){
var G__34405 = cljs.core.first.call(null,seq34404);
var seq34404__$1 = cljs.core.next.call(null,seq34404);
return om_tools.dom.svg.cljs$core$IFn$_invoke$arity$variadic(G__34405,seq34404__$1);
});

om_tools.dom.svg.cljs$lang$maxFixedArity = (1);


om_tools.dom.text = (function om_tools$dom$text(var_args){
var args34408 = [];
var len__21576__auto___34934 = arguments.length;
var i__21577__auto___34935 = (0);
while(true){
if((i__21577__auto___34935 < len__21576__auto___34934)){
args34408.push((arguments[i__21577__auto___34935]));

var G__34936 = (i__21577__auto___34935 + (1));
i__21577__auto___34935 = G__34936;
continue;
} else {
}
break;
}

var G__34412 = args34408.length;
switch (G__34412) {
case 0:
return om_tools.dom.text.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34408.slice((1)),(0),null));
return om_tools.dom.text.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.text.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.text,null,null);
});

om_tools.dom.text.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.text,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.text.cljs$lang$applyTo = (function (seq34409){
var G__34410 = cljs.core.first.call(null,seq34409);
var seq34409__$1 = cljs.core.next.call(null,seq34409);
return om_tools.dom.text.cljs$core$IFn$_invoke$arity$variadic(G__34410,seq34409__$1);
});

om_tools.dom.text.cljs$lang$maxFixedArity = (1);


om_tools.dom.defs = (function om_tools$dom$defs(var_args){
var args34413 = [];
var len__21576__auto___34938 = arguments.length;
var i__21577__auto___34939 = (0);
while(true){
if((i__21577__auto___34939 < len__21576__auto___34938)){
args34413.push((arguments[i__21577__auto___34939]));

var G__34940 = (i__21577__auto___34939 + (1));
i__21577__auto___34939 = G__34940;
continue;
} else {
}
break;
}

var G__34417 = args34413.length;
switch (G__34417) {
case 0:
return om_tools.dom.defs.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34413.slice((1)),(0),null));
return om_tools.dom.defs.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.defs.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.defs,null,null);
});

om_tools.dom.defs.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.defs,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.defs.cljs$lang$applyTo = (function (seq34414){
var G__34415 = cljs.core.first.call(null,seq34414);
var seq34414__$1 = cljs.core.next.call(null,seq34414);
return om_tools.dom.defs.cljs$core$IFn$_invoke$arity$variadic(G__34415,seq34414__$1);
});

om_tools.dom.defs.cljs$lang$maxFixedArity = (1);


om_tools.dom.linearGradient = (function om_tools$dom$linearGradient(var_args){
var args34418 = [];
var len__21576__auto___34942 = arguments.length;
var i__21577__auto___34943 = (0);
while(true){
if((i__21577__auto___34943 < len__21576__auto___34942)){
args34418.push((arguments[i__21577__auto___34943]));

var G__34944 = (i__21577__auto___34943 + (1));
i__21577__auto___34943 = G__34944;
continue;
} else {
}
break;
}

var G__34422 = args34418.length;
switch (G__34422) {
case 0:
return om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34418.slice((1)),(0),null));
return om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.linearGradient,null,null);
});

om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.linearGradient,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.linearGradient.cljs$lang$applyTo = (function (seq34419){
var G__34420 = cljs.core.first.call(null,seq34419);
var seq34419__$1 = cljs.core.next.call(null,seq34419);
return om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic(G__34420,seq34419__$1);
});

om_tools.dom.linearGradient.cljs$lang$maxFixedArity = (1);


om_tools.dom.polygon = (function om_tools$dom$polygon(var_args){
var args34423 = [];
var len__21576__auto___34946 = arguments.length;
var i__21577__auto___34947 = (0);
while(true){
if((i__21577__auto___34947 < len__21576__auto___34946)){
args34423.push((arguments[i__21577__auto___34947]));

var G__34948 = (i__21577__auto___34947 + (1));
i__21577__auto___34947 = G__34948;
continue;
} else {
}
break;
}

var G__34427 = args34423.length;
switch (G__34427) {
case 0:
return om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34423.slice((1)),(0),null));
return om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.polygon,null,null);
});

om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.polygon,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.polygon.cljs$lang$applyTo = (function (seq34424){
var G__34425 = cljs.core.first.call(null,seq34424);
var seq34424__$1 = cljs.core.next.call(null,seq34424);
return om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$variadic(G__34425,seq34424__$1);
});

om_tools.dom.polygon.cljs$lang$maxFixedArity = (1);


om_tools.dom.radialGradient = (function om_tools$dom$radialGradient(var_args){
var args34428 = [];
var len__21576__auto___34950 = arguments.length;
var i__21577__auto___34951 = (0);
while(true){
if((i__21577__auto___34951 < len__21576__auto___34950)){
args34428.push((arguments[i__21577__auto___34951]));

var G__34952 = (i__21577__auto___34951 + (1));
i__21577__auto___34951 = G__34952;
continue;
} else {
}
break;
}

var G__34432 = args34428.length;
switch (G__34432) {
case 0:
return om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34428.slice((1)),(0),null));
return om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.radialGradient,null,null);
});

om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.radialGradient,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.radialGradient.cljs$lang$applyTo = (function (seq34429){
var G__34430 = cljs.core.first.call(null,seq34429);
var seq34429__$1 = cljs.core.next.call(null,seq34429);
return om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic(G__34430,seq34429__$1);
});

om_tools.dom.radialGradient.cljs$lang$maxFixedArity = (1);


om_tools.dom.stop = (function om_tools$dom$stop(var_args){
var args34433 = [];
var len__21576__auto___34954 = arguments.length;
var i__21577__auto___34955 = (0);
while(true){
if((i__21577__auto___34955 < len__21576__auto___34954)){
args34433.push((arguments[i__21577__auto___34955]));

var G__34956 = (i__21577__auto___34955 + (1));
i__21577__auto___34955 = G__34956;
continue;
} else {
}
break;
}

var G__34437 = args34433.length;
switch (G__34437) {
case 0:
return om_tools.dom.stop.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34433.slice((1)),(0),null));
return om_tools.dom.stop.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.stop.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.stop,null,null);
});

om_tools.dom.stop.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.stop,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.stop.cljs$lang$applyTo = (function (seq34434){
var G__34435 = cljs.core.first.call(null,seq34434);
var seq34434__$1 = cljs.core.next.call(null,seq34434);
return om_tools.dom.stop.cljs$core$IFn$_invoke$arity$variadic(G__34435,seq34434__$1);
});

om_tools.dom.stop.cljs$lang$maxFixedArity = (1);


om_tools.dom.tspan = (function om_tools$dom$tspan(var_args){
var args34438 = [];
var len__21576__auto___34958 = arguments.length;
var i__21577__auto___34959 = (0);
while(true){
if((i__21577__auto___34959 < len__21576__auto___34958)){
args34438.push((arguments[i__21577__auto___34959]));

var G__34960 = (i__21577__auto___34959 + (1));
i__21577__auto___34959 = G__34960;
continue;
} else {
}
break;
}

var G__34442 = args34438.length;
switch (G__34442) {
case 0:
return om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34438.slice((1)),(0),null));
return om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tspan,null,null);
});

om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.tspan,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.tspan.cljs$lang$applyTo = (function (seq34439){
var G__34440 = cljs.core.first.call(null,seq34439);
var seq34439__$1 = cljs.core.next.call(null,seq34439);
return om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$variadic(G__34440,seq34439__$1);
});

om_tools.dom.tspan.cljs$lang$maxFixedArity = (1);


om_tools.dom.use = (function om_tools$dom$use(var_args){
var args34443 = [];
var len__21576__auto___34962 = arguments.length;
var i__21577__auto___34963 = (0);
while(true){
if((i__21577__auto___34963 < len__21576__auto___34962)){
args34443.push((arguments[i__21577__auto___34963]));

var G__34964 = (i__21577__auto___34963 + (1));
i__21577__auto___34963 = G__34964;
continue;
} else {
}
break;
}

var G__34447 = args34443.length;
switch (G__34447) {
case 0:
return om_tools.dom.use.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34443.slice((1)),(0),null));
return om_tools.dom.use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.use.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.use,null,null);
});

om_tools.dom.use.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,React.DOM.use,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.use.cljs$lang$applyTo = (function (seq34444){
var G__34445 = cljs.core.first.call(null,seq34444);
var seq34444__$1 = cljs.core.next.call(null,seq34444);
return om_tools.dom.use.cljs$core$IFn$_invoke$arity$variadic(G__34445,seq34444__$1);
});

om_tools.dom.use.cljs$lang$maxFixedArity = (1);


om_tools.dom.input = (function om_tools$dom$input(var_args){
var args34448 = [];
var len__21576__auto___34966 = arguments.length;
var i__21577__auto___34967 = (0);
while(true){
if((i__21577__auto___34967 < len__21576__auto___34966)){
args34448.push((arguments[i__21577__auto___34967]));

var G__34968 = (i__21577__auto___34967 + (1));
i__21577__auto___34967 = G__34968;
continue;
} else {
}
break;
}

var G__34452 = args34448.length;
switch (G__34452) {
case 0:
return om_tools.dom.input.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34448.slice((1)),(0),null));
return om_tools.dom.input.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.input.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,om.dom.input,null,null);
});

om_tools.dom.input.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,om.dom.input,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.input.cljs$lang$applyTo = (function (seq34449){
var G__34450 = cljs.core.first.call(null,seq34449);
var seq34449__$1 = cljs.core.next.call(null,seq34449);
return om_tools.dom.input.cljs$core$IFn$_invoke$arity$variadic(G__34450,seq34449__$1);
});

om_tools.dom.input.cljs$lang$maxFixedArity = (1);


om_tools.dom.textarea = (function om_tools$dom$textarea(var_args){
var args34453 = [];
var len__21576__auto___34970 = arguments.length;
var i__21577__auto___34971 = (0);
while(true){
if((i__21577__auto___34971 < len__21576__auto___34970)){
args34453.push((arguments[i__21577__auto___34971]));

var G__34972 = (i__21577__auto___34971 + (1));
i__21577__auto___34971 = G__34972;
continue;
} else {
}
break;
}

var G__34457 = args34453.length;
switch (G__34457) {
case 0:
return om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args34453.slice((1)),(0),null));
return om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,om.dom.textarea,null,null);
});

om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,om.dom.textarea,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.textarea.cljs$lang$applyTo = (function (seq34454){
var G__34455 = cljs.core.first.call(null,seq34454);
var seq34454__$1 = cljs.core.next.call(null,seq34454);
return om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$variadic(G__34455,seq34454__$1);
});

om_tools.dom.textarea.cljs$lang$maxFixedArity = (1);


om_tools.dom.option = (function om_tools$dom$option(var_args){
var args33968 = [];
var len__21576__auto___34974 = arguments.length;
var i__21577__auto___34975 = (0);
while(true){
if((i__21577__auto___34975 < len__21576__auto___34974)){
args33968.push((arguments[i__21577__auto___34975]));

var G__34976 = (i__21577__auto___34975 + (1));
i__21577__auto___34975 = G__34976;
continue;
} else {
}
break;
}

var G__33972 = args33968.length;
switch (G__33972) {
case 0:
return om_tools.dom.option.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args33968.slice((1)),(0),null));
return om_tools.dom.option.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21599__auto__);

}
});

om_tools.dom.option.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,om.dom.option,null,null);
});

om_tools.dom.option.cljs$core$IFn$_invoke$arity$variadic = (function (opts__33776__auto__,children__33777__auto__){
return om_tools.dom.element.call(null,om.dom.option,opts__33776__auto__,children__33777__auto__);
});

om_tools.dom.option.cljs$lang$applyTo = (function (seq33969){
var G__33970 = cljs.core.first.call(null,seq33969);
var seq33969__$1 = cljs.core.next.call(null,seq33969);
return om_tools.dom.option.cljs$core$IFn$_invoke$arity$variadic(G__33970,seq33969__$1);
});

om_tools.dom.option.cljs$lang$maxFixedArity = (1);

om_tools.dom.class_set = (function om_tools$dom$class_set(m){

var temp__6753__auto__ = cljs.core.seq.call(null,cljs.core.distinct.call(null,cljs.core.map.call(null,cljs.core.name,cljs.core.keys.call(null,cljs.core.filter.call(null,cljs.core.val,m)))));
if(temp__6753__auto__){
var ks = temp__6753__auto__;
return clojure.string.join.call(null," ",ks);
} else {
return null;
}
});

//# sourceMappingURL=dom.js.map