// Compiled by ClojureScript 1.9.293 {}
goog.provide('plumbing.core');
goog.require('cljs.core');
goog.require('schema.utils');
goog.require('plumbing.fnk.schema');
/**
 * A sentinel value representing missing portions of the input data.
 */
plumbing.core._PLUS_none_PLUS_ = new cljs.core.Keyword("plumbing.core","missing","plumbing.core/missing",1721767298);
/**
 * Updates the value in map m at k with the function f.
 * 
 *  Like update-in, but for updating a single top-level key.
 *  Any additional args will be passed to f after the value.
 * 
 *  WARNING As of Clojure 1.7 this function exists in clojure.core and
 *  will not be exported by this namespace.
 */
plumbing.core.update = (function plumbing$core$update(var_args){
var args38676 = [];
var len__21576__auto___38685 = arguments.length;
var i__21577__auto___38686 = (0);
while(true){
if((i__21577__auto___38686 < len__21576__auto___38685)){
args38676.push((arguments[i__21577__auto___38686]));

var G__38687 = (i__21577__auto___38686 + (1));
i__21577__auto___38686 = G__38687;
continue;
} else {
}
break;
}

var G__38684 = args38676.length;
switch (G__38684) {
case 3:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args38676.slice((5)),(0),null));
return plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__21599__auto__);

}
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x1){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x1,x2){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1,x2));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x1,x2,xs){
return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x1,x2,xs));
});

plumbing.core.update.cljs$lang$applyTo = (function (seq38677){
var G__38678 = cljs.core.first.call(null,seq38677);
var seq38677__$1 = cljs.core.next.call(null,seq38677);
var G__38679 = cljs.core.first.call(null,seq38677__$1);
var seq38677__$2 = cljs.core.next.call(null,seq38677__$1);
var G__38680 = cljs.core.first.call(null,seq38677__$2);
var seq38677__$3 = cljs.core.next.call(null,seq38677__$2);
var G__38681 = cljs.core.first.call(null,seq38677__$3);
var seq38677__$4 = cljs.core.next.call(null,seq38677__$3);
var G__38682 = cljs.core.first.call(null,seq38677__$4);
var seq38677__$5 = cljs.core.next.call(null,seq38677__$4);
return plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic(G__38678,G__38679,G__38680,G__38681,G__38682,seq38677__$5);
});

plumbing.core.update.cljs$lang$maxFixedArity = (5);

/**
 * Build map k -> (f v) for [k v] in map, preserving the initial type
 */
plumbing.core.map_vals = (function plumbing$core$map_vals(f,m){
if(cljs.core.sorted_QMARK_.call(null,m)){
return cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__38382__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__38701_38711 = cljs.core.seq.call(null,m);
var chunk__38702_38712 = null;
var count__38703_38713 = (0);
var i__38704_38714 = (0);
while(true){
if((i__38704_38714 < count__38703_38713)){
var vec__38705_38715 = cljs.core._nth.call(null,chunk__38702_38712,i__38704_38714);
var k_38716 = cljs.core.nth.call(null,vec__38705_38715,(0),null);
var v_38717 = cljs.core.nth.call(null,vec__38705_38715,(1),null);
var m38700_38718 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38700_38718,k_38716,f.call(null,v_38717)));

var G__38719 = seq__38701_38711;
var G__38720 = chunk__38702_38712;
var G__38721 = count__38703_38713;
var G__38722 = (i__38704_38714 + (1));
seq__38701_38711 = G__38719;
chunk__38702_38712 = G__38720;
count__38703_38713 = G__38721;
i__38704_38714 = G__38722;
continue;
} else {
var temp__6753__auto___38723 = cljs.core.seq.call(null,seq__38701_38711);
if(temp__6753__auto___38723){
var seq__38701_38724__$1 = temp__6753__auto___38723;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38701_38724__$1)){
var c__21266__auto___38725 = cljs.core.chunk_first.call(null,seq__38701_38724__$1);
var G__38726 = cljs.core.chunk_rest.call(null,seq__38701_38724__$1);
var G__38727 = c__21266__auto___38725;
var G__38728 = cljs.core.count.call(null,c__21266__auto___38725);
var G__38729 = (0);
seq__38701_38711 = G__38726;
chunk__38702_38712 = G__38727;
count__38703_38713 = G__38728;
i__38704_38714 = G__38729;
continue;
} else {
var vec__38708_38730 = cljs.core.first.call(null,seq__38701_38724__$1);
var k_38731 = cljs.core.nth.call(null,vec__38708_38730,(0),null);
var v_38732 = cljs.core.nth.call(null,vec__38708_38730,(1),null);
var m38700_38733 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38700_38733,k_38731,f.call(null,v_38732)));

var G__38734 = cljs.core.next.call(null,seq__38701_38724__$1);
var G__38735 = null;
var G__38736 = (0);
var G__38737 = (0);
seq__38701_38711 = G__38734;
chunk__38702_38712 = G__38735;
count__38703_38713 = G__38736;
i__38704_38714 = G__38737;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__38382__auto__));

}
}
});
/**
 * Build map (f k) -> v for [k v] in map m
 */
plumbing.core.map_keys = (function plumbing$core$map_keys(f,m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,f.call(null,k),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__38382__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__38750_38760 = cljs.core.seq.call(null,m);
var chunk__38751_38761 = null;
var count__38752_38762 = (0);
var i__38753_38763 = (0);
while(true){
if((i__38753_38763 < count__38752_38762)){
var vec__38754_38764 = cljs.core._nth.call(null,chunk__38751_38761,i__38753_38763);
var k_38765 = cljs.core.nth.call(null,vec__38754_38764,(0),null);
var v_38766 = cljs.core.nth.call(null,vec__38754_38764,(1),null);
var m38749_38767 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38749_38767,f.call(null,k_38765),v_38766));

var G__38768 = seq__38750_38760;
var G__38769 = chunk__38751_38761;
var G__38770 = count__38752_38762;
var G__38771 = (i__38753_38763 + (1));
seq__38750_38760 = G__38768;
chunk__38751_38761 = G__38769;
count__38752_38762 = G__38770;
i__38753_38763 = G__38771;
continue;
} else {
var temp__6753__auto___38772 = cljs.core.seq.call(null,seq__38750_38760);
if(temp__6753__auto___38772){
var seq__38750_38773__$1 = temp__6753__auto___38772;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38750_38773__$1)){
var c__21266__auto___38774 = cljs.core.chunk_first.call(null,seq__38750_38773__$1);
var G__38775 = cljs.core.chunk_rest.call(null,seq__38750_38773__$1);
var G__38776 = c__21266__auto___38774;
var G__38777 = cljs.core.count.call(null,c__21266__auto___38774);
var G__38778 = (0);
seq__38750_38760 = G__38775;
chunk__38751_38761 = G__38776;
count__38752_38762 = G__38777;
i__38753_38763 = G__38778;
continue;
} else {
var vec__38757_38779 = cljs.core.first.call(null,seq__38750_38773__$1);
var k_38780 = cljs.core.nth.call(null,vec__38757_38779,(0),null);
var v_38781 = cljs.core.nth.call(null,vec__38757_38779,(1),null);
var m38749_38782 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38749_38782,f.call(null,k_38780),v_38781));

var G__38783 = cljs.core.next.call(null,seq__38750_38773__$1);
var G__38784 = null;
var G__38785 = (0);
var G__38786 = (0);
seq__38750_38760 = G__38783;
chunk__38751_38761 = G__38784;
count__38752_38762 = G__38785;
i__38753_38763 = G__38786;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__38382__auto__));
}
});
/**
 * Build map k -> (f k) for keys in ks
 */
plumbing.core.map_from_keys = (function plumbing$core$map_from_keys(f,ks){
var m_atom__38382__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__38793_38797 = cljs.core.seq.call(null,ks);
var chunk__38794_38798 = null;
var count__38795_38799 = (0);
var i__38796_38800 = (0);
while(true){
if((i__38796_38800 < count__38795_38799)){
var k_38801 = cljs.core._nth.call(null,chunk__38794_38798,i__38796_38800);
var m38792_38802 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38792_38802,k_38801,f.call(null,k_38801)));

var G__38803 = seq__38793_38797;
var G__38804 = chunk__38794_38798;
var G__38805 = count__38795_38799;
var G__38806 = (i__38796_38800 + (1));
seq__38793_38797 = G__38803;
chunk__38794_38798 = G__38804;
count__38795_38799 = G__38805;
i__38796_38800 = G__38806;
continue;
} else {
var temp__6753__auto___38807 = cljs.core.seq.call(null,seq__38793_38797);
if(temp__6753__auto___38807){
var seq__38793_38808__$1 = temp__6753__auto___38807;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38793_38808__$1)){
var c__21266__auto___38809 = cljs.core.chunk_first.call(null,seq__38793_38808__$1);
var G__38810 = cljs.core.chunk_rest.call(null,seq__38793_38808__$1);
var G__38811 = c__21266__auto___38809;
var G__38812 = cljs.core.count.call(null,c__21266__auto___38809);
var G__38813 = (0);
seq__38793_38797 = G__38810;
chunk__38794_38798 = G__38811;
count__38795_38799 = G__38812;
i__38796_38800 = G__38813;
continue;
} else {
var k_38814 = cljs.core.first.call(null,seq__38793_38808__$1);
var m38792_38815 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38792_38815,k_38814,f.call(null,k_38814)));

var G__38816 = cljs.core.next.call(null,seq__38793_38808__$1);
var G__38817 = null;
var G__38818 = (0);
var G__38819 = (0);
seq__38793_38797 = G__38816;
chunk__38794_38798 = G__38817;
count__38795_38799 = G__38818;
i__38796_38800 = G__38819;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__38382__auto__));
});
/**
 * Build map (f v) -> v for vals in vs
 */
plumbing.core.map_from_vals = (function plumbing$core$map_from_vals(f,vs){
var m_atom__38382__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__38826_38830 = cljs.core.seq.call(null,vs);
var chunk__38827_38831 = null;
var count__38828_38832 = (0);
var i__38829_38833 = (0);
while(true){
if((i__38829_38833 < count__38828_38832)){
var v_38834 = cljs.core._nth.call(null,chunk__38827_38831,i__38829_38833);
var m38825_38835 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38825_38835,f.call(null,v_38834),v_38834));

var G__38836 = seq__38826_38830;
var G__38837 = chunk__38827_38831;
var G__38838 = count__38828_38832;
var G__38839 = (i__38829_38833 + (1));
seq__38826_38830 = G__38836;
chunk__38827_38831 = G__38837;
count__38828_38832 = G__38838;
i__38829_38833 = G__38839;
continue;
} else {
var temp__6753__auto___38840 = cljs.core.seq.call(null,seq__38826_38830);
if(temp__6753__auto___38840){
var seq__38826_38841__$1 = temp__6753__auto___38840;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38826_38841__$1)){
var c__21266__auto___38842 = cljs.core.chunk_first.call(null,seq__38826_38841__$1);
var G__38843 = cljs.core.chunk_rest.call(null,seq__38826_38841__$1);
var G__38844 = c__21266__auto___38842;
var G__38845 = cljs.core.count.call(null,c__21266__auto___38842);
var G__38846 = (0);
seq__38826_38830 = G__38843;
chunk__38827_38831 = G__38844;
count__38828_38832 = G__38845;
i__38829_38833 = G__38846;
continue;
} else {
var v_38847 = cljs.core.first.call(null,seq__38826_38841__$1);
var m38825_38848 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38825_38848,f.call(null,v_38847),v_38847));

var G__38849 = cljs.core.next.call(null,seq__38826_38841__$1);
var G__38850 = null;
var G__38851 = (0);
var G__38852 = (0);
seq__38826_38830 = G__38849;
chunk__38827_38831 = G__38850;
count__38828_38832 = G__38851;
i__38829_38833 = G__38852;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__38382__auto__));
});
/**
 * Dissociate this keyseq from m, removing any empty maps created as a result
 * (including at the top-level).
 */
plumbing.core.dissoc_in = (function plumbing$core$dissoc_in(m,p__38853){
var vec__38857 = p__38853;
var seq__38858 = cljs.core.seq.call(null,vec__38857);
var first__38859 = cljs.core.first.call(null,seq__38858);
var seq__38858__$1 = cljs.core.next.call(null,seq__38858);
var k = first__38859;
var ks = seq__38858__$1;
if(cljs.core.truth_(m)){
var temp__6751__auto__ = (function (){var and__20348__auto__ = ks;
if(and__20348__auto__){
return plumbing.core.dissoc_in.call(null,cljs.core.get.call(null,m,k),ks);
} else {
return and__20348__auto__;
}
})();
if(cljs.core.truth_(temp__6751__auto__)){
var res = temp__6751__auto__;
return cljs.core.assoc.call(null,m,k,res);
} else {
var res = cljs.core.dissoc.call(null,m,k);
if(cljs.core.empty_QMARK_.call(null,res)){
return null;
} else {
return res;
}
}
} else {
return null;
}
});
/**
 * Recursively convert maps in m (including itself)
 * to have keyword keys instead of string
 */
plumbing.core.keywordize_map = (function plumbing$core$keywordize_map(x){
if(cljs.core.map_QMARK_.call(null,x)){
var m_atom__38382__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__38872_38882 = cljs.core.seq.call(null,x);
var chunk__38873_38883 = null;
var count__38874_38884 = (0);
var i__38875_38885 = (0);
while(true){
if((i__38875_38885 < count__38874_38884)){
var vec__38876_38886 = cljs.core._nth.call(null,chunk__38873_38883,i__38875_38885);
var k_38887 = cljs.core.nth.call(null,vec__38876_38886,(0),null);
var v_38888 = cljs.core.nth.call(null,vec__38876_38886,(1),null);
var m38871_38889 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38871_38889,((typeof k_38887 === 'string')?cljs.core.keyword.call(null,k_38887):k_38887),plumbing.core.keywordize_map.call(null,v_38888)));

var G__38890 = seq__38872_38882;
var G__38891 = chunk__38873_38883;
var G__38892 = count__38874_38884;
var G__38893 = (i__38875_38885 + (1));
seq__38872_38882 = G__38890;
chunk__38873_38883 = G__38891;
count__38874_38884 = G__38892;
i__38875_38885 = G__38893;
continue;
} else {
var temp__6753__auto___38894 = cljs.core.seq.call(null,seq__38872_38882);
if(temp__6753__auto___38894){
var seq__38872_38895__$1 = temp__6753__auto___38894;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38872_38895__$1)){
var c__21266__auto___38896 = cljs.core.chunk_first.call(null,seq__38872_38895__$1);
var G__38897 = cljs.core.chunk_rest.call(null,seq__38872_38895__$1);
var G__38898 = c__21266__auto___38896;
var G__38899 = cljs.core.count.call(null,c__21266__auto___38896);
var G__38900 = (0);
seq__38872_38882 = G__38897;
chunk__38873_38883 = G__38898;
count__38874_38884 = G__38899;
i__38875_38885 = G__38900;
continue;
} else {
var vec__38879_38901 = cljs.core.first.call(null,seq__38872_38895__$1);
var k_38902 = cljs.core.nth.call(null,vec__38879_38901,(0),null);
var v_38903 = cljs.core.nth.call(null,vec__38879_38901,(1),null);
var m38871_38904 = cljs.core.deref.call(null,m_atom__38382__auto__);
cljs.core.reset_BANG_.call(null,m_atom__38382__auto__,cljs.core.assoc_BANG_.call(null,m38871_38904,((typeof k_38902 === 'string')?cljs.core.keyword.call(null,k_38902):k_38902),plumbing.core.keywordize_map.call(null,v_38903)));

var G__38905 = cljs.core.next.call(null,seq__38872_38895__$1);
var G__38906 = null;
var G__38907 = (0);
var G__38908 = (0);
seq__38872_38882 = G__38905;
chunk__38873_38883 = G__38906;
count__38874_38884 = G__38907;
i__38875_38885 = G__38908;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__38382__auto__));
} else {
if(cljs.core.seq_QMARK_.call(null,x)){
return cljs.core.map.call(null,plumbing.core.keywordize_map,x);
} else {
if(cljs.core.vector_QMARK_.call(null,x)){
return cljs.core.mapv.call(null,plumbing.core.keywordize_map,x);
} else {
return x;

}
}
}
});
/**
 * Like get but throw an exception if not found
 */
plumbing.core.safe_get = (function plumbing$core$safe_get(m,k){
var temp__6751__auto__ = cljs.core.find.call(null,m,k);
if(cljs.core.truth_(temp__6751__auto__)){
var pair__38472__auto__ = temp__6751__auto__;
return cljs.core.val.call(null,pair__38472__auto__);
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.mapv.call(null,cljs.core.key,m))));

}
});
/**
 * Like get-in but throws exception if not found
 */
plumbing.core.safe_get_in = (function plumbing$core$safe_get_in(m,ks){
while(true){
if(cljs.core.seq.call(null,ks)){
var G__38909 = plumbing.core.safe_get.call(null,m,cljs.core.first.call(null,ks));
var G__38910 = cljs.core.next.call(null,ks);
m = G__38909;
ks = G__38910;
continue;
} else {
return m;
}
break;
}
});
/**
 * Like assoc but only assocs when value is truthy
 */
plumbing.core.assoc_when = (function plumbing$core$assoc_when(var_args){
var args__21583__auto__ = [];
var len__21576__auto___38929 = arguments.length;
var i__21577__auto___38930 = (0);
while(true){
if((i__21577__auto___38930 < len__21576__auto___38929)){
args__21583__auto__.push((arguments[i__21577__auto___38930]));

var G__38931 = (i__21577__auto___38930 + (1));
i__21577__auto___38930 = G__38931;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((1) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((1)),(0),null)):null);
return plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21584__auto__);
});

plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

return cljs.core.into.call(null,(function (){var or__20360__auto__ = m;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__21217__auto__ = (function plumbing$core$iter__38913(s__38914){
return (new cljs.core.LazySeq(null,(function (){
var s__38914__$1 = s__38914;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__38914__$1);
if(temp__6753__auto__){
var s__38914__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38914__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__38914__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__38916 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__38915 = (0);
while(true){
if((i__38915 < size__21216__auto__)){
var vec__38923 = cljs.core._nth.call(null,c__21215__auto__,i__38915);
var k = cljs.core.nth.call(null,vec__38923,(0),null);
var v = cljs.core.nth.call(null,vec__38923,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__38916,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__38932 = (i__38915 + (1));
i__38915 = G__38932;
continue;
} else {
var G__38933 = (i__38915 + (1));
i__38915 = G__38933;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38916),plumbing$core$iter__38913.call(null,cljs.core.chunk_rest.call(null,s__38914__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38916),null);
}
} else {
var vec__38926 = cljs.core.first.call(null,s__38914__$2);
var k = cljs.core.nth.call(null,vec__38926,(0),null);
var v = cljs.core.nth.call(null,vec__38926,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$core$iter__38913.call(null,cljs.core.rest.call(null,s__38914__$2)));
} else {
var G__38934 = cljs.core.rest.call(null,s__38914__$2);
s__38914__$1 = G__38934;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

plumbing.core.assoc_when.cljs$lang$maxFixedArity = (1);

plumbing.core.assoc_when.cljs$lang$applyTo = (function (seq38911){
var G__38912 = cljs.core.first.call(null,seq38911);
var seq38911__$1 = cljs.core.next.call(null,seq38911);
return plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__38912,seq38911__$1);
});

/**
 * Like update-in but returns m unchanged if key-seq is not present.
 */
plumbing.core.update_in_when = (function plumbing$core$update_in_when(var_args){
var args__21583__auto__ = [];
var len__21576__auto___38939 = arguments.length;
var i__21577__auto___38940 = (0);
while(true){
if((i__21577__auto___38940 < len__21576__auto___38939)){
args__21583__auto__.push((arguments[i__21577__auto___38940]));

var G__38941 = (i__21577__auto___38940 + (1));
i__21577__auto___38940 = G__38941;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((3) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((3)),(0),null)):null);
return plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__21584__auto__);
});

plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,key_seq,f,args){
var found = cljs.core.get_in.call(null,m,key_seq,plumbing.core._PLUS_none_PLUS_);
if(!((plumbing.core._PLUS_none_PLUS_ === found))){
return cljs.core.assoc_in.call(null,m,key_seq,cljs.core.apply.call(null,f,found,args));
} else {
return m;
}
});

plumbing.core.update_in_when.cljs$lang$maxFixedArity = (3);

plumbing.core.update_in_when.cljs$lang$applyTo = (function (seq38935){
var G__38936 = cljs.core.first.call(null,seq38935);
var seq38935__$1 = cljs.core.next.call(null,seq38935);
var G__38937 = cljs.core.first.call(null,seq38935__$1);
var seq38935__$2 = cljs.core.next.call(null,seq38935__$1);
var G__38938 = cljs.core.first.call(null,seq38935__$2);
var seq38935__$3 = cljs.core.next.call(null,seq38935__$2);
return plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic(G__38936,G__38937,G__38938,seq38935__$3);
});

/**
 * Like group-by, but accepts a map-fn that is applied to values before
 * collected.
 */
plumbing.core.grouped_map = (function plumbing$core$grouped_map(key_fn,map_fn,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (ret,x){
var k = key_fn.call(null,x);
return cljs.core.assoc_BANG_.call(null,ret,k,cljs.core.conj.call(null,cljs.core.get.call(null,ret,k,cljs.core.PersistentVector.EMPTY),map_fn.call(null,x)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Like (apply concat s) but lazier (and shorter) 
 */
plumbing.core.aconcat = (function plumbing$core$aconcat(s){
return cljs.core.concat.call(null,(new cljs.core.LazySeq(null,(function (){
return cljs.core.first.call(null,s);
}),null,null)),(new cljs.core.LazySeq(null,(function (){
var temp__6753__auto__ = cljs.core.next.call(null,s);
if(temp__6753__auto__){
var n = temp__6753__auto__;
return plumbing.core.aconcat.call(null,n);
} else {
return null;
}
}),null,null)));
});
/**
 * Takes a seqable and returns a lazy sequence that
 * is maximally lazy and doesn't realize elements due to either
 * chunking or apply.
 * 
 * Useful when you don't want chunking, for instance,
 * (first awesome-website? (map slurp +a-bunch-of-urls+))
 * may slurp up to 31 unneed webpages, wherease
 * (first awesome-website? (map slurp (unchunk +a-bunch-of-urls+)))
 * is guaranteed to stop slurping after the first awesome website.
 * 
 *   Taken from http://stackoverflow.com/questions/3407876/how-do-i-avoid-clojures-chunking-behavior-for-lazy-seqs-that-i-want-to-short-ci
 */
plumbing.core.unchunk = (function plumbing$core$unchunk(s){
if(cljs.core.seq.call(null,s)){
return cljs.core.cons.call(null,cljs.core.first.call(null,s),(new cljs.core.LazySeq(null,(function (){
return plumbing.core.unchunk.call(null,cljs.core.rest.call(null,s));
}),null,null)));
} else {
return null;
}
});
/**
 * Return sum of (f x) for each x in xs
 */
plumbing.core.sum = (function plumbing$core$sum(var_args){
var args38942 = [];
var len__21576__auto___38945 = arguments.length;
var i__21577__auto___38946 = (0);
while(true){
if((i__21577__auto___38946 < len__21576__auto___38945)){
args38942.push((arguments[i__21577__auto___38946]));

var G__38947 = (i__21577__auto___38946 + (1));
i__21577__auto___38946 = G__38947;
continue;
} else {
}
break;
}

var G__38944 = args38942.length;
switch (G__38944) {
case 2:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38942.length)].join('')));

}
});

plumbing.core.sum.cljs$core$IFn$_invoke$arity$2 = (function (f,xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,f,xs));
});

plumbing.core.sum.cljs$core$IFn$_invoke$arity$1 = (function (xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,xs);
});

plumbing.core.sum.cljs$lang$maxFixedArity = 2;

/**
 * returns (first xs) when xs has only 1 element
 */
plumbing.core.singleton = (function plumbing$core$singleton(xs){
var temp__6753__auto__ = cljs.core.seq.call(null,xs);
if(temp__6753__auto__){
var xs__$1 = temp__6753__auto__;
if(cljs.core.next.call(null,xs__$1)){
return null;
} else {
return cljs.core.first.call(null,xs__$1);
}
} else {
return null;
}
});
/**
 * Returns [idx x] for x in seqable s
 */
plumbing.core.indexed = (function plumbing$core$indexed(s){
return cljs.core.map_indexed.call(null,cljs.core.vector,s);
});
/**
 * Returns indices idx of sequence s where (f (nth s idx))
 */
plumbing.core.positions = (function plumbing$core$positions(f,s){
return cljs.core.keep_indexed.call(null,(function (i,x){
if(cljs.core.truth_(f.call(null,x))){
return i;
} else {
return null;
}
}),s);
});
/**
 * Returns elements of xs which return unique
 * values according to f. If multiple elements of xs return the same
 * value under f, the first is returned
 */
plumbing.core.distinct_by = (function plumbing$core$distinct_by(f,xs){
var s = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var iter__21217__auto__ = ((function (s){
return (function plumbing$core$distinct_by_$_iter__38953(s__38954){
return (new cljs.core.LazySeq(null,((function (s){
return (function (){
var s__38954__$1 = s__38954;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__38954__$1);
if(temp__6753__auto__){
var s__38954__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__38954__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__38954__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__38956 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__38955 = (0);
while(true){
if((i__38955 < size__21216__auto__)){
var x = cljs.core._nth.call(null,c__21215__auto__,i__38955);
var id = f.call(null,x);
if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id))){
cljs.core.chunk_append.call(null,b__38956,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
);

var G__38957 = (i__38955 + (1));
i__38955 = G__38957;
continue;
} else {
var G__38958 = (i__38955 + (1));
i__38955 = G__38958;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38956),plumbing$core$distinct_by_$_iter__38953.call(null,cljs.core.chunk_rest.call(null,s__38954__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__38956),null);
}
} else {
var x = cljs.core.first.call(null,s__38954__$2);
var id = f.call(null,x);
if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id))){
return cljs.core.cons.call(null,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
,plumbing$core$distinct_by_$_iter__38953.call(null,cljs.core.rest.call(null,s__38954__$2)));
} else {
var G__38959 = cljs.core.rest.call(null,s__38954__$2);
s__38954__$1 = G__38959;
continue;
}
}
} else {
return null;
}
break;
}
});})(s))
,null,null));
});})(s))
;
return iter__21217__auto__.call(null,xs);
});
/**
 * Analogy: partition:partition-all :: interleave:interleave-all
 */
plumbing.core.interleave_all = (function plumbing$core$interleave_all(var_args){
var args__21583__auto__ = [];
var len__21576__auto___38961 = arguments.length;
var i__21577__auto___38962 = (0);
while(true){
if((i__21577__auto___38962 < len__21576__auto___38961)){
args__21583__auto__.push((arguments[i__21577__auto___38962]));

var G__38963 = (i__21577__auto___38962 + (1));
i__21577__auto___38962 = G__38963;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((0) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((0)),(0),null)):null);
return plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic(argseq__21584__auto__);
});

plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (colls){
return (new cljs.core.LazySeq(null,(function (){
return (function plumbing$core$helper(seqs){
if(cljs.core.seq.call(null,seqs)){
return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,seqs),(new cljs.core.LazySeq(null,(function (){
return plumbing$core$helper.call(null,cljs.core.keep.call(null,cljs.core.next,seqs));
}),null,null)));
} else {
return null;
}
}).call(null,cljs.core.keep.call(null,cljs.core.seq,colls));
}),null,null));
});

plumbing.core.interleave_all.cljs$lang$maxFixedArity = (0);

plumbing.core.interleave_all.cljs$lang$applyTo = (function (seq38960){
return plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38960));
});

/**
 * Returns # of elements of xs where pred holds
 */
plumbing.core.count_when = (function plumbing$core$count_when(pred,xs){
return cljs.core.count.call(null,cljs.core.filter.call(null,pred,xs));
});
/**
 * Like conj but ignores non-truthy values
 */
plumbing.core.conj_when = (function plumbing$core$conj_when(var_args){
var args38964 = [];
var len__21576__auto___38970 = arguments.length;
var i__21577__auto___38971 = (0);
while(true){
if((i__21577__auto___38971 < len__21576__auto___38970)){
args38964.push((arguments[i__21577__auto___38971]));

var G__38972 = (i__21577__auto___38971 + (1));
i__21577__auto___38971 = G__38972;
continue;
} else {
}
break;
}

var G__38969 = args38964.length;
switch (G__38969) {
case 2:
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args38964.slice((2)),(0),null));
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__21599__auto__);

}
});

plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(cljs.core.truth_(x)){
return cljs.core.conj.call(null,coll,x);
} else {
return coll;
}
});

plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__38974 = plumbing.core.conj_when.call(null,coll,x);
var G__38975 = cljs.core.first.call(null,xs);
var G__38976 = cljs.core.next.call(null,xs);
coll = G__38974;
x = G__38975;
xs = G__38976;
continue;
} else {
return plumbing.core.conj_when.call(null,coll,x);
}
break;
}
});

plumbing.core.conj_when.cljs$lang$applyTo = (function (seq38965){
var G__38966 = cljs.core.first.call(null,seq38965);
var seq38965__$1 = cljs.core.next.call(null,seq38965);
var G__38967 = cljs.core.first.call(null,seq38965__$1);
var seq38965__$2 = cljs.core.next.call(null,seq38965__$1);
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic(G__38966,G__38967,seq38965__$2);
});

plumbing.core.conj_when.cljs$lang$maxFixedArity = (2);

/**
 * Like cons but does nothing if x is non-truthy.
 */
plumbing.core.cons_when = (function plumbing$core$cons_when(x,s){
if(cljs.core.truth_(x)){
return cljs.core.cons.call(null,x,s);
} else {
return s;
}
});
/**
 * Like sort-by, but prefers higher values rather than lower ones.
 */
plumbing.core.rsort_by = cljs.core.comp.call(null,cljs.core.reverse,cljs.core.sort_by);
/**
 * Like swap! but returns a pair [old-val new-val]
 */
plumbing.core.swap_pair_BANG_ = (function plumbing$core$swap_pair_BANG_(var_args){
var args38978 = [];
var len__21576__auto___38984 = arguments.length;
var i__21577__auto___38985 = (0);
while(true){
if((i__21577__auto___38985 < len__21576__auto___38984)){
args38978.push((arguments[i__21577__auto___38985]));

var G__38986 = (i__21577__auto___38985 + (1));
i__21577__auto___38985 = G__38986;
continue;
} else {
}
break;
}

var G__38983 = args38978.length;
switch (G__38983) {
case 2:
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args38978.slice((2)),(0),null));
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__21599__auto__);

}
});

plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
while(true){
var old_val = cljs.core.deref.call(null,a);
var new_val = f.call(null,old_val);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_.call(null,a,old_val,new_val))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_val,new_val], null);
} else {
continue;
}
break;
}
});

plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,args){
return plumbing.core.swap_pair_BANG_.call(null,a,(function (p1__38977_SHARP_){
return cljs.core.apply.call(null,f,p1__38977_SHARP_,args);
}));
});

plumbing.core.swap_pair_BANG_.cljs$lang$applyTo = (function (seq38979){
var G__38980 = cljs.core.first.call(null,seq38979);
var seq38979__$1 = cljs.core.next.call(null,seq38979);
var G__38981 = cljs.core.first.call(null,seq38979__$1);
var seq38979__$2 = cljs.core.next.call(null,seq38979__$1);
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38980,G__38981,seq38979__$2);
});

plumbing.core.swap_pair_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Like reset! but returns old-val
 */
plumbing.core.get_and_set_BANG_ = (function plumbing$core$get_and_set_BANG_(a,new_val){
return cljs.core.first.call(null,plumbing.core.swap_pair_BANG_.call(null,a,cljs.core.constantly.call(null,new_val)));
});
plumbing.core.millis = (function plumbing$core$millis(){
return (new Date()).getTime();
});
/**
 * Like apply, but applies a map to a function with positional map
 *   arguments. Can take optional initial args just like apply.
 */
plumbing.core.mapply = (function plumbing$core$mapply(var_args){
var args38988 = [];
var len__21576__auto___38994 = arguments.length;
var i__21577__auto___38995 = (0);
while(true){
if((i__21577__auto___38995 < len__21576__auto___38994)){
args38988.push((arguments[i__21577__auto___38995]));

var G__38996 = (i__21577__auto___38995 + (1));
i__21577__auto___38995 = G__38996;
continue;
} else {
}
break;
}

var G__38993 = args38988.length;
switch (G__38993) {
case 2:
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__21599__auto__ = (new cljs.core.IndexedSeq(args38988.slice((2)),(0),null));
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__21599__auto__);

}
});

plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2 = (function (f,m){
return cljs.core.apply.call(null,f,cljs.core.apply.call(null,cljs.core.concat,m));
});

plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg,args){
return cljs.core.apply.call(null,f,arg,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),cljs.core.apply.call(null,cljs.core.concat,cljs.core.last.call(null,args))));
});

plumbing.core.mapply.cljs$lang$applyTo = (function (seq38989){
var G__38990 = cljs.core.first.call(null,seq38989);
var seq38989__$1 = cljs.core.next.call(null,seq38989);
var G__38991 = cljs.core.first.call(null,seq38989__$1);
var seq38989__$2 = cljs.core.next.call(null,seq38989__$1);
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic(G__38990,G__38991,seq38989__$2);
});

plumbing.core.mapply.cljs$lang$maxFixedArity = (2);


//# sourceMappingURL=core.js.map