// Compiled by ClojureScript 1.9.293 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom.server');
goog.require('cljsjs.react.dom');
goog.require('clojure.string');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__28119__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__28116 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__28117 = cljs.core.seq.call(null,vec__28116);
var first__28118 = cljs.core.first.call(null,seq__28117);
var seq__28117__$1 = cljs.core.next.call(null,seq__28117);
var tag = first__28118;
var body = seq__28117__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__28119 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__28120__i = 0, G__28120__a = new Array(arguments.length -  0);
while (G__28120__i < G__28120__a.length) {G__28120__a[G__28120__i] = arguments[G__28120__i + 0]; ++G__28120__i;}
  args = new cljs.core.IndexedSeq(G__28120__a,0);
} 
return G__28119__delegate.call(this,args);};
G__28119.cljs$lang$maxFixedArity = 0;
G__28119.cljs$lang$applyTo = (function (arglist__28121){
var args = cljs.core.seq(arglist__28121);
return G__28119__delegate(args);
});
G__28119.cljs$core$IFn$_invoke$arity$variadic = G__28119__delegate;
return G__28119;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__21217__auto__ = (function sablono$core$update_arglists_$_iter__28126(s__28127){
return (new cljs.core.LazySeq(null,(function (){
var s__28127__$1 = s__28127;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__28127__$1);
if(temp__6753__auto__){
var s__28127__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__28127__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__28127__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__28129 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__28128 = (0);
while(true){
if((i__28128 < size__21216__auto__)){
var args = cljs.core._nth.call(null,c__21215__auto__,i__28128);
cljs.core.chunk_append.call(null,b__28129,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__28130 = (i__28128 + (1));
i__28128 = G__28130;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28129),sablono$core$update_arglists_$_iter__28126.call(null,cljs.core.chunk_rest.call(null,s__28127__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28129),null);
}
} else {
var args = cljs.core.first.call(null,s__28127__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__28126.call(null,cljs.core.rest.call(null,s__28127__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return ReactDOMServer.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return ReactDOMServer.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__21583__auto__ = [];
var len__21576__auto___28136 = arguments.length;
var i__21577__auto___28137 = (0);
while(true){
if((i__21577__auto___28137 < len__21576__auto___28136)){
args__21583__auto__.push((arguments[i__21577__auto___28137]));

var G__28138 = (i__21577__auto___28137 + (1));
i__21577__auto___28137 = G__28138;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((0) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__21584__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__21217__auto__ = (function sablono$core$iter__28132(s__28133){
return (new cljs.core.LazySeq(null,(function (){
var s__28133__$1 = s__28133;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__28133__$1);
if(temp__6753__auto__){
var s__28133__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__28133__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__28133__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__28135 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__28134 = (0);
while(true){
if((i__28134 < size__21216__auto__)){
var style = cljs.core._nth.call(null,c__21215__auto__,i__28134);
cljs.core.chunk_append.call(null,b__28135,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__28139 = (i__28134 + (1));
i__28134 = G__28139;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28135),sablono$core$iter__28132.call(null,cljs.core.chunk_rest.call(null,s__28133__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28135),null);
}
} else {
var style = cljs.core.first.call(null,s__28133__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__28132.call(null,cljs.core.rest.call(null,s__28133__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq28131){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28131));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to28140 = (function sablono$core$link_to28140(var_args){
var args__21583__auto__ = [];
var len__21576__auto___28143 = arguments.length;
var i__21577__auto___28144 = (0);
while(true){
if((i__21577__auto___28144 < len__21576__auto___28143)){
args__21583__auto__.push((arguments[i__21577__auto___28144]));

var G__28145 = (i__21577__auto___28144 + (1));
i__21577__auto___28144 = G__28145;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((1) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to28140.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21584__auto__);
});

sablono.core.link_to28140.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to28140.cljs$lang$maxFixedArity = (1);

sablono.core.link_to28140.cljs$lang$applyTo = (function (seq28141){
var G__28142 = cljs.core.first.call(null,seq28141);
var seq28141__$1 = cljs.core.next.call(null,seq28141);
return sablono.core.link_to28140.cljs$core$IFn$_invoke$arity$variadic(G__28142,seq28141__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to28140);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to28146 = (function sablono$core$mail_to28146(var_args){
var args__21583__auto__ = [];
var len__21576__auto___28153 = arguments.length;
var i__21577__auto___28154 = (0);
while(true){
if((i__21577__auto___28154 < len__21576__auto___28153)){
args__21583__auto__.push((arguments[i__21577__auto___28154]));

var G__28155 = (i__21577__auto___28154 + (1));
i__21577__auto___28154 = G__28155;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((1) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to28146.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21584__auto__);
});

sablono.core.mail_to28146.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__28149){
var vec__28150 = p__28149;
var content = cljs.core.nth.call(null,vec__28150,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__20360__auto__ = content;
if(cljs.core.truth_(or__20360__auto__)){
return or__20360__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to28146.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to28146.cljs$lang$applyTo = (function (seq28147){
var G__28148 = cljs.core.first.call(null,seq28147);
var seq28147__$1 = cljs.core.next.call(null,seq28147);
return sablono.core.mail_to28146.cljs$core$IFn$_invoke$arity$variadic(G__28148,seq28147__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to28146);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list28156 = (function sablono$core$unordered_list28156(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__21217__auto__ = (function sablono$core$unordered_list28156_$_iter__28161(s__28162){
return (new cljs.core.LazySeq(null,(function (){
var s__28162__$1 = s__28162;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__28162__$1);
if(temp__6753__auto__){
var s__28162__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__28162__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__28162__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__28164 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__28163 = (0);
while(true){
if((i__28163 < size__21216__auto__)){
var x = cljs.core._nth.call(null,c__21215__auto__,i__28163);
cljs.core.chunk_append.call(null,b__28164,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__28165 = (i__28163 + (1));
i__28163 = G__28165;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28164),sablono$core$unordered_list28156_$_iter__28161.call(null,cljs.core.chunk_rest.call(null,s__28162__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28164),null);
}
} else {
var x = cljs.core.first.call(null,s__28162__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list28156_$_iter__28161.call(null,cljs.core.rest.call(null,s__28162__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list28156);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list28166 = (function sablono$core$ordered_list28166(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__21217__auto__ = (function sablono$core$ordered_list28166_$_iter__28171(s__28172){
return (new cljs.core.LazySeq(null,(function (){
var s__28172__$1 = s__28172;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__28172__$1);
if(temp__6753__auto__){
var s__28172__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__28172__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__28172__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__28174 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__28173 = (0);
while(true){
if((i__28173 < size__21216__auto__)){
var x = cljs.core._nth.call(null,c__21215__auto__,i__28173);
cljs.core.chunk_append.call(null,b__28174,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__28175 = (i__28173 + (1));
i__28173 = G__28175;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28174),sablono$core$ordered_list28166_$_iter__28171.call(null,cljs.core.chunk_rest.call(null,s__28172__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28174),null);
}
} else {
var x = cljs.core.first.call(null,s__28172__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list28166_$_iter__28171.call(null,cljs.core.rest.call(null,s__28172__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list28166);
/**
 * Create an image element.
 */
sablono.core.image28176 = (function sablono$core$image28176(var_args){
var args28177 = [];
var len__21576__auto___28180 = arguments.length;
var i__21577__auto___28181 = (0);
while(true){
if((i__21577__auto___28181 < len__21576__auto___28180)){
args28177.push((arguments[i__21577__auto___28181]));

var G__28182 = (i__21577__auto___28181 + (1));
i__21577__auto___28181 = G__28182;
continue;
} else {
}
break;
}

var G__28179 = args28177.length;
switch (G__28179) {
case 1:
return sablono.core.image28176.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image28176.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28177.length)].join('')));

}
});

sablono.core.image28176.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image28176.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image28176.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image28176);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__28184_SHARP_,p2__28185_SHARP_){
return [cljs.core.str(p1__28184_SHARP_),cljs.core.str("["),cljs.core.str(p2__28185_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__28186_SHARP_,p2__28187_SHARP_){
return [cljs.core.str(p1__28186_SHARP_),cljs.core.str("-"),cljs.core.str(p2__28187_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field28188 = (function sablono$core$color_field28188(var_args){
var args28189 = [];
var len__21576__auto___28256 = arguments.length;
var i__21577__auto___28257 = (0);
while(true){
if((i__21577__auto___28257 < len__21576__auto___28256)){
args28189.push((arguments[i__21577__auto___28257]));

var G__28258 = (i__21577__auto___28257 + (1));
i__21577__auto___28257 = G__28258;
continue;
} else {
}
break;
}

var G__28191 = args28189.length;
switch (G__28191) {
case 1:
return sablono.core.color_field28188.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field28188.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28189.length)].join('')));

}
});

sablono.core.color_field28188.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.color_field28188.call(null,name__28103__auto__,null);
});

sablono.core.color_field28188.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.color_field28188.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field28188);

/**
 * Creates a date input field.
 */
sablono.core.date_field28192 = (function sablono$core$date_field28192(var_args){
var args28193 = [];
var len__21576__auto___28260 = arguments.length;
var i__21577__auto___28261 = (0);
while(true){
if((i__21577__auto___28261 < len__21576__auto___28260)){
args28193.push((arguments[i__21577__auto___28261]));

var G__28262 = (i__21577__auto___28261 + (1));
i__21577__auto___28261 = G__28262;
continue;
} else {
}
break;
}

var G__28195 = args28193.length;
switch (G__28195) {
case 1:
return sablono.core.date_field28192.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field28192.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28193.length)].join('')));

}
});

sablono.core.date_field28192.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.date_field28192.call(null,name__28103__auto__,null);
});

sablono.core.date_field28192.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.date_field28192.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field28192);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field28196 = (function sablono$core$datetime_field28196(var_args){
var args28197 = [];
var len__21576__auto___28264 = arguments.length;
var i__21577__auto___28265 = (0);
while(true){
if((i__21577__auto___28265 < len__21576__auto___28264)){
args28197.push((arguments[i__21577__auto___28265]));

var G__28266 = (i__21577__auto___28265 + (1));
i__21577__auto___28265 = G__28266;
continue;
} else {
}
break;
}

var G__28199 = args28197.length;
switch (G__28199) {
case 1:
return sablono.core.datetime_field28196.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field28196.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28197.length)].join('')));

}
});

sablono.core.datetime_field28196.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.datetime_field28196.call(null,name__28103__auto__,null);
});

sablono.core.datetime_field28196.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.datetime_field28196.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field28196);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field28200 = (function sablono$core$datetime_local_field28200(var_args){
var args28201 = [];
var len__21576__auto___28268 = arguments.length;
var i__21577__auto___28269 = (0);
while(true){
if((i__21577__auto___28269 < len__21576__auto___28268)){
args28201.push((arguments[i__21577__auto___28269]));

var G__28270 = (i__21577__auto___28269 + (1));
i__21577__auto___28269 = G__28270;
continue;
} else {
}
break;
}

var G__28203 = args28201.length;
switch (G__28203) {
case 1:
return sablono.core.datetime_local_field28200.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field28200.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28201.length)].join('')));

}
});

sablono.core.datetime_local_field28200.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.datetime_local_field28200.call(null,name__28103__auto__,null);
});

sablono.core.datetime_local_field28200.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.datetime_local_field28200.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field28200);

/**
 * Creates a email input field.
 */
sablono.core.email_field28204 = (function sablono$core$email_field28204(var_args){
var args28205 = [];
var len__21576__auto___28272 = arguments.length;
var i__21577__auto___28273 = (0);
while(true){
if((i__21577__auto___28273 < len__21576__auto___28272)){
args28205.push((arguments[i__21577__auto___28273]));

var G__28274 = (i__21577__auto___28273 + (1));
i__21577__auto___28273 = G__28274;
continue;
} else {
}
break;
}

var G__28207 = args28205.length;
switch (G__28207) {
case 1:
return sablono.core.email_field28204.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field28204.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28205.length)].join('')));

}
});

sablono.core.email_field28204.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.email_field28204.call(null,name__28103__auto__,null);
});

sablono.core.email_field28204.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.email_field28204.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field28204);

/**
 * Creates a file input field.
 */
sablono.core.file_field28208 = (function sablono$core$file_field28208(var_args){
var args28209 = [];
var len__21576__auto___28276 = arguments.length;
var i__21577__auto___28277 = (0);
while(true){
if((i__21577__auto___28277 < len__21576__auto___28276)){
args28209.push((arguments[i__21577__auto___28277]));

var G__28278 = (i__21577__auto___28277 + (1));
i__21577__auto___28277 = G__28278;
continue;
} else {
}
break;
}

var G__28211 = args28209.length;
switch (G__28211) {
case 1:
return sablono.core.file_field28208.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field28208.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28209.length)].join('')));

}
});

sablono.core.file_field28208.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.file_field28208.call(null,name__28103__auto__,null);
});

sablono.core.file_field28208.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.file_field28208.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field28208);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field28212 = (function sablono$core$hidden_field28212(var_args){
var args28213 = [];
var len__21576__auto___28280 = arguments.length;
var i__21577__auto___28281 = (0);
while(true){
if((i__21577__auto___28281 < len__21576__auto___28280)){
args28213.push((arguments[i__21577__auto___28281]));

var G__28282 = (i__21577__auto___28281 + (1));
i__21577__auto___28281 = G__28282;
continue;
} else {
}
break;
}

var G__28215 = args28213.length;
switch (G__28215) {
case 1:
return sablono.core.hidden_field28212.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field28212.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28213.length)].join('')));

}
});

sablono.core.hidden_field28212.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.hidden_field28212.call(null,name__28103__auto__,null);
});

sablono.core.hidden_field28212.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.hidden_field28212.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field28212);

/**
 * Creates a month input field.
 */
sablono.core.month_field28216 = (function sablono$core$month_field28216(var_args){
var args28217 = [];
var len__21576__auto___28284 = arguments.length;
var i__21577__auto___28285 = (0);
while(true){
if((i__21577__auto___28285 < len__21576__auto___28284)){
args28217.push((arguments[i__21577__auto___28285]));

var G__28286 = (i__21577__auto___28285 + (1));
i__21577__auto___28285 = G__28286;
continue;
} else {
}
break;
}

var G__28219 = args28217.length;
switch (G__28219) {
case 1:
return sablono.core.month_field28216.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field28216.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28217.length)].join('')));

}
});

sablono.core.month_field28216.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.month_field28216.call(null,name__28103__auto__,null);
});

sablono.core.month_field28216.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.month_field28216.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field28216);

/**
 * Creates a number input field.
 */
sablono.core.number_field28220 = (function sablono$core$number_field28220(var_args){
var args28221 = [];
var len__21576__auto___28288 = arguments.length;
var i__21577__auto___28289 = (0);
while(true){
if((i__21577__auto___28289 < len__21576__auto___28288)){
args28221.push((arguments[i__21577__auto___28289]));

var G__28290 = (i__21577__auto___28289 + (1));
i__21577__auto___28289 = G__28290;
continue;
} else {
}
break;
}

var G__28223 = args28221.length;
switch (G__28223) {
case 1:
return sablono.core.number_field28220.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field28220.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28221.length)].join('')));

}
});

sablono.core.number_field28220.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.number_field28220.call(null,name__28103__auto__,null);
});

sablono.core.number_field28220.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.number_field28220.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field28220);

/**
 * Creates a password input field.
 */
sablono.core.password_field28224 = (function sablono$core$password_field28224(var_args){
var args28225 = [];
var len__21576__auto___28292 = arguments.length;
var i__21577__auto___28293 = (0);
while(true){
if((i__21577__auto___28293 < len__21576__auto___28292)){
args28225.push((arguments[i__21577__auto___28293]));

var G__28294 = (i__21577__auto___28293 + (1));
i__21577__auto___28293 = G__28294;
continue;
} else {
}
break;
}

var G__28227 = args28225.length;
switch (G__28227) {
case 1:
return sablono.core.password_field28224.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field28224.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28225.length)].join('')));

}
});

sablono.core.password_field28224.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.password_field28224.call(null,name__28103__auto__,null);
});

sablono.core.password_field28224.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.password_field28224.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field28224);

/**
 * Creates a range input field.
 */
sablono.core.range_field28228 = (function sablono$core$range_field28228(var_args){
var args28229 = [];
var len__21576__auto___28296 = arguments.length;
var i__21577__auto___28297 = (0);
while(true){
if((i__21577__auto___28297 < len__21576__auto___28296)){
args28229.push((arguments[i__21577__auto___28297]));

var G__28298 = (i__21577__auto___28297 + (1));
i__21577__auto___28297 = G__28298;
continue;
} else {
}
break;
}

var G__28231 = args28229.length;
switch (G__28231) {
case 1:
return sablono.core.range_field28228.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field28228.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28229.length)].join('')));

}
});

sablono.core.range_field28228.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.range_field28228.call(null,name__28103__auto__,null);
});

sablono.core.range_field28228.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.range_field28228.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field28228);

/**
 * Creates a search input field.
 */
sablono.core.search_field28232 = (function sablono$core$search_field28232(var_args){
var args28233 = [];
var len__21576__auto___28300 = arguments.length;
var i__21577__auto___28301 = (0);
while(true){
if((i__21577__auto___28301 < len__21576__auto___28300)){
args28233.push((arguments[i__21577__auto___28301]));

var G__28302 = (i__21577__auto___28301 + (1));
i__21577__auto___28301 = G__28302;
continue;
} else {
}
break;
}

var G__28235 = args28233.length;
switch (G__28235) {
case 1:
return sablono.core.search_field28232.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field28232.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28233.length)].join('')));

}
});

sablono.core.search_field28232.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.search_field28232.call(null,name__28103__auto__,null);
});

sablono.core.search_field28232.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.search_field28232.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field28232);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field28236 = (function sablono$core$tel_field28236(var_args){
var args28237 = [];
var len__21576__auto___28304 = arguments.length;
var i__21577__auto___28305 = (0);
while(true){
if((i__21577__auto___28305 < len__21576__auto___28304)){
args28237.push((arguments[i__21577__auto___28305]));

var G__28306 = (i__21577__auto___28305 + (1));
i__21577__auto___28305 = G__28306;
continue;
} else {
}
break;
}

var G__28239 = args28237.length;
switch (G__28239) {
case 1:
return sablono.core.tel_field28236.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field28236.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28237.length)].join('')));

}
});

sablono.core.tel_field28236.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.tel_field28236.call(null,name__28103__auto__,null);
});

sablono.core.tel_field28236.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.tel_field28236.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field28236);

/**
 * Creates a text input field.
 */
sablono.core.text_field28240 = (function sablono$core$text_field28240(var_args){
var args28241 = [];
var len__21576__auto___28308 = arguments.length;
var i__21577__auto___28309 = (0);
while(true){
if((i__21577__auto___28309 < len__21576__auto___28308)){
args28241.push((arguments[i__21577__auto___28309]));

var G__28310 = (i__21577__auto___28309 + (1));
i__21577__auto___28309 = G__28310;
continue;
} else {
}
break;
}

var G__28243 = args28241.length;
switch (G__28243) {
case 1:
return sablono.core.text_field28240.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field28240.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28241.length)].join('')));

}
});

sablono.core.text_field28240.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.text_field28240.call(null,name__28103__auto__,null);
});

sablono.core.text_field28240.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.text_field28240.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field28240);

/**
 * Creates a time input field.
 */
sablono.core.time_field28244 = (function sablono$core$time_field28244(var_args){
var args28245 = [];
var len__21576__auto___28312 = arguments.length;
var i__21577__auto___28313 = (0);
while(true){
if((i__21577__auto___28313 < len__21576__auto___28312)){
args28245.push((arguments[i__21577__auto___28313]));

var G__28314 = (i__21577__auto___28313 + (1));
i__21577__auto___28313 = G__28314;
continue;
} else {
}
break;
}

var G__28247 = args28245.length;
switch (G__28247) {
case 1:
return sablono.core.time_field28244.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field28244.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28245.length)].join('')));

}
});

sablono.core.time_field28244.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.time_field28244.call(null,name__28103__auto__,null);
});

sablono.core.time_field28244.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.time_field28244.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field28244);

/**
 * Creates a url input field.
 */
sablono.core.url_field28248 = (function sablono$core$url_field28248(var_args){
var args28249 = [];
var len__21576__auto___28316 = arguments.length;
var i__21577__auto___28317 = (0);
while(true){
if((i__21577__auto___28317 < len__21576__auto___28316)){
args28249.push((arguments[i__21577__auto___28317]));

var G__28318 = (i__21577__auto___28317 + (1));
i__21577__auto___28317 = G__28318;
continue;
} else {
}
break;
}

var G__28251 = args28249.length;
switch (G__28251) {
case 1:
return sablono.core.url_field28248.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field28248.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28249.length)].join('')));

}
});

sablono.core.url_field28248.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.url_field28248.call(null,name__28103__auto__,null);
});

sablono.core.url_field28248.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.url_field28248.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field28248);

/**
 * Creates a week input field.
 */
sablono.core.week_field28252 = (function sablono$core$week_field28252(var_args){
var args28253 = [];
var len__21576__auto___28320 = arguments.length;
var i__21577__auto___28321 = (0);
while(true){
if((i__21577__auto___28321 < len__21576__auto___28320)){
args28253.push((arguments[i__21577__auto___28321]));

var G__28322 = (i__21577__auto___28321 + (1));
i__21577__auto___28321 = G__28322;
continue;
} else {
}
break;
}

var G__28255 = args28253.length;
switch (G__28255) {
case 1:
return sablono.core.week_field28252.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field28252.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28253.length)].join('')));

}
});

sablono.core.week_field28252.cljs$core$IFn$_invoke$arity$1 = (function (name__28103__auto__){
return sablono.core.week_field28252.call(null,name__28103__auto__,null);
});

sablono.core.week_field28252.cljs$core$IFn$_invoke$arity$2 = (function (name__28103__auto__,value__28104__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__28103__auto__,value__28104__auto__);
});

sablono.core.week_field28252.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field28252);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box28324 = (function sablono$core$check_box28324(var_args){
var args28325 = [];
var len__21576__auto___28328 = arguments.length;
var i__21577__auto___28329 = (0);
while(true){
if((i__21577__auto___28329 < len__21576__auto___28328)){
args28325.push((arguments[i__21577__auto___28329]));

var G__28330 = (i__21577__auto___28329 + (1));
i__21577__auto___28329 = G__28330;
continue;
} else {
}
break;
}

var G__28327 = args28325.length;
switch (G__28327) {
case 1:
return sablono.core.check_box28324.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box28324.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box28324.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28325.length)].join('')));

}
});

sablono.core.check_box28324.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box28324.call(null,name,null);
});

sablono.core.check_box28324.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box28324.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box28324.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box28324.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box28324);
/**
 * Creates a radio button.
 */
sablono.core.radio_button28332 = (function sablono$core$radio_button28332(var_args){
var args28333 = [];
var len__21576__auto___28336 = arguments.length;
var i__21577__auto___28337 = (0);
while(true){
if((i__21577__auto___28337 < len__21576__auto___28336)){
args28333.push((arguments[i__21577__auto___28337]));

var G__28338 = (i__21577__auto___28337 + (1));
i__21577__auto___28337 = G__28338;
continue;
} else {
}
break;
}

var G__28335 = args28333.length;
switch (G__28335) {
case 1:
return sablono.core.radio_button28332.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button28332.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button28332.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28333.length)].join('')));

}
});

sablono.core.radio_button28332.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button28332.call(null,group,null);
});

sablono.core.radio_button28332.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button28332.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button28332.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button28332.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button28332);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options28340 = (function sablono$core$select_options28340(coll){
var iter__21217__auto__ = (function sablono$core$select_options28340_$_iter__28357(s__28358){
return (new cljs.core.LazySeq(null,(function (){
var s__28358__$1 = s__28358;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__28358__$1);
if(temp__6753__auto__){
var s__28358__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__28358__$2)){
var c__21215__auto__ = cljs.core.chunk_first.call(null,s__28358__$2);
var size__21216__auto__ = cljs.core.count.call(null,c__21215__auto__);
var b__28360 = cljs.core.chunk_buffer.call(null,size__21216__auto__);
if((function (){var i__28359 = (0);
while(true){
if((i__28359 < size__21216__auto__)){
var x = cljs.core._nth.call(null,c__21215__auto__,i__28359);
cljs.core.chunk_append.call(null,b__28360,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__28367 = x;
var text = cljs.core.nth.call(null,vec__28367,(0),null);
var val = cljs.core.nth.call(null,vec__28367,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__28367,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options28340.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__28373 = (i__28359 + (1));
i__28359 = G__28373;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28360),sablono$core$select_options28340_$_iter__28357.call(null,cljs.core.chunk_rest.call(null,s__28358__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__28360),null);
}
} else {
var x = cljs.core.first.call(null,s__28358__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__28370 = x;
var text = cljs.core.nth.call(null,vec__28370,(0),null);
var val = cljs.core.nth.call(null,vec__28370,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__28370,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options28340.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options28340_$_iter__28357.call(null,cljs.core.rest.call(null,s__28358__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__21217__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options28340);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down28374 = (function sablono$core$drop_down28374(var_args){
var args28375 = [];
var len__21576__auto___28378 = arguments.length;
var i__21577__auto___28379 = (0);
while(true){
if((i__21577__auto___28379 < len__21576__auto___28378)){
args28375.push((arguments[i__21577__auto___28379]));

var G__28380 = (i__21577__auto___28379 + (1));
i__21577__auto___28379 = G__28380;
continue;
} else {
}
break;
}

var G__28377 = args28375.length;
switch (G__28377) {
case 2:
return sablono.core.drop_down28374.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down28374.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28375.length)].join('')));

}
});

sablono.core.drop_down28374.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down28374.call(null,name,options,null);
});

sablono.core.drop_down28374.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down28374.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down28374);
/**
 * Creates a text area element.
 */
sablono.core.text_area28382 = (function sablono$core$text_area28382(var_args){
var args28383 = [];
var len__21576__auto___28386 = arguments.length;
var i__21577__auto___28387 = (0);
while(true){
if((i__21577__auto___28387 < len__21576__auto___28386)){
args28383.push((arguments[i__21577__auto___28387]));

var G__28388 = (i__21577__auto___28387 + (1));
i__21577__auto___28387 = G__28388;
continue;
} else {
}
break;
}

var G__28385 = args28383.length;
switch (G__28385) {
case 1:
return sablono.core.text_area28382.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area28382.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28383.length)].join('')));

}
});

sablono.core.text_area28382.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area28382.call(null,name,null);
});

sablono.core.text_area28382.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area28382.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area28382);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label28390 = (function sablono$core$label28390(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label28390);
/**
 * Creates a submit button.
 */
sablono.core.submit_button28391 = (function sablono$core$submit_button28391(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button28391);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button28392 = (function sablono$core$reset_button28392(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button28392);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to28393 = (function sablono$core$form_to28393(var_args){
var args__21583__auto__ = [];
var len__21576__auto___28400 = arguments.length;
var i__21577__auto___28401 = (0);
while(true){
if((i__21577__auto___28401 < len__21576__auto___28400)){
args__21583__auto__.push((arguments[i__21577__auto___28401]));

var G__28402 = (i__21577__auto___28401 + (1));
i__21577__auto___28401 = G__28402;
continue;
} else {
}
break;
}

var argseq__21584__auto__ = ((((1) < args__21583__auto__.length))?(new cljs.core.IndexedSeq(args__21583__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to28393.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21584__auto__);
});

sablono.core.form_to28393.cljs$core$IFn$_invoke$arity$variadic = (function (p__28396,body){
var vec__28397 = p__28396;
var method = cljs.core.nth.call(null,vec__28397,(0),null);
var action = cljs.core.nth.call(null,vec__28397,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to28393.cljs$lang$maxFixedArity = (1);

sablono.core.form_to28393.cljs$lang$applyTo = (function (seq28394){
var G__28395 = cljs.core.first.call(null,seq28394);
var seq28394__$1 = cljs.core.next.call(null,seq28394);
return sablono.core.form_to28393.cljs$core$IFn$_invoke$arity$variadic(G__28395,seq28394__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to28393);

//# sourceMappingURL=core.js.map