/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.fs.AdversarialFileDispatcherFactory;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.StoreFileChannelUnwrapper;
import sun.nio.ch.FileChannelImpl;

public class AdversarialFileChannel
implements StoreChannel {
    public static volatile boolean useAdversarialFileDispatcherHack;
    private final StoreChannel delegate;
    private final Adversary adversary;

    public static StoreChannel wrap(StoreChannel channel, Adversary adversary) {
        FileChannel innerChannel;
        if (useAdversarialFileDispatcherHack && channel.getClass() == StoreFileChannel.class && (innerChannel = StoreFileChannelUnwrapper.unwrap(channel)).getClass() == FileChannelImpl.class) {
            FileChannelImpl channelImpl = (FileChannelImpl)innerChannel;
            try {
                Field nd = FileChannelImpl.class.getDeclaredField("nd");
                nd.setAccessible(true);
                Object fileDispatcher = nd.get(channelImpl);
                nd.set(channelImpl, AdversarialFileDispatcherFactory.makeFileDispatcherAdversarial(fileDispatcher, adversary));
                return new StoreFileChannel(innerChannel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new AdversarialFileChannel(channel, adversary);
    }

    private AdversarialFileChannel(StoreChannel channel, Adversary adversary) {
        this.delegate = channel;
        this.adversary = adversary;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer mischievousBuffer = srcs[srcs.length - 1];
            int oldLimit = this.mischiefLimit(mischievousBuffer);
            long written = this.delegate.write(srcs);
            mischievousBuffer.limit(oldLimit);
            return written;
        }
        return this.delegate.write(srcs);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(src);
            int written = this.delegate.write(src, position);
            src.limit(oldLimit);
            return written;
        }
        return this.delegate.write(src, position);
    }

    @Override
    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.writeAll(src, position);
    }

    @Override
    public void writeAll(ByteBuffer src) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.writeAll(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            length = length == 1 ? 1 : length / 2;
            ByteBuffer mischievousBuffer = srcs[offset + length - 1];
            int oldLimit = this.mischiefLimit(mischievousBuffer);
            long written = this.delegate.write(srcs, offset, length);
            mischievousBuffer.limit(oldLimit);
            return written;
        }
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public StoreChannel truncate(long size) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.truncate(size);
    }

    @Override
    public StoreChannel position(long newPosition) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.position(newPosition);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(dst);
            int read = this.delegate.read(dst, position);
            dst.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dst, position);
    }

    private int mischiefLimit(ByteBuffer buf) {
        int oldLimit = buf.limit();
        int newLimit = oldLimit - buf.remaining() / 2;
        buf.limit(newLimit);
        return oldLimit;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.force(metaData);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(dst);
            int read = this.delegate.read(dst);
            dst.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = this.mischiefLimit(lastBuf);
            long read = this.delegate.read(dsts, offset, length);
            lastBuf.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public long position() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.position();
    }

    @Override
    public FileLock tryLock() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.tryLock();
    }

    @Override
    public boolean isOpen() {
        this.adversary.injectFailure(new Class[0]);
        return this.delegate.isOpen();
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = this.mischiefLimit(lastBuf);
            long read = this.delegate.read(dsts);
            lastBuf.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dsts);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(src);
            int written = this.delegate.write(src);
            src.limit(oldLimit);
            return written;
        }
        return this.delegate.write(src);
    }

    @Override
    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.close();
    }

    @Override
    public long size() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.size();
    }

    @Override
    public void flush() throws IOException {
        this.force(false);
    }
}

