/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.fs.AdversarialFileChannel;
import org.neo4j.adversaries.fs.AdversarialInputStream;
import org.neo4j.adversaries.fs.AdversarialOutputStream;
import org.neo4j.adversaries.fs.AdversarialReader;
import org.neo4j.adversaries.fs.AdversarialWriter;
import org.neo4j.function.Function;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;

public class AdversarialFileSystemAbstraction
implements FileSystemAbstraction {
    private final FileSystemAbstraction delegate;
    private final Adversary adversary;
    private final Map<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem> thirdPartyFileSystems = new HashMap<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem>();

    public AdversarialFileSystemAbstraction(Adversary adversary) {
        this(adversary, new DefaultFileSystemAbstraction());
    }

    public AdversarialFileSystemAbstraction(Adversary adversary, FileSystemAbstraction delegate) {
        this.adversary = adversary;
        this.delegate = delegate;
    }

    @Override
    public StoreChannel open(File fileName, String mode) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        return AdversarialFileChannel.wrap(this.delegate.open(fileName, mode), this.adversary);
    }

    @Override
    public boolean renameFile(File from, File to) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, SecurityException.class);
        return this.delegate.renameFile(from, to);
    }

    @Override
    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, SecurityException.class);
        return new AdversarialOutputStream(this.delegate.openAsOutputStream(fileName, append), this.adversary);
    }

    @Override
    public StoreChannel create(File fileName) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        return AdversarialFileChannel.wrap(this.delegate.create(fileName), this.adversary);
    }

    @Override
    public boolean mkdir(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.mkdir(fileName);
    }

    @Override
    public File[] listFiles(File directory) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.listFiles(directory);
    }

    @Override
    public File[] listFiles(File directory, FilenameFilter filter) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.listFiles(directory, filter);
    }

    @Override
    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        this.adversary.injectFailure(UnsupportedEncodingException.class, FileNotFoundException.class, SecurityException.class);
        return new AdversarialWriter(this.delegate.openAsWriter(fileName, encoding, append), this.adversary);
    }

    @Override
    public Reader openAsReader(File fileName, String encoding) throws IOException {
        this.adversary.injectFailure(UnsupportedEncodingException.class, FileNotFoundException.class, SecurityException.class);
        return new AdversarialReader(this.delegate.openAsReader(fileName, encoding), this.adversary);
    }

    @Override
    public long getFileSize(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.getFileSize(fileName);
    }

    @Override
    public void copyFile(File from, File to) throws IOException {
        this.adversary.injectFailure(SecurityException.class, FileNotFoundException.class, IOException.class);
        this.delegate.copyFile(from, to);
    }

    @Override
    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IOException.class, NullPointerException.class);
        this.delegate.copyRecursively(fromDirectory, toDirectory);
    }

    @Override
    public boolean deleteFile(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.deleteFile(fileName);
    }

    @Override
    public InputStream openAsInputStream(File fileName) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, SecurityException.class);
        return new AdversarialInputStream(this.delegate.openAsInputStream(fileName), this.adversary);
    }

    @Override
    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IllegalArgumentException.class, FileNotFoundException.class, NullPointerException.class, IOException.class);
        this.delegate.moveToDirectory(file, toDirectory);
    }

    @Override
    public boolean isDirectory(File file) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.isDirectory(file);
    }

    @Override
    public boolean fileExists(File fileName) {
        this.adversary.injectFailure(SecurityException.class);
        return this.delegate.fileExists(fileName);
    }

    @Override
    public void mkdirs(File fileName) throws IOException {
        this.adversary.injectFailure(SecurityException.class, IOException.class);
        this.delegate.mkdirs(fileName);
    }

    @Override
    public void deleteRecursively(File directory) throws IOException {
        this.adversary.injectFailure(SecurityException.class, NullPointerException.class, IOException.class);
        this.delegate.deleteRecursively(directory);
    }

    @Override
    public synchronized <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        FileSystemAbstraction.ThirdPartyFileSystem fileSystem = this.thirdPartyFileSystems.get(clazz);
        if (fileSystem == null) {
            fileSystem = (FileSystemAbstraction.ThirdPartyFileSystem)creator.apply(clazz);
            fileSystem = this.adversarialProxy(fileSystem, clazz);
            this.thirdPartyFileSystems.put(clazz, fileSystem);
        }
        return (K)fileSystem;
    }

    @Override
    public void truncate(File path, long size) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, IllegalArgumentException.class, SecurityException.class, NullPointerException.class);
        this.delegate.truncate(path, size);
    }

    private <K extends FileSystemAbstraction.ThirdPartyFileSystem> FileSystemAbstraction.ThirdPartyFileSystem adversarialProxy(final FileSystemAbstraction.ThirdPartyFileSystem fileSystem, Class<K> clazz) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                AdversarialFileSystemAbstraction.this.adversary.injectFailure(method.getExceptionTypes());
                return method.invoke((Object)fileSystem, args);
            }
        };
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return (FileSystemAbstraction.ThirdPartyFileSystem)Proxy.newProxyInstance(loader, new Class[]{clazz}, handler);
    }
}

