/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.randomharness.Command;
import org.neo4j.io.pagecache.randomharness.PageCountRecordFormat;
import org.neo4j.io.pagecache.randomharness.Phase;
import org.neo4j.io.pagecache.randomharness.RandomPageCacheTestHarness;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.RecordFormat;
import org.neo4j.io.pagecache.randomharness.StandardRecordFormat;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.test.ByteArrayMatcher;
import org.neo4j.test.LinearHistoryPageCacheTracer;
import org.neo4j.test.RepeatRule;
import org.neo4j.test.ThreadTestUtils;

public abstract class PageCacheTest<T extends PageCache> {
    protected static final long SHORT_TIMEOUT_MILLIS = 10000L;
    protected static final long SEMI_LONG_TIMEOUT_MILLIS = 60000L;
    protected static final long LONG_TIMEOUT_MILLIS = 360000L;
    protected static ExecutorService executor;
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    protected int recordSize = 9;
    protected int maxPages = 20;
    protected int pageCachePageSize = 32;
    protected int recordsPerFilePage = this.pageCachePageSize / this.recordSize;
    protected int recordCount = 25 * this.maxPages * this.recordsPerFilePage;
    protected int filePageSize = this.recordsPerFilePage * this.recordSize;
    protected ByteBuffer bufA = ByteBuffer.allocate(this.recordSize);
    protected FileSystemAbstraction fs;
    private T pageCache;

    @BeforeClass
    public static void enablePinUnpinMonitoring() {
        DefaultPageCacheTracer.enablePinUnpinTracing();
    }

    @BeforeClass
    public static void startExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void stopExecutor() {
        executor.shutdown();
    }

    protected File file(String pathname) {
        return new File(pathname);
    }

    protected abstract T createPageCache(PageSwapperFactory var1, int var2, int var3, PageCacheTracer var4);

    protected T createPageCache(FileSystemAbstraction fs, int maxPages, int pageSize, PageCacheTracer tracer) {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.setFileSystemAbstraction(fs);
        return this.createPageCache(swapperFactory, maxPages, pageSize, tracer);
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new EphemeralFileSystemAbstraction();
    }

    protected abstract void tearDownPageCache(T var1) throws IOException;

    protected final T getPageCache(FileSystemAbstraction fs, int maxPages, int pageSize, PageCacheTracer tracer) throws IOException {
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.pageCache = this.createPageCache(fs, maxPages, pageSize, tracer);
        return this.pageCache;
    }

    @Before
    public void setUp() throws IOException {
        Thread.interrupted();
        this.fs = this.createFileSystemAbstraction();
        this.ensureExists(this.file("a"));
    }

    protected void ensureExists(File file) throws IOException {
        this.fs.create(file).close();
    }

    protected File existingFile(String name) throws IOException {
        File file = this.file(name);
        this.ensureExists(file);
        return file;
    }

    @After
    public void tearDown() throws IOException {
        Thread.interrupted();
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        if (this.fs instanceof EphemeralFileSystemAbstraction) {
            ((EphemeralFileSystemAbstraction)this.fs).shutdown();
        }
    }

    protected void verifyRecordsMatchExpected(PageCursor cursor) throws IOException {
        ByteBuffer expectedPageContents = ByteBuffer.allocate(this.filePageSize);
        ByteBuffer actualPageContents = ByteBuffer.allocate(this.filePageSize);
        byte[] record = new byte[this.recordSize];
        long pageId = cursor.getCurrentPageId();
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = pageId * (long)this.recordsPerFilePage + (long)i;
            expectedPageContents.position(this.recordSize * i);
            PageCacheTest.generateRecordForId(recordId, expectedPageContents.slice());
            do {
                cursor.setOffset(this.recordSize * i);
                cursor.getBytes(record);
            } while (cursor.shouldRetry());
            actualPageContents.position(this.recordSize * i);
            actualPageContents.put(record);
        }
        this.assertRecord(pageId, actualPageContents, expectedPageContents);
    }

    protected void assertRecord(long pageId, ByteBuffer actualPageContents, ByteBuffer expectedPageContents) {
        byte[] actualBytes = actualPageContents.array();
        byte[] expectedBytes = expectedPageContents.array();
        int estimatedPageId = this.estimateId(actualBytes);
        Assert.assertThat((String)("Page id: " + pageId + " " + "(based on record data, it should have been " + estimatedPageId + ", a difference of " + Math.abs(pageId - (long)estimatedPageId) + ")"), (Object)actualBytes, (Matcher)ByteArrayMatcher.byteArray(expectedBytes));
    }

    protected int estimateId(byte[] record) {
        return ByteBuffer.wrap(record).getInt() - 1;
    }

    protected void writeRecords(PageCursor cursor) {
        cursor.setOffset(0);
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = cursor.getCurrentPageId() * (long)this.recordsPerFilePage + (long)i;
            PageCacheTest.generateRecordForId(recordId, this.bufA);
            cursor.putBytes(this.bufA.array());
        }
    }

    protected void generateFileWithRecords(File file, int recordCount, int recordSize) throws IOException {
        StoreChannel channel = this.fs.open(file, "rw");
        ByteBuffer buf = ByteBuffer.allocate(recordSize);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTest.generateRecordForId(i, buf);
            channel.writeAll(buf);
        }
        channel.close();
    }

    protected static void generateRecordForId(long id, ByteBuffer buf) {
        buf.position(0);
        int x = (int)(id + 1L);
        buf.putInt(x);
        while (buf.position() < buf.limit()) {
            buf.put((byte)(++x & 0xFF));
        }
        buf.position(0);
    }

    protected void verifyRecordsInFile(File file, int recordCount) throws IOException {
        StoreChannel channel = this.fs.open(file, "r");
        ByteBuffer buf = ByteBuffer.allocate(this.recordSize);
        ByteBuffer observation = ByteBuffer.allocate(this.recordSize);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTest.generateRecordForId(i, buf);
            observation.position(0);
            channel.read(observation);
            this.assertRecord(i, observation, buf);
        }
        channel.close();
    }

    protected Runnable $close(final PagedFile file) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    file.close();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    protected void assumeTrue(String description, boolean test) {
        if (!test) {
            throw new AssumptionViolatedException(description);
        }
    }

    @Test
    public void mustReportConfiguredMaxPages() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        Assert.assertThat((Object)this.pageCache.maxCachedPages(), (Matcher)Matchers.is((Object)this.maxPages));
    }

    @Test
    public void mustReportConfiguredCachePageSize() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        Assert.assertThat((Object)this.pageCache.pageSize(), (Matcher)Matchers.is((Object)this.pageCachePageSize));
    }

    @Test(expected=IllegalArgumentException.class)
    public void cachePageSizeMustBePowerOfTwo() throws IOException {
        this.getPageCache(this.fs, this.maxPages, 31, PageCacheTracer.NULL);
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustHaveAtLeastTwoPages() throws Exception {
        this.getPageCache(this.fs, 1, this.pageCachePageSize, PageCacheTracer.NULL);
    }

    @Test
    public void mustAcceptTwoPagesAsMinimumConfiguration() throws Exception {
        this.getPageCache(this.fs, 2, this.pageCachePageSize, PageCacheTracer.NULL);
    }

    @Test(timeout=10000L)
    public void mustReadExistingData() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        int recordId = 0;
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
                recordId += this.recordsPerFilePage;
            }
        }
        Assert.assertThat((Object)recordId, (Matcher)Matchers.is((Object)this.recordCount));
    }

    @Test(timeout=10000L)
    public void mustScanInTheMiddleOfTheFile() throws IOException {
        long startPage = 10L;
        long endPage = this.recordCount / this.recordsPerFilePage - 10;
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        int recordId = (int)(startPage * (long)this.recordsPerFilePage);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(startPage, 1);){
            while (cursor.next() && cursor.getCurrentPageId() < endPage) {
                this.verifyRecordsMatchExpected(cursor);
                recordId += this.recordsPerFilePage;
            }
        }
        Assert.assertThat((Object)recordId, (Matcher)Matchers.is((Object)(this.recordCount - 10 * this.recordsPerFilePage)));
    }

    @Test(timeout=60000L)
    public void writesFlushedFromPageFileMustBeExternallyObservable() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long startPageId = 0L;
        long endPageId = this.recordCount / this.recordsPerFilePage;
        try (PageCursor cursor = pagedFile.io(startPageId, 2);){
            while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        pagedFile.flushAndForce();
        this.verifyRecordsInFile(this.file("a"), this.recordCount);
        pagedFile.close();
    }

    @Test(timeout=60000L)
    public void repeatablyWritesFlushedFromPageFileMustBeExternallyObservable() throws IOException {
        for (int i = 0; i < 100; ++i) {
            this.tearDown();
            this.setUp();
            try {
                this.writesFlushedFromPageFileMustBeExternallyObservable();
                continue;
            }
            catch (Throwable e) {
                System.err.println("iteration " + i);
                System.err.flush();
                throw e;
            }
        }
    }

    @Test(timeout=360000L)
    public void writesFlushedFromPageFileMustBeObservableEvenWhenRacingWithEviction() throws IOException {
        T cache = this.getPageCache(this.fs, 20, this.pageCachePageSize, PageCacheTracer.NULL);
        long startPageId = 0L;
        long endPageId = 21L;
        int iterations = 10000;
        int shortsPerPage = this.pageCachePageSize / 2;
        try (PagedFile pagedFile = cache.map(this.file("a"), this.pageCachePageSize, new OpenOption[0]);){
            for (int i = 1; i <= iterations; ++i) {
                try (PageCursor cursor = pagedFile.io(startPageId, 2);){
                    while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                        for (int j = 0; j < shortsPerPage; ++j) {
                            cursor.putShort((short)i);
                        }
                    }
                }
                pagedFile.flushAndForce();
                var12_12 = null;
                try (DataInputStream stream = new DataInputStream(this.fs.openAsInputStream(this.file("a")));){
                    for (int j = 0; j < shortsPerPage; ++j) {
                        short value = stream.readShort();
                        Assert.assertThat((String)("short pos = " + j + ", iteration = " + i), (Object)value, (Matcher)Matchers.is((Object)i));
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    var12_12 = throwable;
                    throw throwable;
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void writesFlushedFromPageCacheMustBeExternallyObservable() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.recordSize);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        long startPageId = 0L;
        long endPageId = this.recordCount / this.recordsPerFilePage;
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(startPageId, 2);){
            while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        ByteBuffer observation = ByteBuffer.allocate(this.recordSize);
        for (int i = 0; i < this.recordCount; ++i) {
            PageCacheTest.generateRecordForId(i, buf);
            observation.position(0);
            channel.read(observation);
            this.assertRecord(i, observation, buf);
        }
        channel.close();
    }

    @Test(timeout=10000L)
    public void writesToPagesMustNotBleedIntoAdjacentPages() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            for (int i = 1; i <= 100; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                for (int j = 0; j < this.filePageSize; ++j) {
                    cursor.putByte((byte)i);
                }
            }
        }
        InputStream inputStream = this.fs.openAsInputStream(this.file("a"));
        for (int i = 1; i <= 100; ++i) {
            for (int j = 0; j < this.filePageSize; ++j) {
                Assert.assertThat((Object)inputStream.read(), (Matcher)Matchers.is((Object)i));
            }
        }
        inputStream.close();
    }

    @Test
    public void channelMustBeForcedAfterPagedFileFlushAndForce() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            pagedFile.flushAndForce();
            Assert.assertThat((Object)writeCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
            Assert.assertThat((Object)forceCounter.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    public void channelsMustBeForcedAfterPageCacheFlushAndForce() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFileA = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile pagedFileB = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFileA.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            cursor = pagedFileB.io(0L, 2);
            var9_13 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            catch (Throwable throwable) {
                var9_13 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var9_13 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var9_13.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            this.pageCache.flushAndForce();
            Assert.assertThat((Object)writeCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
            Assert.assertThat((Object)forceCounter.get(), (Matcher)Matchers.is((Object)2));
        }
    }

    private DelegatingFileSystemAbstraction writeAndForceCountingFs(final AtomicInteger writeCounter, final AtomicInteger forceCounter) {
        return new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        writeCounter.getAndIncrement();
                        super.writeAll(src, position);
                    }

                    @Override
                    public void force(boolean metaData) throws IOException {
                        forceCounter.getAndIncrement();
                        super.force(metaData);
                    }
                };
            }
        };
    }

    @Test(timeout=10000L)
    public void firstNextCallMustReturnFalseWhenTheFileIsEmptyAndNoGrowIsSpecified() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 6);){
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    @Test(timeout=10000L)
    public void nextMustReturnTrueThenFalseWhenThereIsOnlyOnePageInTheFileAndNoGrowIsSpecified() throws IOException {
        int numberOfRecordsToGenerate = this.recordsPerFilePage;
        this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 6);){
            Assert.assertTrue((boolean)cursor.next());
            this.verifyRecordsMatchExpected(cursor);
            Assert.assertFalse((boolean)cursor.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void closingWithoutCallingNextMustLeavePageUnpinnedAndUntouched() throws IOException {
        int numberOfRecordsToGenerate = this.recordsPerFilePage;
        this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor ignore = pagedFile.io(0L, 2);
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignore.close();
                }
            }
            throwable = null;
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                cursor.next();
                this.verifyRecordsMatchExpected(cursor);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Test(timeout=60000L)
    public void rewindMustStartScanningOverFromTheBeginning() throws IOException {
        int numberOfRewindsToTest = 10;
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        int actualPageCounter = 0;
        int filePageCount = this.recordCount / this.recordsPerFilePage;
        int expectedPageCounterResult = numberOfRewindsToTest * filePageCount;
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            for (int i = 0; i < numberOfRewindsToTest; ++i) {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    ++actualPageCounter;
                }
                cursor.rewind();
            }
        }
        Assert.assertThat((Object)actualPageCounter, (Matcher)Matchers.is((Object)expectedPageCounterResult));
    }

    @Test(timeout=10000L)
    public void mustCloseFileChannelWhenTheLastHandleIsUnmapped() throws Exception {
        this.assumeTrue("This depends on EphemeralFSA specific features", this.fs.getClass() == EphemeralFileSystemAbstraction.class);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile a = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PagedFile b = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        a.close();
        b.close();
        ((EphemeralFileSystemAbstraction)this.fs).assertNoOpenFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void dirtyPagesMustBeFlushedWhenTheCacheIsClosed() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        long startPageId = 0L;
        long endPageId = this.recordCount / this.recordsPerFilePage;
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(startPageId, 2);){
            while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        finally {
            this.pageCache.close();
        }
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        ByteBuffer observation = ByteBuffer.allocate(this.recordSize);
        for (int i = 0; i < this.recordCount; ++i) {
            PageCacheTest.generateRecordForId(i, buf);
            observation.position(0);
            channel.read(observation);
            this.assertRecord(i, observation, buf);
        }
        channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void flushingDuringPagedFileCloseMustRetryUntilItSucceeds() throws IOException {
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){
                    private int writeCount;
                    {
                        this.writeCount = 0;
                    }

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (this.writeCount++ < 10) {
                            throw new IOException("This is a benign exception that we expect to be thrown during a flush of a PagedFile.");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PrintStream oldSystemErr = System.err;
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            this.writeRecords(cursor);
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
        }
        finally {
            System.setErr(oldSystemErr);
        }
        this.verifyRecordsInFile(this.file("a"), this.recordsPerFilePage);
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void mappingFilesInClosedCacheMustThrow() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        cache.close();
        cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void flushingClosedCacheMustThrow() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        cache.close();
        cache.flushAndForce();
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void mappingFileWithPageSizeGreaterThanCachePageSizeMustThrow() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        cache.map(this.file("a"), this.pageCachePageSize + 1, new OpenOption[0]);
    }

    @Test(timeout=10000L)
    public void mappingFileWithPageSizeEqualToCachePageSizeMustNotThrow() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.pageCachePageSize, new OpenOption[0]);
        pagedFile.close();
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void notSpecifyingAnyPfFlagsMustThrow() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            pagedFile.io(0L, 0);
        }
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void notSpecifyingAnyPfLockFlagsMustThrow() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            pagedFile.io(0L, 16);
        }
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void specifyingBothSharedAndExclusiveLocksMustThrow() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            pagedFile.io(0L, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void mustNotPinPagesAfterNextReturnsFalse() throws Exception {
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch unpinLatch = new CountDownLatch(1);
        final AtomicReference exceptionRef = new AtomicReference();
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        final PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try (PageCursor cursorA = pagedFile.io(0L, 6);){
                    Assert.assertTrue((boolean)cursorA.next());
                    Assert.assertFalse((boolean)cursorA.next());
                    startLatch.countDown();
                    unpinLatch.await();
                    cursorA.close();
                }
                catch (Exception e) {
                    exceptionRef.set(e);
                }
            }
        };
        executor.submit(runnable);
        startLatch.await();
        try (PageCursor cursorB = pagedFile.io(1L, 2);){
            Assert.assertTrue((boolean)cursorB.next());
            unpinLatch.countDown();
        }
        finally {
            pagedFile.close();
        }
        Exception e = (Exception)exceptionRef.get();
        if (e != null) {
            throw new Exception("Child thread got exception", e);
        }
    }

    @Test(timeout=10000L)
    public void nextMustResetTheCursorOffset() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.setOffset(0);
                cursor.putByte((byte)1);
                cursor.putByte((byte)2);
                cursor.putByte((byte)3);
                cursor.putByte((byte)4);
            } while (cursor.shouldRetry());
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.setOffset(0);
                cursor.putByte((byte)5);
                cursor.putByte((byte)6);
                cursor.putByte((byte)7);
                cursor.putByte((byte)8);
            } while (cursor.shouldRetry());
        }
        cursor = pagedFile.io(0L, 2);
        var4_4 = null;
        try {
            byte[] bytes = new byte[4];
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.getBytes(bytes);
            } while (cursor.shouldRetry());
            Assert.assertThat((Object)bytes, (Matcher)ByteArrayMatcher.byteArray(new byte[]{1, 2, 3, 4}));
            Assert.assertTrue((boolean)cursor.next());
            do {
                cursor.getBytes(bytes);
            } while (cursor.shouldRetry());
            Assert.assertThat((Object)bytes, (Matcher)ByteArrayMatcher.byteArray(new byte[]{5, 6, 7, 8}));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var4_4 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void nextMustAdvanceCurrentPageId() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)0L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)1L));
        }
    }

    @Test(timeout=10000L)
    public void nextToSpecificPageIdMustAdvanceFromThatPointOn() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(1L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)1L));
            Assert.assertTrue((boolean)cursor.next(4L));
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)4L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)5L));
        }
    }

    @Test(timeout=10000L)
    public void currentPageIdIsUnboundBeforeFirstNextAndAfterRewind() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)0L));
            cursor.rewind();
            Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
        }
    }

    @Test(timeout=10000L)
    public void pageCursorMustKnowCurrentFilePageSize() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)-1));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)this.filePageSize));
            cursor.rewind();
            Assert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)-1));
        }
    }

    @Test(timeout=10000L)
    public void pageCursorMustKnowCurrentFile() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.nullValue());
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.is((Object)this.file("a")));
            cursor.rewind();
            Assert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.nullValue());
        }
    }

    @Test(expected=NullPointerException.class)
    public void readingFromUnboundCursorMustThrow() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            cursor.getByte();
        }
    }

    @Test(expected=NullPointerException.class)
    public void writingFromUnboundCursorMustThrow() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            cursor.putInt(1);
        }
    }

    @Test(timeout=10000L)
    public void lastPageMustBeAccessibleWithNoGrowSpecified() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void lastPageMustBeAccessibleWithNoGrowSpecifiedEvenIfLessThanFilePageSize() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2 - 1, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(2L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 6);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var4_6 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(3L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void firstPageMustBeAccessibleWithNoGrowSpecifiedIfItIsTheOnlyPage() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var5_7 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var5_7 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var5_7 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void firstPageMustBeAccessibleEvenIfTheFileIsNonEmptyButSmallerThanFilePageSize() throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var5_7 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var5_7 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var5_7 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void firstPageMustNotBeAccessibleIfFileIsEmptyAndNoGrowSpecified() throws IOException {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertFalse((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFile.io(0L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var5_7 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 6);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable x2) {
                var5_7 = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = pagedFile.io(1L, 1);
            var5_7 = null;
            try {
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var5_7 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void newlyWrittenPagesMustBeAccessibleWithNoGrow() throws IOException {
        int initialPages = 1;
        int pagesToAdd = 3;
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(1L, 2);){
            for (int i = 0; i < pagesToAdd; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                do {
                    this.writeRecords(cursor);
                } while (cursor.shouldRetry());
            }
        }
        int pagesChecked = 0;
        try (PageCursor cursor = pagedFile.io(0L, 6);){
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
                ++pagesChecked;
            }
        }
        Assert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)(initialPages + pagesToAdd)));
        pagesChecked = 0;
        cursor = pagedFile.io(0L, 1);
        var7_11 = null;
        try {
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
                ++pagesChecked;
            }
        }
        catch (Throwable throwable) {
            var7_11 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var7_11 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        var7_11.addSuppressed(x2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        Assert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)(initialPages + pagesToAdd)));
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void sharedLockImpliesNoGrow() throws IOException {
        int initialPages = 3;
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        int pagesChecked = 0;
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                ++pagesChecked;
            }
        }
        Assert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)initialPages));
    }

    @Test(timeout=10000L)
    public void retryMustResetCursorOffset() throws Exception {
        T cache = this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        final PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        final AtomicReference caughtWriterException = new AtomicReference();
        final CountDownLatch startLatch = new CountDownLatch(1);
        int expectedByte = 13;
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            if (cursor.next()) {
                do {
                    cursor.putByte((byte)13);
                } while (cursor.shouldRetry());
            }
        }
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        PageCursor cursor = pagedFile.io(0L, 2);
                        Throwable throwable = null;
                        try {
                            if (cursor.next()) {
                                do {
                                    cursor.setOffset(PageCacheTest.this.recordSize);
                                    cursor.putByte((byte)14);
                                } while (cursor.shouldRetry());
                            }
                            startLatch.countDown();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (cursor == null) continue;
                            if (throwable != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            cursor.close();
                        }
                    }
                    catch (IOException e) {
                        caughtWriterException.set(e);
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        Future<?> writerFuture = executor.submit(writer);
        startLatch.await();
        for (int i = 0; i < 1000; ++i) {
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                Assert.assertTrue((boolean)cursor.next());
                do {
                    Assert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)13));
                } while (cursor.shouldRetry());
                continue;
            }
        }
        writerFuture.cancel(true);
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void nextWithPageIdMustAllowTraversingInReverse() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        long lastFilePageId = this.recordCount / this.recordsPerFilePage - 1;
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            for (long currentPageId = lastFilePageId; currentPageId >= 0L; --currentPageId) {
                Assert.assertTrue((String)("next( currentPageId = " + currentPageId + " )"), (boolean)cursor.next(currentPageId));
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)currentPageId));
                this.verifyRecordsMatchExpected(cursor);
            }
        }
    }

    @Test(timeout=10000L)
    public void nextWithPageIdMustReturnFalseIfPageIdIsBeyondFilePageRangeAndNoGrowSpecified() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                Assert.assertFalse((boolean)cursor.next(2L));
                Assert.assertTrue((boolean)cursor.next(1L));
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertFalse((boolean)cursor.next(2L));
                Assert.assertTrue((boolean)cursor.next(1L));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void pagesAddedWithNextWithPageIdMustBeAccessibleWithNoGrowSpecified() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next(2L));
            do {
                this.writeRecords(cursor);
            } while (cursor.shouldRetry());
            Assert.assertTrue((boolean)cursor.next(0L));
            do {
                this.writeRecords(cursor);
            } while (cursor.shouldRetry());
            Assert.assertTrue((boolean)cursor.next(1L));
            do {
                this.writeRecords(cursor);
            } while (cursor.shouldRetry());
        }
        cursor = pagedFile.io(0L, 6);
        var3_3 = null;
        try {
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
            }
        }
        catch (Throwable x2) {
            var3_3 = x2;
            throw x2;
        }
        finally {
            if (cursor != null) {
                if (var3_3 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        cursor = pagedFile.io(0L, 1);
        var3_3 = null;
        try {
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var3_3 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        pagedFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RepeatRule.Repeat(times=10)
    @Test(timeout=60000L)
    public void readsAndWritesMustBeMutuallyConsistent() throws Exception {
        int i;
        int pageCount = 100;
        int writerThreads = 8;
        final CountDownLatch startLatch = new CountDownLatch(writerThreads);
        final CountDownLatch writersDoneLatch = new CountDownLatch(writerThreads);
        ArrayList writers = new ArrayList();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        final PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            void var9_12;
            boolean bl = false;
            while (var9_12 < 100) {
                Assert.assertTrue((boolean)cursor.next());
                ++var9_12;
            }
        }
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                try {
                    int pageRangeMin = 50;
                    int pageRangeMax = pageRangeMin + 5;
                    ThreadLocalRandom rng = ThreadLocalRandom.current();
                    int[] offsets = new int[PageCacheTest.this.filePageSize];
                    for (int i = 0; i < offsets.length; ++i) {
                        offsets[i] = i;
                    }
                    startLatch.countDown();
                    while (!Thread.interrupted()) {
                        byte value = (byte)rng.nextInt();
                        int pageId = rng.nextInt(pageRangeMin, pageRangeMax);
                        for (int i = 0; i < offsets.length; ++i) {
                            int j = rng.nextInt(i, offsets.length);
                            int s = offsets[i];
                            offsets[i] = offsets[j];
                            offsets[j] = s;
                        }
                        PageCursor cursor = pagedFile.io(pageId, 2);
                        Throwable throwable = null;
                        try {
                            if (!cursor.next()) continue;
                            do {
                                for (int offset : offsets) {
                                    cursor.setOffset(offset);
                                    cursor.putByte(value);
                                }
                            } while (cursor.shouldRetry());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (cursor == null) continue;
                            if (throwable != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            cursor.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    writersDoneLatch.countDown();
                }
            }
        };
        for (i = 0; i < writerThreads; ++i) {
            writers.add(executor.submit(writer));
        }
        startLatch.await();
        try {
            for (i = 0; i < 2000; ++i) {
                int n = 0;
                try (PageCursor cursor = pagedFile.io(0L, 1);){
                    while (cursor.next()) {
                        boolean consistent;
                        do {
                            consistent = true;
                            byte first = cursor.getByte();
                            for (int j = 1; j < this.filePageSize; ++j) {
                                byte b = cursor.getByte();
                                consistent = consistent && b == first;
                            }
                        } while (cursor.shouldRetry());
                        Assert.assertTrue((String)("checked consistency at itr " + i), (boolean)consistent);
                        ++n;
                    }
                }
                Assert.assertThat((Object)n, (Matcher)Matchers.is((Object)100));
            }
            for (Future future : writers) {
                if (future.isDone()) {
                    future.get();
                    continue;
                }
                future.cancel(true);
            }
            writersDoneLatch.await();
        }
        finally {
            pagedFile.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @RepeatRule.Repeat(times=1000)
    @Test(timeout=60000L)
    public void mustNotLoseUpdates() throws Exception {
        final AtomicBoolean shouldStop = new AtomicBoolean();
        int cachePages = 20;
        int filePages = 40;
        int threadCount = 8;
        int pageSize = 32;
        this.getPageCache(this.fs, 20, 32, PageCacheTracer.NULL);
        final PagedFile pagedFile = this.pageCache.map(this.file("a"), 32, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            void var9_12;
            boolean bl = false;
            while (var9_12 < 40) {
                Assert.assertTrue((String)("failed to initialise file page " + (int)var9_12), (boolean)cursor.next());
                for (int j = 0; j < 32; ++j) {
                    cursor.putByte((byte)0);
                }
                ++var9_12;
            }
        }
        this.pageCache.flushAndForce();
        ArrayList<Future<org.neo4j.io.pagecache.PageCacheTest.1Result>> futures = new ArrayList<Future<org.neo4j.io.pagecache.PageCacheTest.1Result>>();
        for (int i = 0; i < 8; ++i) {
            class Worker
            implements Callable<org.neo4j.io.pagecache.PageCacheTest.1Result> {
                final int threadId;

                Worker(int threadId) {
                    this.threadId = threadId;
                }

                @Override
                public org.neo4j.io.pagecache.PageCacheTest.1Result call() throws Exception {
                    int[] pageCounts = new int[40];
                    ThreadLocalRandom rng = ThreadLocalRandom.current();
                    while (!shouldStop.get()) {
                        int pageId = rng.nextInt(0, 40);
                        int offset = this.threadId * 4;
                        boolean updateCounter = rng.nextBoolean();
                        int pf_flags = updateCounter ? 2 : 1;
                        PageCursor cursor = pagedFile.io(pageId, pf_flags);
                        Throwable throwable = null;
                        try {
                            int counter;
                            try {
                                Assert.assertTrue((boolean)cursor.next());
                                do {
                                    cursor.setOffset(offset);
                                    counter = cursor.getInt();
                                } while (cursor.shouldRetry());
                                String lockName = updateCounter ? "PF_EXCLUSIVE_LOCK" : "PF_SHARED_LOCK";
                                Assert.assertThat((String)("inconsistent page read from filePageId = " + pageId + ", with " + lockName + ", workerId = " + this.threadId + " [t:" + Thread.currentThread().getId() + "]"), (Object)counter, (Matcher)Matchers.is((Object)pageCounts[pageId]));
                            }
                            catch (Throwable throwable2) {
                                shouldStop.set(true);
                                throw throwable2;
                            }
                            if (!updateCounter) continue;
                            int n = pageId;
                            pageCounts[n] = pageCounts[n] + 1;
                            cursor.setOffset(offset);
                            cursor.putInt(++counter);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (cursor == null) continue;
                            if (throwable != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            cursor.close();
                        }
                    }
                    class Result {
                        final int threadId;
                        final int[] pageCounts;

                        Result(int threadId, int[] pageCounts) {
                            this.threadId = threadId;
                            this.pageCounts = pageCounts;
                        }
                    }
                    return new Result(this.threadId, pageCounts);
                }
            }
            futures.add(executor.submit(new Worker(i)));
        }
        Thread.sleep(10L);
        shouldStop.set(true);
        for (Future future : futures) {
            Result result = (Result)future.get();
            PageCursor cursor = pagedFile.io(0L, 1);
            Throwable throwable = null;
            try {
                for (int i = 0; i < 40; ++i) {
                    int actualCount;
                    Assert.assertTrue((boolean)cursor.next());
                    int threadId = result.threadId;
                    int expectedCount = result.pageCounts[i];
                    do {
                        cursor.setOffset(threadId * 4);
                        actualCount = cursor.getInt();
                    } while (cursor.shouldRetry());
                    Assert.assertThat((String)("wrong count for threadId = " + threadId + ", pageId = " + i), (Object)actualCount, (Matcher)Matchers.is((Object)expectedCount));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor == null) continue;
                if (throwable != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                cursor.close();
            }
        }
        pagedFile.close();
    }

    @Test(timeout=10000L)
    public void writesOfDifferentUnitsMustHaveCorrectEndianess() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), 20, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            byte[] data = new byte[]{42, 43, 44, 45, 46};
            cursor.putLong(41L);
            cursor.putInt(41);
            cursor.putShort((short)41);
            cursor.putByte((byte)41);
            cursor.putBytes(data);
        }
        cursor = pagedFile.io(0L, 2);
        var3_3 = null;
        try {
            Assert.assertTrue((boolean)cursor.next());
            long a = cursor.getLong();
            int b = cursor.getInt();
            short c = cursor.getShort();
            byte[] data = new byte[]{cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte()};
            cursor.setOffset(0);
            cursor.putLong(1L + a);
            cursor.putInt(1 + b);
            cursor.putShort((short)(1 + c));
            for (byte d : data) {
                d = (byte)(d + 1);
                cursor.putByte(d);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var3_3 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        pagedFile.close();
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        ByteBuffer buf = ByteBuffer.allocate(20);
        channel.read(buf);
        buf.flip();
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)42L));
        Assert.assertThat((Object)buf.getInt(), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)buf.getShort(), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)43));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)44));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)45));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)46));
        Assert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)47));
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void mappingFileSecondTimeWithLesserPageSizeMustThrow() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile ignore = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.pageCache.map(this.file("a"), this.filePageSize - 1, new OpenOption[0]);
        }
    }

    @Test(timeout=10000L, expected=IllegalArgumentException.class)
    public void mappingFileSecondTimeWithGreaterPageSizeMustThrow() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile ignore = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.pageCache.map(this.file("a"), this.filePageSize + 1, new OpenOption[0]);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void mustThrowWhenClaimingExclusivelyMoreThanOneCursorFromSamePagedFile() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor a = pf.io(0L, 2);
             PageCursor b = pf.io(0L, 2);){
            Assert.fail((String)"The second io() call should have thrown");
        }
    }

    @Test(expected=IllegalStateException.class)
    public void mustThrowWhenClaimingExclusivelyMoreThanOneCursorFromSamePageCacheButDifferentPagedFiles() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pfA = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
             PageCursor a = pfA.io(0L, 2);
             PageCursor b = pfB.io(0L, 2);){
            Assert.fail((String)"The second io() call should have thrown");
        }
    }

    @Test(expected=IllegalStateException.class)
    public void mustThrowWhenClaimingWithSharedLockMoreThanOneCursorFromSamePagedFile() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor a = pf.io(0L, 1);
             PageCursor b = pf.io(0L, 1);){
            Assert.fail((String)"The second io() call should have thrown");
        }
    }

    @Test(expected=IllegalStateException.class)
    public void mustThrowWhenClaimingWithSharedLockMoreThanOneCursorFromSamePageCacheButDifferentPagedFiles() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pfA = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
             PageCursor a = pfA.io(0L, 1);
             PageCursor b = pfB.io(0L, 1);){
            Assert.fail((String)"The second io() call should have thrown");
        }
    }

    @Test(expected=IllegalStateException.class)
    public void mustThrowWhenClaimingReadCursorWhileHavingWriteCursor() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pfA = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
             PageCursor a = pfA.io(0L, 2);
             PageCursor b = pfB.io(0L, 1);){
            Assert.fail((String)"The second io() call should have thrown");
        }
    }

    @Test(expected=IllegalStateException.class)
    public void mustThrowWhenClaimingWriteCursorWhileHavingReadCursor() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pfA = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile pfB = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
             PageCursor a = pfA.io(0L, 1);
             PageCursor b = pfB.io(0L, 2);){
            Assert.fail((String)"The second io() call should have thrown");
        }
    }

    @Test(timeout=10000L)
    public void mustNotFlushCleanPagesWhenEvicting() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        final AtomicBoolean observedWrite = new AtomicBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                StoreChannel channel = super.open(fileName, mode);
                return new DelegatingStoreChannel(channel){

                    @Override
                    public int write(ByteBuffer src, long position) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public void writeAll(ByteBuffer src) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public int write(ByteBuffer src) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }

                    @Override
                    public long write(ByteBuffer[] srcs) throws IOException {
                        observedWrite.set(true);
                        throw new IOException("not allowed");
                    }
                };
            }
        };
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                this.verifyRecordsMatchExpected(cursor);
            }
        }
        Assert.assertFalse((boolean)observedWrite.get());
    }

    @Test(timeout=10000L)
    public void evictionMustFlushPagesToTheRightFiles() throws IOException {
        boolean cursorReady2;
        boolean cursorReady1;
        boolean moreWorkToDo;
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        int filePageSize2 = this.filePageSize - 3;
        long maxPageIdCursor1 = this.recordCount / this.recordsPerFilePage;
        File file2 = this.file("b");
        OutputStream outputStream = this.fs.openAsOutputStream(file2, false);
        long file2sizeBytes = (maxPageIdCursor1 + 17L) * (long)filePageSize2;
        int i = 0;
        while ((long)i < file2sizeBytes) {
            outputStream.write(97);
            ++i;
        }
        outputStream.flush();
        outputStream.close();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile1 = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PagedFile pagedFile2 = this.pageCache.map(file2, filePageSize2, new OpenOption[0]);
        long pageId1 = 0L;
        long pageId2 = 0L;
        do {
            try (PageCursor cursor = pagedFile1.io(pageId1, 2);){
                boolean bl = cursorReady1 = cursor.next() && cursor.getCurrentPageId() < maxPageIdCursor1;
                if (cursorReady1) {
                    this.writeRecords(cursor);
                    ++pageId1;
                }
            }
            cursor = pagedFile2.io(pageId2, 6);
            var18_20 = null;
            try {
                cursorReady2 = cursor.next();
                if (cursorReady2) {
                    do {
                        for (int i2 = 0; i2 < filePageSize2; ++i2) {
                            cursor.putByte((byte)98);
                        }
                    } while (cursor.shouldRetry());
                }
                ++pageId2;
            }
            catch (Throwable throwable) {
                var18_20 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var18_20 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var18_20.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        } while (moreWorkToDo = cursorReady1 || cursorReady2);
        pagedFile1.close();
        pagedFile2.close();
        Assert.assertThat((Object)this.fs.getFileSize(file2), (Matcher)Matchers.is((Object)file2sizeBytes));
        InputStream inputStream = this.fs.openAsInputStream(file2);
        int i3 = 0;
        while ((long)i3 < file2sizeBytes) {
            int b = inputStream.read();
            Assert.assertThat((Object)b, (Matcher)Matchers.is((Object)98));
            ++i3;
        }
        Assert.assertThat((Object)inputStream.read(), (Matcher)Matchers.is((Object)-1));
        inputStream.close();
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        ByteBuffer bufB = ByteBuffer.allocate(this.recordSize);
        for (int i4 = 0; i4 < this.recordCount; ++i4) {
            this.bufA.clear();
            channel.read(this.bufA);
            this.bufA.flip();
            bufB.clear();
            PageCacheTest.generateRecordForId(i4, bufB);
            Assert.assertThat((Object)bufB.array(), (Matcher)ByteArrayMatcher.byteArray(this.bufA.array()));
        }
    }

    @Test(timeout=10000L)
    public void tracerMustBeNotifiedAboutPinUnpinFaultAndEvictEventsWhenReading() throws IOException {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, tracer);
        long countedPages = 0L;
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                Assert.assertTrue((boolean)cursor.next(cursor.getCurrentPageId()));
                ++countedPages;
            }
        }
        Assert.assertThat((String)"wrong count of pins", (Object)tracer.countPins(), (Matcher)Matchers.is((Object)(countedPages * 2L)));
        Assert.assertThat((String)"wrong count of unpins", (Object)tracer.countUnpins(), (Matcher)Matchers.is((Object)(countedPages * 2L)));
        long faults = tracer.countFaults();
        long bytesRead = tracer.countBytesRead();
        Assert.assertThat((String)"wrong count of faults", (Object)faults, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedPages)));
        Assert.assertThat((String)"wrong number of bytes read", (Object)bytesRead, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedPages * (long)this.filePageSize)));
        Assert.assertThat((String)"wrong count of evictions", (Object)tracer.countEvictions(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedPages - (long)this.maxPages))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(countedPages + faults))));
    }

    @Test(timeout=10000L)
    public void tracerMustBeNotifiedAboutPinUnpinFaultFlushAndEvictionEventsWhenWriting() throws IOException {
        long pagesToGenerate = 142L;
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, tracer);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            for (long i = 0L; i < pagesToGenerate; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)i));
                Assert.assertTrue((boolean)cursor.next(i));
                Assert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)i));
                this.writeRecords(cursor);
            }
        }
        Assert.assertThat((String)"wrong count of pins", (Object)tracer.countPins(), (Matcher)Matchers.is((Object)(pagesToGenerate * 2L)));
        Assert.assertThat((String)"wrong count of unpins", (Object)tracer.countUnpins(), (Matcher)Matchers.is((Object)(pagesToGenerate * 2L)));
        long faults = tracer.countFaults();
        Assert.assertThat((String)"wrong count of faults", (Object)faults, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate)));
        Assert.assertThat((String)"wrong count of evictions", (Object)tracer.countEvictions(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate - (long)this.maxPages))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate + faults))));
        long flushes = tracer.countFlushes();
        long bytesWritten = tracer.countBytesWritten();
        Assert.assertThat((String)"wrong count of flushes", (Object)flushes, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate - (long)this.maxPages)));
        Assert.assertThat((String)"wrong count of bytes written", (Object)bytesWritten, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate * (long)this.filePageSize)));
    }

    @Test
    public void tracerMustBeNotifiedOfSharedAndExclusivePins() throws Exception {
        final AtomicInteger exclusiveCount = new AtomicInteger();
        final AtomicInteger sharedCount = new AtomicInteger();
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(){

            @Override
            public PinEvent beginPin(boolean exclusiveLock, long filePageId, PageSwapper swapper) {
                (exclusiveLock ? exclusiveCount : sharedCount).getAndIncrement();
                return super.beginPin(exclusiveLock, filePageId, swapper);
            }
        };
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, tracer);
        int pinsForSharing = 13;
        int pinsForExclusive = 42;
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            int i;
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                for (i = 0; i < pinsForSharing; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                }
            }
            cursor = pagedFile.io(0L, 2);
            var9_11 = null;
            try {
                for (i = 0; i < pinsForExclusive; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                }
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var9_11 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var9_11.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        Assert.assertThat((String)"wrong shared pin count", (Object)sharedCount.get(), (Matcher)Matchers.is((Object)pinsForSharing));
        Assert.assertThat((String)"wrong exclusive pin count", (Object)exclusiveCount.get(), (Matcher)Matchers.is((Object)pinsForExclusive));
    }

    @Test
    public void lastPageIdOfEmptyFileIsMinusOne() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
        }
    }

    @Test
    public void lastPageIdOfFileWithOneByteIsZero() throws IOException {
        StoreChannel channel = this.fs.create(this.file("a"));
        channel.write(ByteBuffer.wrap(new byte[]{1}));
        channel.close();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)0L));
        pagedFile.close();
    }

    @Test
    public void lastPageIdOfFileWithExactlyTwoPagesWorthOfDataIsOne() throws IOException {
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)1L));
        }
    }

    @Test
    public void lastPageIdOfFileWithExactlyTwoPagesAndOneByteWorthOfDataIsTwo() throws IOException {
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        OutputStream outputStream = this.fs.openAsOutputStream(this.file("a"), true);
        outputStream.write(97);
        outputStream.close();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)2L));
        }
    }

    @Test
    public void lastPageIdMustNotIncreaseWhenReadingToEndWithSharedLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        pagedFile.close();
        Assert.assertThat((Object)resultingLastPageId, (Matcher)Matchers.is((Object)initialLastPageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lastPageIdMustNotIncreaseWhenReadingToEndWithNoGrowAndExclusiveLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 6);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        try {
            Assert.assertThat((Object)resultingLastPageId, (Matcher)Matchers.is((Object)initialLastPageId));
        }
        finally {
            pagedFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lastPageIdMustIncreaseWhenScanningPastEndWithExclusiveLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)9L));
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            for (int i = 0; i < 15; ++i) {
                Assert.assertTrue((boolean)cursor.next());
            }
        }
        try {
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)14L));
        }
        finally {
            pagedFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lastPageIdMustIncreaseWhenJumpingPastEndWithExclusiveLock() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)9L));
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next(15L));
        }
        try {
            Assert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)15L));
        }
        finally {
            pagedFile.close();
        }
    }

    @Test
    public void cursorOffsetMustBeUpdatedReadAndWrite() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                this.verifyWriteOffsets(cursor);
                cursor.setOffset(0);
                this.verifyReadOffsets(cursor);
            }
            cursor = pagedFile.io(0L, 1);
            var4_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                this.verifyReadOffsets(cursor);
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var4_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var4_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    private void verifyWriteOffsets(PageCursor cursor) {
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)0));
        cursor.putLong(1L);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)8));
        cursor.putInt(1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)12));
        cursor.putShort((short)1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)14));
        cursor.putByte((byte)1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)15));
        cursor.putBytes(new byte[]{1, 2, 3});
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)18));
        cursor.putBytes(new byte[]{1, 2, 3}, 1, 1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)19));
    }

    private void verifyReadOffsets(PageCursor cursor) {
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)0));
        cursor.getLong();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)8));
        cursor.getInt();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)12));
        cursor.getShort();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)14));
        cursor.getByte();
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)15));
        cursor.getBytes(new byte[3]);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)18));
        cursor.getBytes(new byte[3], 1, 1);
        Assert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)19));
        byte[] expectedBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 3, 2};
        byte[] actualBytes = new byte[19];
        cursor.setOffset(0);
        cursor.getBytes(actualBytes);
        Assert.assertThat((Object)actualBytes, (Matcher)ByteArrayMatcher.byteArray(expectedBytes));
    }

    @Test
    public void cursorCanReadUnsignedIntGreaterThanMaxInt() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            long greaterThanMaxInt = 0xFFFFFFFFFFL;
            cursor.putLong(greaterThanMaxInt);
            cursor.setOffset(0);
            Assert.assertThat((Object)cursor.getInt(), (Matcher)Matchers.is((Object)255));
            Assert.assertThat((Object)cursor.getUnsignedInt(), (Matcher)Matchers.is((Object)0xFFFFFFFFL));
        }
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void pageCacheCloseMustThrowIfFilesAreStillMapped() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile ignore = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.pageCache.close();
        }
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void pagedFileIoMustThrowIfFileIsUnmapped() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        pagedFile.close();
        pagedFile.io(0L, 2);
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void writeLockedPageCursorNextMustThrowIfFileIsUnmapped() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 2);
        pagedFile.close();
        cursor.next();
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void writeLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() throws IOException {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 2);
        pagedFile.close();
        cursor.next(1L);
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void readLockedPageCursorNextMustThrowIfFileIsUnmapped() throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        pagedFile.close();
        cursor.next();
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void readLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        pagedFile.close();
        cursor.next(1L);
    }

    @Test(timeout=10000L)
    public void writeLockedPageMustBlockFileUnmapping() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 2);
        Assert.assertTrue((boolean)cursor.next());
        Thread unmapper = ThreadTestUtils.fork(this.$close(pagedFile));
        ThreadTestUtils.awaitThreadState(unmapper, 1000L, Thread.State.BLOCKED, Thread.State.WAITING, Thread.State.TIMED_WAITING);
        Assert.assertFalse((boolean)cursor.shouldRetry());
        cursor.close();
        unmapper.join();
    }

    @Test(timeout=10000L)
    public void pessimisticReadLockedPageMustNotBlockFileUnmapping() throws Exception {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        Assert.assertFalse((boolean)cursor.shouldRetry());
        cursor.close();
    }

    @Test(timeout=10000L, expected=IllegalStateException.class)
    public void advancingPessimisticReadLockingCursorAfterUnmappingMustThrow() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        cursor.next();
    }

    @Test(timeout=10000L)
    public void advancingOptimisticReadLockingCursorAfterUnmappingMustThrow() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next(0L));
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        Assert.assertFalse((boolean)cursor.shouldRetry());
        try {
            cursor.next();
            Assert.fail((String)"Advancing the cursor should have thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void readingAndRetryingOnPageWithOptimisticReadLockingAfterUnmappingMustNotThrow() throws Exception {
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        PageCursor cursor = pagedFile.io(0L, 1);
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next(0L));
        ThreadTestUtils.fork(this.$close(pagedFile)).join();
        this.pageCache.close();
        this.pageCache = null;
        cursor.getByte();
        Assert.assertFalse((boolean)cursor.shouldRetry());
        try {
            cursor.next();
            Assert.fail((String)"Advancing the cursor should have thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @RepeatRule.Repeat(times=100)
    @Test(timeout=60000L)
    public void writeLockingCursorMustThrowWhenLockingPageRacesWithUnmapping() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        final PagedFile pf = this.pageCache.map(file, this.filePageSize, new OpenOption[0]);
        final CountDownLatch hasLockLatch = new CountDownLatch(1);
        final CountDownLatch unlockLatch = new CountDownLatch(1);
        final CountDownLatch secondThreadGotLockLatch = new CountDownLatch(1);
        executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (PageCursor cursor = pf.io(0L, 2);){
                    cursor.next();
                    hasLockLatch.countDown();
                    unlockLatch.await();
                }
                return null;
            }
        });
        hasLockLatch.await();
        Future<Object> takeLockFuture = executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (PageCursor cursor = pf.io(0L, 2);){
                    cursor.next();
                    secondThreadGotLockLatch.await();
                }
                return null;
            }
        });
        Future<Object> closeFuture = executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                pf.close();
                return null;
            }
        });
        try {
            closeFuture.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected a TimeoutException here");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        unlockLatch.countDown();
        try {
            closeFuture.get(1000L, TimeUnit.MILLISECONDS);
            try {
                secondThreadGotLockLatch.countDown();
                takeLockFuture.get();
                Assert.fail((String)"Expected takeLockFuture.get() to throw an ExecutionException");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(IllegalStateException.class));
                Assert.assertThat((Object)cause.getMessage(), (Matcher)Matchers.startsWith((String)"File has been unmapped"));
            }
        }
        catch (TimeoutException e) {
            secondThreadGotLockLatch.countDown();
            closeFuture.get(2000L, TimeUnit.MILLISECONDS);
        }
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void getByteBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.getByte();
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void putByteBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.putByte((byte)42);
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void getShortBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.getShort();
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void putShortBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.putShort((short)42);
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void getIntBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.getInt();
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void putIntBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.putInt(42);
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void getUnsignedIntBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.getUnsignedInt();
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void putLongBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.putLong(42L);
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void getLongBeyondPageEndMustThrow() throws IOException {
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.getLong();
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void putBytesBeyondPageEndMustThrow() throws IOException {
        final byte[] bytes = new byte[]{1, 2, 3};
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.putBytes(bytes);
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void getBytesBeyondPageEndMustThrow() throws IOException {
        final byte[] bytes = new byte[3];
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.getBytes(bytes);
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void putBytesWithOffsetAndLengthBeyondPageEndMustThrow() throws IOException {
        final byte[] bytes = new byte[]{1, 2, 3};
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.putBytes(bytes, 1, 1);
            }
        });
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void getBytesWithOffsetAndLengthBeyondPageEndMustThrow() throws IOException {
        final byte[] bytes = new byte[3];
        this.verifyPageBounds(new PageCursorAction(){

            @Override
            public void apply(PageCursor cursor) {
                cursor.getBytes(bytes, 1, 1);
            }
        });
    }

    private void verifyPageBounds(PageCursorAction action) throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            cursor.next();
            for (int i = 0; i < 100000; ++i) {
                action.apply(cursor);
            }
        }
    }

    @Test(timeout=10000L, expected=IndexOutOfBoundsException.class)
    public void settingNegativeCursorOffsetMustThrow() throws IOException {
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            cursor.setOffset(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L, expected=IOException.class)
    public void pageFaultForWriteMustThrowIfOutOfStorageSpace() throws IOException {
        final AtomicInteger writeCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (writeCounter.incrementAndGet() > 10) {
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        fs.create(this.file("a")).close();
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            while (cursor.next()) {
            }
        }
        finally {
            this.pageCache = null;
        }
    }

    @Test(timeout=60000L, expected=IOException.class)
    public void pageFaultForReadMustThrowIfOutOfStorageSpace() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        final AtomicInteger writeCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (writeCounter.incrementAndGet() >= 1) {
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
        try {
            cursor = pagedFile.io(0L, 1);
            var5_5 = null;
            try {
                try {
                    while (true) {
                        if (cursor.next()) {
                            continue;
                        }
                        cursor.rewind();
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    if (var5_5 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var5_5.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.pageCache = null;
            throw throwable;
        }
    }

    @Test(timeout=10000L)
    public void mustRecoverFromFullDriveWhenMoreStorageBecomesAvailable() throws IOException {
        final AtomicBoolean hasSpace = new AtomicBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (!hasSpace.get()) {
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        fs.create(this.file("a")).close();
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try {
            PageCursor cursor = pagedFile.io(0L, 2);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        Assert.assertTrue((boolean)cursor.next());
                        this.writeRecords(cursor);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            hasSpace.set(true);
            pagedFile.close();
            return;
        }
    }

    @Test(timeout=10000L)
    public void dataFromDifferentFilesMustNotBleedIntoEachOther() throws IOException {
        int i;
        File fileB = this.existingFile("b");
        int filePageSizeA = this.pageCachePageSize - 2;
        int filePageSizeB = this.pageCachePageSize - 6;
        int pagesToWriteA = 100;
        int pagesToWriteB = 3;
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFileA = this.pageCache.map(this.existingFile("a"), filePageSizeA, new OpenOption[0]);
        try (PageCursor cursor = pagedFileA.io(0L, 2);){
            for (int i2 = 0; i2 < pagesToWriteA; ++i2) {
                Assert.assertTrue((boolean)cursor.next());
                for (int j = 0; j < filePageSizeA; ++j) {
                    cursor.putByte((byte)42);
                }
            }
        }
        PagedFile pagedFileB = this.pageCache.map(fileB, filePageSizeB, new OpenOption[0]);
        try (PageCursor cursor = pagedFileB.io(0L, 2);){
            for (int i3 = 0; i3 < pagesToWriteB; ++i3) {
                Assert.assertTrue((boolean)cursor.next());
                cursor.putByte((byte)63);
            }
        }
        pagedFileA.close();
        pagedFileB.close();
        InputStream inputStream = this.fs.openAsInputStream(fileB);
        Assert.assertThat((String)"first page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
        for (i = 0; i < filePageSizeB - 1; ++i) {
            Assert.assertThat((String)("page 0 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
        }
        Assert.assertThat((String)"second page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
        for (i = 0; i < filePageSizeB - 1; ++i) {
            Assert.assertThat((String)("page 1 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
        }
        Assert.assertThat((String)"third page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
        for (i = 0; i < filePageSizeB - 1; ++i) {
            Assert.assertThat((String)("page 2 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
        }
        Assert.assertThat((String)"expect EOF", (Object)inputStream.read(), (Matcher)Matchers.is((Object)-1));
    }

    @Test(timeout=60000L)
    public void freshlyCreatedPagesMustContainAllZeros() throws IOException {
        int j;
        int i;
        Throwable throwable;
        PageCursor cursor;
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                for (i = 0; i < 100; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                    for (j = 0; j < this.filePageSize; ++j) {
                        cursor.putByte((byte)rng.nextInt());
                    }
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        this.pageCache.close();
        this.pageCache = null;
        System.gc();
        System.gc();
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        pagedFile = this.pageCache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
        var3_3 = null;
        try {
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                for (i = 0; i < 100; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                    for (j = 0; j < this.filePageSize; ++j) {
                        Assert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)0));
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            var3_3 = throwable3;
            throw throwable3;
        }
        finally {
            if (pagedFile != null) {
                if (var3_3 != null) {
                    try {
                        pagedFile.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    pagedFile.close();
                }
            }
        }
    }

    @Test(timeout=60000L)
    public void optimisticReadLockMustFaultOnRetryIfPageHasBeenEvicted() throws Exception {
        int a = 97;
        int b = 98;
        File fileA = this.existingFile("a");
        File fileB = this.existingFile("b");
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFileA = this.pageCache.map(fileA, this.filePageSize, new OpenOption[0]);
        final PagedFile pagedFileB = this.pageCache.map(fileB, this.filePageSize, new OpenOption[0]);
        try (PageCursor cursor = pagedFileA.io(0L, 2);){
            for (int i = 0; i < this.maxPages; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                for (int j = 0; j < this.filePageSize; ++j) {
                    cursor.putByte((byte)97);
                }
            }
        }
        Runnable fillPagedFileB = new Runnable(){

            @Override
            public void run() {
                try (PageCursor cursor = pagedFileB.io(0L, 2);){
                    for (int i = 0; i < PageCacheTest.this.maxPages * 30; ++i) {
                        Assert.assertTrue((boolean)cursor.next());
                        for (int j = 0; j < PageCacheTest.this.filePageSize; ++j) {
                            cursor.putByte((byte)98);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        try (PageCursor cursor = pagedFileA.io(0L, 1);){
            Assert.assertTrue((boolean)cursor.next(0L));
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertTrue((boolean)cursor.next(0L));
            for (int i = 0; i < this.filePageSize; ++i) {
                Assert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)97));
            }
            ThreadTestUtils.fork(fillPagedFileB).join();
            if (cursor.shouldRetry()) {
                int actual;
                int expected = 97 * this.filePageSize;
                do {
                    actual = 0;
                    for (int i = 0; i < this.filePageSize; ++i) {
                        actual += cursor.getByte();
                    }
                } while (cursor.shouldRetry());
                Assert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
            }
        }
        pagedFileA.close();
        pagedFileB.close();
    }

    @Test(timeout=60000L)
    public void concurrentPageFaultingMustNotPutInterleavedDataIntoPages() throws Exception {
        int filePageCount = 11;
        final PageCountRecordFormat recordFormat = new PageCountRecordFormat();
        RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();
        harness.setConcurrencyLevel(11);
        harness.setUseAdversarialIO(false);
        harness.setCachePageCount(3);
        harness.setCachePageSize(this.pageCachePageSize);
        harness.setFilePageCount(11);
        harness.setFilePageSize(this.pageCachePageSize);
        harness.setInitialMappedFiles(1);
        harness.setCommandCount(10000);
        harness.setRecordFormat(recordFormat);
        harness.setFileSystem(this.fs);
        harness.disableCommands(Command.FlushCache, Command.FlushFile, Command.MapFile, Command.UnmapFile, Command.WriteRecord);
        harness.setPreparation(new Phase(){

            @Override
            public void run(PageCache pageCache, FileSystemAbstraction fs, Set<File> filesTouched) throws Exception {
                File file = filesTouched.iterator().next();
                try (PagedFile pf = pageCache.map(file, PageCacheTest.this.pageCachePageSize, new OpenOption[0]);
                     PageCursor cursor = pf.io(0L, 2);){
                    for (int pageId = 0; pageId < 11; ++pageId) {
                        cursor.next();
                        recordFormat.fillWithRecords(cursor);
                    }
                }
            }
        });
        harness.run(60000L, TimeUnit.MILLISECONDS);
    }

    @Test(timeout=60000L)
    public void concurrentFlushingMustNotPutInterleavedDataIntoFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        int filePageCount = 2000;
        RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();
        harness.setConcurrencyLevel(16);
        harness.setUseAdversarialIO(false);
        harness.setCachePageCount(1000);
        harness.setFilePageCount(2000);
        harness.setCachePageSize(this.pageCachePageSize);
        harness.setFilePageSize(this.pageCachePageSize);
        harness.setInitialMappedFiles(3);
        harness.setCommandCount(15000);
        harness.setFileSystem(this.fs);
        harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord);
        harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, 2000));
        harness.run(60000L, TimeUnit.MILLISECONDS);
    }

    @Test(timeout=60000L)
    public void concurrentFlushingWithMischiefMustNotPutInterleavedDataIntoFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        int filePageCount = 2000;
        RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();
        harness.setConcurrencyLevel(16);
        harness.setUseAdversarialIO(true);
        harness.setMischiefRate(0.5);
        harness.setFailureRate(0.0);
        harness.setErrorRate(0.0);
        harness.setCachePageCount(1000);
        harness.setFilePageCount(2000);
        harness.setCachePageSize(this.pageCachePageSize);
        harness.setFilePageSize(this.pageCachePageSize);
        harness.setInitialMappedFiles(3);
        harness.setCommandCount(15000);
        harness.setFileSystem(this.fs);
        harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord);
        harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, 2000));
        harness.run(60000L, TimeUnit.MILLISECONDS);
    }

    @Test(timeout=60000L)
    public void concurrentFlushingWithFailuresMustNotPutInterleavedDataIntoFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        int filePageCount = 20000;
        RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();
        harness.setConcurrencyLevel(16);
        harness.setUseAdversarialIO(true);
        harness.setMischiefRate(0.0);
        harness.setFailureRate(0.5);
        harness.setErrorRate(0.0);
        harness.setCachePageCount(10000);
        harness.setFilePageCount(20000);
        harness.setCachePageSize(this.pageCachePageSize);
        harness.setFilePageSize(this.pageCachePageSize);
        harness.setInitialMappedFiles(3);
        harness.setCommandCount(150000);
        harness.setFileSystem(this.fs);
        harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord);
        harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, 20000));
        harness.run(60000L, TimeUnit.MILLISECONDS);
    }

    private Phase filesAreCorrectlyWrittenVerification(final RecordFormat recordFormat, final int filePageCount) {
        return new Phase(){

            @Override
            public void run(PageCache pageCache, FileSystemAbstraction fs, Set<File> filesTouched) throws Exception {
                for (File file : filesTouched) {
                    try (PagedFile pf = pageCache.map(file, PageCacheTest.this.pageCachePageSize, new OpenOption[0]);
                         PageCursor cursor = pf.io(0L, 1);){
                        for (int pageId = 0; pageId < filePageCount && cursor.next(); ++pageId) {
                            try {
                                recordFormat.assertRecordsWrittenCorrectly(cursor);
                                continue;
                            }
                            catch (Throwable th) {
                                th.addSuppressed(new Exception("pageId = " + pageId));
                                throw th;
                            }
                        }
                    }
                    StoreChannel channel = fs.open(file, "r");
                    var7_7 = null;
                    try {
                        recordFormat.assertRecordsWrittenCorrectly(file, channel);
                    }
                    catch (Throwable throwable) {
                        var7_7 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (channel == null) continue;
                        if (var7_7 != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable x2) {
                                var7_7.addSuppressed(x2);
                            }
                            continue;
                        }
                        channel.close();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void backgroundThreadsMustGracefullyShutDown() throws Exception {
        boolean passed;
        this.assumeTrue("For some reason, this test is very flaky on Windows", !SystemUtils.IS_OS_WINDOWS);
        int iterations = 1000;
        LinkedList<WeakReference<T>> refs = new LinkedList<WeakReference<T>>();
        final ConcurrentLinkedQueue caughtExceptions = new ConcurrentLinkedQueue();
        Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                caughtExceptions.offer(e);
            }
        };
        Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
        try {
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int filePagesInTotal = this.recordCount / this.recordsPerFilePage;
            for (int i = 0; i < iterations; ++i) {
                T cache = this.createPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
                PagedFile pagedFile = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                try (PageCursor pageCursor = pagedFile.io(0L, 1);){
                    for (int j = 0; j < filePagesInTotal; ++j) {
                        Assert.assertTrue((boolean)pageCursor.next());
                    }
                }
                pagedFile.close();
                cache.close();
                refs.add(new WeakReference<T>(cache));
                Assert.assertTrue((boolean)caughtExceptions.isEmpty());
            }
        }
        finally {
            Thread.setDefaultUncaughtExceptionHandler(defaultUncaughtExceptionHandler);
        }
        int maxChecks = 100;
        do {
            System.gc();
            Thread.sleep(100L);
            passed = true;
            for (WeakReference weakReference : refs) {
                if (weakReference.get() == null) continue;
                passed = false;
            }
        } while (!passed && maxChecks-- > 0);
        if (!passed) {
            LinkedList<PageCache> nonNullPageCaches = new LinkedList<PageCache>();
            for (WeakReference weakReference : refs) {
                PageCache pageCache = (PageCache)weakReference.get();
                if (pageCache == null) continue;
                nonNullPageCaches.add(pageCache);
            }
            if (!nonNullPageCaches.isEmpty()) {
                Assert.fail((String)("PageCaches should not be held live after close: " + nonNullPageCaches));
            }
        }
    }

    @Test(timeout=10000L)
    public void pagesMustReturnToFreelistIfSwapInThrows() throws IOException {
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        int iterations = this.maxPages * 2;
        this.accessPagesWhileInterrupted(pagedFile, 1, iterations);
        this.accessPagesWhileInterrupted(pagedFile, 2, iterations);
        Thread.interrupted();
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            Assert.assertTrue((boolean)cursor.next());
            this.verifyRecordsMatchExpected(cursor);
        }
        pagedFile.close();
    }

    private void accessPagesWhileInterrupted(PagedFile pagedFile, int pf_flags, int iterations) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, pf_flags);){
            for (int i = 0; i < iterations; ++i) {
                Thread.currentThread().interrupt();
                try {
                    cursor.next(0L);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @RepeatRule.Repeat(times=3000)
    @Test(timeout=360000L)
    public void pageCacheMustRemainInternallyConsistentWhenGettingRandomFailures() throws Exception {
        RandomAdversary adversary = new RandomAdversary(0.5, 0.2, 0.2);
        adversary.setProbabilityFactor(0.0);
        AdversarialFileSystemAbstraction fs = new AdversarialFileSystemAbstraction(adversary, this.fs);
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        LinearHistoryPageCacheTracer tracer = new LinearHistoryPageCacheTracer();
        this.getPageCache(fs, this.maxPages, this.pageCachePageSize, tracer);
        PagedFile pfA = this.pageCache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
        PagedFile pfB = this.pageCache.map(this.existingFile("b"), this.filePageSize / 2 + 1, new OpenOption[0]);
        adversary.setProbabilityFactor(1.0);
        for (int i = 0; i < 1000; ++i) {
            PagedFile pagedFile = rng.nextBoolean() ? pfA : pfB;
            long maxPageId = pagedFile.getLastPageId();
            boolean performingRead = rng.nextBoolean() && maxPageId != -1L;
            long startingPage = maxPageId == -1L ? 0L : rng.nextLong(maxPageId + 1L);
            int pf_flags = performingRead ? 1 : 2;
            int pageSize = pagedFile.pageSize();
            try (PageCursor cursor = pagedFile.io(startingPage, pf_flags);){
                if (performingRead) {
                    this.performConsistentAdversarialRead(cursor, maxPageId, startingPage, pageSize);
                    continue;
                }
                this.performConsistentAdversarialWrite(cursor, rng, pageSize);
                continue;
            }
            catch (AssertionError error) {
                adversary.setProbabilityFactor(0.0);
                try (PageCursor cursor2 = pagedFile.io(0L, 2);){
                    for (int j = 0; j < 100; ++j) {
                        cursor2.next(rng.nextLong(maxPageId + 1L));
                    }
                }
                catch (Throwable throwable) {
                    ((Throwable)((Object)error)).addSuppressed(throwable);
                }
                throw error;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        adversary.setProbabilityFactor(0.0);
        try {
            this.pageCache.flushAndForce();
            this.verifyAdversarialPagedContent(pfA);
            this.verifyAdversarialPagedContent(pfB);
            pfA.close();
            pfB.close();
        }
        catch (Throwable e) {
            tracer.printHistory(System.err);
            throw e;
        }
    }

    private void performConsistentAdversarialRead(PageCursor cursor, long maxPageId, long startingPage, int pageSize) throws IOException {
        long pagesToLookAt = Math.min(maxPageId, startingPage + 3L) - startingPage + 1L;
        int j = 0;
        while ((long)j < pagesToLookAt) {
            Assert.assertTrue((boolean)cursor.next());
            this.readAndVerifyAdversarialPage(cursor, pageSize);
            ++j;
        }
    }

    private void readAndVerifyAdversarialPage(PageCursor cursor, int pageSize) throws IOException {
        byte[] actualPage = new byte[pageSize];
        byte[] expectedPage = new byte[pageSize];
        do {
            cursor.getBytes(actualPage);
        } while (cursor.shouldRetry());
        Arrays.fill(expectedPage, actualPage[0]);
        String msg = String.format("filePageId = %s, pageSize = %s", cursor.getCurrentPageId(), pageSize);
        Assert.assertThat((String)msg, (Object)actualPage, (Matcher)ByteArrayMatcher.byteArray(expectedPage));
    }

    private void performConsistentAdversarialWrite(PageCursor cursor, ThreadLocalRandom rng, int pageSize) throws IOException {
        for (int j = 0; j < 3; ++j) {
            Assert.assertTrue((boolean)cursor.next());
            byte b = (byte)rng.nextInt(1, 127);
            for (int k = 0; k < pageSize; ++k) {
                cursor.putByte(b);
            }
            Assert.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    private void verifyAdversarialPagedContent(PagedFile pagedFile) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                this.readAndVerifyAdversarialPage(cursor, pagedFile.pageSize());
            }
        }
    }

    @Test(timeout=60000L)
    public void mustSupportUnalignedWordAccesses() throws Exception {
        int pageSize = 0x800000;
        this.getPageCache(this.fs, 10, pageSize, PageCacheTracer.NULL);
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            for (int i = 0; i < pageSize - 8; ++i) {
                cursor.setOffset(i);
                long x = rng.nextLong();
                cursor.putLong(x);
                cursor.setOffset(i);
                String reason = "Failed to read back the value that was written at offset " + Long.toHexString(i);
                Assert.assertThat((String)reason, (Object)Long.toHexString(cursor.getLong()), (Matcher)Matchers.is((Object)Long.toHexString(x)));
            }
        }
    }

    @RepeatRule.Repeat(times=50)
    @Test(timeout=60000L)
    public void mustEvictPagesFromUnmappedFiles() throws Exception {
        Throwable throwable;
        PageCursor cursor;
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        pagedFile = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        var2_2 = null;
        try {
            cursor = pagedFile.io(0L, 2);
            throwable = null;
            try {
                for (int i = 0; i < this.maxPages + 5; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        finally {
            if (pagedFile != null) {
                if (var2_2 != null) {
                    try {
                        pagedFile.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    pagedFile.close();
                }
            }
        }
    }

    @Test(timeout=60000L)
    public void mustFlushDirtyPagesInTheBackground() throws Exception {
        final CountDownLatch swapOutLatch = new CountDownLatch(1);
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(){

            @Override
            public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist) throws IOException {
                PageSwapper delegate = super.createPageSwapper(file, filePageSize, onEviction, createIfNotExist);
                return new DelegatingPageSwapper(delegate){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public long write(long filePageId, Page page) throws IOException {
                        try {
                            long l = super.write(filePageId, page);
                            return l;
                        }
                        finally {
                            swapOutLatch.countDown();
                        }
                    }
                };
            }
        };
        swapperFactory.setFileSystemAbstraction(this.fs);
        try (T pageCache = this.createPageCache(swapperFactory, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
             PagedFile pagedFile = pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                this.writeRecords(cursor);
            }
            swapOutLatch.await();
            this.verifyRecordsInFile(this.file("a"), this.recordsPerFilePage);
        }
    }

    @Test(timeout=60000L)
    public void mustReadZerosFromBeyondEndOfFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        File[] files = new File[]{this.file("1"), this.file("2"), this.file("3"), this.file("4"), this.file("5"), this.file("6"), this.file("7"), this.file("8"), this.file("9"), this.file("0"), this.file("A"), this.file("B")};
        for (int fileId = 0; fileId < files.length; ++fileId) {
            File file = files[fileId];
            StoreChannel channel = this.fs.open(file, "rw");
            for (int recordId = 0; recordId < fileId + 1; ++recordId) {
                Record record = recordFormat.createRecord(file, recordId);
                recordFormat.writeRecord(record, channel);
            }
            channel.close();
        }
        int pageSize = this.nextPowerOf2(recordFormat.getRecordSize() * (files.length + 1));
        this.getPageCache(this.fs, 2, pageSize, PageCacheTracer.NULL);
        int fileId = files.length;
        while (fileId-- > 0) {
            File file = files[fileId];
            PagedFile pf = this.pageCache.map(file, pageSize, new OpenOption[0]);
            Throwable throwable = null;
            try {
                PageCursor cursor = pf.io(0L, 1);
                Throwable throwable2 = null;
                try {
                    int pageCount = 0;
                    while (cursor.next()) {
                        ++pageCount;
                        recordFormat.assertRecordsWrittenCorrectly(cursor);
                    }
                    Assert.assertThat((String)("pages in file " + file), (Object)pageCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (cursor == null) continue;
                    if (throwable2 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                        continue;
                    }
                    cursor.close();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (pf == null) continue;
                if (throwable != null) {
                    try {
                        pf.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                pf.close();
            }
        }
    }

    private int nextPowerOf2(int i) {
        return 1 << 32 - Integer.numberOfLeadingZeros(i);
    }

    private PageSwapperFactory factoryCountingSyncDevice(final AtomicInteger syncDeviceCounter, final Queue<Integer> expectedCountsInForce) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(){

            @Override
            public void syncDevice() {
                super.syncDevice();
                syncDeviceCounter.getAndIncrement();
            }

            @Override
            public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist) throws IOException {
                PageSwapper delegate = super.createPageSwapper(file, filePageSize, onEviction, createIfNotExist);
                return new DelegatingPageSwapper(delegate){

                    @Override
                    public void force() throws IOException {
                        super.force();
                        Assert.assertThat((Object)syncDeviceCounter.get(), (Matcher)Matchers.is(expectedCountsInForce.poll()));
                    }
                };
            }
        };
        factory.setFileSystemAbstraction(this.fs);
        return factory;
    }

    @SafeVarargs
    private static <E> Queue<E> queue(E ... items) {
        ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue<E>();
        for (E item : items) {
            queue.offer(item);
        }
        return queue;
    }

    @Test(timeout=60000L)
    public void mustSyncDeviceWhenFlushAndForcingPagedFile() throws Exception {
        AtomicInteger syncDeviceCounter = new AtomicInteger();
        AtomicInteger expectedCountInForce = new AtomicInteger();
        Queue<Integer> expectedCountsInForce = PageCacheTest.queue(0, 1, 2);
        PageSwapperFactory factory = this.factoryCountingSyncDevice(syncDeviceCounter, expectedCountsInForce);
        try (T cache = this.createPageCache(factory, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
             PagedFile p1 = cache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile p2 = cache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = p1.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
            }
            cursor = p2.io(0L, 2);
            var12_18 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var12_18 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var12_18 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var12_18.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            p1.flushAndForce();
            expectedCountInForce.set(1);
            Assert.assertThat((Object)syncDeviceCounter.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test(timeout=60000L)
    public void mustSyncDeviceWhenFlushAndForcingPageCache() throws Exception {
        AtomicInteger syncDeviceCounter = new AtomicInteger();
        AtomicInteger expectedCountInForce = new AtomicInteger();
        Queue<Integer> expectedCountsInForce = PageCacheTest.queue(0, 0, 1, 2);
        PageSwapperFactory factory = this.factoryCountingSyncDevice(syncDeviceCounter, expectedCountsInForce);
        try (T cache = this.createPageCache(factory, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
             PagedFile p1 = cache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile p2 = cache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = p1.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
            }
            cursor = p2.io(0L, 2);
            var12_18 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var12_18 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var12_18 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var12_18.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cache.flushAndForce();
            expectedCountInForce.set(1);
            Assert.assertThat((Object)syncDeviceCounter.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test(expected=NoSuchFileException.class)
    public void mustThrowWhenMappingNonExistingFile() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        this.pageCache.map(this.file("does not exist"), this.filePageSize, new OpenOption[0]);
    }

    @Test(timeout=60000L)
    public void mustCreateNonExistingFileWithCreateOption() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pf = this.pageCache.map(this.file("does not exist"), this.filePageSize, StandardOpenOption.CREATE);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test(timeout=60000L)
    public void mustIgnoreCreateOptionIfFileAlreadyExists() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, StandardOpenOption.CREATE);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test(timeout=60000L)
    public void mustIgnoreCertainOpenOptions() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.SPARSE);
             PageCursor cursor = pf.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
        }
    }

    @Test(timeout=60000L)
    public void mustThrowOnUnsupportedOpenOptions() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        this.verifyMappingWithOpenOptionThrows(StandardOpenOption.CREATE_NEW);
        this.verifyMappingWithOpenOptionThrows(StandardOpenOption.DELETE_ON_CLOSE);
        this.verifyMappingWithOpenOptionThrows(StandardOpenOption.SYNC);
        this.verifyMappingWithOpenOptionThrows(StandardOpenOption.DSYNC);
        this.verifyMappingWithOpenOptionThrows(new OpenOption(){

            public String toString() {
                return "NonStandardOpenOption";
            }
        });
    }

    private void verifyMappingWithOpenOptionThrows(OpenOption option) throws IOException {
        try {
            this.pageCache.map(this.file("a"), this.filePageSize, option).close();
            Assert.fail((String)("Expected PageCache.map() to throw when given the OpenOption " + option));
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void mappingFileWithTruncateOptionMustTruncateFile() throws Exception {
        Throwable throwable;
        PageCursor cursor;
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile pf = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pf.io(10L, 2);
            throwable = null;
            try {
                Assert.assertThat((Object)pf.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(-889275714);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        pf = this.pageCache.map(this.file("a"), this.filePageSize, StandardOpenOption.TRUNCATE_EXISTING);
        var2_2 = null;
        try {
            cursor = pf.io(0L, 1);
            throwable = null;
            try {
                Assert.assertThat((Object)pf.getLastPageId(), (Matcher)Matchers.is((Object)-1L));
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        finally {
            if (pf != null) {
                if (var2_2 != null) {
                    try {
                        pf.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    pf.close();
                }
            }
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void mappingAlreadyMappedFileWithTruncateOptionMustThrow() throws Exception {
        this.getPageCache(this.fs, this.maxPages, this.pageCachePageSize, PageCacheTracer.NULL);
        try (PagedFile first = this.pageCache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PagedFile second = this.pageCache.map(this.file("a"), this.filePageSize, StandardOpenOption.TRUNCATE_EXISTING);){
            Assert.fail((String)"the second map call should have thrown");
        }
    }

    private static interface PageCursorAction {
        public void apply(PageCursor var1);
    }
}

