/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnReadPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

final class CursorPool {
    private static boolean disableCursorPooling = FeatureToggles.flag(CursorPool.class, "disableCursorPooling", false);
    private final ThreadLocal<MuninnReadPageCursor> readCursorCache = new MuninnReadPageCursorThreadLocal();
    private final ThreadLocal<MuninnWritePageCursor> writeCursorCache = new MuninnWritePageCursorThreadLocal();

    CursorPool() {
    }

    public MuninnReadPageCursor takeReadCursor() {
        if (disableCursorPooling) {
            return new MuninnReadPageCursor();
        }
        MuninnReadPageCursor cursor = this.readCursorCache.get();
        assert (CursorPool.unclaimed(cursor, this.writeCursorCache));
        cursor.markAsClaimed();
        return cursor;
    }

    public MuninnWritePageCursor takeWriteCursor() {
        if (disableCursorPooling) {
            return new MuninnWritePageCursor();
        }
        MuninnWritePageCursor cursor = this.writeCursorCache.get();
        assert (CursorPool.unclaimed(cursor, this.readCursorCache));
        cursor.markAsClaimed();
        return cursor;
    }

    private static boolean unclaimed(MuninnPageCursor first, ThreadLocal<? extends MuninnPageCursor> second) {
        first.assertUnclaimed();
        second.get().assertUnclaimed();
        return true;
    }

    private static class MuninnWritePageCursorThreadLocal
    extends ThreadLocal<MuninnWritePageCursor> {
        private MuninnWritePageCursorThreadLocal() {
        }

        @Override
        protected MuninnWritePageCursor initialValue() {
            return new MuninnWritePageCursor();
        }
    }

    private static class MuninnReadPageCursorThreadLocal
    extends ThreadLocal<MuninnReadPageCursor> {
        private MuninnReadPageCursorThreadLocal() {
        }

        @Override
        protected MuninnReadPageCursor initialValue() {
            return new MuninnReadPageCursor();
        }
    }
}

