/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.CountKeeperFactory;
import org.neo4j.io.pagecache.stress.PageCacheStresser;
import org.neo4j.io.pagecache.stress.StressTestRecord;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class PageCacheStressTest {
    private final int numberOfPages;
    private final int recordsPerPage;
    private final int numberOfThreads;
    private final int numberOfCachePages;
    private final int cachePageSize;
    private final PageCacheTracer tracer;
    private final Condition condition;
    private final String workingDirectory;

    private PageCacheStressTest(Builder builder) {
        this.numberOfPages = builder.numberOfPages;
        this.recordsPerPage = builder.recordsPerPage;
        this.numberOfThreads = builder.numberOfThreads;
        this.numberOfCachePages = builder.numberOfCachePages;
        this.cachePageSize = builder.cachePageSize;
        this.tracer = builder.tracer;
        this.condition = builder.condition;
        this.workingDirectory = builder.workingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.setFileSystemAbstraction(fs);
        MuninnPageCache pageCacheUnderTest = new MuninnPageCache(swapperFactory, this.numberOfCachePages, this.cachePageSize, this.tracer);
        MuninnPageCache pageCacheKeepingCount = new MuninnPageCache(swapperFactory, this.numberOfCachePages, this.cachePageSize, this.tracer);
        try {
            File file = Files.createTempFile(Paths.get(this.workingDirectory, new String[0]), "pagecachekeepingcounts", ".bin", new FileAttribute[0]).toFile();
            file.deleteOnExit();
            PagedFile pagedFile = pageCacheKeepingCount.map(file, this.recordsPerPage * this.numberOfThreads * StressTestRecord.SizeOfCounter, new OpenOption[0]);
            CountKeeperFactory countKeeperFactory = new CountKeeperFactory(pagedFile, this.recordsPerPage, this.numberOfThreads);
            PageCacheStresser pageCacheStresser = new PageCacheStresser(this.numberOfPages, this.recordsPerPage, this.numberOfThreads, this.workingDirectory);
            pageCacheStresser.stress(pageCacheUnderTest, this.condition, countKeeperFactory);
            pagedFile.close();
        }
        finally {
            pageCacheUnderTest.close();
            pageCacheKeepingCount.close();
        }
    }

    public static class Builder {
        int numberOfPages = 10000;
        int recordsPerPage = 113;
        int numberOfThreads = 8;
        int cachePagePadding = 56;
        int numberOfCachePages = 1000;
        int cachePageSize;
        PageCacheTracer tracer = PageCacheTracer.NULL;
        Condition condition;
        String workingDirectory = System.getProperty("java.io.tmpdir");

        public PageCacheStressTest build() {
            Assert.assertThat((String)"the cache should cover only a fraction of the mapped file", (Object)this.numberOfPages, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(10 * this.numberOfCachePages))));
            int pageSize = this.recordsPerPage * (this.numberOfThreads + 1) * StressTestRecord.SizeOfCounter;
            Assert.assertThat((String)"padding should not allow another page to fit", (Object)this.cachePagePadding, (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(pageSize))));
            this.cachePageSize = pageSize + this.cachePagePadding;
            return new PageCacheStressTest(this);
        }

        public Builder with(PageCacheTracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder with(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder withNumberOfPages(int value) {
            this.numberOfPages = value;
            return this;
        }

        public Builder withRecordsPerPage(int value) {
            this.recordsPerPage = value;
            return this;
        }

        public Builder withNumberOfThreads(int value) {
            this.numberOfThreads = value;
            return this;
        }

        public Builder withCachePagePadding(int value) {
            this.cachePagePadding = value;
            return this;
        }

        public Builder withNumberOfCachePages(int value) {
            this.numberOfCachePages = value;
            return this;
        }

        public Builder withWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }
    }
}

