/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.stress.ChecksumVerifier;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.CountKeeperFactory;
import org.neo4j.io.pagecache.stress.CountUpdater;
import org.neo4j.io.pagecache.stress.RecordStresser;
import org.neo4j.io.pagecache.stress.StressTestRecord;

public class PageCacheStresser {
    private final int maxPages;
    private final int recordsPerPage;
    private final int numberOfThreads;
    private final String workingDirectory;

    public PageCacheStresser(int maxPages, int recordsPerPage, int numberOfThreads, String workingDirectory) {
        this.maxPages = maxPages;
        this.recordsPerPage = recordsPerPage;
        this.numberOfThreads = numberOfThreads;
        this.workingDirectory = workingDirectory;
    }

    public void stress(PageCache pageCache, Condition condition, CountKeeperFactory countKeeperFactory) throws Exception {
        File file = Files.createTempFile(Paths.get(this.workingDirectory, new String[0]), "pagecacheundertest", ".bin", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        PagedFile pagedFile = pageCache.map(file, this.recordsPerPage * (this.numberOfThreads + 1) * StressTestRecord.SizeOfCounter, new OpenOption[0]);
        ChecksumVerifier checksumVerifier = new ChecksumVerifier(this.recordsPerPage, this.numberOfThreads);
        List<RecordStresser> recordStressers = this.prepare(condition, countKeeperFactory, pagedFile, checksumVerifier);
        this.execute(recordStressers);
        countKeeperFactory.createVerifier().verifyCounts(pagedFile);
        checksumVerifier.verifyChecksums(pagedFile);
        pagedFile.close();
    }

    private List<RecordStresser> prepare(Condition condition, CountKeeperFactory countKeeperFactory, PagedFile pagedFile, ChecksumVerifier checksumVerifier) {
        CountUpdater countUpdater = new CountUpdater(this.numberOfThreads);
        LinkedList<RecordStresser> recordStressers = new LinkedList<RecordStresser>();
        for (int threadNumber = 0; threadNumber < this.numberOfThreads; ++threadNumber) {
            recordStressers.add(new RecordStresser(pagedFile, condition, checksumVerifier, countUpdater, countKeeperFactory.createRecordKeeper(), this.maxPages, this.recordsPerPage, threadNumber));
        }
        return recordStressers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(List<RecordStresser> recordStressers) throws InterruptedException, ExecutionException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads);
        try {
            for (Future future : executorService.invokeAll(recordStressers)) {
                future.get();
            }
        }
        finally {
            executorService.shutdown();
        }
    }
}

