/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.function.Functions;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.index.DummyIndexImplementation;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CountCommittedTransactionThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.StoreFlusher;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.DefaultFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class TransactionRepresentationCommitProcessIT {
    private static final String INDEX_NAME = "index";
    private static final int TOTAL_ACTIVE_THREADS = 6;
    private static final String TEST_PROVIDER_NAME = "testProvider";
    private static ExecutorService executorService;
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public LifeRule lifeRule = new LifeRule();
    private NeoStores neoStores;
    private DefaultFileSystemAbstraction fileSystem;
    private File storeDir;

    @BeforeClass
    public static void startExecutor() {
        executorService = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void stopExecutor() {
        executorService.shutdownNow();
    }

    @Before
    public void setUp() {
        this.fileSystem = this.fileSystemRule.get();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        this.storeDir = this.testDirectory.graphDbDir();
        StoreFactory storeFactory = new StoreFactory((FileSystemAbstraction)this.fileSystem, this.storeDir, pageCache, (LogProvider)NullLogProvider.getInstance());
        this.neoStores = storeFactory.openAllNeoStores(true);
    }

    @After
    public void tearDown() {
        this.neoStores.close();
    }

    @Test(timeout=5000L)
    public void commitDuringContinuousCheckpointing() throws Exception {
        IndexConfigStore indexStore = new IndexConfigStore(this.storeDir, (FileSystemAbstraction)this.fileSystem);
        indexStore.set(Node.class, INDEX_NAME, MapUtil.stringMap((String[])new String[]{"provider", TEST_PROVIDER_NAME}));
        LegacyIndexApplierLookup.Direct legacyIndexApplierLookup = new LegacyIndexApplierLookup.Direct(Functions.map(MapUtil.genericMap((Object[])new Object[]{TEST_PROVIDER_NAME, new DummyIndexImplementation()})));
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(1000, 100000);
        SynchronizedArrayIdOrderingQueue legacyIndexTransactionOrdering = new SynchronizedArrayIdOrderingQueue(20);
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.storeDir, "neostore.transaction.db", (FileSystemAbstraction)this.fileSystem);
        PhysicalLogFile logFile = new PhysicalLogFile((FileSystemAbstraction)this.fileSystem, logFiles, 10000L, (TransactionIdStore)metaDataStore, (LogVersionRepository)metaDataStore, (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]), transactionMetadataCache);
        KernelHealth kernelHealth = (KernelHealth)Mockito.mock(KernelHealth.class);
        TransactionRepresentationStoreApplier storeApplier = this.createStoreApplier(indexStore, (LegacyIndexApplierLookup)legacyIndexApplierLookup, (IdOrderingQueue)legacyIndexTransactionOrdering, kernelHealth);
        BatchingTransactionAppender appender = this.createTransactionAppender(metaDataStore, transactionMetadataCache, (IdOrderingQueue)legacyIndexTransactionOrdering, logFile, kernelHealth);
        CheckPointerImpl checkPointer = this.createCheckPointer(metaDataStore, kernelHealth, (TransactionAppender)appender);
        this.lifeRule.add(logFile);
        this.lifeRule.add(indexStore);
        this.lifeRule.add(appender);
        this.lifeRule.start();
        this.neoStores.rebuildCountStoreIfNeeded();
        CountDownLatch completionLatch = new CountDownLatch(6);
        InsaneCheckPointer insaneCheckPointer = new InsaneCheckPointer((CheckPointer)checkPointer, completionLatch);
        executorService.submit(insaneCheckPointer);
        List<TransactionalWorker> workers = this.createTransactionWorkers(5, (TransactionAppender)appender, storeApplier, completionLatch);
        for (TransactionalWorker worker : workers) {
            executorService.submit(worker);
        }
        executorService.invokeAll(workers, 0L, TimeUnit.MILLISECONDS);
        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        insaneCheckPointer.complete();
        for (TransactionalWorker worker : workers) {
            worker.complete();
        }
        completionLatch.await();
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        Assert.assertTrue((String)"All legacy index commands should be applied", (boolean)legacyIndexTransactionOrdering.isEmpty());
        Assert.assertEquals((String)"NeoStore last closed transaction id should be equal to count store transaction id.", (long)metaDataStore.getLastClosedTransactionId(), (long)this.neoStores.getCounts().txId());
    }

    private List<TransactionalWorker> createTransactionWorkers(int numberOfWorkers, TransactionAppender appender, TransactionRepresentationStoreApplier storeApplier, CountDownLatch completedLatch) {
        ArrayList<TransactionalWorker> workers = new ArrayList<TransactionalWorker>(numberOfWorkers);
        for (int i = 0; i < numberOfWorkers; ++i) {
            workers.add(new TransactionalWorker(this.neoStores, appender, storeApplier, completedLatch));
        }
        return workers;
    }

    private BatchingTransactionAppender createTransactionAppender(MetaDataStore metaDataStore, TransactionMetadataCache transactionMetadataCache, IdOrderingQueue legacyIndexTransactionOrdering, PhysicalLogFile logFile, KernelHealth kernelHealth) {
        return new BatchingTransactionAppender((LogFile)logFile, (LogRotation)Mockito.mock(LogRotation.class), transactionMetadataCache, (TransactionIdStore)metaDataStore, legacyIndexTransactionOrdering, kernelHealth);
    }

    private TransactionRepresentationStoreApplier createStoreApplier(IndexConfigStore indexStore, LegacyIndexApplierLookup legacyIndexApplierLookup, IdOrderingQueue legacyIndexTransactionOrdering, KernelHealth kernelHealth) {
        return new TransactionRepresentationStoreApplier((IndexingService)Mockito.mock(IndexingService.class), (Provider)Mockito.mock(Provider.class), this.neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), (LockService)Mockito.mock(LockService.class), legacyIndexApplierLookup, indexStore, kernelHealth, legacyIndexTransactionOrdering);
    }

    private CheckPointerImpl createCheckPointer(MetaDataStore metaDataStore, KernelHealth kernelHealth, TransactionAppender appender) {
        CountCommittedTransactionThreshold committedTransactionThreshold = new CountCommittedTransactionThreshold(1);
        StoreFlusher storeFlusher = new StoreFlusher(this.neoStores, (IndexingService)Mockito.mock(IndexingService.class), (LabelScanStore)Mockito.mock(LabelScanStore.class), Iterables.empty());
        LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
        Mockito.when((Object)logProvider.getLog((Class)Matchers.any(Class.class))).thenReturn(Mockito.mock(Log.class));
        return new CheckPointerImpl((TransactionIdStore)metaDataStore, (CheckPointThreshold)committedTransactionThreshold, storeFlusher, (LogPruning)Mockito.mock(LogPruning.class), appender, kernelHealth, logProvider, (CheckPointTracer)Mockito.mock(CheckPointTracer.class));
    }

    private static final class CommandHelper {
        private CommandHelper() {
        }

        static List<Command> createListOfCommands(long highId) {
            IndexDefineCommand indexDefineCommand = CommandHelper.createIndexDefinedCommand();
            return Arrays.asList(indexDefineCommand, CommandHelper.createAddNodeCommand(indexDefineCommand), CommandHelper.createNodeCommand(highId));
        }

        private static IndexDefineCommand createIndexDefinedCommand() {
            Map indexNames = MapUtil.genericMap((Object[])new Object[]{TransactionRepresentationCommitProcessIT.INDEX_NAME, 0});
            IndexDefineCommand indexDefineCommand = new IndexDefineCommand();
            indexDefineCommand.init(indexNames, Collections.emptyMap());
            return indexDefineCommand;
        }

        private static Command createAddNodeCommand(IndexDefineCommand indexDefineCommand) {
            IndexCommand.AddNodeCommand addNodeCommand = new IndexCommand.AddNodeCommand();
            addNodeCommand.init(indexDefineCommand.getOrAssignIndexNameId(TransactionRepresentationCommitProcessIT.INDEX_NAME), 0L, 0, (Object)"test");
            return addNodeCommand;
        }

        private static Command createNodeCommand(long currentHighId) {
            Command.NodeCommand nodeCommand = new Command.NodeCommand();
            NodeRecord beforeRecord = new NodeRecord(currentHighId - 1L);
            NodeRecord afterRecord = new NodeRecord(currentHighId);
            nodeCommand.init(beforeRecord, afterRecord);
            return nodeCommand;
        }
    }

    private static class TransactionalWorker
    implements Callable<Long> {
        private final NeoStores neoStores;
        private final TransactionAppender appender;
        private final TransactionRepresentationStoreApplier storeApplier;
        private final CountDownLatch completedLatch;
        private volatile boolean completed = false;

        public TransactionalWorker(NeoStores neoStores, TransactionAppender appender, TransactionRepresentationStoreApplier storeApplier, CountDownLatch completedLatch) {
            this.neoStores = neoStores;
            this.appender = appender;
            this.storeApplier = storeApplier;
            this.completedLatch = completedLatch;
        }

        @Override
        public Long call() {
            long lastCommittedTransaction = 0L;
            while (!this.isCompleted()) {
                try {
                    TransactionRepresentationCommitProcess transactionCommit = this.createTransactionCommitProcess();
                    PhysicalTransactionRepresentation transactionRepresentation = this.createPhysicalTransactionRepresentation();
                    this.randomSleep();
                    lastCommittedTransaction = transactionCommit.commit((TransactionRepresentation)transactionRepresentation, new LockGroup(), CommitEvent.NULL, TransactionApplicationMode.INTERNAL);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.completedLatch.countDown();
            return lastCommittedTransaction;
        }

        private void randomSleep() throws InterruptedException {
            Thread.sleep(ThreadLocalRandom.current().nextInt(50));
        }

        private PhysicalTransactionRepresentation createPhysicalTransactionRepresentation() {
            long nextId = this.neoStores.getNodeStore().nextId();
            PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(CommandHelper.createListOfCommands(nextId));
            transactionRepresentation.setHeader(new byte[0], 0, 0, System.currentTimeMillis(), this.neoStores.getMetaDataStore().getLastCommittedTransactionId(), 0L, 0);
            return transactionRepresentation;
        }

        private TransactionRepresentationCommitProcess createTransactionCommitProcess() throws IOException {
            IndexUpdatesValidator updatesValidator = (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class);
            Mockito.when((Object)updatesValidator.validate((TransactionRepresentation)Matchers.any(TransactionRepresentation.class))).thenReturn(Mockito.mock(ValidatedIndexUpdates.class));
            return new TransactionRepresentationCommitProcess(this.appender, this.storeApplier, updatesValidator);
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void complete() {
            this.completed = true;
        }
    }

    private static class InsaneCheckPointer
    implements Callable<Void> {
        private volatile boolean completed = false;
        private final CheckPointer checkPointer;
        private final CountDownLatch completedLatch;

        public InsaneCheckPointer(CheckPointer checkPointer, CountDownLatch completedLatch) {
            this.checkPointer = checkPointer;
            this.completedLatch = completedLatch;
        }

        @Override
        public Void call() {
            while (!this.isCompleted()) {
                try {
                    this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.completedLatch.countDown();
            return null;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void complete() {
            this.completed = true;
        }
    }
}

