/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.RecoveryIndexingUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;

public class RecoveryIndexingUpdatesValidatorTest {
    private final PrimitiveLongVisitor<RuntimeException> nodeVisitor = (PrimitiveLongVisitor)Mockito.mock(PrimitiveLongVisitor.class);

    @Test
    public void recoveredValidatedUpdatesShouldFlushRecoveredNodeIds() throws Exception {
        long nodeId1 = 42L;
        long nodeId2 = 4242L;
        long nodeId3 = 424242L;
        IndexUpdatesValidator validator = this.newIndexUpdatesValidatorWithMockedDependencies();
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Arrays.asList(RecoveryIndexingUpdatesValidatorTest.nodeAddRandomLabelsCommand(nodeId1), RecoveryIndexingUpdatesValidatorTest.nodeAddRandomLabelsCommand(nodeId2), RecoveryIndexingUpdatesValidatorTest.nodeAddRandomLabelsCommand(nodeId3)));
        try (ValidatedIndexUpdates updates = validator.validate((TransactionRepresentation)tx);){
            updates.flush();
        }
        ((PrimitiveLongVisitor)Mockito.verify(this.nodeVisitor)).visited(nodeId1);
        ((PrimitiveLongVisitor)Mockito.verify(this.nodeVisitor)).visited(nodeId2);
        ((PrimitiveLongVisitor)Mockito.verify(this.nodeVisitor)).visited(nodeId3);
    }

    private IndexUpdatesValidator newIndexUpdatesValidatorWithMockedDependencies() {
        return new RecoveryIndexingUpdatesValidator(this.nodeVisitor);
    }

    private static Command nodeAddRandomLabelsCommand(long nodeId) {
        NodeRecord before = new NodeRecord(nodeId, true, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), (long)Record.NO_LABELS_FIELD.intValue());
        NodeRecord after = new NodeRecord(nodeId, true, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue(), ThreadLocalRandom.current().nextLong(100L));
        Command.NodeCommand command = new Command.NodeCommand();
        command.init(before, after);
        return command;
    }
}

