/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.direct.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.direct.NodeLabelRange;
import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class InMemoryLabelScanStore
implements LabelScanStore {
    private final Map<Long, Set<Long>> data = new HashMap<Long, Set<Long>>();

    private Set<Long> nodeSetForRemoving(long labelId) {
        Set<Long> nodes = this.data.get(labelId);
        return nodes != null ? nodes : Collections.emptySet();
    }

    private Set<Long> nodeSetForAdding(long labelId) {
        Set<Long> nodes = this.data.get(labelId);
        if (nodes == null) {
            nodes = new HashSet<Long>();
            this.data.put(labelId, nodes);
        }
        return nodes;
    }

    public LabelScanReader newReader() {
        return new LabelScanReader(){

            public PrimitiveLongIterator nodesWithLabel(int labelId) {
                Set nodes = (Set)InMemoryLabelScanStore.this.data.get(labelId);
                if (null == nodes) {
                    return PrimitiveLongCollections.emptyIterator();
                }
                final Iterator nodesIterator = nodes.iterator();
                return new PrimitiveLongIterator(){

                    @Override
                    public long next() {
                        return (Long)nodesIterator.next();
                    }

                    @Override
                    public boolean hasNext() {
                        return nodesIterator.hasNext();
                    }
                };
            }

            public void close() {
            }

            public Iterator<Long> labelsForNode(long nodeId) {
                ArrayList nodes = new ArrayList();
                for (Map.Entry entry : InMemoryLabelScanStore.this.data.entrySet()) {
                    if (!((Set)entry.getValue()).contains(nodeId)) continue;
                    nodes.add(entry.getKey());
                }
                return nodes.iterator();
            }
        };
    }

    public AllEntriesLabelScanReader newAllEntriesReader() {
        final HashMap nodesToLabels = new HashMap();
        for (Map.Entry<Long, Set<Long>> labelToNodes : this.data.entrySet()) {
            for (Long nodeId : labelToNodes.getValue()) {
                if (!nodesToLabels.containsKey(nodeId)) {
                    nodesToLabels.put(nodeId, new HashSet());
                }
                ((Set)nodesToLabels.get(nodeId)).add(labelToNodes.getKey());
            }
        }
        return new AllEntriesLabelScanReader(){

            public long maxCount() {
                return 0L;
            }

            public void close() {
            }

            public Iterator<NodeLabelRange> iterator() {
                NodeLabelRange range = new NodeLabelRange(){

                    public int id() {
                        return 0;
                    }

                    public long[] nodes() {
                        return this.toLongArray(nodesToLabels.keySet());
                    }

                    public long[] labels(long nodeId) {
                        return this.toLongArray((Set)nodesToLabels.get(nodeId));
                    }
                };
                return Collections.singletonList(range).iterator();
            }

            private long[] toLongArray(Set<Long> longs) {
                long[] array = new long[longs.size()];
                int position = 0;
                for (Long entry : longs) {
                    array[position++] = entry;
                }
                return array;
            }
        };
    }

    public ResourceIterator<File> snapshotStoreFiles() {
        return IteratorUtil.emptyIterator();
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }

    public LabelScanWriter newWriter() {
        return new LabelScanWriter(){

            public void write(NodeLabelUpdate update) throws IOException {
                int i;
                long[] added = new long[update.getLabelsAfter().length];
                long[] removed = new long[update.getLabelsBefore().length];
                int addedIndex = 0;
                int removedIndex = 0;
                for (long labelAfter : update.getLabelsAfter()) {
                    if (Arrays.binarySearch(update.getLabelsBefore(), labelAfter) >= 0) continue;
                    added[addedIndex++] = labelAfter;
                }
                for (long labelBefore : update.getLabelsBefore()) {
                    if (Arrays.binarySearch(update.getLabelsAfter(), labelBefore) >= 0) continue;
                    removed[removedIndex++] = labelBefore;
                }
                for (i = 0; i < addedIndex; ++i) {
                    InMemoryLabelScanStore.this.nodeSetForAdding(added[i]).add(update.getNodeId());
                }
                for (i = 0; i < removedIndex; ++i) {
                    InMemoryLabelScanStore.this.nodeSetForRemoving(removed[i]).remove(update.getNodeId());
                }
            }

            public void close() throws IOException {
            }
        };
    }

    public void force() {
    }
}

