/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DiskLayerTest {
    protected GraphDatabaseAPI db;
    protected final Label label1 = DynamicLabel.label((String)"FirstLabel");
    protected final Label label2 = DynamicLabel.label((String)"SecondLabel");
    protected final RelationshipType relType1 = DynamicRelationshipType.withName((String)"type1");
    protected final RelationshipType relType2 = DynamicRelationshipType.withName((String)"type2");
    protected final String propertyKey = "name";
    protected final String otherPropertyKey = "age";
    protected KernelStatement state;
    protected DiskLayer disk;

    @Before
    public void before() {
        this.db = (GraphDatabaseAPI)this.createGraphDatabase();
        DependencyResolver resolver = this.db.getDependencyResolver();
        IndexingService indexingService = (IndexingService)resolver.resolveDependency(IndexingService.class);
        final NeoStores neoStores = (NeoStores)((NeoStoresSupplier)resolver.resolveDependency(NeoStoresSupplier.class)).get();
        this.disk = new DiskLayer((PropertyKeyTokenHolder)resolver.resolveDependency(PropertyKeyTokenHolder.class), (LabelTokenHolder)resolver.resolveDependency(LabelTokenHolder.class), (RelationshipTypeTokenHolder)resolver.resolveDependency(RelationshipTypeTokenHolder.class), new SchemaStorage((RecordStore)neoStores.getSchemaStore()), neoStores, indexingService, (Factory)new Factory<StoreStatement>(){

            @Override
            public StoreStatement newInstance() {
                return new StoreStatement(neoStores, LockService.NO_LOCK_SERVICE);
            }
        });
        this.state = new KernelStatement(null, (IndexReaderFactory)new IndexReaderFactory.Caching(indexingService), (LabelScanStore)resolver.resolveDependency(LabelScanStore.class), null, null, null, this.disk.acquireStatement());
    }

    protected GraphDatabaseService createGraphDatabase() {
        return new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    protected static Node createLabeledNode(GraphDatabaseService db, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    protected IndexDescriptor createIndexAndAwaitOnline(Label label, String propertyKey) throws Exception {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = this.db.schema().indexFor(label).on(propertyKey).create();
            tx.success();
        }
        var5_4 = null;
        try (Transaction ignored = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(index, 10L, TimeUnit.SECONDS);
            IndexDescriptor indexDescriptor = this.disk.indexesGetForLabelAndPropertyKey(this.disk.labelGetForName(label.name()), this.disk.propertyKeyGetForName(propertyKey));
            return indexDescriptor;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    protected int labelId(Label label) {
        try (Transaction ignored = this.db.beginTx();){
            int n = this.readOps().labelGetForName(label.name());
            return n;
        }
    }

    protected int relationshipTypeId(RelationshipType type) {
        try (Transaction ignored = this.db.beginTx();){
            int n = this.readOps().relationshipTypeGetForName(type.name());
            return n;
        }
    }

    protected int propertyKeyId(String propertyKey) {
        try (Transaction ignored = this.db.beginTx();){
            int n = this.readOps().propertyKeyGetForName(propertyKey);
            return n;
        }
    }

    protected ReadOperations readOps() {
        DependencyResolver dependencyResolver = this.db.getDependencyResolver();
        Statement statement = ((ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class)).get();
        return statement.readOperations();
    }
}

