/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore(value="unstable")
public class TestIsolationMultipleThreads {
    GraphDatabaseService database;
    private static final int COUNT = 1000;

    @Before
    public void setup() {
        this.database = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = this.database.createNode();
                node.setProperty("foo", (Object)0);
            }
            tx.success();
        }
    }

    @After
    public void tearDown() {
        this.database.shutdown();
    }

    @Test
    public void testIsolation() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker(done, this.database));
        new DataChanger(this.database, 1000, done).call();
    }

    @Test
    public void testIsolationWithLocks() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker(done, this.database){

            @Override
            protected Integer getSecondValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1000L);
                this.tx.acquireReadLock((PropertyContainer)nodeById);
                return (Integer)nodeById.getProperty("foo");
            }

            @Override
            protected Integer getFirstValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1L);
                this.tx.acquireReadLock((PropertyContainer)nodeById);
                return (Integer)nodeById.getProperty("foo");
            }
        });
        new DataChanger(this.database, 1000, done).call();
    }

    @Test(expected=DeadlockDetectedException.class)
    public void testIsolationWithLocksReversed() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker(done, this.database){

            @Override
            protected Integer getSecondValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1L);
                this.tx.acquireReadLock((PropertyContainer)nodeById);
                return (Integer)nodeById.getProperty("foo");
            }

            @Override
            protected Integer getFirstValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1000L);
                this.tx.acquireReadLock((PropertyContainer)nodeById);
                return (Integer)nodeById.getProperty("foo");
            }
        });
        new DataChanger(this.database, 1000, done).call();
        executor.shutdownNow();
    }

    @Test
    public void testIsolationWithShortLocks() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker(done, this.database){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Integer getSecondValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1000L);
                Lock lock = this.tx.acquireReadLock((PropertyContainer)nodeById);
                try {
                    Integer n = (Integer)nodeById.getProperty("foo");
                    return n;
                }
                finally {
                    lock.release();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Integer getFirstValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1L);
                Lock lock = this.tx.acquireReadLock((PropertyContainer)nodeById);
                try {
                    Integer n = (Integer)nodeById.getProperty("foo");
                    return n;
                }
                finally {
                    lock.release();
                }
            }
        });
        new DataChanger(this.database, 1000, done).call();
        executor.shutdownNow();
    }

    @Test
    public void testIsolationWithShortLocksReversed() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker(done, this.database){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Integer getSecondValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1L);
                Lock lock = this.tx.acquireReadLock((PropertyContainer)nodeById);
                try {
                    Integer n = (Integer)nodeById.getProperty("foo");
                    return n;
                }
                finally {
                    lock.release();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Integer getFirstValue() {
                Node nodeById = TestIsolationMultipleThreads.this.database.getNodeById(1000L);
                Lock lock = this.tx.acquireReadLock((PropertyContainer)nodeById);
                try {
                    Integer n = (Integer)nodeById.getProperty("foo");
                    return n;
                }
                finally {
                    lock.release();
                }
            }
        });
        new DataChanger(this.database, 1000, done).call();
        executor.shutdownNow();
    }

    @Test
    public void testIsolationAll() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker2(1000, done, this.database));
        new DataChanger(this.database, 1000, done).call();
        executor.shutdownNow();
    }

    @Test
    public void testIsolationAllWithLocks() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker2(1000, done, this.database){

            @Override
            protected int getNodeValue(int i) {
                Node node = TestIsolationMultipleThreads.this.database.getNodeById((long)(i + 1));
                this.tx.acquireReadLock((PropertyContainer)node);
                return (Integer)node.getProperty("foo");
            }
        });
        new DataChanger(this.database, 1000, done).call();
        executor.shutdownNow();
    }

    @Test(expected=DeadlockDetectedException.class)
    public void testIsolationAllWithLocksReverse() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        AtomicBoolean done = new AtomicBoolean(false);
        executor.submit(new DataChecker2(1000, done, this.database){

            @Override
            protected int getNodeValue(int i) {
                Node node = TestIsolationMultipleThreads.this.database.getNodeById((long)(1000 - i));
                this.tx.acquireReadLock((PropertyContainer)node);
                return (Integer)node.getProperty("foo");
            }
        });
        new DataChanger(this.database, 1000, done).call();
        executor.shutdownNow();
    }

    private static class DataChecker2
    implements Runnable {
        private final int count;
        private final AtomicBoolean done;
        private final GraphDatabaseService database;
        protected Transaction tx;

        public DataChecker2(int count, AtomicBoolean done, GraphDatabaseService database) {
            this.count = count;
            this.done = done;
            this.database = database;
        }

        @Override
        public void run() {
            System.out.println("Start checking data");
            int totalDiff = 0;
            while (!this.done.get()) {
                try {
                    Transaction tx = this.database.beginTx();
                    Throwable throwable = null;
                    try {
                        int correctValue = -1;
                        int diff = 0;
                        for (int i = 0; i < this.count; ++i) {
                            int foo = this.getNodeValue(i);
                            if (correctValue == -1) {
                                correctValue = foo;
                            }
                            diff = diff + foo - correctValue;
                        }
                        totalDiff += diff;
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.tx.failure();
                }
            }
            System.out.printf("Done checking data, %d diff\n", totalDiff);
        }

        protected int getNodeValue(int i) {
            Node node = this.database.getNodeById((long)(i + 1));
            return (Integer)node.getProperty("foo");
        }
    }

    private static class DataChecker
    implements Runnable {
        private final AtomicBoolean done;
        private final GraphDatabaseService database;
        protected Transaction tx;

        public DataChecker(AtomicBoolean done, GraphDatabaseService database) {
            this.done = done;
            this.database = database;
        }

        @Override
        public void run() {
            System.out.println("Start checking data");
            double errors = 0.0;
            double total = 0.0;
            while (!this.done.get()) {
                Transaction transaction = this.database.beginTx();
                Throwable throwable = null;
                try {
                    int firstNode = this.getFirstValue();
                    int lastNode = this.getSecondValue();
                    if (firstNode - lastNode != 0) {
                        errors += 1.0;
                    }
                    total += 1.0;
                    this.tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (transaction == null) continue;
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    transaction.close();
                }
            }
            double percentage = errors / total * 100.0;
            System.out.printf("Done checking data, %1.0f errors found(%1.3f%%)\n", errors, percentage);
        }

        protected Integer getSecondValue() {
            return (Integer)this.database.getNodeById(1000L).getProperty("foo");
        }

        protected Integer getFirstValue() {
            return (Integer)this.database.getNodeById(1L).getProperty("foo");
        }
    }

    private static class DataChanger
    implements Callable {
        private final GraphDatabaseService database;
        private final int count;
        private final AtomicBoolean done;

        public DataChanger(GraphDatabaseService database, int count, AtomicBoolean done) {
            this.database = database;
            this.count = count;
            this.done = done;
        }

        public Object call() throws Exception {
            System.out.println("Start changing data");
            int totalDeadlocks = 0;
            try {
                for (int round = 0; round < 100; ++round) {
                    int deadLocks = 0;
                    DeadlockDetectedException ex = null;
                    do {
                        ex = null;
                        try (Transaction tx = this.database.beginTx();){
                            for (int i = 0; i < this.count; ++i) {
                                Node node = this.database.getNodeById((long)(i + 1));
                                int foo = (Integer)node.getProperty("foo");
                                node.setProperty("foo", (Object)(foo + 1));
                            }
                            tx.success();
                        }
                        catch (DeadlockDetectedException e) {
                            System.out.println("Deadlock detected");
                            ex = e;
                            if (++deadLocks <= 100) continue;
                            totalDeadlocks += deadLocks;
                            throw e;
                        }
                    } while (ex != null);
                    totalDeadlocks += deadLocks;
                }
                this.done.set(true);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable throwable) {
                    this.done.set(true);
                    System.out.printf("Done changing data. Detected %d deadlocks\n", totalDeadlocks);
                    throw throwable;
                }
            }
            System.out.printf("Done changing data. Detected %d deadlocks\n", totalDeadlocks);
            return null;
        }
    }
}

