/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.LogMatchers;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class KernelRecoveryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final File storeDir = new File("dir").getAbsoluteFile();

    @Test
    public void shouldHandleWritesProperlyAfterRecovery() throws Exception {
        EphemeralFileSystemAbstraction fs = this.fsRule.get();
        GraphDatabaseService db = this.newDB(fs);
        long node1 = this.createNode(db);
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        db.shutdown();
        db = this.newDB(crashedFs);
        long node2 = this.createNode(db);
        db.shutdown();
        File logFile = new File(this.storeDir, "neostore.transaction.db.0");
        MatcherAssert.assertThat(LogMatchers.logEntries((FileSystemAbstraction)crashedFs, logFile), LogMatchers.containsExactly(LogMatchers.startEntry(-1, -1), LogMatchers.commandEntry(node1, Command.NodeCommand.class), LogMatchers.commandEntry(-1L, Command.NodeCountsCommand.class), LogMatchers.commitEntry(2L), LogMatchers.startEntry(-1, -1), LogMatchers.commandEntry(node2, Command.NodeCommand.class), LogMatchers.commandEntry(-1L, Command.NodeCountsCommand.class), LogMatchers.commitEntry(3L), LogMatchers.checkPoint(new LogPosition(0L, 250L))));
    }

    private GraphDatabaseService newDB(EphemeralFileSystemAbstraction fs) {
        fs.mkdirs(this.storeDir);
        return new TestGraphDatabaseFactory().setFileSystem(fs).newImpermanentDatabase(this.storeDir);
    }

    private long createNode(GraphDatabaseService db) {
        long node1;
        try (Transaction tx = db.beginTx();){
            node1 = db.createNode().getId();
            tx.success();
        }
        return node1;
    }
}

