/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

@RunWith(value=Enclosed.class)
public class UpgradableDatabaseTest {
    private static final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();

    @RunWith(value=Parameterized.class)
    public static class UnsupportedVersions {
        @Rule
        public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
        @Parameterized.Parameter(value=0)
        public String version;
        private File workingDirectory;
        private static final String neostoreFilename = "neostore.nodestore.db";
        @Rule
        public final PageCacheRule pageCacheRule = new PageCacheRule();

        @Parameterized.Parameters(name="{0}")
        public static Collection<Object[]> versions() {
            return Arrays.asList({"v0.9.5"}, {"v0.A.4"});
        }

        @Before
        public void setup() throws IOException {
            this.workingDirectory = this.testDirectory.graphDbDir();
            MigrationTestUtils.findFormatStoreDirectoryForVersion("v0.A.3", this.workingDirectory);
            MigrationTestUtils.changeVersionNumber(fileSystem, new File(this.workingDirectory, neostoreFilename), this.version);
        }

        @Test
        public void shouldDetectOldVersionAsDifferentFromCurrent() throws Exception {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem));
            boolean currentVersion = upgradableDatabase.hasCurrentVersion(this.workingDirectory);
            Assert.assertFalse((boolean)currentVersion);
        }

        @Test
        public void shouldCommunicateWhatCausesInabilityToUpgrade() throws IOException {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem));
            try {
                upgradableDatabase.checkUpgradeable(this.workingDirectory);
                Assert.fail((String)"should not have been able to upgrade");
            }
            catch (StoreUpgrader.UnexpectedUpgradingStoreVersionException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)neostoreFilename));
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)("has a store version number that we cannot upgrade from. Expected 'v0.A.3' but file is version 'NodeStore " + this.version + "'.")));
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SupportedVersions {
        @Rule
        public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
        @Parameterized.Parameter(value=0)
        public String version;
        private File workingDirectory;
        @Rule
        public final PageCacheRule pageCacheRule = new PageCacheRule();

        @Parameterized.Parameters(name="{0}")
        public static Collection<Object[]> versions() {
            return Arrays.asList({"v0.A.0"}, {"v0.A.1"}, {"v0.A.3"}, {"v0.A.5"});
        }

        @Before
        public void setup() throws IOException {
            this.workingDirectory = this.testDirectory.graphDbDir();
            MigrationTestUtils.findFormatStoreDirectoryForVersion(this.version, this.workingDirectory);
        }

        @Test
        public void shouldAcceptTheStoresInTheSampleDatabaseAsBeingEligibleForUpgrade() throws IOException {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem));
            boolean result = upgradableDatabase.storeFilesUpgradeable(this.workingDirectory);
            Assert.assertTrue((boolean)result);
        }

        @Test
        public void shouldRejectStoresIfOneFileHasIncorrectVersion() throws IOException {
            MigrationTestUtils.changeVersionNumber(fileSystem, new File(this.workingDirectory, "neostore.nodestore.db"), "v0.9.5");
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem));
            boolean result = upgradableDatabase.storeFilesUpgradeable(this.workingDirectory);
            Assert.assertFalse((boolean)result);
        }

        @Test
        public void shouldDetectOldVersionAsDifferentFromCurrent() throws Exception {
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem));
            boolean currentVersion = upgradableDatabase.hasCurrentVersion(this.workingDirectory);
            Assert.assertFalse((boolean)currentVersion);
        }

        @Test
        public void shouldRejectStoresIfOneFileShorterThanExpectedVersionString() throws IOException {
            int shortFileLength = 15;
            Assert.assertTrue((15 < UTF8.encode((String)("StringPropertyStore " + this.version)).length ? 1 : 0) != 0);
            MigrationTestUtils.truncateToFixedLength(fileSystem, new File(this.workingDirectory, "neostore.relationshiptypestore.db"), 15);
            UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCacheRule.getPageCache(fileSystem)), new LegacyStoreVersionCheck(fileSystem));
            boolean result = upgradableDatabase.storeFilesUpgradeable(this.workingDirectory);
            Assert.assertFalse((boolean)result);
        }
    }
}

