/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryReader;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryWriter;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;

public class LegacyLogsTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LegacyLogEntryReader reader = (LegacyLogEntryReader)Mockito.mock(LegacyLogEntryReader.class);
    private final LegacyLogEntryWriter writer = (LegacyLogEntryWriter)Mockito.mock(LegacyLogEntryWriter.class);
    private final File storeDir = new File("/store");
    private final File migrationDir = new File("/migration");

    @Test
    public void shouldRewriteLogFiles() throws IOException {
        IOCursor cursor = (IOCursor)Mockito.mock(IOCursor.class);
        LogVersionedStoreChannel writeChannel = (LogVersionedStoreChannel)Mockito.mock(LogVersionedStoreChannel.class);
        LogHeader header = new LogHeader(6, 1L, 42L);
        Mockito.when((Object)this.fs.listFiles(this.storeDir, LegacyLogFilenames.versionedLegacyLogFilesFilter)).thenReturn((Object)new File[]{new File(LegacyLogFilenames.getLegacyLogFilename((int)1))});
        Mockito.when((Object)this.reader.openReadableChannel(new File(LegacyLogFilenames.getLegacyLogFilename((int)1)))).thenReturn((Object)Pair.of((Object)header, (Object)cursor));
        Mockito.when((Object)this.writer.openWritableChannel(new File(this.migrationDir, LegacyLogFilenames.getLegacyLogFilename((int)1)))).thenReturn((Object)writeChannel);
        new LegacyLogs(this.fs, this.reader, this.writer).migrateLogs(this.storeDir, this.migrationDir);
        ((LegacyLogEntryWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeLogHeader(writeChannel, header);
        ((LegacyLogEntryWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeAllLogEntries(writeChannel, cursor);
    }

    @Test
    public void shouldMoveFiles() throws IOException {
        ByteBuffer buffer;
        Throwable throwable;
        StoreChannel channel;
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        fs.mkdirs(this.storeDir);
        fs.mkdirs(this.migrationDir);
        HashSet<File> logsInStoreDir = new HashSet<File>(Arrays.asList(new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)1)), new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)2))));
        List<File> logsInMigrationDir = Arrays.asList(new File(this.migrationDir, LegacyLogFilenames.getLegacyLogFilename((int)1)), new File(this.migrationDir, LegacyLogFilenames.getLegacyLogFilename((int)2)));
        for (File file : logsInMigrationDir) {
            channel = fs.create(file);
            throwable = null;
            try {
                buffer = ByteBuffer.allocate(8);
                buffer.putLong(42L);
                buffer.flip();
                channel.write(buffer);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (channel == null) continue;
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                channel.close();
            }
        }
        for (File file : logsInStoreDir) {
            channel = fs.create(file);
            throwable = null;
            try {
                buffer = ByteBuffer.allocate(8);
                buffer.putLong(13L);
                buffer.flip();
                channel.write(buffer);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (channel == null) continue;
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                channel.close();
            }
        }
        new LegacyLogs((FileSystemAbstraction)fs, this.reader, this.writer).operate(FileOperation.MOVE, this.migrationDir, this.storeDir);
        Assert.assertEquals(logsInStoreDir, new HashSet<File>(Arrays.asList(fs.listFiles(this.storeDir))));
        for (File file : logsInStoreDir) {
            channel = fs.open(file, "r");
            throwable = null;
            try {
                buffer = ByteBuffer.allocate(8);
                channel.read(buffer);
                buffer.flip();
                Assert.assertEquals((long)42L, (long)buffer.getLong());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (channel == null) continue;
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                channel.close();
            }
        }
    }

    @Test
    public void shouldRenameFiles() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        fs.mkdirs(this.storeDir);
        File unrelated = new File(this.storeDir, "unrelated");
        List<File> files = Arrays.asList(new File(this.storeDir, "active_tx_log"), new File(this.storeDir, "tm_tx_log.v0"), new File(this.storeDir, "tm_tx_log.v1"), new File(this.storeDir, "nioneo_logical.log.1"), new File(this.storeDir, "nioneo_logical.log.2"), new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)1)), new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)2)), unrelated);
        for (File file : files) {
            fs.create(file).close();
        }
        new LegacyLogs((FileSystemAbstraction)fs, this.reader, this.writer).renameLogFiles(this.storeDir);
        HashSet<File> expected = new HashSet<File>(Arrays.asList(unrelated, new File(this.storeDir, this.getLogFilenameForVersion(1)), new File(this.storeDir, this.getLogFilenameForVersion(2))));
        Assert.assertEquals(expected, new HashSet<File>(Arrays.asList(fs.listFiles(this.storeDir))));
    }

    private String getLogFilenameForVersion(int version) {
        return "neostore.transaction.db." + version;
    }
}

