/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.neo4j.function.BooleanSupplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.TransactionRepresentationFactory;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.Worker;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class Runner
implements Callable<Long> {
    private final File workingDirectory;
    private final BooleanSupplier condition;
    private final int threads;
    private static final PhysicalLogFile.Monitor NOOP_LOGFILE_MONITOR = new PhysicalLogFile.Monitor(){

        public void opened(File logFile, long logVersion, long lastTransactionId, boolean clean) {
        }
    };
    private static final LogRotation.Monitor NOOP_LOGROTATION_MONITOR = new LogRotation.Monitor(){

        public void startedRotating(long currentVersion) {
        }

        public void finishedRotating(long currentVersion) {
        }
    };

    public Runner(File workingDirectory, BooleanSupplier condition, int threads) {
        this.workingDirectory = workingDirectory;
        this.condition = condition;
        this.threads = threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        long lastCommittedTransactionId;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore();
            TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(1000, 100000);
            LogFile logFile = (LogFile)life.add((Lifecycle)this.createPhysicalLogFile(transactionIdStore, transactionMetadataCache));
            TransactionAppender transactionAppender = (TransactionAppender)life.add((Lifecycle)this.createBatchingTransactionAppender(transactionIdStore, transactionMetadataCache, logFile));
            ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
            try {
                Future[] handlers = new Future[this.threads];
                for (int i = 0; i < this.threads; ++i) {
                    TransactionRepresentationFactory factory = new TransactionRepresentationFactory();
                    Worker task = new Worker(transactionAppender, factory, this.condition);
                    handlers[i] = executorService.submit(task);
                }
                for (Future handle : handlers) {
                    handle.get();
                }
            }
            finally {
                executorService.shutdown();
            }
            lastCommittedTransactionId = transactionIdStore.getLastCommittedTransactionId();
        }
        return lastCommittedTransactionId;
    }

    private BatchingTransactionAppender createBatchingTransactionAppender(TransactionIdStore transactionIdStore, TransactionMetadataCache transactionMetadataCache, LogFile logFile) {
        NullLog log = NullLog.getInstance();
        KernelEventHandlers kernelEventHandlers = new KernelEventHandlers((Log)log);
        KernelPanicEventGenerator kpe = new KernelPanicEventGenerator(kernelEventHandlers);
        KernelHealth kernelHealth = new KernelHealth(kpe, (Log)log);
        LogRotationImpl logRotation = new LogRotationImpl(NOOP_LOGROTATION_MONITOR, logFile, kernelHealth);
        return new BatchingTransactionAppender(logFile, (LogRotation)logRotation, transactionMetadataCache, transactionIdStore, IdOrderingQueue.BYPASS, kernelHealth);
    }

    private PhysicalLogFile createPhysicalLogFile(TransactionIdStore transactionIdStore, TransactionMetadataCache transactionMetadataCache) {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.workingDirectory, (FileSystemAbstraction)fs);
        long rotateAtSize = (Long)Settings.BYTES.apply((Object)GraphDatabaseSettings.logical_log_rotation_threshold.getDefaultValue());
        DeadSimpleLogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(0L);
        return new PhysicalLogFile((FileSystemAbstraction)fs, logFiles, rotateAtSize, transactionIdStore, (LogVersionRepository)logVersionRepository, NOOP_LOGFILE_MONITOR, transactionMetadataCache);
    }
}

