/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.io.IOException;
import org.neo4j.function.BooleanSupplier;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.TransactionRepresentationFactory;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;

class Worker
implements Runnable {
    private final TransactionAppender transactionAppender;
    private final TransactionRepresentationFactory factory;
    private final BooleanSupplier condition;

    public Worker(TransactionAppender transactionAppender, TransactionRepresentationFactory factory, BooleanSupplier condition) {
        this.transactionAppender = transactionAppender;
        this.factory = factory;
        this.condition = condition;
    }

    @Override
    public void run() {
        long latestTxId = 1L;
        while (this.condition.getAsBoolean()) {
            TransactionRepresentation representation = this.factory.nextTransaction(latestTxId);
            try {
                Commitment commitment = this.transactionAppender.append(representation, LogAppendEvent.NULL);
                commitment.publishAsCommitted();
                latestTxId = commitment.transactionId();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

