/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.helpers.collection.Visitable;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.util.dbstructure.ArgumentFormatter;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureArgumentFormatter;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.kernel.impl.util.dbstructure.InvocationTracer;

public class DbStructureInvocationTracingAcceptanceTest {
    private final String packageName = "org.neo4j.kernel.impl.util.data";
    private final String className = "XXYYZZData";
    private final String classNameWithPackage = "org.neo4j.kernel.impl.util.data.XXYYZZData";

    @Test
    public void outputCompilesWithoutErrors() throws IOException {
        StringBuilder output = new StringBuilder();
        InvocationTracer tracer = new InvocationTracer("Test", "org.neo4j.kernel.impl.util.data", "XXYYZZData", DbStructureVisitor.class, (ArgumentFormatter)DbStructureArgumentFormatter.INSTANCE, (Appendable)output);
        DbStructureVisitor visitor = (DbStructureVisitor)tracer.newProxy();
        this.exerciseVisitor(Functions.constant(visitor));
        tracer.close();
        this.assertCompiles("org.neo4j.kernel.impl.util.data.XXYYZZData", output.toString());
    }

    @Test
    public void compiledOutputCreatesInputTrace() throws IOException {
        StringBuilder output = new StringBuilder();
        InvocationTracer tracer = new InvocationTracer("Test", "org.neo4j.kernel.impl.util.data", "XXYYZZData", DbStructureVisitor.class, (ArgumentFormatter)DbStructureArgumentFormatter.INSTANCE, (Appendable)output);
        this.exerciseVisitor(Functions.constant(tracer.newProxy()));
        tracer.close();
        Visitable<DbStructureVisitor> visitable = this.compileVisitable("org.neo4j.kernel.impl.util.data.XXYYZZData", output.toString());
        final DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        visitable.accept((Object)visitor);
        this.exerciseVisitor(new Function<Object, DbStructureVisitor>(){

            @Override
            public DbStructureVisitor apply(Object o) throws RuntimeException {
                return (DbStructureVisitor)Mockito.verify((Object)visitor);
            }
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{visitor});
    }

    @Test
    public void compiledOutputProducesSameCompiledOutputIfCompiledAgain() throws IOException {
        StringBuilder output1 = new StringBuilder();
        InvocationTracer tracer1 = new InvocationTracer("Test", "org.neo4j.kernel.impl.util.data", "XXYYZZData", DbStructureVisitor.class, (ArgumentFormatter)DbStructureArgumentFormatter.INSTANCE, (Appendable)output1);
        DbStructureVisitor visitor1 = (DbStructureVisitor)tracer1.newProxy();
        this.exerciseVisitor(Functions.constant(visitor1));
        tracer1.close();
        String source1 = output1.toString();
        Visitable<DbStructureVisitor> visitable = this.compileVisitable("org.neo4j.kernel.impl.util.data.XXYYZZData", source1);
        StringBuilder output2 = new StringBuilder();
        InvocationTracer tracer2 = new InvocationTracer("Test", "org.neo4j.kernel.impl.util.data", "XXYYZZData", DbStructureVisitor.class, (ArgumentFormatter)DbStructureArgumentFormatter.INSTANCE, (Appendable)output2);
        DbStructureVisitor visitor2 = (DbStructureVisitor)tracer2.newProxy();
        visitable.accept((Object)visitor2);
        tracer2.close();
        String source2 = output2.toString();
        Assert.assertEquals((Object)source1, (Object)source2);
    }

    private void exerciseVisitor(Function<Object, DbStructureVisitor> visitor) {
        visitor.apply(null).visitLabel(0, "Person");
        visitor.apply(null).visitLabel(1, "Party");
        visitor.apply(null).visitPropertyKey(0, "name");
        visitor.apply(null).visitPropertyKey(1, "age");
        visitor.apply(null).visitRelationshipType(0, "ACCEPTS");
        visitor.apply(null).visitRelationshipType(1, "REJECTS");
        visitor.apply(null).visitIndex(new IndexDescriptor(0, 1), ":Person(age)", 0.5, 1L);
        visitor.apply(null).visitUniqueIndex(new IndexDescriptor(0, 0), ":Person(name)", 0.5, 1L);
        visitor.apply(null).visitUniqueConstraint(new UniquenessConstraint(1, 0), ":Party(name)");
        visitor.apply(null).visitAllNodesCount(55L);
        visitor.apply(null).visitNodeCount(0, "Person", 50L);
        visitor.apply(null).visitNodeCount(0, "Party", 5L);
        visitor.apply(null).visitRelCount(0, 1, -1, "MATCH (:Person)-[:REJECTS]->() RETURN count(*)", 5L);
    }

    private void assertCompiles(final String className, String source) {
        this.compile(className, source, new CompilationListener<Boolean>(){

            @Override
            public Boolean compiled(Boolean success, JavaFileManager manager, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
                DbStructureInvocationTracingAcceptanceTest.this.assertSuccessfullyCompiled(success, diagnostics, className);
                return true;
            }
        });
    }

    private Visitable<DbStructureVisitor> compileVisitable(final String className, String inputSource) {
        return this.compile(className, inputSource, new CompilationListener<Visitable<DbStructureVisitor>>(){

            @Override
            public Visitable<DbStructureVisitor> compiled(Boolean success, JavaFileManager manager, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
                Object instance;
                DbStructureInvocationTracingAcceptanceTest.this.assertSuccessfullyCompiled(success, diagnostics, className);
                try {
                    ClassLoader classLoader = manager.getClassLoader(null);
                    Class<?> clazz = classLoader.loadClass(className);
                    instance = clazz.getDeclaredField("INSTANCE").get(null);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                    throw new AssertionError("Failed to instantiate compiled class", e);
                }
                return (Visitable)instance;
            }
        });
    }

    private void assertSuccessfullyCompiled(Boolean success, List<Diagnostic<? extends JavaFileObject>> diagnostics, String className) {
        if (success == null || !success.booleanValue()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Failed to compile: ");
            builder.append(className);
            builder.append("\n\n");
            for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
                builder.append(diagnostic.toString());
                builder.append("\n");
            }
            throw new AssertionError((Object)builder.toString());
        }
    }

    private <T> T compile(String className, String source, CompilationListener<T> listener) {
        JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
        InMemFileManager manager = new InMemFileManager();
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        List<InMemSource> sources = Arrays.asList(new InMemSource(className, source));
        JavaCompiler.CompilationTask task = systemCompiler.getTask(null, manager, diagnosticsCollector, null, null, sources);
        Boolean success = task.call();
        return listener.compiled(success, manager, diagnosticsCollector.getDiagnostics());
    }

    private static class InMemFileManager
    extends ForwardingJavaFileManager {
        private final Map<String, InMemSink> classes = new HashMap<String, InMemSink>();

        InMemFileManager() {
            super(ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null));
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new SecureClassLoader(){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    byte[] byteCode = ((InMemSink)InMemFileManager.this.classes.get(name)).getBytes();
                    return super.defineClass(name, byteCode, 0, byteCode.length);
                }
            };
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (StandardLocation.CLASS_OUTPUT == location && JavaFileObject.Kind.CLASS == kind) {
                InMemSink clazz = new InMemSink(className);
                this.classes.put(className, clazz);
                return clazz;
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }
    }

    private static class InMemSink
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream byteCodeStream = new ByteArrayOutputStream();

        InMemSink(String className) {
            super(URI.create("mem:///" + className + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
        }

        public byte[] getBytes() {
            return this.byteCodeStream.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.byteCodeStream;
        }
    }

    private static class InMemSource
    extends SimpleJavaFileObject {
        final String javaSource;

        InMemSource(String className, String javaSource) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.javaSource = javaSource;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.javaSource;
        }
    }

    private static interface CompilationListener<T> {
        public T compiled(Boolean var1, JavaFileManager var2, List<Diagnostic<? extends JavaFileObject>> var3);
    }
}

