/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.async;

import java.util.Objects;
import org.neo4j.concurrent.AsyncEventSender;
import org.neo4j.function.Consumer;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.async.AsyncLogEvent;

public class AsyncLog
extends AbstractLog {
    private final Log log;
    private final AsyncEventSender<AsyncLogEvent> events;

    public AsyncLog(AsyncEventSender<AsyncLogEvent> events, Log log) {
        this.log = Objects.requireNonNull(log, "Log");
        this.events = Objects.requireNonNull(events, "AsyncEventSender<AsyncLogEvent>");
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public Logger debugLogger() {
        return new AsyncLogger(this.events, this.log.debugLogger());
    }

    @Override
    public Logger infoLogger() {
        return new AsyncLogger(this.events, this.log.infoLogger());
    }

    @Override
    public Logger warnLogger() {
        return new AsyncLogger(this.events, this.log.warnLogger());
    }

    @Override
    public Logger errorLogger() {
        return new AsyncLogger(this.events, this.log.errorLogger());
    }

    @Override
    public void bulk(Consumer<Log> consumer) {
        this.events.send(AsyncLogEvent.bulkLogEvent(this.log, consumer));
    }

    private static class AsyncLogger
    implements Logger {
        private final Logger logger;
        private final AsyncEventSender<AsyncLogEvent> events;

        AsyncLogger(AsyncEventSender<AsyncLogEvent> events, Logger logger) {
            this.logger = Objects.requireNonNull(logger, "Logger");
            this.events = events;
        }

        @Override
        public void log(String message) {
            this.events.send(AsyncLogEvent.logEvent(this.logger, message));
        }

        @Override
        public void log(String message, Throwable throwable) {
            this.events.send(AsyncLogEvent.logEvent(this.logger, message, throwable));
        }

        @Override
        public void log(String format, Object ... arguments) {
            this.events.send(AsyncLogEvent.logEvent(this.logger, format, arguments));
        }

        @Override
        public void bulk(Consumer<Logger> consumer) {
            this.events.send(AsyncLogEvent.bulkLogEvent(this.logger, consumer));
        }
    }
}

