/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.Map;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.ExternalResource;

public class NeoStoreDataSourceRule
extends ExternalResource {
    private NeoStoreDataSource dataSource;

    public NeoStoreDataSource getDataSource(File storeDir, FileSystemAbstraction fs, PageCache pageCache, Map<String, String> additionalConfig, KernelHealth kernelHealth) {
        if (this.dataSource != null) {
            this.dataSource.stop();
            this.dataSource.shutdown();
        }
        Config config = new Config(MapUtil.stringMap(additionalConfig, (String[])new String[0]), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs), pageCache, fs, (LogProvider)NullLogProvider.getInstance());
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Mockito.when((Object)locks.newClient()).thenReturn(Mockito.mock(Locks.Client.class));
        this.dataSource = new NeoStoreDataSource(storeDir, config, sf, (LogProvider)NullLogProvider.getInstance(), (JobScheduler)Mockito.mock(JobScheduler.class, (Answer)Mockito.RETURNS_MOCKS), (TokenNameLookup)Mockito.mock(TokenNameLookup.class), this.dependencyResolverForNoIndexProvider(), (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), locks, (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), (TransactionEventHandlers)Mockito.mock(TransactionEventHandlers.class), IndexingService.NO_MONITOR, fs, (StoreUpgrader)Mockito.mock(StoreUpgrader.class), (TransactionMonitor)Mockito.mock(TransactionMonitor.class), kernelHealth, (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class), TransactionHeaderInformationFactory.DEFAULT, new StartupStatisticsProvider(), (NodeManager)Mockito.mock(NodeManager.class), null, null, (CommitProcessFactory)new CommunityCommitProcessFactory(), (PageCache)Mockito.mock(PageCache.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), new Monitors(), new Tracers("null", (Log)NullLog.getInstance()));
        return this.dataSource;
    }

    public NeoStoreDataSource getDataSource(File storeDir, FileSystemAbstraction fs, PageCache pageCache, Map<String, String> additionalConfig) {
        KernelHealth kernelHealth = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), NullLogProvider.getInstance().getLog(KernelHealth.class));
        return this.getDataSource(storeDir, fs, pageCache, additionalConfig, kernelHealth);
    }

    private DependencyResolver dependencyResolverForNoIndexProvider() {
        return new DependencyResolver.Adapter(){
            private final LabelScanStoreProvider labelScanStoreProvider = new LabelScanStoreProvider((LabelScanStore)new InMemoryLabelScanStore(), 10);

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws IllegalArgumentException {
                if (SchemaIndexProvider.class.isAssignableFrom(type)) {
                    return type.cast(SchemaIndexProvider.NO_INDEX_PROVIDER);
                }
                if (LabelScanStoreProvider.class.isAssignableFrom(type)) {
                    return type.cast(this.labelScanStoreProvider);
                }
                throw new IllegalArgumentException(type.toString());
            }
        };
    }
}

