/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TraceCounter {
    private static Map<String, Map<List<StackTraceElement>, AtomicInteger>> traceCounts = new HashMap<String, Map<List<StackTraceElement>, AtomicInteger>>();

    public static String trace(String name) {
        List<StackTraceElement> trace;
        AtomicInteger count;
        Map<List<StackTraceElement>, AtomicInteger> namedTraces = traceCounts.get(name);
        if (namedTraces == null) {
            namedTraces = new HashMap<List<StackTraceElement>, AtomicInteger>();
            traceCounts.put(name, namedTraces);
        }
        if ((count = namedTraces.get(trace = Arrays.asList(new Exception().getStackTrace()))) == null) {
            count = new AtomicInteger();
            namedTraces.put(trace, count);
        }
        count.incrementAndGet();
        return "";
    }

    public static void clear() {
        traceCounts.clear();
    }

    public static void print(PrintWriter out) {
        for (Map.Entry<String, Map<List<StackTraceElement>, AtomicInteger>> stringMapEntry : traceCounts.entrySet()) {
            out.println(stringMapEntry.getKey());
            for (Map.Entry<List<StackTraceElement>, AtomicInteger> listAtomicIntegerEntry : stringMapEntry.getValue().entrySet()) {
                out.println(listAtomicIntegerEntry.getValue().get() + ":");
                for (StackTraceElement stackTraceElement : listAtomicIntegerEntry.getKey()) {
                    out.println(stackTraceElement);
                }
                out.println();
            }
            out.println("---------------------------------");
        }
    }

    public static String asString() {
        StringWriter writer = new StringWriter();
        PrintWriter print = new PrintWriter(writer);
        TraceCounter.print(print);
        print.close();
        return writer.toString();
    }
}

