/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;

public class ProcessorAssignmentStrategies {
    public static ExecutionMonitor eagerRandomSaturation(final int availableProcessor) {
        return new AbstractAssigner(Clock.SYSTEM_CLOCK, 10L, TimeUnit.SECONDS){

            public void start(StageExecution[] executions) {
                this.saturate(availableProcessor, executions);
                this.registerProcessorCount(executions);
            }

            private void saturate(int availableProcessor2, StageExecution[] executions) {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int processors = availableProcessor2;
                for (int rounds = 0; rounds < availableProcessor2 && processors > 0; ++rounds) {
                    for (StageExecution execution : executions) {
                        for (Step step : execution.steps()) {
                            if (!((Random)random).nextBoolean() || !step.incrementNumberOfProcessors() || --processors != 0) continue;
                            return;
                        }
                    }
                }
            }

            public void check(StageExecution[] executions) {
            }
        };
    }

    public static ExecutionMonitor randomSaturationOverTime(final int availableProcessor) {
        return new AbstractAssigner(Clock.SYSTEM_CLOCK, 100L, TimeUnit.MILLISECONDS){
            private int processors;
            {
                super(x0, x1, x2);
                this.processors = availableProcessor;
            }

            public void check(StageExecution[] executions) {
                this.saturate(executions);
                this.registerProcessorCount(executions);
            }

            private void saturate(StageExecution[] executions) {
                if (this.processors == 0) {
                    return;
                }
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int maxThisCheck = ((Random)random).nextInt(this.processors - 1) + 1;
                for (StageExecution execution : executions) {
                    for (Step step : execution.steps()) {
                        if (!((Random)random).nextBoolean() || !step.incrementNumberOfProcessors()) continue;
                        --this.processors;
                        if (--maxThisCheck != 0) continue;
                        return;
                    }
                }
            }
        };
    }

    private static abstract class AbstractAssigner
    extends ExecutionMonitor.Adapter {
        private final Map<String, Map<String, Integer>> processors = new HashMap<String, Map<String, Integer>>();

        protected AbstractAssigner(Clock clock, long time, TimeUnit unit) {
            super(clock, time, unit);
        }

        protected void registerProcessorCount(StageExecution[] executions) {
            for (StageExecution execution : executions) {
                HashMap<String, Integer> byStage = new HashMap<String, Integer>();
                this.processors.put(execution.getStageName(), byStage);
                for (Step step : execution.steps()) {
                    byStage.put(step.name(), step.numberOfProcessors());
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (String stage : this.processors.keySet()) {
                builder.append(stage).append(':');
                Map<String, Integer> byStage = this.processors.get(stage);
                for (String step : byStage.keySet()) {
                    builder.append(String.format("%n  %s:%d", step, byStage.get(step)));
                }
                builder.append(String.format("%n", new Object[0]));
            }
            return builder.toString();
        }
    }
}

