/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.httpclient.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;

public class HttpIdleConnectionReaper {
    private final HttpClient httpClient;
    private final long idleCheckInterval;
    private final long idleTimeOut;
    private final ReaperThread reaperThread;

    public HttpIdleConnectionReaper(HttpClient httpClient, long idleCheckInterval, long idleTimeout) {
        if (httpClient == null) {
            throw new IllegalArgumentException("HttpClient is a required parameter");
        }
        this.httpClient = httpClient;
        this.idleCheckInterval = idleCheckInterval;
        this.idleTimeOut = idleTimeout;
        ReaperThread reaperThread = this.reaperThread = idleCheckInterval > 0L ? new ReaperThread() : null;
        if (this.reaperThread != null) {
            this.reaperThread.start();
        }
    }

    public boolean isStarted() {
        return this.reaperThread != null && this.reaperThread.isAlive();
    }

    public boolean isStopped() {
        return this.reaperThread != null || !this.reaperThread.isAlive();
    }

    public void stop() throws InterruptedException {
        if (this.reaperThread == null) {
            return;
        }
        this.reaperThread.shutdown = true;
        this.reaperThread.interrupt();
        this.reaperThread.join(1000L);
    }

    public void waitForReaperStart(long millis) throws InterruptedException {
        this.reaperThread.waitForStart(millis);
    }

    public void waitForReaperStop(long millis) throws InterruptedException {
        this.reaperThread.waitForStop(millis);
    }

    private class ReaperThread
    extends Thread {
        private volatile boolean shutdown;
        private final CountDownLatch shutdownLatch = new CountDownLatch(1);
        private final CountDownLatch startupLatch = new CountDownLatch(1);

        private ReaperThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startupLatch.countDown();
                while (!this.shutdown && !this.isInterrupted()) {
                    try {
                        Thread.sleep(HttpIdleConnectionReaper.this.idleCheckInterval);
                    }
                    catch (InterruptedException interrupted) {
                        continue;
                    }
                    HttpIdleConnectionReaper.this.httpClient.getConnectionManager().closeExpiredConnections();
                    HttpIdleConnectionReaper.this.httpClient.getConnectionManager().closeIdleConnections(HttpIdleConnectionReaper.this.idleTimeOut, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.shutdownLatch.countDown();
            }
        }

        void waitForStart(long millis) throws InterruptedException {
            this.startupLatch.await(millis, TimeUnit.MILLISECONDS);
        }

        void waitForStop(long millis) throws InterruptedException {
            this.shutdownLatch.await(millis, TimeUnit.MILLISECONDS);
        }
    }
}

