/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.test.EmbeddedDatabaseRule;

public class DeadlockDocTest {
    @Rule
    public EmbeddedDatabaseRule rule = new EmbeddedDatabaseRule();

    @Test
    public void transactionWithRetries() throws InterruptedException {
        Object result = this.transactionWithRetry();
    }

    @Test
    public void transactionWithTemplate() throws InterruptedException {
        GraphDatabaseService graphDatabaseService = this.rule.getGraphDatabaseService();
        TransactionTemplate template = new TransactionTemplate().retries(5).backoff(3L, TimeUnit.SECONDS);
        Object result = template.with(graphDatabaseService).execute((Function)new Function<Transaction, Object>(){

            @Override
            public Object apply(Transaction transaction) throws RuntimeException {
                Object result = null;
                return result;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object transactionWithRetry() {
        GraphDatabaseService graphDatabaseService = this.rule.getGraphDatabaseService();
        Throwable txEx = null;
        int RETRIES = 5;
        int BACKOFF = 3000;
        for (int i = 0; i < RETRIES; ++i) {
            try (Transaction tx = graphDatabaseService.beginTx();){
                Object result = this.doStuff(tx);
                tx.success();
                Object object = result;
                return object;
            }
            catch (Throwable ex) {
                txEx = ex;
                if (!(ex instanceof DeadlockDetectedException)) break;
                if (i >= RETRIES - 1) continue;
                try {
                    Thread.sleep(BACKOFF);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new TransactionFailureException("Interrupted", (Throwable)e);
                }
            }
        }
        if (txEx instanceof TransactionFailureException) {
            throw (TransactionFailureException)txEx;
        }
        if (txEx instanceof Error) {
            throw (Error)txEx;
        }
        if (!(txEx instanceof RuntimeException)) throw new TransactionFailureException("Failed", txEx);
        throw (RuntimeException)txEx;
    }

    private Object doStuff(Transaction tx) {
        return null;
    }
}

