/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.io.OutputStream;
import org.neo4j.adversaries.Adversary;

public class AdversarialOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private final Adversary adversary;

    public AdversarialOutputStream(OutputStream outputStream, Adversary adversary) {
        this.outputStream = outputStream;
        this.adversary = adversary;
    }

    @Override
    public void write(int b) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.adversary.injectFailure(NullPointerException.class, IndexOutOfBoundsException.class, IOException.class);
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.adversary.injectFailure(NullPointerException.class, IndexOutOfBoundsException.class, IOException.class);
        this.outputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.outputStream.close();
    }
}

