/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.Collections;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.FacadeMethod;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class RelationshipFacadeMethods {
    private static final FacadeMethod<Relationship> HAS_PROPERTY = new FacadeMethod<Relationship>("boolean hasProperty( String key )"){

        @Override
        public void call(Relationship relationship) {
            relationship.hasProperty("foo");
        }
    };
    private static final FacadeMethod<Relationship> GET_PROPERTY = new FacadeMethod<Relationship>("Object getProperty( String key )"){

        @Override
        public void call(Relationship relationship) {
            relationship.getProperty("foo");
        }
    };
    private static final FacadeMethod<Relationship> GET_PROPERTY_WITH_DEFAULT = new FacadeMethod<Relationship>("Object getProperty( String key, Object defaultValue )"){

        @Override
        public void call(Relationship relationship) {
            relationship.getProperty("foo", (Object)42);
        }
    };
    private static final FacadeMethod<Relationship> SET_PROPERTY = new FacadeMethod<Relationship>("void setProperty( String key, Object value )"){

        @Override
        public void call(Relationship relationship) {
            relationship.setProperty("foo", (Object)42);
        }
    };
    private static final FacadeMethod<Relationship> REMOVE_PROPERTY = new FacadeMethod<Relationship>("Object removeProperty( String key )"){

        @Override
        public void call(Relationship relationship) {
            relationship.removeProperty("foo");
        }
    };
    private static final FacadeMethod<Relationship> GET_PROPERTY_KEYS = new FacadeMethod<Relationship>("Iterable<String> getPropertyKeys()"){

        @Override
        public void call(Relationship relationship) {
            for (String string : relationship.getPropertyKeys()) {
            }
        }
    };
    private static final FacadeMethod<Relationship> DELETE = new FacadeMethod<Relationship>("void delete()"){

        @Override
        public void call(Relationship relationship) {
            relationship.delete();
        }
    };
    private static final FacadeMethod<Relationship> GET_START_NODE = new FacadeMethod<Relationship>("Node getStartNode()"){

        @Override
        public void call(Relationship relationship) {
            relationship.getStartNode();
        }
    };
    private static final FacadeMethod<Relationship> GET_END_NODE = new FacadeMethod<Relationship>("Node getEndNode()"){

        @Override
        public void call(Relationship relationship) {
            relationship.getEndNode();
        }
    };
    private static final FacadeMethod<Relationship> GET_OTHER_NODE = new FacadeMethod<Relationship>("Node getOtherNode( Node node )"){

        @Override
        public void call(Relationship relationship) {
            relationship.getOtherNode(null);
        }
    };
    private static final FacadeMethod<Relationship> GET_NODES = new FacadeMethod<Relationship>("Node[] getNodes()"){

        @Override
        public void call(Relationship relationship) {
            for (Node node : relationship.getNodes()) {
            }
        }
    };
    private static final FacadeMethod<Relationship> GET_TYPE = new FacadeMethod<Relationship>("RelationshipType getType()"){

        @Override
        public void call(Relationship relationship) {
            relationship.getType();
        }
    };
    private static final FacadeMethod<Relationship> IS_TYPE = new FacadeMethod<Relationship>("boolean isType( RelationshipType type )"){

        @Override
        public void call(Relationship relationship) {
            relationship.isType((RelationshipType)DynamicRelationshipType.withName((String)"foo"));
        }
    };
    static final Iterable<FacadeMethod<Relationship>> ALL_RELATIONSHIP_FACADE_METHODS = Collections.unmodifiableCollection(Arrays.asList(HAS_PROPERTY, GET_PROPERTY, GET_PROPERTY_WITH_DEFAULT, SET_PROPERTY, REMOVE_PROPERTY, GET_PROPERTY_KEYS, DELETE, GET_START_NODE, GET_END_NODE, GET_OTHER_NODE, GET_NODES, GET_TYPE, IS_TYPE));
}

