/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;

public class TickingClock
implements Clock {
    private long currentNanoTime;
    private long tickNanos;
    private Map<Long, List<Runnable>> actions = new HashMap<Long, List<Runnable>>();

    public TickingClock(long current, long tick, TimeUnit timeUnit) {
        this.currentNanoTime = timeUnit.toNanos(current);
        this.tickNanos = timeUnit.toNanos(tick);
    }

    public TickingClock at(long time, TimeUnit timeUnit, Runnable action) {
        long timeNanos = timeUnit.toNanos(time);
        List<Runnable> actionList = this.actions.get(timeNanos);
        if (actionList == null) {
            actionList = new ArrayList<Runnable>();
            this.actions.put(timeNanos, actionList);
        }
        actionList.add(action);
        return this;
    }

    public long currentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nanoTime() {
        List<Runnable> actionList = this.actions.get(this.currentNanoTime);
        if (actionList != null) {
            for (Runnable runnable : actionList) {
                runnable.run();
            }
        }
        try {
            long l = this.currentNanoTime;
            return l;
        }
        finally {
            this.currentNanoTime += this.tickNanos;
        }
    }
}

