/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;

public class RecordingPageCacheTracer
implements PageCacheTracer {
    private final BlockingQueue<Event> record = new LinkedBlockingQueue<Event>();
    private CountDownLatch trapLatch;
    private Matcher<? extends Event> trap;

    public void pageFaulted(long filePageId, PageSwapper swapper) {
        Fault event = new Fault(swapper, filePageId);
        this.record.add(event);
        this.trip(event);
    }

    public void evicted(long filePageId, PageSwapper swapper) {
        Evict event = new Evict(swapper, filePageId);
        this.record.add(event);
        this.trip(event);
    }

    @Override
    public void mappedFile(File file) {
    }

    @Override
    public void unmappedFile(File file) {
    }

    @Override
    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return new EvictionRunEvent(){

            @Override
            public EvictionEvent beginEviction() {
                return new RecordingEvictionEvent();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public PinEvent beginPin(boolean exclusiveLock, final long filePageId, final PageSwapper swapper) {
        return new PinEvent(){

            @Override
            public void setCachePageId(int cachePageId) {
            }

            @Override
            public PageFaultEvent beginPageFault() {
                return new PageFaultEvent(){

                    @Override
                    public void addBytesRead(long bytes) {
                    }

                    @Override
                    public void done() {
                        RecordingPageCacheTracer.this.pageFaulted(filePageId, swapper);
                    }

                    @Override
                    public void done(Throwable throwable) {
                    }

                    @Override
                    public EvictionEvent beginEviction() {
                        return new RecordingEvictionEvent();
                    }

                    @Override
                    public void setCachePageId(int cachePageId) {
                    }
                };
            }

            @Override
            public void done() {
            }
        };
    }

    @Override
    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return MajorFlushEvent.NULL;
    }

    @Override
    public MajorFlushEvent beginCacheFlush() {
        return MajorFlushEvent.NULL;
    }

    @Override
    public long countFaults() {
        return 0L;
    }

    @Override
    public long countEvictions() {
        return 0L;
    }

    @Override
    public long countPins() {
        return 0L;
    }

    @Override
    public long countUnpins() {
        return 0L;
    }

    @Override
    public long countFlushes() {
        return 0L;
    }

    @Override
    public long countBytesRead() {
        return 0L;
    }

    @Override
    public long countBytesWritten() {
        return 0L;
    }

    @Override
    public long countFilesMapped() {
        return 0L;
    }

    @Override
    public long countFilesUnmapped() {
        return 0L;
    }

    @Override
    public long countEvictionExceptions() {
        return 0L;
    }

    public <T extends Event> T observe(Class<T> type) throws InterruptedException {
        return (T)((Event)type.cast(this.record.take()));
    }

    public <T extends Event> T tryObserve(Class<T> type) {
        return (T)((Event)type.cast(this.record.poll()));
    }

    public synchronized CountDownLatch trap(Matcher<? extends Event> trap) {
        assert (trap != null);
        this.trapLatch = new CountDownLatch(1);
        this.trap = trap;
        return this.trapLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trip(Event event) {
        CountDownLatch theTrapLatch;
        Matcher<? extends Event> theTrap;
        RecordingPageCacheTracer recordingPageCacheTracer = this;
        synchronized (recordingPageCacheTracer) {
            theTrap = this.trap;
            theTrapLatch = this.trapLatch;
        }
        if (theTrap != null && theTrap.matches((Object)event)) {
            try {
                theTrapLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Unexpected interrupt in RecordingMonitor", e);
            }
        }
    }

    private class RecordingEvictionEvent
    implements EvictionEvent {
        private long filePageId;
        private PageSwapper swapper;

        private RecordingEvictionEvent() {
        }

        @Override
        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
            this.swapper = swapper;
        }

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return FlushEventOpportunity.NULL;
        }

        @Override
        public void threwException(IOException exception) {
        }

        @Override
        public void setCachePageId(int cachePageId) {
        }

        @Override
        public void close() {
            RecordingPageCacheTracer.this.evicted(this.filePageId, this.swapper);
        }
    }

    public static class Evict
    extends Event {
        public Evict(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }

    public static class Fault
    extends Event {
        public Fault(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }

    public static abstract class Event {
        public final PageSwapper io;
        public final long pageId;

        public Event(PageSwapper io, long pageId) {
            this.io = io;
            this.pageId = pageId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Event event = (Event)o;
            return this.pageId == event.pageId && !(this.io == null ? event.io != null : !this.io.equals(event.io));
        }

        public int hashCode() {
            int result = this.io != null ? this.io.hashCode() : 0;
            result = 31 * result + (int)(this.pageId ^ this.pageId >>> 32);
            return result;
        }

        public String toString() {
            return String.format("%s{io=%s, pageId=%s}", this.getClass().getSimpleName(), this.io, this.pageId);
        }
    }
}

