/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PageSwapperTest;
import org.neo4j.io.pagecache.impl.ByteBufferPage;
import org.neo4j.io.pagecache.impl.FileLockException;
import org.neo4j.io.pagecache.impl.LockThisFileProgram;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.test.ByteArrayMatcher;

public class SingleFilePageSwapperTest
extends PageSwapperTest {
    private final File file = new File("file");
    private EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();

    @After
    public void tearDown() {
        this.fs.shutdown();
    }

    @Override
    protected PageSwapperFactory swapperFactory() {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.setFileSystemAbstraction(this.getFs());
        return factory;
    }

    @Override
    protected void mkdirs(File dir) throws IOException {
        this.getFs().mkdirs(dir);
    }

    protected File getFile() {
        return this.file;
    }

    protected FileSystemAbstraction getFs() {
        return this.fs;
    }

    protected void assumeFalse(String message, boolean test) {
        if (test) {
            throw new AssumptionViolatedException(message);
        }
    }

    @Test
    public void swappingInMustFillPageWithData() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        StoreChannel channel = this.getFs().create(this.getFile());
        channel.writeAll(this.wrap(bytes));
        channel.close();
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        ByteBuffer target = ByteBuffer.allocateDirect(4);
        ByteBufferPage page = new ByteBufferPage(target);
        swapper.read(0L, page);
        Assert.assertThat((Object)this.array(target), (Matcher)ByteArrayMatcher.byteArray(bytes));
    }

    @Test
    public void mustZeroFillPageBeyondEndOfFile() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6};
        StoreChannel channel = this.getFs().create(this.getFile());
        channel.writeAll(this.wrap(bytes));
        channel.close();
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        ByteBuffer target = ByteBuffer.allocateDirect(4);
        ByteBufferPage page = new ByteBufferPage(target);
        swapper.read(1L, page);
        Assert.assertThat((Object)this.array(target), (Matcher)ByteArrayMatcher.byteArray(new byte[]{5, 6, 0, 0}));
    }

    @Test
    public void swappingOutMustWritePageToFile() throws IOException {
        this.getFs().create(this.getFile()).close();
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBufferPage page = new ByteBufferPage(this.wrap(expected));
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        swapper.write(0L, page);
        InputStream stream = this.getFs().openAsInputStream(this.getFile());
        byte[] actual = new byte[expected.length];
        Assert.assertThat((Object)stream.read(actual), (Matcher)Matchers.is((Object)actual.length));
        Assert.assertThat((Object)actual, (Matcher)ByteArrayMatcher.byteArray(expected));
    }

    @Test
    public void swappingOutMustNotOverwriteDataBeyondPage() throws IOException {
        byte[] initialData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] finalData = new byte[]{1, 2, 3, 4, 8, 7, 6, 5, 9, 10};
        StoreChannel channel = this.getFs().create(this.getFile());
        channel.writeAll(this.wrap(initialData));
        channel.close();
        byte[] change = new byte[]{8, 7, 6, 5};
        ByteBufferPage page = new ByteBufferPage(this.wrap(change));
        PageSwapperFactory factory = this.swapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        swapper.write(1L, page);
        InputStream stream = this.getFs().openAsInputStream(this.getFile());
        byte[] actual = new byte[(int)this.getFs().getFileSize(this.getFile())];
        Assert.assertThat((Object)stream.read(actual), (Matcher)Matchers.is((Object)actual.length));
        Assert.assertThat((Object)actual, (Matcher)ByteArrayMatcher.byteArray(finalData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OverlappingFileLockException.class)
    public void creatingSwapperForFileMustTakeLockOnFile() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.swapperFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        factory.setFileSystemAbstraction(fs);
        File file = this.testDir.file("file");
        fs.create(file).close();
        try (PageSwapper pageSwapper = this.createSwapper(factory, file, 4, NO_CALLBACK, false);){
            StoreFileChannel channel = fs.open(file, "rw");
            Assert.assertThat((Object)channel.tryLock(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test(expected=FileLockException.class)
    public void creatingSwapperForInternallyLockedFileMustThrow() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.swapperFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        factory.setFileSystemAbstraction(fs);
        File file = this.testDir.file("file");
        StoreFileChannel channel = fs.create(file);
        try (FileLock fileLock = channel.tryLock();){
            Assert.assertThat((Object)fileLock, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=FileLockException.class)
    public void creatingSwapperForExternallyLockedFileMustThrow() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.swapperFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        factory.setFileSystemAbstraction(fs);
        File file = this.testDir.file("file");
        fs.create(file).close();
        ProcessBuilder pb = new ProcessBuilder("java", "-cp", ".", LockThisFileProgram.class.getCanonicalName(), file.getAbsolutePath());
        File wd = new File("target/test-classes").getAbsoluteFile();
        pb.directory(wd);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)Matchers.is((Object)"locked"));
        try {
            this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        }
        finally {
            process.getOutputStream().write(0);
            process.getOutputStream().flush();
            process.waitFor();
        }
    }

    @Test
    public void mustUnlockFileWhenThePageSwapperIsClosed() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.swapperFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        factory.setFileSystemAbstraction(fs);
        File file = this.testDir.file("file");
        fs.create(file).close();
        this.createSwapper(factory, file, 4, NO_CALLBACK, false).close();
        try (StoreFileChannel channel = fs.open(file, "rw");
             FileLock fileLock = channel.tryLock();){
            Assert.assertThat((Object)fileLock, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OverlappingFileLockException.class)
    public void fileMustRemainLockedEvenIfChannelIsClosedByStrayInterrupt() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.swapperFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        factory.setFileSystemAbstraction(fs);
        File file = this.testDir.file("file");
        fs.create(file).close();
        try (PageSwapper pageSwapper = this.createSwapper(factory, file, 4, NO_CALLBACK, false);){
            StoreFileChannel channel = fs.open(file, "rw");
            Thread.currentThread().interrupt();
            pageSwapper.force();
            Assert.assertThat((Object)channel.tryLock(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void mustCloseFilesIfTakingFileLockThrows() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        final AtomicInteger openFilesCounter = new AtomicInteger();
        PageSwapperFactory factory = this.swapperFactory();
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        factory.setFileSystemAbstraction(new DelegatingFileSystemAbstraction(fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                openFilesCounter.getAndIncrement();
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void close() throws IOException {
                        openFilesCounter.getAndDecrement();
                        super.close();
                    }
                };
            }
        });
        File file = this.testDir.file("file");
        try (StoreFileChannel ch = fs.create(file);
             FileLock lock = ch.tryLock();){
            this.createSwapper(factory, file, 4, NO_CALLBACK, false).close();
            Assert.fail((String)"Creating a page swapper for a locked channel should have thrown");
        }
        catch (FileLockException fileLockException) {
            // empty catch block
        }
        Assert.assertThat((Object)openFilesCounter.get(), (Matcher)Matchers.is((Object)0));
    }

    private byte[] array(ByteBuffer target) {
        target.clear();
        byte[] array = new byte[target.capacity()];
        while (target.position() < target.capacity()) {
            array[target.position()] = target.get();
        }
        return array;
    }

    private ByteBuffer wrap(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
        for (byte b : bytes) {
            buffer.put(b);
        }
        buffer.clear();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedRead() throws Exception {
        int bytesTotal = 512;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        PageSwapperFactory factory = this.swapperFactory();
        factory.setFileSystemAbstraction(this.getFs());
        File file = this.getFile();
        try (PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);){
            swapper.write(0L, new ByteBufferPage(this.wrap(data)));
        }
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.setFileSystemAbstraction(new AdversarialFileSystemAbstraction(adversary, this.getFs()));
        swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, false);
        ByteBufferPage page = this.createPage(bytesTotal);
        try {
            for (int i = 0; i < 10000; ++i) {
                this.clear(page);
                Assert.assertThat((Object)swapper.read(0L, page), (Matcher)Matchers.is((Object)bytesTotal));
                Assert.assertThat((Object)this.array(page.buffer), (Matcher)Matchers.is((Object)data));
            }
        }
        finally {
            swapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedWrite() throws Exception {
        int bytesTotal = 512;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        ByteBufferPage zeroPage = this.createPage(bytesTotal);
        this.clear(zeroPage);
        File file = this.getFile();
        PageSwapperFactory factory = this.swapperFactory();
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.setFileSystemAbstraction(new AdversarialFileSystemAbstraction(adversary, this.getFs()));
        PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);
        ByteBufferPage page = this.createPage(bytesTotal);
        try {
            for (int i = 0; i < 10000; ++i) {
                adversary.setProbabilityFactor(0.0);
                swapper.write(0L, zeroPage);
                page.putBytes(data, 0, 0, data.length);
                adversary.setProbabilityFactor(1.0);
                Assert.assertThat((Object)swapper.write(0L, page), (Matcher)Matchers.is((Object)bytesTotal));
                this.clear(page);
                adversary.setProbabilityFactor(0.0);
                swapper.read(0L, page);
                Assert.assertThat((Object)this.array(page.buffer), (Matcher)Matchers.is((Object)data));
            }
        }
        finally {
            swapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedVectoredRead() throws Exception {
        int bytesTotal = 512;
        int bytesPerPage = 32;
        int pageCount = bytesTotal / bytesPerPage;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        PageSwapperFactory factory = this.swapperFactory();
        factory.setFileSystemAbstraction(this.getFs());
        File file = this.getFile();
        try (PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);){
            swapper.write(0L, new ByteBufferPage(this.wrap(data)));
        }
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.setFileSystemAbstraction(new AdversarialFileSystemAbstraction(adversary, this.getFs()));
        swapper = this.createSwapper(factory, file, bytesPerPage, NO_CALLBACK, false);
        Page[] pages = new ByteBufferPage[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            pages[i] = this.createPage(bytesPerPage);
        }
        byte[] temp = new byte[bytesPerPage];
        try {
            for (int i = 0; i < 10000; ++i) {
                for (ByteBufferPage byteBufferPage : pages) {
                    this.clear(byteBufferPage);
                }
                Assert.assertThat((Object)swapper.read(0L, pages, 0, pages.length), (Matcher)Matchers.is((Object)bytesTotal));
                for (int j = 0; j < pageCount; ++j) {
                    System.arraycopy(data, j * bytesPerPage, temp, 0, bytesPerPage);
                    Assert.assertThat((Object)this.array(((ByteBufferPage)pages[j]).buffer), (Matcher)Matchers.is((Object)temp));
                }
            }
        }
        finally {
            swapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedVectoredWrite() throws Exception {
        int i;
        int bytesTotal = 512;
        int bytesPerPage = 32;
        int pageCount = bytesTotal / bytesPerPage;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        ByteBufferPage zeroPage = this.createPage(bytesPerPage);
        this.clear(zeroPage);
        File file = this.getFile();
        PageSwapperFactory factory = this.swapperFactory();
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.setFileSystemAbstraction(new AdversarialFileSystemAbstraction(adversary, this.getFs()));
        PageSwapper swapper = this.createSwapper(factory, file, bytesPerPage, NO_CALLBACK, true);
        Page[] writePages = new ByteBufferPage[pageCount];
        Page[] readPages = new ByteBufferPage[pageCount];
        Page[] zeroPages = new ByteBufferPage[pageCount];
        for (i = 0; i < pageCount; ++i) {
            writePages[i] = this.createPage(bytesPerPage);
            writePages[i].putBytes(data, 0, i * bytesPerPage, bytesPerPage);
            readPages[i] = this.createPage(bytesPerPage);
            zeroPages[i] = zeroPage;
        }
        try {
            for (i = 0; i < 10000; ++i) {
                adversary.setProbabilityFactor(0.0);
                swapper.write(0L, zeroPages, 0, pageCount);
                adversary.setProbabilityFactor(1.0);
                swapper.write(0L, writePages, 0, pageCount);
                for (ByteBufferPage byteBufferPage : readPages) {
                    this.clear(byteBufferPage);
                }
                adversary.setProbabilityFactor(0.0);
                Assert.assertThat((Object)swapper.read(0L, readPages, 0, pageCount), (Matcher)Matchers.is((Object)bytesTotal));
                for (int j = 0; j < pageCount; ++j) {
                    Assert.assertThat((Object)this.array(((ByteBufferPage)readPages[j]).buffer), (Matcher)Matchers.is((Object)this.array(((ByteBufferPage)writePages[j]).buffer)));
                }
            }
        }
        finally {
            swapper.close();
        }
    }
}

