/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import org.neo4j.jdbc.CallProxy;
import org.neo4j.jdbc.Driver;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.ext.DbVisualizerConnection;
import org.neo4j.jdbc.ext.IntelliJConnection;
import org.neo4j.jdbc.ext.LibreOfficeConnection;

public enum Connections {
    OpenOffice{

        @Override
        protected boolean matches(Properties sysProps) {
            return sysProps.containsKey("org.openoffice.native");
        }

        @Override
        protected Neo4jConnection doCreate(Driver driver, String url, Properties p) throws SQLException {
            return new LibreOfficeConnection(driver, url, p);
        }
    }
    ,
    IntelliJ{

        @Override
        protected boolean matches(Properties sysProps) {
            return sysProps.getProperty("user.dir").contains("IntelliJ");
        }

        @Override
        protected Neo4jConnection doCreate(Driver driver, String url, Properties p) throws SQLException {
            return new IntelliJConnection(driver, url, p);
        }
    }
    ,
    DbVisualizer{

        @Override
        protected boolean matches(Properties sysProps) {
            return sysProps.containsKey(Connections.DB_VIS);
        }

        @Override
        protected Neo4jConnection doCreate(Driver driver, String url, Properties p) throws SQLException {
            return new DbVisualizerConnection(driver, url, p);
        }
    }
    ,
    Default{

        @Override
        protected boolean matches(Properties sysProps) {
            return true;
        }

        @Override
        protected Neo4jConnection doCreate(Driver driver, String url, Properties p) throws SQLException {
            return new Neo4jConnection(driver, url, p);
        }
    };

    public static final String DB_VIS = "dbvis.ScriptsTreeShowDetails";

    protected abstract boolean matches(Properties var1);

    public static Neo4jConnection create(Driver driver, String url, Properties p) throws SQLException {
        Properties sysProps = System.getProperties();
        for (Connections connections : Connections.values()) {
            if (!connections.matches(sysProps)) continue;
            Neo4jConnection con = connections.doCreate(driver, url, p);
            return Connections.debug(con, Connections.hasDebug(p));
        }
        throw new SQLException("Couldn't create connection for " + url + " properties " + p);
    }

    public static boolean hasDebug(Properties properties) {
        return "true".equalsIgnoreCase(properties.getProperty("debug", "false"));
    }

    public static <T> T debug(T obj, boolean debug) {
        if (debug) {
            Class<?>[] interfaces = obj.getClass().getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                return (T)CallProxy.proxy(interfaces[0], obj);
            }
            return obj;
        }
        return obj;
    }

    protected abstract Neo4jConnection doCreate(Driver var1, String var2, Properties var3) throws SQLException;
}

