/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.ResultSetBuilder;

public class Neo4jStatement
implements Statement {
    protected Neo4jConnection connection;
    protected ResultSet resultSet;
    protected SQLWarning sqlWarning;

    public Neo4jStatement(Neo4jConnection connection) {
        this.connection = connection;
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        this.execute(s);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        this.execute(s);
        return 0;
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.connection = null;
        this.resultSet = null;
        this.sqlWarning = null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw Neo4jStatement.unsupported("getMaxFieldSize");
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        throw Neo4jStatement.unsupported("setMaxFieldSize ");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw Neo4jStatement.unsupported("getMaxRows");
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        throw Neo4jStatement.unsupported("setMaxRows");
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        throw Neo4jStatement.unsupported("setEscapeProcessing");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw Neo4jStatement.unsupported("getQueryTimeout");
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        throw Neo4jStatement.unsupported("setQueryTimeout");
    }

    @Override
    public void cancel() throws SQLException {
        throw Neo4jStatement.unsupported("cancel");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        throw Neo4jStatement.unsupported("setCursorName");
    }

    @Override
    public boolean execute(String s) throws SQLException {
        try {
            this.resultSet = this.connection.executeQuery(this.connection.nativeSQL(s), Collections.emptyMap());
            return true;
        }
        catch (SQLWarning e) {
            if (this.sqlWarning == null) {
                this.sqlWarning = e;
            } else {
                this.sqlWarning.setNextWarning(e);
            }
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.resultSet = null;
        return false;
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        throw Neo4jStatement.unsupported("setFetchDirection");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        throw Neo4jStatement.unsupported("setFetchSize");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw Neo4jStatement.unsupported("getFetchSize");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String s) throws SQLException {
        throw Neo4jStatement.unsupported("addBatch");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw Neo4jStatement.unsupported("clearBatch");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw Neo4jStatement.unsupported("executeBatch");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new ResultSetBuilder().newResultSet(this.connection);
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        return this.executeUpdate(s);
    }

    @Override
    public int executeUpdate(String s, int[] ints) throws SQLException {
        return this.executeUpdate(s);
    }

    @Override
    public int executeUpdate(String s, String[] strings) throws SQLException {
        return this.executeUpdate(s);
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        return this.execute(s);
    }

    @Override
    public boolean execute(String s, int[] ints) throws SQLException {
        return this.execute(s);
    }

    @Override
    public boolean execute(String s, String[] strings) throws SQLException {
        return this.execute(s);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection == null;
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        throw Neo4jStatement.unsupported("setPoolable");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw Neo4jStatement.unsupported("closeOnCompletion");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    private static SQLFeatureNotSupportedException unsupported(String methodName) {
        return new SQLFeatureNotSupportedException(methodName + " is not supported by Neo4jStatement.");
    }
}

