/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.rest;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.jdbc.ExecutionResult;
import org.neo4j.jdbc.rest.Statement;
import org.neo4j.jdbc.util.ClosableIterator;
import org.restlet.representation.Representation;

class StreamingParser {
    private final JsonFactory JSON_FACTORY;
    private final ObjectMapper mapper;

    StreamingParser(ObjectMapper mapper) {
        this.mapper = mapper;
        this.JSON_FACTORY = new JsonFactory(mapper);
    }

    public JsonParser obtainParser(Representation representation) throws SQLException {
        try {
            return this.obtainParser(representation.getReader());
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error creating parser", ioe);
        }
    }

    ExecutionResult nextResult(ParserState state) {
        return this.nextResult(state, null, null);
    }

    ExecutionResult nextResult(final ParserState state, final EndCallback endCallback, final AutoCloseable closeable) {
        if (!this.skipTo(state, "nextResult1", new Object[]{JsonToken.START_OBJECT, "columns"})) {
            return null;
        }
        final List<String> columns = this.readList(state);
        final int cols = columns.size();
        this.skipTo(state, "nextResult2", new Object[]{"data", JsonToken.START_ARRAY});
        return new ExecutionResult(columns, (Iterator<Object[]>)new ClosableIterator<Object[]>(){
            boolean last = false;
            Object[] nextRow = null;

            private Object[] nextRow() {
                Object[] row;
                if (StreamingParser.this.nextToken(state) == JsonToken.START_OBJECT) {
                    StreamingParser.this.skipTo(state, "nextResult2.5", new Object[]{JsonToken.START_OBJECT, "row"});
                }
                if ((row = StreamingParser.this.readObjectArray(state)) != null) {
                    StreamingParser.this.skipTo(state, "nextResult3", new Object[]{JsonToken.END_OBJECT});
                }
                if (row != null && row.length != cols) {
                    throw new IllegalStateException("Row length " + row.length + " differs from column definition " + columns + " row details " + Arrays.toString(row));
                }
                return row;
            }

            @Override
            public void close() {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    while (this.hasNext()) {
                        this.nextRow();
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.last) {
                    return false;
                }
                if (this.nextRow == null) {
                    this.nextRow = this.nextRow();
                    if (this.nextRow == null) {
                        this.last = true;
                        StreamingParser.this.skipTo(state, "nextResult4", new Object[]{JsonToken.END_ARRAY, JsonToken.END_OBJECT});
                        if (endCallback != null) {
                            endCallback.endReached();
                        }
                    }
                }
                return this.nextRow != null;
            }

            @Override
            public Object[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] row = this.nextRow;
                this.nextRow = null;
                return row;
            }

            @Override
            public void remove() {
            }
        });
    }

    Object[] readObjectArray(ParserState state) {
        List objects = this.readList(state);
        return objects != null ? objects.toArray() : null;
    }

    <T> List<T> readList(ParserState state) {
        JsonToken token = this.nextToken(state);
        if (token == JsonToken.START_ARRAY) {
            List result = state.readValueAs(List.class);
            state.consumeLast();
            return result;
        }
        return null;
    }

    Iterator<ExecutionResult> toResults(JsonParser parser, final AutoCloseable closeable, Statement ... statements) throws SQLException {
        try {
            final ParserState state = ParserState.from(parser);
            this.skipTo(state, "toResults1", new Object[]{JsonToken.START_OBJECT, "results", JsonToken.START_ARRAY});
            return new Iterator<ExecutionResult>(){
                boolean last = false;
                ExecutionResult nextResult = null;

                @Override
                public boolean hasNext() {
                    if (this.last) {
                        return false;
                    }
                    if (this.nextResult == null) {
                        this.nextResult = StreamingParser.this.nextResult(state, new EndCallback(){

                            @Override
                            public void endReached() {
                                this.hasNext();
                            }
                        }, closeable);
                        if (this.nextResult == null) {
                            this.last = true;
                            StreamingParser.this.skipTo(state, "toResults2", new Object[]{JsonToken.END_OBJECT, JsonToken.END_ARRAY, JsonToken.END_OBJECT});
                        }
                    }
                    return this.nextResult != null;
                }

                @Override
                public ExecutionResult next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ExecutionResult result = this.nextResult;
                    this.nextResult = null;
                    return result;
                }

                @Override
                public void remove() {
                }
            };
        }
        catch (Exception ioe) {
            throw new SQLException("Error executing statements " + Statement.toJson(this.mapper, statements), ioe);
        }
    }

    boolean skipTo(ParserState state, String msg, Object ... tokenOrField) {
        LinkedHashMap<JsonToken, String> foundTokens = new LinkedHashMap<JsonToken, String>();
        for (Object expectedToken : tokenOrField) {
            JsonToken token;
            boolean matched;
            do {
                token = state.nextToken();
                foundTokens.put(token, state.getCurrentName());
                this.handleErrors(state);
                state.consumeLast();
                if (token != null) continue;
                return false;
            } while (!(matched = expectedToken == token || state.getCurrentName() != null && state.getCurrentName().equals(expectedToken)));
        }
        return true;
    }

    private void handleErrors(ParserState state) {
        JsonToken token;
        if ("errors".equals(state.getCurrentName()) && (token = state.nextToken()) == JsonToken.FIELD_NAME) {
            state.consumeLast();
            List errors = this.readList(state);
            if (errors == null || errors.isEmpty()) {
                return;
            }
            throw new RuntimeException("Error executing cypher statement(s) " + errors);
        }
    }

    public ParserState obtainParserState(Reader reader) throws SQLException {
        return ParserState.from(this.obtainParser(reader));
    }

    public JsonParser obtainParser(Reader reader) throws SQLException {
        try {
            JsonParser parser = this.JSON_FACTORY.createJsonParser(reader);
            parser.setCodec(this.mapper);
            return parser;
        }
        catch (IOException ioe) {
            throw new SQLTransientConnectionException("Error creating result parser", ioe);
        }
    }

    public JsonToken nextToken(ParserState state) {
        return state.nextToken();
    }

    static interface EndCallback {
        public void endReached();
    }

    static class ParserState {
        JsonParser parser;
        JsonToken nextToken;

        private ParserState(JsonParser parser) {
            this.parser = parser;
        }

        JsonToken nextToken() {
            if (this.nextToken == null) {
                try {
                    this.nextToken = this.parser.nextToken();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Error during parsing", ioe);
                }
            }
            return this.nextToken;
        }

        void consumeLast() {
            this.nextToken = null;
        }

        static ParserState from(JsonParser parser) {
            return new ParserState(parser);
        }

        public String getCurrentName() {
            try {
                return this.parser.getCurrentName();
            }
            catch (IOException e) {
                throw new IllegalStateException("Error during parse");
            }
        }

        public String getCurrentToken() {
            return String.valueOf((Object)this.parser.getCurrentToken());
        }

        public <T> T readValueAs(Class<T> type) {
            try {
                return this.parser.readValueAs(type);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error during parse");
            }
        }
    }
}

