/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.Consumer;
import org.neo4j.function.Consumers;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

@RunWith(value=Enclosed.class)
public class StorePropertyCursorTest {
    private static final List<Object[]> PARAMETERS = Arrays.asList({false, PropertyType.BOOL}, {(byte)3, PropertyType.BYTE}, {(short)34, PropertyType.SHORT}, {3456, PropertyType.INT}, {3456L, PropertyType.LONG}, {0xFFFFFFFEL, PropertyType.LONG}, {Float.valueOf(1.6f), PropertyType.FLOAT}, {1.9, PropertyType.DOUBLE}, {Character.valueOf('a'), PropertyType.CHAR}, {"short", PropertyType.SHORT_STRING}, {"notsoshort", PropertyType.SHORT_STRING}, {"alongershortstring", PropertyType.SHORT_STRING}, {"areallylongshortstringbutstillnotsobig", PropertyType.SHORT_STRING}, {new double[]{0.0}, PropertyType.SHORT_ARRAY}, {new double[]{1.2}, PropertyType.SHORT_ARRAY}, {new double[]{1.2, 1.4}, PropertyType.SHORT_ARRAY}, {new double[]{1.2, 1.4, 1.6}, PropertyType.SHORT_ARRAY}, {new double[]{1.2, 1.4, 1.6, 1.8}, PropertyType.ARRAY}, {new double[]{1.2, 1.4, 1.6, 1.8, 2.2, 2.4, 2.6, 2.8, 3.2, 3.4, 3.6, 3.8}, PropertyType.ARRAY}, {"thisisaveryveryveryverylongstringwhichisnotgonnafiteverintothepropertyblock", PropertyType.STRING}, {new BigProperty("thisisaveryveryveryverylongstringwhichisnotgonnafiteverintothepropertyblock\nthisisaveryveryveryverylongstringwhichisnotgonnafiteverintothepropertyblock", "two very long lines..."), PropertyType.STRING}, {new BigProperty("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare augue a felis interdum, id sodales magna tempor. Donec aliquam, nunc eu semper semper, orci metus tincidunt urna, non sagittis eros tellus vel tellus. Maecenas vel nisi magna. Morbi tincidunt pretium nibh, eu tristique magna cursus vitae. Sed vel ultricies sem. Nunc blandit nulla leo, a tempor libero placerat ut. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Phasellus in velit vel dui euismod semper id varius neque. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nam ultrices accumsan ultrices.\n\nAenean laoreet tellus non velit vulputate finibus. Mauris facilisis mi ac eros hendrerit, mollis cursus lectus tincidunt. Sed et enim porta, mollis massa a, ornare lacus. Donec condimentum purus risus, ut vestibulum orci accumsan nec. Mauris condimentum aliquet felis, nec porttitor nunc faucibus vel. Donec eget rutrum urna. Donec aliquet, sapien quis ornare vulputate, tortor massa facilisis leo, nec pharetra dolor sapien non nunc. Mauris erat nulla, aliquam a sem sed, cursus ornare leo. Nulla et volutpat ligula. Curabitur iaculis massa vitae purus pretium, sed vehicula leo facilisis. Aenean egestas augue sit amet ex finibus, eu varius nisi tristique. Aenean molestie nisi vitae erat euismod pharetra.\n\nNunc eu dolor euismod, commodo magna at, molestie velit. Cras vitae posuere sem, quis egestas mi. Morbi vestibulum, lorem sit amet semper porta, purus lorem rhoncus augue, non posuere justo magna sed diam. Donec a neque ac enim placerat semper eu ac purus. Duis sit amet sodales ligula. Vestibulum et dui tempus, molestie diam ut, commodo felis. Sed at congue ligula, fermentum sagittis turpis.\n\nFusce in pharetra nisl. Pellentesque urna urna, rutrum ac tellus sed, rutrum mattis magna. Donec facilisis, tellus consequat placerat mollis, mauris dui molestie ligula, ut ullamcorper lectus tortor in nisl. Aenean congue semper turpis. Mauris iaculis mi vel neque rutrum, vel viverra tellus hendrerit. Nam sed tincidunt lorem. Vestibulum eleifend augue magna, nec gravida leo finibus id. Phasellus id arcu eget ipsum cursus placerat. Donec sit amet lorem porttitor nibh suscipit lobortis. Donec ultrices, purus nec convallis blandit, mi nisl tincidunt justo, dignissim maximus nisi nulla quis dui. Interdum et malesuada fames ac ante ipsum primis in faucibus. Integer ac rhoncus nunc. Donec varius tempus imperdiet. Aenean at semper elit. Donec mattis imperdiet sem. Ut dolor augue, bibendum et metus nec, vestibulum blandit dolor.\n\nProin dui nisi, malesuada lacinia sodales sed, porta et arcu. Quisque in massa a diam ultrices porttitor. Mauris vulputate ipsum dignissim eros sodales facilisis in vel nunc. Fusce blandit efficitur convallis. Sed ut ex ac mauris dignissim tempor. Morbi a dui nibh. Suspendisse eu lobortis lorem. Curabitur dictum convallis sapien, ac egestas odio hendrerit at.\n\nDonec nisi arcu, porta quis tristique ac, elementum vitae purus. Suspendisse tempor lorem eu metus gravida consectetur. Donec sapien felis, aliquam eget diam at, ultricies tristique velit. In libero velit, pulvinar accumsan fermentum a, mollis id risus. Praesent facilisis convallis dolor, et cursus tellus varius tristique. Vivamus ac eros pulvinar, blandit ipsum ac, interdum turpis. Donec nec ultrices elit. Proin auctor, nisl vitae viverra ornare, nisl ipsum congue ligula, et tempor diam orci ac ex. In faucibus massa quis purus malesuada convallis. Suspendisse metus ex, malesuada vel auctor et, finibus quis nulla. Cras tincidunt, mauris ac varius tincidunt, enim nunc finibus libero, et euismod quam dolor non magna. Nulla rhoncus dolor a nulla hendrerit iaculis. Nunc tristique, ante id tincidunt feugiat, ligula ipsum faucibus dui, sed suscipit eros nulla non augue. Donec hendrerit arcu sit amet ex laoreet, sit amet gravida risus aliquam. Nullam efficitur placerat sem quis venenatis.\n\nNullam scelerisque purus urna, vel laoreet velit consequat congue. Morbi tincidunt aliquet dignissim. Fusce neque mauris, euismod eu orci a, hendrerit pretium metus. In imperdiet nibh non augue pharetra, nec aliquet orci molestie. Morbi quis blandit leo. Mauris facilisis urna vitae ante molestie, ut efficitur dui elementum. Suspendisse a lectus sit amet turpis feugiat pellentesque ac vel nulla. Proin lobortis ante tincidunt porttitor aliquam. Praesent consequat blandit magna, sit amet finibus dui dapibus eget. Integer quis sem ut justo vulputate volutpat. Vestibulum nec varius lacus. Maecenas eget metus sed lectus suscipit laoreet. Sed mattis magna eu nunc ultrices vestibulum nec vel lacus. Curabitur dapibus nec arcu non tincidunt. Duis eget nulla dictum, lobortis leo ultrices, eleifend neque.\n\nAliquam egestas tortor mi, sed blandit odio sollicitudin et. Mauris fermentum eros orci, id euismod ante interdum vel. Mauris egestas molestie augue, eu rutrum massa interdum in. Mauris sit amet facilisis risus, a convallis nunc. Vivamus hendrerit lobortis ex et ullamcorper. Sed suscipit egestas aliquet. Cras quis bibendum lacus. Nulla maximus consectetur purus quis varius. Nullam ultricies vehicula lectus, eget elementum elit commodo sit amet. Quisque molestie finibus est vel bibendum. Vestibulum a imperdiet turpis, ut volutpat orci. Morbi erat augue, varius sed ullamcorper auctor, varius tincidunt ante. Vivamus mattis justo nulla, auctor euismod nulla mollis id. ", "Lorem ipsum... ad infinitum..."), PropertyType.STRING});

    private static Object actualValue(Object parameter) {
        return parameter instanceof BigProperty ? ((BigProperty)parameter).value() : parameter;
    }

    private static void assertEqualValues(Object expectedValue, PropertyItem item) {
        if (expectedValue.getClass().isArray()) {
            Assert.assertArrayEquals((double[])((double[])expectedValue), (double[])((double[])item.value()), (double)0.0);
            Assert.assertArrayEquals((double[])((double[])expectedValue), (double[])((double[])item.value()), (double)0.0);
        } else {
            Assert.assertEquals((Object)expectedValue, (Object)item.value());
            Assert.assertEquals((Object)expectedValue, (Object)item.value());
        }
    }

    static StorePropertyCursor newStorePropertyCursor(PropertyStore propertyStore, Consumer<StorePropertyCursor> cache) {
        return new StorePropertyCursor(propertyStore, cache);
    }

    private static void createSinglePropertyValue(PropertyStore store, int recordId, int keyId, Object value) {
        DynamicStringStore stringAllocator = store.getStringStore();
        DynamicArrayStore arrayAllocator = store.getArrayStore();
        PropertyBlock block = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block, (int)keyId, (Object)value, (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator);
        PropertyRecord record = new PropertyRecord((long)recordId);
        record.addPropertyBlock(block);
        record.setInUse(true);
        store.updateRecord(record);
    }

    private static void createTwoPropertyValues(PropertyStore store, int recordId, int keyId1, Object value1, int keyId2, Object value2) throws IOException {
        DynamicStringStore stringAllocator = store.getStringStore();
        DynamicArrayStore arrayAllocator = store.getArrayStore();
        PropertyBlock block1 = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block1, (int)keyId1, (Object)value1, (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator);
        PropertyBlock block2 = new PropertyBlock();
        PropertyStore.encodeValue((PropertyBlock)block2, (int)keyId2, (Object)value2, (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator);
        PropertyRecord record = new PropertyRecord((long)recordId);
        record.addPropertyBlock(block1);
        if (block1.getSize() + block2.getSize() <= 32) {
            record.addPropertyBlock(block2);
        } else {
            PropertyRecord nextRecord = new PropertyRecord((long)(recordId + 1));
            record.setNextProp(nextRecord.getId());
            nextRecord.addPropertyBlock(block2);
            nextRecord.setPrevProp(record.getId());
            nextRecord.setInUse(true);
            store.updateRecord(nextRecord);
        }
        record.setInUse(true);
        store.updateRecord(record);
    }

    @RunWith(value=Parameterized.class)
    public static class CursorReuse
    extends PropertyStoreBasedTestSupport {
        @Parameterized.Parameter(value=0)
        public Object expectedValue;
        @Parameterized.Parameter(value=1)
        public PropertyType type;

        @Parameterized.Parameters(name="value={0} of type={1}")
        public static List<Object[]> parameters() {
            return PARAMETERS;
        }

        @Test
        public void shouldReuseCorrectlyCursor() throws Throwable {
            PropertyItem item;
            int recordId = 42;
            int keyId = 11;
            Object expectedValue = StorePropertyCursorTest.actualValue(this.expectedValue);
            StorePropertyCursorTest.createSinglePropertyValue(this.propertyStore, recordId, keyId, expectedValue);
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(this.propertyStore, this.cache);
            try (StorePropertyCursor cursor = storePropertyCursor.init((long)recordId, LockService.NO_LOCK);){
                Assert.assertTrue((boolean)cursor.next());
                item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue, item);
                Assert.assertFalse((boolean)cursor.next());
            }
            cursor = storePropertyCursor.init((long)recordId, LockService.NO_LOCK);
            var6_6 = null;
            try {
                Assert.assertTrue((boolean)cursor.next());
                item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue, item);
                Assert.assertFalse((boolean)cursor.next());
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var6_6 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable x2) {
                            var6_6.addSuppressed(x2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TwoValueProperties
    extends PropertyStoreBasedTestSupport {
        @Parameterized.Parameter(value=0)
        public Object expectedValue1;
        @Parameterized.Parameter(value=1)
        public PropertyType type1;
        @Parameterized.Parameter(value=2)
        public Object expectedValue2;
        @Parameterized.Parameter(value=3)
        public PropertyType type2;

        @Parameterized.Parameters(name="value={0} of type={1} and value={2} of type={3}")
        public static Collection<Object[]> parameters() {
            ArrayList<Object[]> combinations = new ArrayList<Object[]>();
            for (int i = 0; i < PARAMETERS.size(); ++i) {
                Object[] current = (Object[])PARAMETERS.get(i);
                for (Object[] other : PARAMETERS) {
                    Object[] objects = new Object[]{current[0], current[1], other[0], other[1]};
                    combinations.add(objects);
                }
            }
            return combinations;
        }

        @Test
        public void shouldReturnAPropertyBySkippingOne() throws Throwable {
            int recordId = 42;
            int keyId1 = 11;
            int keyId2 = 22;
            Object expectedValue1 = StorePropertyCursorTest.actualValue(this.expectedValue1);
            Object expectedValue2 = StorePropertyCursorTest.actualValue(this.expectedValue2);
            StorePropertyCursorTest.createTwoPropertyValues(this.propertyStore, recordId, keyId1, expectedValue1, keyId2, expectedValue2);
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(this.propertyStore, this.cache);
            try (StorePropertyCursor cursor = storePropertyCursor.init((long)recordId, LockService.NO_LOCK);){
                Assert.assertTrue((boolean)cursor.next());
                PropertyItem item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId1, (long)item.propertyKeyId());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)keyId2, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue2, item);
                Assert.assertFalse((boolean)cursor.next());
            }
        }

        @Test
        public void shouldReturnTwoProperties() throws Throwable {
            int recordId = 42;
            int keyId1 = 11;
            int keyId2 = 22;
            Object expectedValue1 = StorePropertyCursorTest.actualValue(this.expectedValue1);
            Object expectedValue2 = StorePropertyCursorTest.actualValue(this.expectedValue2);
            StorePropertyCursorTest.createTwoPropertyValues(this.propertyStore, recordId, keyId1, expectedValue1, keyId2, expectedValue2);
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(this.propertyStore, this.cache);
            try (StorePropertyCursor cursor = storePropertyCursor.init((long)recordId, LockService.NO_LOCK);){
                Assert.assertTrue((boolean)cursor.next());
                PropertyItem item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId1, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue1, item);
                Assert.assertTrue((boolean)cursor.next());
                item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId2, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue2, item);
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SingleValueProperties
    extends PropertyStoreBasedTestSupport {
        @Parameterized.Parameter(value=0)
        public Object expectedValue;
        @Parameterized.Parameter(value=1)
        public PropertyType type;

        @Parameterized.Parameters(name="value={0} of type={1}")
        public static List<Object[]> parameters() {
            return PARAMETERS;
        }

        @Test
        public void shouldReturnAProperty() throws Throwable {
            int recordId = 42;
            int keyId = 11;
            Object expectedValue = StorePropertyCursorTest.actualValue(this.expectedValue);
            StorePropertyCursorTest.createSinglePropertyValue(this.propertyStore, recordId, keyId, expectedValue);
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(this.propertyStore, this.cache);
            try (StorePropertyCursor cursor = storePropertyCursor.init((long)recordId, LockService.NO_LOCK);){
                Assert.assertTrue((boolean)cursor.next());
                PropertyItem item = (PropertyItem)cursor.get();
                Assert.assertEquals((long)keyId, (long)item.propertyKeyId());
                StorePropertyCursorTest.assertEqualValues(expectedValue, item);
                Assert.assertFalse((boolean)cursor.next());
            }
        }
    }

    public static class PropertyStoreBasedTestSupport {
        @ClassRule
        public static EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
        @ClassRule
        public static PageCacheRule pageCacheRule = new PageCacheRule();
        private static PageCache pageCache;
        protected final Consumer<StorePropertyCursor> cache = Consumers.noop();
        protected PropertyStore propertyStore;
        private NeoStores neoStores;

        @BeforeClass
        public static void setUpPageCache() {
            pageCache = pageCacheRule.getPageCache(fsRule.get());
        }

        @AfterClass
        public static void tearDownPageCache() throws IOException {
            pageCache.close();
        }

        @Before
        public void setup() throws IOException {
            EphemeralFileSystemAbstraction fs = fsRule.get();
            NullLogProvider log = NullLogProvider.getInstance();
            File storeDir = new File("store");
            if (fs.isDirectory(storeDir)) {
                fs.deleteRecursively(storeDir);
            }
            fs.mkdirs(storeDir);
            StoreFactory storeFactory = new StoreFactory((FileSystemAbstraction)fs, storeDir, pageCache, (LogProvider)log);
            this.neoStores = storeFactory.openAllNeoStores(true);
            this.propertyStore = this.neoStores.getPropertyStore();
        }

        @After
        public void tearDown() {
            this.neoStores.close();
        }

        @Test
        public void ignore() throws Exception {
        }
    }

    public static class ErrorTest {
        private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
        private final Consumer<StorePropertyCursor> cache = (Consumer)Mockito.mock(Consumer.class);
        private final DynamicStringStore stringStore = (DynamicStringStore)Mockito.mock(DynamicStringStore.class);
        private final DynamicArrayStore arrayStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);

        public ErrorTest() {
            Mockito.when((Object)this.propertyStore.getStringStore()).thenReturn((Object)this.stringStore);
            Mockito.when((Object)this.propertyStore.getArrayStore()).thenReturn((Object)this.arrayStore);
        }

        @Test
        public void shouldReturnTheCursorToTheCacheOnClose() throws Throwable {
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(this.propertyStore, this.cache);
            storePropertyCursor.init(0L, LockService.NO_LOCK);
            storePropertyCursor.close();
            ((Consumer)Mockito.verify(this.cache, (VerificationMode)Mockito.times((int)1))).accept(storePropertyCursor);
        }

        @Test
        public void shouldThrowIfTheRecordIsNotInUse() throws Throwable {
            int recordId = 42;
            PageCursor pageCursor = (PageCursor)Mockito.mock(PageCursor.class);
            Mockito.when((Object)this.propertyStore.newReadCursor((long)recordId)).thenReturn((Object)pageCursor);
            Mockito.when((Object)pageCursor.shouldRetry()).thenReturn((Object)false);
            StorePropertyCursor storePropertyCursor = StorePropertyCursorTest.newStorePropertyCursor(this.propertyStore, this.cache);
            try (StorePropertyCursor cursor = storePropertyCursor.init((long)recordId, LockService.NO_LOCK);){
                cursor.next();
                Assert.fail();
            }
            catch (NotFoundException ex) {
                Assert.assertEquals((Object)("Property record with id " + recordId + " not in use"), (Object)ex.getMessage());
            }
        }
    }

    private static class BigProperty {
        private final Object actualValue;
        private final String toStringForUnitTest;

        BigProperty(Object value, String toStringForUnitTest) {
            this.actualValue = value;
            this.toStringForUnitTest = toStringForUnitTest;
        }

        Object value() {
            return this.actualValue;
        }

        public String toString() {
            return this.toStringForUnitTest;
        }
    }
}

