/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class DeadlockCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    public DeadlockCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @After
    public void shutdown() {
        this.threadA.interrupt();
        this.threadB.interrupt();
        this.threadC.interrupt();
    }

    @Test
    public void shouldDetectTwoClientExclusiveDeadlock() throws Exception {
        this.assertDetectsDeadlock(this.acquireExclusive(this.clientA, (Locks.ResourceType)ResourceTypes.NODE, 1L), this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 2L), this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L), this.acquireExclusive(this.clientA, (Locks.ResourceType)ResourceTypes.NODE, 2L));
    }

    @Test
    public void shouldDetectThreeClientExclusiveDeadlock() throws Exception {
        this.assertDetectsDeadlock(this.acquireExclusive(this.clientA, (Locks.ResourceType)ResourceTypes.NODE, 1L), this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 2L), this.acquireExclusive(this.clientC, (Locks.ResourceType)ResourceTypes.NODE, 3L), this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L), this.acquireExclusive(this.clientC, (Locks.ResourceType)ResourceTypes.NODE, 2L), this.acquireExclusive(this.clientA, (Locks.ResourceType)ResourceTypes.NODE, 3L));
    }

    @Test
    public void shouldDetectMixedExclusiveAndSharedDeadlock() throws Exception {
        this.assertDetectsDeadlock(this.acquireShared(this.clientA, (Locks.ResourceType)ResourceTypes.NODE, 1L), this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 2L), this.acquireExclusive(this.clientB, (Locks.ResourceType)ResourceTypes.NODE, 1L), this.acquireShared(this.clientA, (Locks.ResourceType)ResourceTypes.NODE, 2L));
    }

    private void assertDetectsDeadlock(LockingCompatibilityTestSuite.Compatibility.LockCommand ... commands) {
        ArrayList<Pair> calls = new ArrayList<Pair>();
        for (LockingCompatibilityTestSuite.Compatibility.LockCommand command : commands) {
            calls.add(Pair.of((Object)command.client(), command.call()));
        }
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout) {
            for (Pair call : calls) {
                try {
                    ((Future)call.other()).get(1L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof DeadlockDetectedException) {
                        return;
                    }
                    throw new RuntimeException(e);
                }
                catch (InterruptedException | TimeoutException exception) {
                }
            }
        }
        throw new AssertionError((Object)"Failed to detect deadlock. Expected lock manager to detect deadlock, but none of the clients reported any deadlocks.");
    }
}

