/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import com.google.common.jimfs.Jimfs;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.fs.DelegateFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;

public class StandalonePageCacheFactoryTest {
    @Test(timeout=10000L)
    public void mustAutomaticallyStartEvictionThread() throws IOException {
        DelegateFileSystemAbstraction fs = new DelegateFileSystemAbstraction(Jimfs.newFileSystem());
        File file = new File("a");
        fs.create(file);
        try (PageCache cache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);
             PagedFile pf = cache.map(file, 4096, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            for (int i = 0; i < 10000; ++i) {
                Assert.assertTrue((boolean)cursor.next());
                cursor.putInt(42);
            }
        }
    }
}

